# Example for: model.color()

# Two demos: 
#
# 1) Use a given alignment to color a structure according to 
#    insertions and deletions in a pairwise alignment.
#
# 2) Superpose two 3D structure and do (1).

env = environ()

# Demo 1:
mdl = model(env)
aln = alignment(env)
mdl.read(file='1nbt')
aln.append(file='toxin.ali', align_codes=('1nbt', '1fas'), remove_gaps=True)
mdl.color(aln)
mdl.write(file='1nbt-1.clr')

# Demo 2:
aln = alignment(env)
segs = {'1nbt':('1:A', '66:A'), '1fas':('1:', '61:')}
for code in ('1nbt', '1fas'):
    mdl.read(file=code, model_segment=segs[code])
    aln.append_model(mdl, align_codes=code, atom_files=code)
aln.align(gap_penalties_1d=(-600, -400))
aln.malign3d(gap_penalties_3d=(0, 3.0))
aln.write(file='color_aln_model.pap', alignment_format='PAP')

mdl.read(file='1nbt', model_segment=segs['1nbt'])
mdl.color(aln)
mdl.write(file='1nbt-2.clr')
