# Version check
import sys
if sys.version_info[0] < 2 or sys.version_info[1] < 3:
    raise ImportError, "This module requires Python 2.3 or later"

from energy_data import energy_data
from io_data import io_data
from environ import environ
from group_restraints import group_restraints
from error import ModellerError
from model import model
from alignment import alignment
from sequence_db import sequence_db
from profile import profile
from density import density
import modfile
del error, parameters

# Direct standard output to the Modeller logfile
import util.logger
log = util.logger.logger()
sys.stdout.close()
sys.stdout = log

# Provide Modeller information
import information
info = information.information()
del information

# Load in readline, if available, to make interactive use easier
# Note: the readline module causes Modeller to crash under Debian Sarge
# (and possibly some other Linux systems)
try:
    if len(sys.argv) > 0 and sys.argv[0] == '-' and sys.stdin.isatty():
        import readline
except (ImportError, AttributeError):
    pass

del sys
