# Example for: model.restraints.make(), model.restraints.spline(),
#              model.restraints.write()

# This will compare energies of bond length restraints expressed
# by harmonic potential and by cubic spline.

log.verbose()
env = environ()
env.libs.topology.read(file='$(LIB)/top_heav.lib')
env.libs.parameters.read(file='$(LIB)/par.lib')

code = '1fas'
aln = alignment(env)
mdl = model(env, file=code, model_segment=('1:', '61:'))
aln.append_model(mdl, atom_files=code, align_codes=code)
aln.append_model(mdl, atom_files=code+'.ini', align_codes=code+'-ini')
mdl.generate_topology(aln, sequence=code+'-ini')
mdl.transfer_xyz(aln)
mdl.build(initialize_xyz=False, build_method='INTERNAL_COORDINATES')
mdl.write(file=code+'.ini')

mdl.restraints.make(aln, restraint_type='bond', spline_on_site=False)
mdl.restraints.write(file=code+'-1.rsr')
edat = energy_data(dynamic_sphere=False)
mdl.energy(edat=edat)

mdl.restraints.spline(spline_range=5.0, spline_dx=0.005,
                      spline_select=(3, 1, 1), edat=edat)
mdl.restraints.condense()
mdl.restraints.write(file=code+'-2.rsr')
mdl.energy(edat=edat)
