# Example for: model.superpose()

# This will use a given alignment to superpose Calpha atoms of 
# one structure (2ctx) on the other (1fas).

env = environ()

mdl  = model(env, file='1fas')
mdl2 = model(env, file='2ctx')
aln = alignment(env, file='toxin.ali', align_codes=('1fas', '2ctx'))
mdl.pick_atoms(aln, pick_atoms_set=1, atom_types='CA')
mdl.superpose(mdl2, aln)
mdl2.write(file='2ctx.fit')
