#   residue    atoms              mean    stdev
angles = [
    ( 'ALA', ('O', 'C', '+N'), 2.14133, 0.03729 ),
    ( 'ALA', ('CA', 'N', '-C'), 2.11798, 0.03610 ),
    ( 'ALA', ('C', 'CA', 'CB'), 1.92140, 0.02060 ),
    ( 'ALA', ('CA', 'C', '+N'), 2.03583, 0.03475 ),
    ( 'ALA', ('CA', 'C', 'O'), 2.10422, 0.01952 ),
    ( 'ALA', ('N', 'CA', 'C'), 1.93739, 0.04638 ),
    ( 'ALA', ('N', 'CA', 'CB'), 1.92383, 0.01950 ),
    ( 'CYS', ('O', 'C', '+N'), 2.14375, 0.04163 ),
    ( 'CYS', ('CA', 'N', '-C'), 2.11807, 0.03869 ),
    ( 'CYS', ('C', 'CA', 'CB'), 1.91417, 0.03319 ),
    ( 'CYS', ('CA', 'C', '+N'), 2.03371, 0.04421 ),
    ( 'CYS', ('CA', 'C', 'O'), 2.10303, 0.02132 ),
    ( 'CYS', ('CA', 'CB', 'SG'), 1.98777, 0.04103 ),
    ( 'CYS', ('N', 'CA', 'C'), 1.93607, 0.05388 ),
    ( 'CYS', ('N', 'CA', 'CB'), 1.92654, 0.02821 ),
    ( 'ASP', ('O', 'C', '+N'), 2.14102, 0.04348 ),
    ( 'ASP', ('CA', 'N', '-C'), 2.11908, 0.04474 ),
    ( 'ASP', ('C', 'CA', 'CB'), 1.91836, 0.03321 ),
    ( 'ASP', ('CA', 'C', '+N'), 2.03638, 0.03468 ),
    ( 'ASP', ('CA', 'C', 'O'), 2.10353, 0.02127 ),
    ( 'ASP', ('CA', 'CB', 'CG'), 1.97183, 0.02761 ),
    ( 'ASP', ('CB', 'CG', 'OD1'), 2.07925, 0.03085 ),
    ( 'ASP', ('CB', 'CG', 'OD2'), 2.07304, 0.03954 ),
    ( 'ASP', ('N', 'CA', 'C'), 1.93704, 0.05577 ),
    ( 'ASP', ('N', 'CA', 'CB'), 1.92701, 0.02758 ),
    ( 'ASP', ('OD2', 'CG', 'OD1'), 2.13022, 0.03862 ),
    ( 'GLU', ('O', 'C', '+N'), 2.14123, 0.03851 ),
    ( 'GLU', ('CA', 'N', '-C'), 2.11739, 0.04212 ),
    ( 'GLU', ('C', 'CA', 'CB'), 1.91759, 0.02953 ),
    ( 'GLU', ('CA', 'C', '+N'), 2.03624, 0.03398 ),
    ( 'GLU', ('CA', 'C', 'O'), 2.10382, 0.01910 ),
    ( 'GLU', ('CA', 'CB', 'CG'), 1.98848, 0.03805 ),
    ( 'GLU', ('CB', 'CG', 'CD'), 1.97510, 0.03459 ),
    ( 'GLU', ('CG', 'CD', 'OE1'), 2.07615, 0.03086 ),
    ( 'GLU', ('CG', 'CD', 'OE2'), 2.06203, 0.03197 ),
    ( 'GLU', ('N', 'CA', 'C'), 1.94028, 0.04827 ),
    ( 'GLU', ('N', 'CA', 'CB'), 1.92728, 0.02470 ),
    ( 'GLU', ('OE2', 'CD', 'OE1'), 2.14434, 0.02769 ),
    ( 'PHE', ('O', 'C', '+N'), 2.14302, 0.04118 ),
    ( 'PHE', ('CA', 'N', '-C'), 2.11941, 0.03825 ),
    ( 'PHE', ('C', 'CA', 'CB'), 1.91690, 0.03276 ),
    ( 'PHE', ('CA', 'C', '+N'), 2.03385, 0.03695 ),
    ( 'PHE', ('CA', 'C', 'O'), 2.10414, 0.01965 ),
    ( 'PHE', ('CA', 'CB', 'CG'), 1.98588, 0.02613 ),
    ( 'PHE', ('CB', 'CG', 'CD1'), 2.10606, 0.01499 ),
    ( 'PHE', ('CB', 'CG', 'CD2'), 2.10304, 0.01481 ),
    ( 'PHE', ('CD1', 'CE1', 'CZ'), 2.09195, 0.01452 ),
    ( 'PHE', ('CD2', 'CE2', 'CZ'), 2.09198, 0.01450 ),
    ( 'PHE', ('CD2', 'CG', 'CD1'), 2.07324, 0.01327 ),
    ( 'PHE', ('CE2', 'CZ', 'CE1'), 2.09202, 0.01406 ),
    ( 'PHE', ('CG', 'CD1', 'CE1'), 2.10821, 0.01473 ),
    ( 'PHE', ('CG', 'CD2', 'CE2'), 2.10834, 0.01465 ),
    ( 'PHE', ('N', 'CA', 'C'), 1.93398, 0.05368 ),
    ( 'PHE', ('N', 'CA', 'CB'), 1.92829, 0.02607 ),
    ( 'GLY', ('O', 'C', '+N'), 2.14085, 0.04401 ),
    ( 'GLY', ('CA', 'N', '-C'), 2.11142, 0.04589 ),
    ( 'GLY', ('CA', 'C', '+N'), 2.03730, 0.03751 ),
    ( 'GLY', ('CA', 'C', 'O'), 2.10303, 0.02235 ),
    ( 'GLY', ('N', 'CA', 'C'), 1.97394, 0.05736 ),
    ( 'HIS', ('O', 'C', '+N'), 2.14271, 0.03655 ),
    ( 'HIS', ('CA', 'N', '-C'), 2.11904, 0.04079 ),
    ( 'HIS', ('C', 'CA', 'CB'), 1.91752, 0.03253 ),
    ( 'HIS', ('CA', 'C', '+N'), 2.03540, 0.03759 ),
    ( 'HIS', ('CA', 'C', 'O'), 2.10321, 0.02054 ),
    ( 'HIS', ('CD2', 'CG', 'CB'), 2.28434, 0.02747 ),
    ( 'HIS', ('CE1', 'ND1', 'CG'), 1.90484, 0.01717 ),
    ( 'HIS', ('CE1', 'NE2', 'CD2'), 1.89943, 0.01591 ),
    ( 'HIS', ('CG', 'CB', 'CA'), 1.98177, 0.02801 ),
    ( 'HIS', ('N', 'CA', 'C'), 1.93929, 0.05573 ),
    ( 'HIS', ('N', 'CA', 'CB'), 1.92571, 0.02829 ),
    ( 'HIS', ('ND1', 'CG', 'CB'), 2.14259, 0.02242 ),
    ( 'HIS', ('ND1', 'CG', 'CD2'), 1.85505, 0.01649 ),
    ( 'HIS', ('NE2', 'CD2', 'CG'), 1.87020, 0.01636 ),
    ( 'HIS', ('NE2', 'CE1', 'ND1'), 1.89417, 0.01869 ),
    ( 'ILE', ('O', 'C', '+N'), 2.14221, 0.03578 ),
    ( 'ILE', ('CA', 'N', '-C'), 2.11857, 0.03502 ),
    ( 'ILE', ('C', 'CA', 'CB'), 1.92004, 0.03215 ),
    ( 'ILE', ('CA', 'C', '+N'), 2.03504, 0.03209 ),
    ( 'ILE', ('CA', 'C', 'O'), 2.10425, 0.01938 ),
    ( 'ILE', ('CA', 'CB', 'CG1'), 1.92424, 0.02550 ),
    ( 'ILE', ('CA', 'CB', 'CG2'), 1.92884, 0.02135 ),
    ( 'ILE', ('CB', 'CG1', 'CD1'), 1.98798, 0.02896 ),
    ( 'ILE', ('CG1', 'CB', 'CG2'), 1.93198, 0.02874 ),
    ( 'ILE', ('N', 'CA', 'C'), 1.91562, 0.05260 ),
    ( 'ILE', ('N', 'CA', 'CB'), 1.93992, 0.02587 ),
    ( 'LYS', ('O', 'C', '+N'), 2.14126, 0.04056 ),
    ( 'LYS', ('CA', 'N', '-C'), 2.11957, 0.04371 ),
    ( 'LYS', ('C', 'CA', 'CB'), 1.91728, 0.02837 ),
    ( 'LYS', ('CA', 'C', '+N'), 2.03576, 0.03426 ),
    ( 'LYS', ('CA', 'C', 'O'), 2.10400, 0.01977 ),
    ( 'LYS', ('CA', 'CB', 'CG'), 1.98975, 0.03589 ),
    ( 'LYS', ('CB', 'CG', 'CD'), 1.94606, 0.03716 ),
    ( 'LYS', ('CD', 'CE', 'NZ'), 1.95160, 0.03973 ),
    ( 'LYS', ('CG', 'CD', 'CE'), 1.94837, 0.03459 ),
    ( 'LYS', ('N', 'CA', 'C'), 1.93834, 0.04956 ),
    ( 'LYS', ('N', 'CA', 'CB'), 1.92693, 0.02404 ),
    ( 'LEU', ('O', 'C', '+N'), 2.14199, 0.03925 ),
    ( 'LEU', ('CA', 'N', '-C'), 2.11867, 0.03506 ),
    ( 'LEU', ('C', 'CA', 'CB'), 1.91582, 0.02823 ),
    ( 'LEU', ('CA', 'C', '+N'), 2.03620, 0.03049 ),
    ( 'LEU', ('CA', 'C', 'O'), 2.10325, 0.01935 ),
    ( 'LEU', ('CA', 'CB', 'CG'), 2.03111, 0.04924 ),
    ( 'LEU', ('CB', 'CG', 'CD2'), 1.92409, 0.02977 ),
    ( 'LEU', ('CB', 'CG', 'CD1'), 1.92209, 0.02940 ),
    ( 'LEU', ('CD1', 'CG', 'CD2'), 1.92943, 0.02556 ),
    ( 'LEU', ('N', 'CA', 'C'), 1.93417, 0.05056 ),
    ( 'LEU', ('N', 'CA', 'CB'), 1.92584, 0.02335 ),
    ( 'MET', ('O', 'C', '+N'), 2.14152, 0.04898 ),
    ( 'MET', ('CA', 'N', '-C'), 2.11623, 0.04172 ),
    ( 'MET', ('C', 'CA', 'CB'), 1.91662, 0.03024 ),
    ( 'MET', ('CA', 'C', '+N'), 2.03555, 0.03520 ),
    ( 'MET', ('CA', 'C', 'O'), 2.10364, 0.02001 ),
    ( 'MET', ('CA', 'CB', 'CG'), 1.98713, 0.03734 ),
    ( 'MET', ('CB', 'CG', 'SD'), 1.96292, 0.04752 ),
    ( 'MET', ('CG', 'SD', 'CE'), 1.75394, 0.04181 ),
    ( 'MET', ('N', 'CA', 'C'), 1.93610, 0.04965 ),
    ( 'MET', ('N', 'CA', 'CB'), 1.92780, 0.02661 ),
    ( 'ASN', ('O', 'C', '+N'), 2.14140, 0.04496 ),
    ( 'ASN', ('CA', 'N', '-C'), 2.12010, 0.04442 ),
    ( 'ASN', ('C', 'CA', 'CB'), 1.92143, 0.03250 ),
    ( 'ASN', ('CA', 'C', '+N'), 2.03614, 0.03547 ),
    ( 'ASN', ('CA', 'C', 'O'), 2.10331, 0.02118 ),
    ( 'ASN', ('CA', 'CB', 'CG'), 1.96543, 0.02622 ),
    ( 'ASN', ('CB', 'CG', 'ND2'), 2.03480, 0.02299 ),
    ( 'ASN', ('CB', 'CG', 'OD1'), 2.10898, 0.02284 ),
    ( 'ASN', ('N', 'CA', 'C'), 1.94366, 0.05747 ),
    ( 'ASN', ('N', 'CA', 'CB'), 1.92673, 0.02701 ),
    ( 'ASN', ('ND2', 'CG', 'OD1'), 2.13882, 0.02250 ),
    ( 'PRO', ('O', 'C', '+N'), 2.14218, 0.05132 ),
    ( 'PRO', ('CA', 'N', '-C'), 2.11504, 0.05337 ),
    ( 'PRO', ('CD', 'N', '-C'), 2.21708, 0.05478 ),
    ( 'PRO', ('C', 'CA', 'CB'), 1.94374, 0.02840 ),
    ( 'PRO', ('CA', 'C', '+N'), 2.03636, 0.04339 ),
    ( 'PRO', ('CA', 'C', 'O'), 2.10169, 0.02318 ),
    ( 'PRO', ('CA', 'CB', 'CG'), 1.81069, 0.02862 ),
    ( 'PRO', ('CB', 'CG', 'CD'), 1.81861, 0.04325 ),
    ( 'PRO', ('CD', 'N', 'CA'), 1.94360, 0.01928 ),
    ( 'PRO', ('N', 'CA', 'C'), 1.96585, 0.05286 ),
    ( 'PRO', ('N', 'CA', 'CB'), 1.80356, 0.01875 ),
    ( 'PRO', ('N', 'CD', 'CG'), 1.79060, 0.02108 ),
    ( 'GLN', ('O', 'C', '+N'), 2.14135, 0.04338 ),
    ( 'GLN', ('CA', 'N', '-C'), 2.11736, 0.04443 ),
    ( 'GLN', ('C', 'CA', 'CB'), 1.91707, 0.03017 ),
    ( 'GLN', ('CA', 'C', '+N'), 2.03609, 0.03319 ),
    ( 'GLN', ('CA', 'C', 'O'), 2.10373, 0.02050 ),
    ( 'GLN', ('CA', 'CB', 'CG'), 1.98674, 0.03735 ),
    ( 'GLN', ('CB', 'CG', 'CD'), 1.96763, 0.03328 ),
    ( 'GLN', ('CG', 'CD', 'NE2'), 2.03479, 0.02753 ),
    ( 'GLN', ('CG', 'CD', 'OE1'), 2.10869, 0.02502 ),
    ( 'GLN', ('N', 'CA', 'C'), 1.93801, 0.04910 ),
    ( 'GLN', ('N', 'CA', 'CB'), 1.92749, 0.02683 ),
    ( 'GLN', ('NE2', 'CD', 'OE1'), 2.13887, 0.02797 ),
    ( 'ARG', ('O', 'C', '+N'), 2.14156, 0.04381 ),
    ( 'ARG', ('CA', 'N', '-C'), 2.11786, 0.04089 ),
    ( 'ARG', ('C', 'CA', 'CB'), 1.91706, 0.02965 ),
    ( 'ARG', ('CA', 'C', '+N'), 2.03527, 0.03576 ),
    ( 'ARG', ('CA', 'C', 'O'), 2.10414, 0.01920 ),
    ( 'ARG', ('CA', 'CB', 'CG'), 1.98873, 0.03665 ),
    ( 'ARG', ('CB', 'CG', 'CD'), 1.95318, 0.03935 ),
    ( 'ARG', ('CD', 'NE', 'CZ'), 2.17694, 0.04166 ),
    ( 'ARG', ('CG', 'CD', 'NE'), 1.95039, 0.04220 ),
    ( 'ARG', ('N', 'CA', 'C'), 1.93688, 0.04992 ),
    ( 'ARG', ('N', 'CA', 'CB'), 1.92730, 0.02507 ),
    ( 'ARG', ('NE', 'CZ', 'NH1'), 2.10535, 0.02709 ),
    ( 'ARG', ('NE', 'CZ', 'NH2'), 2.08901, 0.02912 ),
    ( 'ARG', ('NH2', 'CZ', 'NH1'), 2.08787, 0.02657 ),
    ( 'SER', ('O', 'C', '+N'), 2.14166, 0.04697 ),
    ( 'SER', ('CA', 'N', '-C'), 2.11785, 0.04697 ),
    ( 'SER', ('C', 'CA', 'CB'), 1.91411, 0.02914 ),
    ( 'SER', ('CA', 'C', '+N'), 2.03547, 0.03909 ),
    ( 'SER', ('CA', 'C', 'O'), 2.10344, 0.02106 ),
    ( 'SER', ('CA', 'CB', 'OG'), 1.93303, 0.03149 ),
    ( 'SER', ('N', 'CA', 'C'), 1.94141, 0.05227 ),
    ( 'SER', ('N', 'CA', 'CB'), 1.92630, 0.02534 ),
    ( 'THR', ('O', 'C', '+N'), 2.14154, 0.04685 ),
    ( 'THR', ('CA', 'N', '-C'), 2.11737, 0.04244 ),
    ( 'THR', ('C', 'CA', 'CB'), 1.90790, 0.03440 ),
    ( 'THR', ('CA', 'C', '+N'), 2.03550, 0.03724 ),
    ( 'THR', ('CA', 'C', 'O'), 2.10361, 0.02085 ),
    ( 'THR', ('CA', 'CB', 'CG2'), 1.93826, 0.02329 ),
    ( 'THR', ('CA', 'CB', 'OG1'), 1.90567, 0.02503 ),
    ( 'THR', ('CG2', 'CB', 'OG1'), 1.89226, 0.03994 ),
    ( 'THR', ('N', 'CA', 'C'), 1.93243, 0.05414 ),
    ( 'THR', ('N', 'CA', 'CB'), 1.93868, 0.03037 ),
    ( 'VAL', ('O', 'C', '+N'), 2.14246, 0.03835 ),
    ( 'VAL', ('CA', 'N', '-C'), 2.11915, 0.03482 ),
    ( 'VAL', ('C', 'CA', 'CB'), 1.91722, 0.03161 ),
    ( 'VAL', ('CA', 'C', '+N'), 2.03466, 0.02970 ),
    ( 'VAL', ('CA', 'C', 'O'), 2.10438, 0.01935 ),
    ( 'VAL', ('CA', 'CB', 'CG1'), 1.93047, 0.02133 ),
    ( 'VAL', ('CA', 'CB', 'CG2'), 1.92476, 0.02261 ),
    ( 'VAL', ('CG2', 'CB', 'CG1'), 1.92602, 0.02501 ),
    ( 'VAL', ('N', 'CA', 'C'), 1.91687, 0.05158 ),
    ( 'VAL', ('N', 'CA', 'CB'), 1.94346, 0.02687 ),
    ( 'TRP', ('O', 'C', '+N'), 2.14309, 0.03339 ),
    ( 'TRP', ('CA', 'N', '-C'), 2.11989, 0.03074 ),
    ( 'TRP', ('C', 'CA', 'CB'), 1.91628, 0.03219 ),
    ( 'TRP', ('CA', 'C', '+N'), 2.03511, 0.03466 ),
    ( 'TRP', ('CA', 'C', 'O'), 2.10351, 0.02018 ),
    ( 'TRP', ('CA', 'CB', 'CG'), 1.98948, 0.04064 ),
    ( 'TRP', ('CB', 'CG', 'CD1'), 2.21627, 0.01918 ),
    ( 'TRP', ('CB', 'CG', 'CD2'), 2.20992, 0.01623 ),
    ( 'TRP', ('CD1', 'CG', 'CD2'), 1.85597, 0.01519 ),
    ( 'TRP', ('CD1', 'NE1', 'CE2'), 1.90147, 0.01205 ),
    ( 'TRP', ('CD2', 'CE2', 'CZ2'), 2.13587, 0.00991 ),
    ( 'TRP', ('CD2', 'CE3', 'CZ3'), 2.07179, 0.01136 ),
    ( 'TRP', ('CE2', 'CZ2', 'CH2'), 2.05087, 0.01157 ),
    ( 'TRP', ('CE3', 'CD2', 'CE2'), 2.07483, 0.01054 ),
    ( 'TRP', ('CE3', 'CZ3', 'CH2'), 2.11228, 0.01099 ),
    ( 'TRP', ('CG', 'CD1', 'NE1'), 1.92079, 0.01512 ),
    ( 'TRP', ('CG', 'CD2', 'CE2'), 1.87063, 0.01309 ),
    ( 'TRP', ('CG', 'CD2', 'CE3'), 2.33732, 0.01264 ),
    ( 'TRP', ('CZ3', 'CH2', 'CZ2'), 2.12004, 0.01130 ),
    ( 'TRP', ('N', 'CA', 'C'), 1.93729, 0.05363 ),
    ( 'TRP', ('N', 'CA', 'CB'), 1.92760, 0.02640 ),
    ( 'TRP', ('NE1', 'CE2', 'CD2'), 1.87533, 0.01005 ),
    ( 'TRP', ('NE1', 'CE2', 'CZ2'), 2.27145, 0.01158 ),
    ( 'TYR', ('CA', 'N', '-C'), 2.12034, 0.03801 ),
    ( 'TYR', ('C', 'CA', 'CB'), 1.91508, 0.03220 ),
    ( 'TYR', ('CA', 'C', 'O'), 2.10402, 0.01974 ),
    ( 'TYR', ('CA', 'CB', 'CG'), 1.98567, 0.03924 ),
    ( 'TYR', ('CB', 'CG', 'CD1'), 2.11058, 0.01554 ),
    ( 'TYR', ('CB', 'CG', 'CD2'), 2.10791, 0.01524 ),
    ( 'TYR', ('CD1', 'CE1', 'CZ'), 2.08575, 0.01246 ),
    ( 'TYR', ('CD2', 'CE2', 'CZ'), 2.08602, 0.01353 ),
    ( 'TYR', ('CD2', 'CG', 'CD1'), 2.06376, 0.01535 ),
    ( 'TYR', ('CE1', 'CZ', 'OH'), 2.09063, 0.02242 ),
    ( 'TYR', ('CE2', 'CZ', 'CE1'), 2.10280, 0.01651 ),
    ( 'TYR', ('CE2', 'CZ', 'OH'), 2.08935, 0.02290 ),
    ( 'TYR', ('CG', 'CD1', 'CE1'), 2.11348, 0.01327 ),
    ( 'TYR', ('CG', 'CD2', 'CE2'), 2.11401, 0.01209 ),
    ( 'TYR', ('N', 'CA', 'C'), 1.93682, 0.05442 ),
    ( 'TYR', ('N', 'CA', 'CB'), 1.92711, 0.02598 ),
    ( 'TYR', ('O', 'C', '+N'), 2.14373, 0.03346 ),
    ( 'TYR', ('CA', 'C', '+N'), 2.03370, 0.03326 ),
  ]

def make_restraints(atmsel, restraints, num_selected):
    from modeller import forms, physical, features
    for (res, atoms, mean, stdev) in angles:
        for a in atmsel.find_atoms(res, atoms, num_selected):
            r = forms.gaussian(physical.angle, features.angle(*a), mean, stdev)
            restraints.add(r)
