import time
from modeller.parallel import communicator, data_types, slavestate

class slave(communicator.communicator):

    def __init__(self):
        communicator.communicator.__init__(self)
        self.task = None
        self._state = slavestate.init
        self.update_contact_time()

    def start(self, path, id, output):
        """Start the slave running on the remote host"""
        self._state = slavestate.pending

    def accept_connection(self, socket):
        communicator.communicator.accept_connection(self, socket)
        self._state = slavestate.connected
        self.update_contact_time()

    def run_cmd(self, cmd):
        """Run a Python command on the remote host"""
        self._send(data_types.netcommand.send(cmd))

    def set_directory(self, dir):
        self.run_cmd('import os\nos.chdir(master.get_data())')
        self.send_data(dir)

    def update_contact_time(self):
        self.last_contact_time = time.time()

    def contact_timeout(self, timeout):
        return (time.time() - self.last_contact_time) > timeout

    def run_task(self, task):
        if not self.ready_for_task():
            raise TypeError, "%s not ready for task" % str(self)
        self._state = slavestate.running_task
        self.task = task
        self.run_cmd('task = master.get_data()')
        self.run_cmd('task._results = task.run(*task._args, **task._vars)')
        self.run_cmd('master.send_data(task._results)')
        self.send_data(task)

    def task_results(self):
        """Read results from slave. If these terminate the task, return it."""
        r = self.get_data(allow_heartbeat=True)
        self.update_contact_time()
        if isinstance(r, data_types.heartbeat):
            return None
        else:
            task = self.task
            task._results = r
            self.task = None
            self._state = slavestate.connected
            return task

    def kill(self):
        self.disconnect()
        task = self.task
        self.task = None
        self._state = slavestate.dead
        return task

    def get_state(self):
        return self._state

    def ready_for_task(self):
        return self.get_state() == slavestate.connected

    def running_task(self):
        return self.get_state() == slavestate.running_task
