/** \file mod_error.h      Error handling routines
 *
 *             Part of MODELLER, Copyright(c) 1989-2007 Andrej Sali
 */

#ifndef __MOD_ERROR_H
#define __MOD_ERROR_H

#ifdef __cplusplus
extern "C" {
#endif

/** Clear the error indicator */
void clear_mod_error(void);

/** Get the current error string, or NULL if no error is set */
char *get_mod_error(void);

/** Get the current error type */
int get_mod_error_type(void);

/** Set the current error type and string */
void set_mod_error(int type, const char *str);

#ifdef __cplusplus
}
#endif

#endif  /* __MOD_ERROR_H */
