/** \file mod_libs.h       Access functions for Modeller library data.
 *
 *             Part of MODELLER, Copyright(c) 1989-2007 Andrej Sali
 */

#ifndef __MOD_LIBS_H
#define __MOD_LIBS_H

#include "mod_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/** Get the directory holding Modeller libraries (usually "modlib") */
const char *get_libdir(void);

/** Set the name of the current job */
void set_jobname(const char *jobname);

/** Get the name of the current job */
const char *get_jobname(void);

/** Get the filenames of the libraries used for GA341 assessment */
void get_ga341libs(const char **surflib, const char **pairlib);

/** Get the directory holding Modeller binaries and TOP scripts (usually
    "bin") */
char *get_bindir(void);

/** Get the filename of the configuration file used by the TOP interpreter
    (usually "modlib/top.ini") */
char *get_inifil(void);

/** Return TRUE iff this Modeller binary is a debugging build */
mbool get_debug(void);

/** Set license key */
void set_license_key(const char *key);

/** Set installation directory */
void set_install_dir(const char *dir);

#ifdef __cplusplus
}
#endif
#endif  /* __MOD_LIBS_H */
