# Step 4: Selecting the templates.
#
# If you do not have ASGL installed (most of you won't), the second
# graphics routine won't work. You can then either determine the templates
# from the sequence identity matrix or use PHYLIP.

from modeller import *
from modeller.scripts import principal_components, asgl_principal_components

log.verbose()
env = environ()
principal_components(env, family='alignment.seg', cluster_cut=-1.0)

try:
    asgl_principal_components(env, family='alignment.seg')
except ModellerError:
    print
    print "ASGL is probably not installed on your system."
    print "You can obtain ASGL from http://salilab.org/asgl/"
    print "However, it is not required for MODELLER to work."
