from topology import topology
from parameters import parameters
import util.top as top
from modeller.util.modobject import modobject
import _modeller

class libraries(modobject):
    __modpt = None
    env = None
    top = None

    def __new__(cls, *args, **vars):
        obj = modobject.__new__(cls)
        obj.__modpt = _modeller.new_libraries(obj)
        return obj

    def __init__(self, env):
        self.env = env
        self.top = top.top(self.env)
        self.__read_libs()

    def __read_libs(self):
        _modeller.libraries_read_libs(self.modpt, self.env.restyp_lib_file,
                                      self.env.rand_seed)

    def __getstate__(self):
        d = modobject.__getstate__(self)
        d['_libraries__rand_state'] = self.rand_state
        return d

    def __setstate__(self, d):
        r = d.pop('_libraries__rand_state')
        self.__dict__.update(d)
        self.__read_libs()
        self.rand_state = r

    def __del__(self):
        _modeller.free_libraries(self.modpt)

    def random_number(self):
        """Get the next random number between 0 and 1 from Modeller's internal
           random number generator."""
        return _modeller.random_number(self.modpt)

    def random_perturb(self, n):
        """Perturb the internal random number generator by some amount, n."""
        return _modeller.random_perturb(self.modpt, n)

    def __get_modpt(self):
        return self.__modpt
    def __get_topology(self):
        return topology(self)
    def __get_parameters(self):
        return parameters(self)
    def __get_rand_seed(self):
        return _modeller.get_libraries_rand_seed(self.modpt)
    def __set_rand_seed(self, val):
        _modeller.set_libraries_rand_seed(self.modpt, val)
    def __get_rand_state(self):
        return _modeller.libraries_randstate_get(self.modpt)
    def __set_rand_state(self, val):
        _modeller.libraries_randstate_set(self.modpt, val)

    modpt = property(__get_modpt)
    topology = property(__get_topology)
    parameters = property(__get_parameters)
    rand_seed = property(__get_rand_seed, __set_rand_seed)
    rand_state = property(__get_rand_state, __set_rand_state)
