import _modeller
import util.top as top
from modeller.util.modobject import modobject
from modeller.util import modlist, array

class saxslist(modlist.linklist):
    """A list of saxsdata objects"""
    def __init__(self, edat):
        self.__edat = edat
        self.__list = []
        modlist.linklist.__init__(self)

    def _insfunc(self, indx, obj):
        _modeller.new_saxsdata_pt(self.__edat, indx, obj.modpt)
        self.__list.insert(indx, obj)
    def __len__(self):
        return len(self.__list)
    def _getfunc(self, indx):
        return self.__list[indx]
    def _delfunc(self, indx):
        del self.__list[indx]
        _modeller.del_saxsdata_pt(self.__edat, indx)


class saxsdata(modobject):
    """Holds all SAXS (Small Angle X-ray Scattering) data"""
    __modpt = None
    env = None
    top = None

    def __new__(cls, *args, **vars):
        obj = modobject.__new__(cls)
        obj.__modpt = _modeller.new_saxsdata()
        return obj

    def __init__(self, env, **vars):
        self.env = env.copy()
        self.top = top.top(self.env)
#        if len(vars) > 0:
#            self.read(**vars)

    def __del__(self):
        _modeller.free_saxsdata(self.modpt)

    def __get_modpt(self):
        return self.__modpt

    def ini_saxs(self, atmsel, filename,**vars):
        """Initialize saxsdata
           ini_saxs(sel, s_min, s_max, maxs, nmesh, natomtyp, represtyp, 
                    filename, wswitch, wswitch, s_hybrid, s_hybrid, s_low, 
                    s_hi, spaceflag, rho_solv, use_lookup, nr, dr, 
                    use_offset) 
           Parameters
              sel         selection of atoms
              s_min       minimum frequency in reciprocal space in A^-1
                          default = 0.0
              s_max       maximum frequency in reciprocal space in A^-1 
                          default = 2.0
              maxs        maximum number of frequencies - default = 100
              nmesh       actual number of frequencies (<= maxs) 
                          default = 100
              natomtyp    number of ''atoms'', i.e. scattering centers 
                          default = 15
              represtyp   representation : 'heav', 'allh', or 'CA'
                          default='heav'
              filename    filename of the library for formfactors
              wswitch     character for filter of scoring function options 
                          'unity' (default), 'sq', or 'hybrid'
              s_hybrid    frequency above which $ s^2$ weighting is applied 
                          if wswitch='hybrid' - default=0.0
              s_low       bandpass filter in A^-1 - lower cutoff 
                          default=0.0
              s_hi        bandpass filter in A^-1 - higher cutoff 
                          default = 2.0
              spaceflag   how should I(s) be computed? 'real' space via P(r) 
                          or 'reciprocal'? 'real' is more than a magnitude 
                          faster but less accurate for high resolution 
                          default='real'
              rho_solv    electron density of solvent 
                          default=0.334 e/A^-3 (H_2O)
              use_lookup  use lookup tables for SINC and COS function - 
                          significant increase in speed for 'reciprocal' 
                          mode - default=True
              nr          number of points for $ P(r)$ sampling 
                          default= 5000
              dr          spacing (sampling) of P(r) in A - default=0.1
              use_offset  allow for additive constant in expt. spectrum 
                          default=False"""
        (inds, mdl) = atmsel.get_atom_indices()
        return self.top.ini_saxs('saxsdata.ini_saxs', saxsd=self.modpt, mdl=mdl.modpt, sel1=inds, filename=filename, **vars)

    def saxs_read(self, filename,**vars):
        """Read in experimental SAXS data"""
        return self.top.saxs_read('saxsdata.saxs_read', saxsd=self.modpt, filename=filename, **vars)

    def __get_s_hybrid(self):
        return _modeller.saxsdata_s_hybrid_get(self.modpt)
    def __set_s_hybrid(self, val):
        return _modeller.saxsdata_s_hybrid_set(self.modpt, val)

    def __get_s_max(self):
        return _modeller.saxsdata_s_max_get(self.modpt)
    def __set_s_max(self, val):
        return _modeller.saxsdata_s_max_set(self.modpt, val)

    def __get_s_min(self):
        return _modeller.saxsdata_s_min_get(self.modpt)
    def __set_s_min(self, val):
        return _modeller.saxsdata_s_min_set(self.modpt, val)

    def __get_s_low(self):
        return _modeller.saxsdata_s_low_get(self.modpt)
    def __set_s_low(self, val):
        return _modeller.saxsdata_s_low_set(self.modpt, val)

    def __get_s_hi(self):
        return _modeller.saxsdata_s_hi_get(self.modpt)
    def __set_s_hi(self, val):
        return _modeller.saxsdata_s_hi_set(self.modpt, val)

    def __get_normsq_exp(self):
        return _modeller.saxsdata_normsq_exp_get(self.modpt)
    def __set_normsq_exp(self, val):
        return _modeller.saxsdata_normsq_exp_set(self.modpt, val)

    def __get_ns(self):
        return _modeller.saxsdata_ns_get(self.modpt)
    def __get_c(self):
        return _modeller.saxsdata_c_get(self.modpt)
    def __set_c(self, val):
        return _modeller.saxsdata_c_set(self.modpt, val)

    def __get_chi_sq(self):
        return _modeller.saxsdata_chi_sq_get(self.modpt)
    def __set_chi_sq(self, val):
        return _modeller.saxsdata_chi_sq_set(self.modpt, val)

    def __get_rho_solv(self):
        return _modeller.saxsdata_rho_solv_get(self.modpt)
    def __set_rho_solv(self, val):
        return _modeller.saxsdata_rho_solv_set(self.modpt, val)

    def __get_offset(self):
        return _modeller.saxsdata_offset_get(self.modpt)
    def __set_offset(self):
        return _modeller.saxsdata_offset(self.modpt, val)
    def __get_intensity(self):
        ptarr = _modeller.saxsdata_intensity_get(self.modpt)
        return array.array_1ddouble(ptarr, self.__get_ns)
    def __set_intensity(self, val):
        modlist.set_fixlist(self.intensity, val)

    modpt = property(__get_modpt)
    s_hybrid = property(__get_s_hybrid, __set_s_hybrid)
    s_max = property(__get_s_max, __set_s_max)
    s_min = property(__get_s_min, __set_s_min)
    s_low = property(__get_s_low, __set_s_low)
    s_hi  = property(__get_s_hi,  __set_s_hi )
    normsq_exp = property(__get_normsq_exp, __set_normsq_exp)
    c     = property(__get_c, __set_c)
    ns = property(__get_ns)
    intensity = property(__get_intensity, __set_intensity)
    chi_sq = property(__get_chi_sq, __set_chi_sq)
    rho_solv = property(__get_rho_solv, __set_rho_solv)
    offset = property(__get_offset, __set_offset)

