import _modeller
from _modeller import wrtlog
from modeller.top_interpreter.commands import commands
from modeller.top_interpreter.variables import variables

class TOPfile:
  def __init__(self, topfile):
    self.topcmds = commands()
    self.variables = variables(self.topcmds)
    self.topcmds.vars = self.variables
    # Read top.ini
    self.read_top_ini(self.variables)
    # Read libraries
    _modeller.libraries_read_libs(self.topcmds.get_libs(),
                                  self.variables['restyp_lib_file'],
                                  self.variables['rand_seed'])
    # Read default atom classes file
    _modeller.read_atom_classes(self.topcmds.get_gprsr(),
                                self.variables['atom_classes_file'])
    if type(topfile) is file:
      self.lines = self.read_top(topfile)
    else:
      fh = open(topfile, 'r')
      self.lines = self.read_top(fh)
      fh.close()

  def read_top_ini(self, vars):
    vars.topini = {}
    fh = open(_modeller.get_inifil(), 'r')
    while True:
      line = fh.readline()
      if line.startswith('--- KEYWORDS:'):
        self.read_topvars(fh, vars)
      elif line == '':
        break
    fh.close()

  def read_topvars(self, fh, vars):
    while True:
      line = fh.readline()
      if line == '' or line.startswith('--- END OF FILE'):
        break
      line = self.remove_comment(line.strip())
      if len(line) > 0:
        try:
          self.parse_top_ini_line(line.split(None, 4), vars)
        except TypeError, detail:
          wrtlog("read_top__E> " + str(detail) + '\n')
          wrtlog("             top.ini line: " + line + '\n')
          raise

  def parse_top_ini_line(self, words, vars):
    typ = words[1][0]
    varname = words[2].lower()
    dim = int(words[3])
    vars.topini[varname] = (typ, dim)
    if len(words) > 4:
        try:
            vars[varname] = self.parse_var(words[4])
        except SyntaxError:    # Ignore 'read-only variable' errors
            pass
    elif dim == 0:
        vars[varname] = []
    else:
        raise TypeError, \
              "No default value given for variable %s!" % varname.upper()

  def read_top(self, fh):
    lines = []
    lastline = ''
    while True:
      line = fh.readline()
      if line == '': break
      line = line.expandtabs(1)
      line = self.remove_comment(line.strip())
      if len(line) > 0:
        if lastline.endswith(';'):
          lines[-1] = lastline[:-1] + line
        else:
          lines.append(line)
        lastline = lines[-1]
    lines = self.process_includes(lines)
    return lines

  def run(self):
    self.runlines(self.lines)

  def process_includes(self, lines):
    newlines = []
    for line in lines:
      (cmd, vars) = self.break_line(line)
      if cmd == 'INCLUDE':
        self.set_top_vars(vars)
        try:
          fh = self.open_include_file(self.variables['include_file'])
        except IOError, detail:
          wrtlog("runlines__E> " + str(detail) + '\n')
          wrtlog("             TOP Command line: " + line + '\n')
          raise
        newlines.extend(self.read_top(fh))
        fh.close()
      else:
        newlines.append(line)
    return newlines

  def open_include_file(self, fname):
    bindir = _modeller.get_bindir()
    dirs = [ '.', bindir ]
    exts = [ '', '.top' ]
    for dir in dirs:
      for ext in exts:
        inc = dir + '/' + fname + ext
        try:
          fh = open(inc, "r")
          return fh
        except IOError:
          pass
    raise IOError, "Could not find include file: %s" % (fname)

  def runlines(self, lines):
    subrout = self.process_subroutines(lines)
    callstack = []
    linenum = 0
    indxca = 0
    while indxca < len(lines):
      linenum = linenum + 1
      line = lines[indxca]
      loglevel = self.variables['output_control'][1]
      (cmd, vars) = self.break_line(line)
      try:
        if loglevel > 0 and cmd != 'SUBROUTINE':
          self.write_act(line, linenum, indxca + 1)
        if cmd == 'DO':
          indxca = self.handle_do(vars, indxca, lines, True)
        else:
          self.set_top_vars(vars)
          _modeller.top_pre()
          indxca = self.run_top_cmd(cmd, indxca, lines, callstack, subrout)
          _modeller.top_post()
      except (IndexError, SyntaxError, TypeError), detail:
        wrtlog("runlines__E> " + str(detail) + '\n')
        wrtlog("             TOP Command line: " + line + '\n')
        raise

  def write_act(self, line, linenum, indxca):
    lenwrap = 57
    line = line.strip()
    splstr = line.split('=')
    for i in range(len(splstr) - 1):
      if not splstr[i].endswith(' '):
        splstr[i] = splstr[i] + ' '
    line = '='.join(splstr)
    thisline = line[:lenwrap]
    line = line[lenwrap:]
    if len(line) > 0:
      thisline = thisline + ';'
    else:
      thisline = thisline + ' '
    wrtlog('TOP_________>%6d%5d %s\n' % (linenum, indxca, thisline))
    while len(line) > 0:
      thisline = line[:lenwrap]
      line = line[lenwrap:]
      if len(line) > 0:
        thisline = thisline + ';'
      else:
        thisline = thisline + ' '
      wrtlog('                      ' + thisline + '\n')
    wrtlog('\n')

  def handle_do(self, var, indxca, lines, firsttime):
    ind = var.find('=')
    varname = var[:ind].strip().lower()
    varval = var[ind+1:].strip()
    varval = self.parse_var(varval)
    if type(varval) is not list:
      varval = [varval]

    if len(varval) == 2:
      varval.append(1)
    if len(varval) != 3:
      raise SyntaxError, "Wrong number of arguments to DO command"
    else:
      for var in varval:
        if type(var) is not int and type(var) is not float:
          raise SyntaxError, "DO commands require INTEGER or REAL arguments"
      if firsttime:
        self.variables[varname] = varval[0]
      else:
        self.variables[varname] = self.variables[varname] + varval[2]
    if self.variables[varname] > varval[1]:
      return self.skip_to('END_DO', indxca, lines, incs=['DO'],
                          decs=['END_DO']) + 1
    else:
      return indxca + 1

  def process_subroutines(self, lines):
    subrout = {}
    for num, line in enumerate(lines):
      (cmd, vars) = self.break_line(line)
      if cmd == 'SUBROUTINE':
        self.set_top_vars(vars)
        rname = self.variables['routine']
        if rname in subrout:
          wrtlog("Warning: subroutine %s redefined\n" % (rname))
        subrout[rname] = num
    return subrout

  def split_quoted(self, line, splch):
    start = 0
    end = 0
    numquote = 0
    last = ''
    splist = []
    for ch in line:
      if ch == "'" and last != '\\':
        numquote = numquote + 1
      if ch == splch and numquote % 2 == 0:
        splist.append(line[start:end])
        start = end + 1
      last = ch
      end = end + 1
    if end > start:
      splist.append(line[start:end])
    return splist

  def break_line(self, line):
    ind = line.find(' ')
    if ind >= 0:
      cmd = line[:ind].upper()
      vars = line[ind+1:].strip()
      if len(vars) > 0:
        if cmd == 'DO':
          vars = vars.replace(',', ' ')
        else:
          vars = self.split_quoted(vars, ',')
    else:
      cmd = line.upper()
      vars = ''
    return (cmd, vars)

  def remove_comment(self, line):
    ind = line.find('#')
    if ind >= 0:
      return line[:ind]
    else:
      return line

  def set_top_vars(self, vars):
    for var in vars:
      if len(var) == 0: continue
      ind = var.find('=')
      if ind < 0:
        ind = var.find(' ')
      if ind < 0:
        raise IndexError, "No '=' found in variable assignment"
      varname = var[:ind].strip().lower()
      varval = var[ind+1:].strip()
      varval = self.parse_var(varval,
                              varname!='result' and varname!='variables')
      if varname in self.variables:
        self.variables[varname] = varval
      else:
        raise IndexError, "Variable name not recognized: %s" % varname.upper()

  def parse_var(self, cmdlin, subvar=True):
    vars = []
    curvar = ''
    delim = ''
    last = ''
    for ch in cmdlin:
      if ch == "'" and last != '\\':
        if delim == "'":
          vars.append(curvar)
          curvar = ''
          delim = ''
        else:
          delim = "'"
          if len(curvar) > 0:
            vars.append(self.get_top_rep(curvar))
            curvar = ''
      elif ch == ' ' and delim != "'":
        if len(curvar) > 0:
          vars.append(self.get_top_rep(curvar))
          curvar = ''
      else:
        if ch == "'" and last == '\\':
          curvar = curvar[:-1] + ch
        else:
          curvar = curvar + ch
      last = ch
    if delim == "'": raise SyntaxError, "Unmatched quote"
    if len(curvar) > 0: vars.append(self.get_top_rep(curvar))
    if subvar:
      newvars = []
      for var in vars:
        if type(var) is str and var.upper() == var:
          varlow = var.lower()
          try:
            getvar = self.variables[var.lower()]
            if type(getvar) is list or type(getvar) is tuple:
              newvars.extend(getvar)
            else:
              newvars.append(getvar)
          except IndexError:
            newvars.append(var)
        else:
          newvars.append(var)
      vars = newvars
    if len(vars) == 1:
      vars = vars[0]
    return vars

  def get_top_rep(self, curvar):
    try:
      return int(curvar)
    except ValueError:
      try:
        retval = float(curvar)
        if int(retval) == retval:
          return int(retval)
        else:
          return retval
      except ValueError:
        return curvar

  def sync_alignment(self, num, topname, getfunc):
    aln = self.topcmds.get_aln(num)
    len_aln = _modeller.alignment_nseq_get(aln)
    value = []
    for i in range(len_aln):
      value.append(getfunc(aln, i))
    self.variables[topname] = value

  def run_top_cmd(self, cmd, indxca, lines, callstack, subrout):
    excludes = [ 'SET', 'INCLUDE', 'DEFINE_STRING', 'DEFINE_INTEGER',
                 'DEFINE_REAL', 'DEFINE_LOGICAL', 'SUBROUTINE', 'CALL',
                 'END_SUBROUTINE', 'RETURN', 'OPERATE', 'STRING_OPERATE',
                 'IF', 'END_IF', 'STRING_IF', 'ELSE', 'DO', 'END_DO',
                 'EXIT', 'CYCLE', 'WRITE_TOP', 'RESET' ]
    if cmd not in excludes:
      lowcmd = cmd.lower()
      try:
        if lowcmd in dir(self.topcmds):
          eval('self.topcmds.' + lowcmd + '()')
        elif lowcmd in dir(_modeller):
          eval('_modeller.' + lowcmd + '()')
        elif "top_" + lowcmd in dir(_modeller):
          eval('_modeller.top_' + lowcmd + '()')
        else:
          raise SyntaxError, "Invalid TOP command: " + cmd
      except (_modeller.error, ZeroDivisionError, IOError, MemoryError,
              EOFError):
        self.variables['error_status'] = 1
        _modeller.top_error(1, self.variables['stop_on_error'])
      if lowcmd in ('read_alignment', 'expand_alignment', 'sequence_search',
                    'delete_alignment'):
        self.sync_alignment(1, 'align_codes', _modeller.alignment_codes_get)
        self.sync_alignment(1, 'atom_files', _modeller.alignment_atom_files_get)
      elif lowcmd == 'read_alignment2':
        self.sync_alignment(2, 'align_codes2', _modeller.alignment_codes_get)
        self.sync_alignment(2, 'atom_files2',
                            _modeller.alignment_atom_files_get)
    elif cmd == 'WRITE_TOP':
      self.write_top(self.variables['file'], lines)
    elif cmd == 'RESET':
      self.reset()
    elif cmd == 'DEFINE_STRING':
      self.make_top_variable('')
    elif cmd == 'DEFINE_REAL':
      self.make_top_variable(0.0)
    elif cmd == 'DEFINE_INTEGER':
      self.make_top_variable(0)
    elif cmd == 'DEFINE_LOGICAL':
      self.make_top_variable(False)
    elif cmd == 'SUBROUTINE':
      return self.skip_to('END_SUBROUTINE', indxca, lines) + 1
    elif cmd == 'CYCLE':
      return self.skip_to('END_DO', indxca, lines, incs=['DO'],
                          decs=['END_DO'])
    elif cmd == 'EXIT':
      return self.skip_to('END_DO', indxca, lines, incs=['DO'],
                          decs=['END_DO']) + 1
    elif cmd == 'END_DO':
      indxca = self.skip_to('DO', indxca, lines, incs=['END_DO'],
                            decs=['DO'], indinc=-1)
      line = lines[indxca]
      (cmd, vars) = self.break_line(line)
      return self.handle_do(vars, indxca, lines, False)
    elif cmd == 'IF' or cmd == 'STRING_IF':
      # Make sure there is a terminating END_IF
      self.skip_to('END_IF', indxca, lines, incs=['IF', 'STRING_IF'],
                   decs=['END_IF'])
      if cmd == 'IF':
        res = self.numeric_if(self.variables['operation'],
                              self.variables['arguments'])
      else:
        res = self.string_if(self.variables['operation'],
                             self.variables['string_arguments'])
      if not res:
        return self.skip_to(['ELSE', 'END_IF'], indxca, lines,
                            incs=['IF', 'STRING_IF'], decs=['END_IF']) + 1
    elif cmd == 'ELSE':
      return self.skip_to('END_IF', indxca, lines,
                          incs=['IF', 'STRING_IF'], decs=['END_IF']) + 1
    elif cmd == 'CALL':
      callstack.append(indxca)
      return self.jump_to_subroutine(self.variables['routine'], subrout) + 1
    elif cmd == 'END_SUBROUTINE' or cmd == 'RETURN':
      if len(callstack) > 0:
        return callstack.pop() + 1
      else:
        raise SyntaxError, cmd + " but not within a SUBROUTINE"
    elif cmd == 'STRING_OPERATE':
      res = self.string_operate(self.variables['operation'],
                                self.variables['string_arguments'])
      name = self.variables['result'].lower()
      if name in self.variables:
        self.variables[name] = res
      else:
        raise IndexError, "Bad variable name for RESULT: %s" % (name.upper())
    elif cmd == 'OPERATE':
      res = self.operate(self.variables['operation'],
                         self.variables['arguments'])
      name = self.variables['result'].lower()
      if name in self.variables:
        self.variables[name] = res
      else:
        raise IndexError, "Bad variable name for RESULT: %s" % (name.upper())
    return indxca + 1

  def write_top(self, filename, lines):
    fh = open(filename, "w")
    for line in lines:
      fh.write(line + '\n')
    fh.close()

  def reset(self):
    self.variables = variables(self.topcmds)
    self.topcmds.vars = self.variables
    # Read top.ini
    self.read_top_ini(self.variables)

  def string_if(self, operation, arguments):
    operation = operation.upper()
    if operation == 'EQ':
      return arguments[0] == arguments[1]
    elif operation == 'NE':
      return arguments[0] != arguments[1]
    elif operation == 'INDEX':
      return arguments[0].find(arguments[1]) >= 0
    else:
      raise SyntaxError, "Invalid OPERATION for STRING_IF: %s" % (operation)

  def numeric_if(self, operation, orig_arguments):
    operation = operation.upper()
    arguments = []
    for arg in orig_arguments:
      try:
        arguments.append(float(arg))
      except ValueError:
        raise SyntaxError, ("Argument for numeric IF must be REAL or INTEGER: "
                            + str(arg))
    if operation == 'EQ':
      return abs(arguments[0] - arguments[1]) < 1e-10
    elif operation == 'GT':
      return arguments[0] > arguments[1]
    elif operation == 'LT':
      return arguments[0] < arguments[1]
    elif operation == 'GE':
      return arguments[0] >= arguments[1] - 1e-10
    elif operation == 'LE':
      return arguments[0] <= arguments[1] + 1e-10
    elif operation == 'NE':
      return abs(arguments[0] - arguments[1]) > 1e-10
    else:
      raise SyntaxError, "Invalid OPERATION for IF: %s" % (operation)
      
  def string_operate(self, operation, arguments):
    if operation.upper() == 'CONCATENATE':
      val = ''
      for arg in arguments: val += str(arg)
#     The old Fortran code did this, since strings can't end in whitespace
      return val.replace('@', ' ')
    else:
      raise SyntaxError, "Invalid OPERATION for STRING_OPERATE: " + operation

  def operate(self, operation, arguments):
    operation = operation.upper()
    if operation == 'SUM':
      return sum(arguments)
    elif operation == 'MULTIPLY':
      val = 0
      for arg in arguments: val = val * arg
      return val
    elif operation == 'DIVIDE':
      return arguments[0] / arguments[1]
    elif operation == 'POWER':
      return arguments[0] ** arguments[1]
    elif operation == 'MOD':
      return arguments[0] % arguments[1]
    else:
      raise SyntaxError, "Invalid OPERATION for OPERATE: %s" % (operation)

  def skip_to(self, gotocmds, indxca, lines, incs=[], decs=[], indinc = 1):
    if type(gotocmds) is not list: gotocmds = [gotocmds]
    inclevel = 0
    indxca = indxca + indinc
    while indxca < len(lines) and indxca >= 0:
      (cmd, vars) = self.break_line(lines[indxca])
      if cmd in gotocmds and inclevel == 0:
        return indxca
      elif cmd in incs:
        inclevel = inclevel + 1
      elif cmd in decs:
        inclevel = inclevel - 1
        if inclevel < 0:
          raise SyntaxError, "Mismatched " + str(incs) + " and " + str(decs)
      indxca = indxca + indinc
    raise SyntaxError, "Cannot find matching " + str(gotocmds)

  def jump_to_subroutine(self, rname, subrout):
    if rname in subrout:
      line = subrout[rname]
      return line
    else:
      raise SyntaxError, "No such subroutine: " + rname

  def make_top_variable(self, initval):
    vars = self.variables['variables']
    if type(vars) is not list:
      vars = [ vars ]
    for var in vars:
      var = var.lower()
      self.variables[var] = initval
