/** \file dstr_type.h      Variable sized string type.
 *
 *             Part of MODELLER, Copyright(c) 1989-2007 Andrej Sali
 */

#ifndef __MOD_DSTRTYPE_H
#define __MOD_DSTRTYPE_H

/** Dynamic string type - is auto-expanded when necessary */
typedef struct _dstr {
  /** The actual null-terminated string data */
  char *text;
  /** Length of current text, NOT including terminating null */
  unsigned length;
  /** Size of the allocated memory buffer */
  unsigned bufsiz;
} dstr;

#endif   /* __MOD_DSTRTYPE_H */
