from modeller import *

log.verbose()
env = environ()

# Read in cryo-EM density map
den = density(env, file='TvLDH.10A.mrc', em_density_format='MRC',
              resolution=10.0, density_type='GAUSS',
              px=-26.742, py=-9.5205, pz=-10.375)

# Fit the PDB file into the map by MC simulated annealing
den.grid_search(em_density_format='MRC', num_structures=1,
                em_pdb_name='TvLDH.B99990001.pdb', chains_num=[1],
                start_type='CENTER', number_of_steps=20,
                angular_step_size=30., temperature=100.,
                best_docked_models=1, translate_type='RANDOM',
                em_fit_output_file='modem.log')
