import IMP
import IMP.restrainer
import IMP.core

IMP.set_log_level(IMP.VERBOSE)

rep = IMP.restrainer.XMLRepresentation('Nup84Complex_bead_repr_1.xml').run()
rsr = IMP.restrainer.XMLRestraint('Nup84Complex_restraint_1.xml').run()
disp = IMP.restrainer.XMLDisplay('Nup84Complex_display_1.xml').run()

model = rep.to_model()

log = disp.create_log(rep, 'bead_log_%03d.py')
log.write('initial.py')

rsr.add_to_representation(rep)

opt = IMP.core.ConjugateGradients()
opt.set_model(model)
opt.add_optimizer_state(log)

opt.optimize(10)
log.write('optimized.py')
