# This file is part of ModPipe, Copyright 1997-2010 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.


import re
import os

class Config(object):
    """A ModPipe configuration file"""

    def parse_file(self, fh):
        """Read a ModPipe configuration file"""
        def sub_env(m):
            env_variable = m.group(1)
            return os.environ[env_variable]

        comment = re.compile('\s*#')
        whitespace = re.compile('\s*$')
        for line in fh:
            if comment.match(line) or whitespace.match(line):
                continue

            tag, value = line.strip().split(None, 1)
            # Expand out any environment variables: $FOO ${FOO} $(FOO)
            value = re.sub("\$\((\w+)\)", sub_env, value)
            value = re.sub("\$\{(\w+)\}", sub_env, value)
            value = re.sub("\$(\w+)", sub_env, value)
            self.__dict__[tag] = value


def read_file(fh):
    """Create and return a new :class:`Config`, read
       from a configuration file"""
    config = Config()
    config.parse_file(fh)
    return config
