import unittest
import os
import modpipe.test
import modpipe.binaries
import subprocess
import modeller

class TMAlignTests(modpipe.test.TestCase):

    def test_tmalign(self):
        """Check TM-align"""
        seqs = ('GKSYPTVSPD', 'GKSYPTVSPS')
        fnames = ('test1.pdb', 'test2.pdb')
        e = modeller.environ()
        e.libs.topology.read('${LIB}/top_heav.lib')
        e.libs.parameters.read('${LIB}/par.lib')

        for s, fname in zip(seqs, fnames):
            m = modeller.model(e)
            m.build_sequence(s)
            m.write(file=fname)

        binary = modpipe.binaries.get_tmalign()
        p = subprocess.Popen([binary, '-p', fnames[0], '-q', fnames[1],
                              '-a', '', '-b', ''], stdout=subprocess.PIPE)
        lines = p.stdout.readlines()
        self.require_clean_exit(p)
        self.assertEqual([line.rstrip('\r\n') for line in lines[-4:-1]],
                         ['Chain 1: ' + seqs[0], 'Eqvpos : ::::::::::',
                          'Chain 2: ' + seqs[1]])
        for f in fnames:
            os.unlink(f)

if __name__ == '__main__':
    unittest.main()
