# This file is part of ModPipe, Copyright 1997-2010 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.


"""Simple cyclic redundancy check.
   This is based on the Perl implementation in SWISS::CRC64, which in turn is
   described by ISO 3309.
"""

# Initialisation
# 32 first bits of generator polynomial for CRC64
# the 32 lower bits are assumed to be zero
_POLY64REVh = 0xd8000000L
_CRCTableh = [0] * 256
_CRCTablel = [0] * 256
_is_initialized = False

def digest(s):
    """Return the 64-bit CRC of a string, as a 16-byte hex-encoded string."""
    global _is_initialized
    crcl = 0
    crch = 0
    if not _is_initialized:
        _is_initialized = True
        for i in range(256):
            partl = i
            parth = 0L
            for j in range(8):
                rflag = partl & 1L
                partl >>= 1L
                if (parth & 1):
                    partl |= (1L << 31L)
                parth >>= 1L
                if rflag:
                    parth ^= _POLY64REVh
            _CRCTableh[i] = parth;
            _CRCTablel[i] = partl;

    for item in s:
        shr = 0L
        shr = (crch & 0xFF) << 24
        temp1h = crch >> 8L
        temp1l = (crcl >> 8L) | shr
        tableindex = (crcl ^ ord(item)) & 0xFF

        crch = temp1h ^ _CRCTableh[tableindex]
        crcl = temp1l ^ _CRCTablel[tableindex]
    return "%08X%08X" % (crch, crcl)
