import unittest
import os
import modpipe.test
from modpipe.scripts import ClusterPDB

class ClusterPDBTests(modpipe.test.TestCase):

    def test_seqfile_exists(self):
        """Non-existing seqlist file should result in a ClusterPDB error"""
        self.assertRaises(IOError, self.run_script, 'scripts', ClusterPDB,
                          ['/does/not/exist'])

    def test_required_arguments(self):
        """Check required ClusterPDB arguments"""
        self.assertRaises(SystemExit, self.run_script, 'scripts',
                          ClusterPDB, [])

    def test_cluster_pdb(self):
        """Check PDB clustering"""
        codes = ['1sj2A', '1n8yC', '1ecsA', '1apxA', '1llp']
        groups = [['1sj2B'], [], ['1ecsB'], ['1apxB', '1apxC', '1apxD'], []]
        self.run_script('scripts', ClusterPDB, ['-f', 'pdb_95', '-t', '95',
                                                '../db/test-pdb.pir'])
        f = open('pdb_95.cod')
        self.assertEqual([lines.rstrip('\r\n') for lines in f], codes)
        f.close()
        os.unlink('pdb_95.cod')
        for n, line in enumerate(open('pdb_95.grp')):
            self.assertEqual(line.rstrip('\r\n '),
                             codes[n] + ' : '  \
                             + " ".join([codes[n]] + groups[n]))
        os.unlink('pdb_95.grp')
        pir_codes = []
        for line in open('pdb_95.pir'):
            if line.startswith('>P1;'):
                pir_codes.append(line[4:].rstrip('\r\n'))
        pir_codes.sort()
        sorted_codes = codes[:]
        sorted_codes.sort()
        self.assertEqual(sorted_codes, pir_codes)
        os.unlink('pdb_95.pir')
        for f in ['test-pdb.fsa', 'test-pdb95.clstr', 'test-pdb95.bak.clstr',
                  'test-pdb95']:
            os.unlink(f)

if __name__ == '__main__':
    unittest.main()
