import unittest
import sys
import os
import filecmp
import modpipe.test
from modpipe.scripts import MakeChains

class MakeChainsTests(modpipe.test.TestCase):

    pdb_codes = [('1apx', 'A', 'B', 'C'),
                 ('1ecs', 'A', 'B'),
                 ('1llp', ''),
                 ('1n8y', 'C'),
                 ('1sj2', 'A', 'B')]

    def _make_pdb_list(self, prefix='pdb', suffix='.ent'):
        tmp = 'pdb-list'
        f = open(tmp, 'w')
        for pdb in self.pdb_codes:
            print >> f, prefix + pdb[0] + suffix
        f.close()
        return tmp

    def test_pdblist_exists(self):
        """Non-existing PDB list file should result in a MakeChains error"""
        self.assertRaises(IOError, self.run_script, 'scripts', MakeChains,
                          ['/does/not/exist'])

    def test_required_arguments(self):
        """Check required MakeChains arguments"""
        self.assertRaises(SystemExit, self.run_script, 'scripts',
                          MakeChains, [])

    def test_make_individual_chains(self):
        """Check production of individual chains files"""
        pdblist = self._make_pdb_list()
        self.run_script('scripts', MakeChains,
                        ['-p', '../db/pdb', pdblist])
        for pdb in self.pdb_codes:
            for chain in pdb[1:]:
                os.unlink(pdb[0] + chain + '.chn')
        os.unlink(pdblist)

    def test_make_one_file(self):
        """Check production of one aggregated chains file"""
        pdblist = self._make_pdb_list()
        out = 'pdb-list.pir'
        if os.path.exists(out):
            os.unlink(out)
        self.run_script('scripts', MakeChains,
                        ['-o', out, '-p', '../db/pdb', pdblist])
        self.assert_(filecmp.cmp(out, '../db/test-pdb.pir'))
        os.unlink(out)
        os.unlink(pdblist)

    def test_invalid_format_pdb_list(self):
        """Check for invalid format PDB list files for MakeChains"""
        pdblist = self._make_pdb_list(prefix='')
        out = 'pdb-list.pir'
        self.assertRaises(modpipe.FileFormatError, self.run_script, 'scripts',
                          MakeChains,
                          ['-o', out, '-p', '../db/pdb', pdblist])
        os.unlink(out)
        os.unlink(pdblist)

if __name__ == '__main__':
    unittest.main()
