# This file is part of ModPipe, Copyright 1997-2010 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.

package MPLib::MPInit;
require Exporter;
@ISA    = qw(Exporter);

@EXPORT = qw(InitConf ModPipeInit WriteConf);

use strict;
use PLLib::Utils;

sub WriteConf {

   # --- Get subroutine name
   my $subname = GetSubrName();

   # --- Check arguments
   my $nargs = 2;

   unless ( scalar(@_) == $nargs ){
      print "${subname}__D> Insufficient arguments\n";
      return;
   }

   # --- Reassign input arguments
   my ($fh_conf, $conf_ref) = @_;

   # -- Write out configuration file
   foreach my $key ( keys %$conf_ref ){
      printf $fh_conf "%s\t\t\t%s\n", $key, $conf_ref->{$key};
   }

   # --- Return value
   return 1;
}

sub ModPipeInit {

   # --- Get subroutine name
   my $subname = GetSubrName();

   # --- Check arguments
   my $nargs = 1;

   unless ( scalar(@_) == $nargs ){
      print "${subname}__D> Insufficient arguments\n";
      return;
   }

   # --- Reassign input arguments
   my $conffile = $_[0];

   # --- Read the configuration file
   my $conf_ref = undef;
   die "${subname}__E> Failed to read configuration file\n"
      unless ( $conf_ref = ReadConf( $conffile ) );

   # --- Assign values to init:: namespace
   die "${subname}__E>Failed to convert configuration varibales to separate namespace\n"
      unless ( InitConf( $conf_ref ) );

   # --- Return
   return 1;
}


sub InitConf {

   # --- Get subroutine name
   my $subname = GetSubrName();

   # --- Check arguments
   my $nargs = 1;

   unless ( scalar(@_) == $nargs ){
      print "${subname}__D> Insufficient arguments\n";
      return;
   }

   # --- Reassign input arguments
   my $conf_ref = $_[0];
   my %conf     = %$conf_ref;

   # --- Assign values to the variables in the namespace

   #     --- Temporary directory
         $init::tmpdir     = $conf{TMPDIR};

   #     --- Repositories
         $init::datdir    = $conf{DATDIR};

   #     --- NRDBTAG
         $init::nrdbtag     = $conf{NRDBTAG};

   #     --- NR Sequence Database
         $init::nrseqdb     = $conf{NRSEQDB};

   #     --- Full Sequence Database
         $init::fullseqdb   = $conf{FULLSEQDB};

   #     --- Template sequence database
         $init::templateseqdb     = $conf{TEMPLATESEQDB};

   #     --- Database of structure profiles
         $init::xprflist     = $conf{XPRF_LIST};

   #     --- Database of structure sequences
         $init::xprfpir   = $conf{XPRF_PIR};

   #     --- Database of profile PSSMs
         $init::xprfpssmdb   = $conf{XPRF_PSSMDB};

   #     --- Directory of profile data
         $init::xprfdatdir   = $conf{XPRF_DATDIR};

   #     --- PDB repository
         $init::pdbrep    = $conf{PDB_REPOSITORY};

   #     --- PDB repository
         $init::pdbdir     = $conf{PDBDIR};

   #     --- TSVMod Executable
         $init::tsvmodexe     = $conf{TSVMODEXE};

   #     --- Profile update flag
         $init::prfupdate     = $conf{PRFUPDATE};

   #     --- Length cutoff for alignments
         $init::minalnlen     = $conf{MINALNLEN};

   #     --- Number of models per alignment
         $init::nummodels     = $conf{NUMMODELS};
  
   #     --- Select models by
         $init::selmodby     = $conf{SELECT_MODEL_BY};
         $init::retmodels    = $conf{RETURN_MODELS};

   #     --- NCBI Blast formatted database
         $init::ncbiseqdb      = $conf{NCBISEQDB};

   #     --- Include HETATOMS in modeling
         $init::hetatoms       = $conf{HETATOMS};
         $init::waters         = $conf{WATERS};

   #     --- Parameters for clustering alignments
         $init::clusterali          = $conf{CLUSTERALI};
         $init::aliclust_ovlp       = $conf{ALICLUST_OVLP};
         $init::aliclust_pcovlp     = $conf{ALICLUST_PCOVLP};
         $init::aliclust_nonovlp    = $conf{ALICLUST_NONOVLP};
         $init::aliclust_pcnonovlp  = $conf{ALICLUST_PCNONOVLP};
         $init::aliclust_idcol      = $conf{ALICLUST_IDCOL};
         $init::aliclust_pcidcol    = $conf{ALICLUST_PCIDCOL};

   # --- Return value
   return 1;

}

