# This file is part of ModPipe, Copyright 1997-2010 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.


def is_gap(r):
    """Returns True if gap ('-')"""
    if r == '-':
        return True
    else:
        return False

def parse_residue_number(r):
    """Convert a residue number to our preferred internal form. Use an integer
       if possible; otherwise (e.g. it contains an insertion code)
       use a string."""
    try:
        return int(r)
    except ValueError:
        return r
