import unittest
import os
import modpipe.test
import modpipe.binaries

class FormatDBTests(modpipe.test.TestCase):

    def test_formatdb(self):
        """Check BLAST's formatdb"""
        log = 'fmdb.log'
        base = 'test-fmdb'
        self.run_binary(modpipe.binaries.get_blast('formatdb'),
                        ['-i', '../db/test-pdb.fsa', '-n', base, '-l', log])
        lines = file(log).readlines()
        self.assertEqual(lines[-1].rstrip('\r\n'),
                         "Formatted 10 sequences in volume 0")
        os.unlink(log)
        for f in ('pin', 'phr', 'psq'):
            os.unlink(base + '.' + f)

if __name__ == '__main__':
    unittest.main()
