import unittest
import modpipe.test
import os
from modpipe.matrix2d import Matrix2D

class Matrix2DTests(modpipe.test.TestCase):

    def test_get_set_element(self):
        """Check get and set of Matrix2D objects"""
        m = Matrix2D(10, 5)
        self.assertEqual(m[4, 3], 0.0)
        m[4, 3] = 14.0
        self.assertEqual(m[4, 3], 14.0)
        self.assertEqual(m[-6, 3], 14.0)
        self.assertEqual(m[4, -2], 14.0)
        self.assertEqual(m[3, 4], 0.0)

    def test_outrange_element(self):
        """Check for out of range elements of Matrix2D objects"""
        m = Matrix2D(4, 3)
        for (row, col) in ((4, 0), (3, 3)):
            self.assertRaises(IndexError, m.__getitem__, (row, col))
        for (row, col) in ((0, 0), (3, 2), (3, 0), (0, 2), (-1, 2), (0, -1)):
            x = m[row, col]

    def test_write(self):
        """Check Matrix2D.write() method"""
        m = Matrix2D(4, 3)
        m[1, 0] = 9
        f = 'test.out'
        m.write(file=f)
        lines = file(f).readlines()
        self.assertEqual([x.strip() for x in lines],
                         ['4 3', '0 0 0', '9 0 0', '0 0 0', '0 0 0'])
        m.write(file=f, dimensions=False)
        lines = file(f).readlines()
        self.assertEqual([x.strip() for x in lines],
                         ['0 0 0', '9 0 0', '0 0 0', '0 0 0'])
        os.unlink(f)

if __name__ == '__main__':
    unittest.main()
