import unittest
import os
import modpipe.test
from modpipe.scripts import MakeHDF5

class MakeHDF5Tests(modpipe.test.TestCase):

    inpfile = '../db/test-pdb.pir'
    outfile = 'test-pdb.hdf5'

    def test_pdblist_exists(self):
        """Non-existing input sequence file should result in a MakeHDF5 error"""
        self.assertRaises(IOError, self.run_script, 'scripts', MakeHDF5,
                          ['/does/not/exist', self.outfile])

    def test_required_arguments(self):
        """Check required MakeHDF5 arguments"""
        for args in [], [self.inpfile], [self.inpfile, self.outfile, 'garbage']:
            self.assertRaises(SystemExit, self.run_script, 'scripts',
                              MakeHDF5, args)

    def test_make_hdf5(self):
        """Check production of HDF5 file"""
        self.run_script('scripts', MakeHDF5,
                        ['-f', 'PIR', self.inpfile, self.outfile])
        os.unlink(self.outfile)


if __name__ == '__main__':
    unittest.main()
