# Modeling using a provided initial structure file (inifile)

from modeller.automodel import *    # Load the automodel class

log.verbose()
env = environ()

# directories for input atom files
env.io.atom_files_directory = '.'

a = automodel(env,
              alnfile  = 'alignment.seg1.ali',     # alignment filename
              knowns   = '1U19',              # codes of the templates
              sequence = 'GHSR',              # code of the target
              inifile  = 'helices.pdb')    # use 'my' initial structure
a.starting_model= 1                 # index of the first model 
a.ending_model  = 1                 # index of the last model
                                    # (determines how many models to calculate)
a.make()                            # do homology modelling
