C**********************************************************************
C
C
C                       PROPRIETARY AND CONFIDENTIAL
C          MODELLER       Copyright 1991-1997 by Andrej Sali.
C          Licensed exclusively to Molecular Simulations Inc.
C
C       $Header: /usr/people/lly/modeler/checkin/energy/RCS/harmonic.f,v 1.1 1997/02/27 18:39:35 lly Exp $
C
C       Author: Andrej Sali
C
C       Change record:
C
C       $Log:	harmonic.f,v $
C	Revision 1.1  1997/02/27  18:39:35  lly
C	Initial revision
C	
C
C*********************************************************************
C

cf ----------------------------------------------------------------------------
cf
cf    pcsr(1) ... mean
cf    pcsr(2) ... standard deviation
cf
cf ----------------------------------------------------------------------------

      real function harmonic2(deriv,fact,iftyp,indatm,nacns,pcsr,npcns)
        implicit none
#include "mod.cst"
#include "model.cmn"
        integer iftyp,nacns,npcns,indatm(nacns)
        real pcsr(npcns),feat,harmonic,tmps,fact
        logical deriv

        call feature(x,y,z,natmp,indatm,nacns,iftyp,feat,1)

        harmonic2 = harmonic(fact,feat,iftyp,pcsr,npcns,tmps)

        if (deriv) call dharmonic(fact,feat,iftyp,indatm,nacns,
     &                            pcsr,npcns,tmps)

        return
      end



      real function harmonic(fact,feat,iftyp,pcsr,npcns,tmps)
        implicit none
#include "numbers.cst"
        integer iftyp, npcns
        real feat,pcsr(npcns),tmps,differ,fact

c ----- calculate the difference between feature and ideal value:
        call deltaf(feat,1,pcsr(1),iftyp,differ)

c ----- calculate the normalized violation
        tmps = differ/pcsr(2)

        harmonic = fact*rt*(0.5*tmps*tmps)

        return
      end



      subroutine dharmonic(fact,feat,iftyp,indatm,nacns,pcsr,npcns,tmps)
        implicit none
#include "mod.cst"
#include "model.cmn"
#include "opt.cmn"
        integer iftyp,nacns,npcns,i,k,indatm(nacns)
        real pcsr(npcns),feat,tmps,fact
        real dervx(mapcsr), dervy(mapcsr), dervz(mapcsr), fderf

c ----- according to the chain derivation rule, the partial derivative
c       with respect to x of the function F of f, where f is a function of
c       x, is: partial derivative of F with respect to f multiplied by
c       the partial derivative of f with respect to x
c       (in this case, for F = -log(Gaussian on f), this derivative is
c       [(normalized feature) / sigma], i.e. tmps/stand dev)

        call featder(x,y,z,natmp,indatm,nacns,feat,1,
     &               dervx,dervy,dervz,iftyp)

c ----- multiply them with the partial derivative of F with respect to f
        fderf = fact * rt * tmps / pcsr(2)

c ------add the derivative contributions to the accumulating derivative arrays:
        do  i = 1, nacns
          k      = indatm(i)
          dvx(k) = dvx(k) + fderf*dervx(i)
          dvy(k) = dvy(k) + fderf*dervy(i)
          dvz(k) = dvz(k) + fderf*dervz(i)
        end do

        return
      end


      real function leftharmonic2(deriv,fact,iftyp,indatm,nacns,
     &                            pcsr,npcns)
        implicit none
#include "mod.cst"
#include "model.cmn"
        integer nacns,npcns,iftyp,indatm(nacns)
        real pcsr(npcns),feat,tmps,differ,harmonic,fact
        logical deriv

        call feature(x,y,z,natmp,indatm,nacns,iftyp,feat,1)

c ----- calculate the difference between feature and ideal value:
        differ = feat - pcsr(1)

        if (differ .lt. 0.0) then
          leftharmonic2 = harmonic(fact,feat,iftyp,pcsr,npcns,tmps)
          if (deriv)
     &      call dharmonic(fact,feat,iftyp,indatm,nacns,pcsr,npcns,tmps)
        else
          leftharmonic2 = 0.0
        end if

        return
      end


      real function leftharmonic(fact,feat,pcsr,npcns)
        implicit none
#include "numbers.cst"
        integer npcns
        real feat,pcsr(npcns),tmps,differ,fact

c ----- calculate the difference between feature and ideal value:
        differ = feat - pcsr(1)

        if (differ .lt. 0.0) then
c ------- calculate the normalized violation
          tmps = differ/pcsr(2)
          leftharmonic = fact*rt*(0.5*tmps*tmps)
        else
          leftharmonic = 0.0
        end if

        return
      end


      real function rightharmonic2(deriv,fact,iftyp,indatm,nacns,
     &                             pcsr,npcns)
        implicit none
#include "mod.cst"
#include "model.cmn"
        integer nacns,npcns,iftyp,indatm(nacns)
        real pcsr(npcns),feat,tmps,differ,harmonic,fact
        logical deriv

        call feature(x,y,z,natmp,indatm,nacns,iftyp,feat,1)

c ----- calculate the difference between feature and ideal value:
        differ = feat - pcsr(1)

        if (differ .gt. 0.0) then
          rightharmonic2 = harmonic(fact,feat,iftyp,pcsr,npcns,tmps)
c ------- update the first -derivatives?
          if (deriv) call dharmonic(fact,feat,iftyp,indatm,nacns,
     &                              pcsr,npcns,tmps)
        else
          rightharmonic2 = 0.0
        end if

        return
      end



      real function rightharmonic(fact,feat,pcsr,npcns)
        implicit none
#include "numbers.cst"
        integer npcns
        real feat,pcsr(npcns),tmps,differ,fact

c ----- calculate the difference between feature and ideal value:
        differ = feat - pcsr(1)

        if (differ .gt. 0.0) then
c ------- calculate the normalized violation
          tmps = differ/pcsr(2)
          rightharmonic = fact*rt*(0.5*tmps*tmps)
        else
          rightharmonic = 0.0
        end if

        return
      end


      real function vmin1(iftyp,indatm,nacns,pcsr,npcns)
        implicit none
#include "mod.cst"
#include "model.cmn"
        integer nacns,npcns,iftyp,indatm(nacns)
        real pcsr(npcns), feat

        call feature(x,y,z,natmp,indatm,nacns,iftyp,feat,1)

        vmin1 = min(0.0, feat - pcsr(1))

        return
      end


      real function rsrmin1(pcsr,npcns)
        implicit none
        integer npcns
        real pcsr(npcns)
        
        rsrmin1 = pcsr(1)

        return
      end


      real function rvmin1(iftyp,indatm,nacns,pcsr,npcns)
        implicit none
        integer npcns, nacns, iftyp, indatm(nacns)
        real pcsr(npcns), vmin1
        external vmin1

        rvmin1 = vmin1(iftyp,indatm,nacns,pcsr,npcns)/pcsr(2)

        return
      end


      real function vmin2(iftyp,indatm,nacns,pcsr,npcns)
        implicit none
#include "mod.cst"
#include "model.cmn"
        integer nacns, npcns, indatm(nacns), iftyp
        real pcsr(npcns), feat

        call feature(x,y,z,natmp,indatm,nacns,iftyp,feat,1)

        vmin2 = max(0.0, feat - pcsr(1))

        return
      end


      real function rvmin2(iftyp,indatm,nacns,pcsr,npcns)
        implicit none
        integer nacns, npcns, iftyp, indatm(nacns)
        real pcsr(npcns), vmin2
        external vmin2

        rvmin2 = vmin2(iftyp,indatm,nacns,pcsr,npcns)/pcsr(2)

        return
      end


      real function vmin3(iftyp,indatm,nacns,pcsr,npcns)
        implicit none
#include "mod.cst"
#include "model.cmn"
        integer iftyp, nacns, npcns, indatm(nacns)
        real pcsr(npcns), feat, differ

        call feature(x,y,z,natmp,indatm,nacns,iftyp,feat,1)

        call deltaf(feat,1,pcsr(1),iftyp,differ)
        vmin3 = differ

        return
      end



      real function rvmin3(iftyp,indatm,nacns,pcsr,npcns)
        implicit none
        integer iftyp, nacns, npcns, indatm(nacns)
        real pcsr(npcns), vmin3
        external vmin3

        rvmin3 = vmin3(iftyp,indatm,nacns,pcsr,npcns)/pcsr(2)

        return
      end


      subroutine sclrsr1(pcsr,npcns,fact)
        implicit none
        integer npcns
        real pcsr(npcns), fact

        pcsr(1) = fact*pcsr(1)

        return
      end
