from modeller import *      # Load Modeller Python module
log.verbose()               # request verbose logging
env = environ()             # create a Modeller environment

aln = alignment(env)        # create an empty alignment

# Read in the template PDB file, and add its sequence to the 
# alignment
mdl = model(env, file='1hms')
aln.append_model(mdl, align_codes='1hms')
# Now add the BLBP sequence
aln.append(file='blbp.seq', align_codes='blbp')

# Align the 1hms and blbp sequences (simple sequence-sequence)
aln.align(gap_penalties_1d=(-600, -400))

# Write out the alignment in both PIR and PAP format
aln.write(file='blbp-1hms.ali', alignment_format='PIR')
aln.write(file='blbp-1hms.pap', alignment_format='PAP') 
