import chimera
import DBPuppet

class Browser_Setup_EMO(chimera.extension.EMO):
  """Extension Management Object (EMO) for browser set-up interface"""

  def name(self):
    return "Browser configuration"
  def description(self):
    return "Set up system web browsers to recognize '.chimerax' files"
  def categories(self):
    return ['DBPuppet']
  def icon(self):
    return None
  def activate(self):
    self.module().ConfigBrowser()
    
    
class Mod_Control_On_EMO(chimera.extension.EMO):
  """Extension Management Object (EMO) to start listening"""

  def name(self):
    return 'Database Control On'
  def description(self):
    return 'Allow Chimera to open files from Databases'
  def categories(self):
    return ['DBPuppet']
  def icon(self):
    return None
  def activate(self):
    ##if you have not already created an instance
    if not self.module().puppet:
      ## create an instance
      self.module().puppet = self.module().DBPuppet("Database Puppet", self.module().PuppetHandler.PuppetHandler)
      ## start listening
      self.module().puppet.start_listening()
      
      self.module().ListenStatusDialog("Chimera is now listening for requests...")

    else:
      ## you already have an instance
      self.module().ListenStatusDialog("Chimera is already listening for requests!!")
  
    return None



## register with the Chimera extension manager
chimera.extension.manager.registerExtension(Mod_Control_On_EMO(__file__))
chimera.extension.manager.registerExtension(Browser_Setup_EMO(__file__))




