import Tkinter
import os,string,sys,shutil
import chimera
from chimera.baseDialog import ModelessDialog

class InstallDialog(ModelessDialog):
    name = "Browser Configuration"
    buttons = ('Back', 'Next', 'Cancel')
    provideStatus = False

    def fillInUI(self, parent):
        self.setUpFrames(parent)
        self.addTitle()        
        self.addIntro()
        
        
    def __init__(self):

        self.installFuncs = {'IE': self.installIE, 'Mozilla/Netscape': self.installMozNet,
                        'Netscape': self.installNet, 'Konqueror': self.installKDE,
                        'Netscape(windows)': self.installWinNet} 

        self.paneState = 0

        try:
            self.home_dir = os.environ['HOME']
        except KeyError:
            ##probably on Windows
            pass


        pf = chimera.pathFinder()
        self.data_root = pf.dataRoot
        del pf
        
        ModelessDialog.__init__(self)

    def addTitle(self):
        self.titleLabel = Tkinter.Label(self.titleFrame, text="Browser Configuration", font=('arial',12,'bold'))
        self.titleLabel.pack(side='top', fill='x', pady=5)
                                        

    def setInfo(self, text, location = Tkinter.END, color = 'black', ovwrt = True, tagName = 'DEFAULT', fnt=('times',12,'normal') ):
       
        self.infoText.configure(state = 'normal')

        if ovwrt:
            self.infoText.delete('0.0', Tkinter.END)
            self.infoText.tag_delete(self.infoText.tag_names())

        self.infoText.insert(location, text, tagName)
        self.infoText.tag_config(tagName, foreground=color, font=fnt)
        
        self.infoText.configure(state = 'disabled')

    def setUpFrames(self,parent):
        self.titleFrame = Tkinter.Frame(parent)#, height=25)
        self.infoFrame = Tkinter.Frame(parent)#, width=410, height=75)
        self.listFrame = Tkinter.Frame(parent, width=410, height=175)

        self.titleFrame.pack(side='top', padx=5, fill='x')
        self.infoFrame.pack(side='top', fill='x')
        self.listFrame.pack(side='top', fill='x') 
        

    def Back(self):
        if self.paneState==2:
            self.list.pack(side='top',fill='x')
            self.setInfo("Chimera has detected the following web browsers installed on your system. Please select the ones you will use to open chimera files, and click 'Next' to continue.")
            self.paneState = 1
            
    def Next(self):
        if self.paneState == 0:
            browsers = self.findBrowsers()
            if browsers != []:
                self.addInfo(1)
                self.addListbox(browsers)
                ##now it's '1'
                self.paneState = 1
            else:
                self.addInfo(0)

        elif self.paneState == 1:
            self.list.forget()
            
            msg = "You have chosen to configure the following browsers:\n\n   "
                        
            selectedBrowserIndices = self.list.curselection()
            self.selectedBrowserNames = []
            for index in selectedBrowserIndices:
                self.selectedBrowserNames.append(self.list.get(index))

            if self.selectedBrowserNames == []:
                self.selectedBrowserNames.append("None")
                self.setInfo("You have not chosen any browsers. Please go back and select a browser.")
            else:
                self.setInfo(msg)
                self.setInfo(string.join(self.selectedBrowserNames, '\n  '), ovwrt=False, tagName = 'browsers', color='blue', fnt=('times', 12, 'bold'))
                self.setInfo("\n\nClick next to continue.", ovwrt=False)
                            
            self.paneState = 2

        elif self.paneState == 2:
            data=''
            self.setInfo('') ##reset the info fieled
            for name in self.selectedBrowserNames:
                print "INSTALLING FOR ", name, "....."
                msg = apply(self.installFuncs[name],())
                if msg[0] == 0:
                    self.setInfo("ERROR", color='red', ovwrt=False, tagName='fail_msg', fnt=('times', 12, 'bold'))
                    self.setInfo(": %s\n\n" % msg[1], ovwrt=False)
                else:
                    self.setInfo("OK", color='black', ovwrt=False, tagName='succ_msg', fnt=('times', 12, 'bold'))
                    self.setInfo(": %s\n\n" % msg[1], ovwrt=False)
                    
            self.setInfo("\nPress \'Next\' to exit",ovwrt=False)
            self.paneState = 3

        elif self.paneState == 3:
            self.Cancel()
    
    def addIntro(self):
        self.paneState = 0
        self.infoText = Tkinter.Text(self.infoFrame, 
                                     relief='flat',
                                     wrap='word',
                                     padx=5,
                                     pady=5,
                                     height=10,
                                     width=50
                                     )
        self.setInfo("Chimera can set up web browsers to automatically recognize and open files ending with the \'.chimerax\' suffix. This dialog will configure your browsers for use with Chimera.\n\n You can click 'Cancel' any time to exit the dialog.\n\nClick 'Next' to continue...")
        
        self.infoText.pack(side='top', fill='x')


    def addInfo(self, browsersExist):
        if browsersExist:
            self.setInfo("Chimera has detected the following web browsers installed on your system. Please select the ones you will use to open chimera files, and click 'Next' to continue.", location='2.0')
        else:
            self.setInfo("Chimera has not detected any browsers on your system. Please try again when you have a browser installed")
            ##dead end
        
    def addListbox(self, browsers):
        self.list = Tkinter.Listbox(self.listFrame, selectmode=Tkinter.EXTENDED)
        self.list.insert(Tkinter.END, *browsers)
        self.list.pack(side='top', fill='x')
           
    def quit(self):
         self.main.destroy()
         sys.exit()
                
    
    def findBrowsers(self):
        browsers = []

        if sys.platform == "win32":
            browsers.append("IE")
            if self.checkForWinNetscape():
                browsers.append("Netscape(windows)")
            
        elif ( (string.find(sys.platform, "linux") >= 0) or (string.find(sys.platform, "irix")  >= 0)  or (string.find(sys.platform, "osf1")  >= 0) ):
            if self.checkForMozillaNetscape():
                browsers.append("Mozilla/Netscape")
            if self.checkForKonqueror():
                browsers.append("Konqueror")            

        return browsers


    def checkForWinNetscape(self):
        return os.access(os.path.join("C:\\","Program Files", "Netscape"), os.F_OK)
        
    def checkForMozillaNetscape(self):
        return ( os.access(os.path.join(self.home_dir, ".mozilla"), os.F_OK) or os.access(os.path.join(self.home_dir, ".netscape"), os.F_OK) )
                 
    def checkForKonqueror(self):
         return os.access(os.path.join(self.home_dir, ".kde"), os.F_OK)
                 
    #def checkForNetscape(self):
    #     return os.access(os.path.join(self.home_dir, ".netscape"), os.F_OK)


    def installIE(self):
        try:
            import _winreg
            
            extension_key = _winreg.CreateKey(_winreg.HKEY_CLASSES_ROOT, ".chimerax")
            extension_key = _winreg.OpenKey(_winreg.HKEY_CLASSES_ROOT, ".chimerax", 0, _winreg.KEY_SET_VALUE)
            
            _winreg.SetValue(_winreg.HKEY_CLASSES_ROOT, ".chimerax", _winreg.REG_SZ, "chimeraxfile")
            _winreg.SetValueEx(extension_key, "Content Type", 0, _winreg.REG_SZ, "application/x-chimerax")
            
            fdesc_key =  _winreg.CreateKey(_winreg.HKEY_CLASSES_ROOT, "chimeraxfile")
             ##do i need to do this/ assign this??
            _winreg.OpenKey(_winreg.HKEY_CLASSES_ROOT, "chimeraxfile", 0, _winreg.KEY_SET_VALUE)
            _winreg.SetValue(_winreg.HKEY_CLASSES_ROOT, "chimeraxfile", _winreg.REG_SZ, "Chimera Puppet File")
            
            ##can probably lump these two (maybe more) commands into one
            shell_key = _winreg.CreateKey(fdesc_key, "shell")
            open_key  = _winreg.CreateKey(shell_key, "open")
            
            cmd_key   = _winreg.CreateKey(open_key, "command")
            _winreg.OpenKey(open_key, "command", 0, _winreg.KEY_SET_VALUE) 
            _winreg.SetValue(open_key, "command", _winreg.REG_SZ, "%s \"%s\\DBPuppet\\send_to_chimera.py\" \"%%1\"" % (sys.executable, self.data_root) )
                        
            return (1,"Internet Explorer succesfully configured to open '.chimerax' files")

        except:
            return (0,"Unable to configure Internet Explorer to open 'chimerax' files")

    def installMozNet(self):
        status = (1, "Chimera has succesfully configured Mozilla/Netscape to open '.chimerax' files")
        
        ##check if user has a .mime.types file in their home directory
        mime_exists    = os.access(os.path.join(self.home_dir, ".mime.types"), os.F_OK)
        
        ##check if user has a .mailcap file in their home directory
        mailcap_exists = os.access(os.path.join(self.home_dir, ".mailcap"), os.F_OK)

        ##check to see if there is a .mime.types file in user's home directory
        
        ##if not
        if not mime_exists:
            print "Home directory does not contain .mime.types, creating now..."
            try:
                mime_file = open(os.path.join(self.home_dir,".mime.types"), 'w')
                #mime_file.write("#--Netscape Communications Corporation MIME Information\n")
                #mime_file.write("#Do not delete the above line. It is used to identify the file type.\n")
                #mime_file.write("#\n")
                writeChimeraxMime(mime_file)
            except:
                status = (0, "Unable to write .mime.types file in %s" % self.home_dir)
                return status
                

        ##if .mime.types does exist
        else:  
            print ".mime.types file already exists, checking if chimerax MIME-type is registered..."

            ##check to see if there is already an application/x-chimerax registered
            try:
                mime_file = open(os.path.join(self.home_dir,".mime.types"), 'r')
            except:
                status = (0, "Unable to read file %s" % os.path.join(self.home_dir,".mime.types"))
                return status
            chimerax_reg = 0
            for line in mime_file.readlines():
                if string.find(line,"application/x-chimerax") >= 0:
                    chimerax_reg = 1
            mime_file.close()
    
            if chimerax_reg: ##x-chimerax already registered mime-type
                print "chimerax already registered in .mime.types!!"
            else: ##not registered yet, add it
                ##create backup, just in case...
                MIME_BACKUP = os.path.join(self.home_dir, ".mime.types.CHBAK")
                print "creating backup of .mime.types file in %s" % MIME_BACKUP
                try:
                    shutil.copy(os.path.join(self.home_dir, ".mime.types"), MIME_BACKUP)
                except:
                    print "Unable to make backup of .mime.types file"

                ##write new informatino to the mimetypes file
                try:
                    mime_file = open(os.path.join(self.home_dir,".mime.types"), 'a')
                    writeChimeraxMime(mime_file)
                except:
                     return (0,"Unable to write information to %s" % os.path.join(self.home_dir,".mime.types"))

                    
        ##if the ~/.mailcap file doesnt exist
        if not mailcap_exists:
            print "Home directory does not contain .mailcap file, creating now..."
            try:
                mailcap_file = open(os.path.join(self.home_dir,".mailcap"), 'w')
                writeChimeraxMailcap(mailcap_file, self.data_root)
            except:
                status = (0, "Unable to write .mailcap file in %s" % self.home_dir)
                return status
            
        else: ##~/.mailcap does exist
            print ".mailcap file already exists, checking if chimerax MIME-type is registered..."
            
            ##check to see if application/x-chimerax has associated application
            try:
                mailcap_file = open(os.path.join(self.home_dir,".mailcap"), 'r')
            except:
                status = (0, "Unable to read file %s" % os.path.join(self.home_dir,".mailcap"))
                return status
            chimerax_reg = 0

            for line in mailcap_file.readlines():
                if string.find(line, "application/x-chimerax") >= 0:
                    chimerax_reg = 1
            mailcap_file.close()

            if chimerax_reg: ##yes it has already been associated
                print "chimerax is already registered in .mailcap!!"
            else: ##nope, write to the pre-existing file
                ##create abckup, just in case..
                MCAP_BACKUP = os.path.join(self.home_dir, ".mailcap.CHBAK")
                print "creating backup of .mailcap file in %s" % MCAP_BACKUP
                try:
                    shutil.copy(os.path.join(self.home_dir, ".mailcap"), MCAP_BACKUP)
                except:
                    print "Unable to make backup of .mailcap file"
                ##write new information to the mailcap file

                try:
                    mailcap_file = open(os.path.join(self.home_dir,".mailcap"), 'a')
                    writeChimeraxMailcap(mailcap_file, self.data_root)
                except:
                    return (0,"Unable to write information to %s" % os.path.join(self.home_dir,".mailcap"))
                    
        return status


    
    def installNet(self):
        pass
    
    def installWinNet(self):
        ok = self.installIE()
        if ok[0]==1:
            return (1,"Netscape succesfully configured to open \'.chimerax\' files")
        else:
            return (0,"Unable to configure Netscape to open 'chimerax' files")
            
    
    def installKDE(self):
        kde_exists    = os.access(os.path.join(self.home_dir,".kde"), os.F_OK)
        status = (1,'Konquerer succesfully configured to open \'.chimerax\' files!!')

        
        ##need to determine what Linux flavor is
        flavor = ''
        if os.uname()[0] == "Linux":
            ##won't always be /etc/redhat-release , need to check on suse"
            linux_id_file = open("/etc/redhat-release",'r').read()
            if string.find(linux_id_file, "Red Hat") == 0:
                flavor = "redhat"
            elif string.find(linux_id_file, "Mandrake") == 0:
                flavor = "mdk"
            elif string.find(linux_id_file, "SuSE") == 0:
                flavor = "SuSE"
        

        ##directory contains files that match mime-types to applications (like .mailcap)
        APPLNK_DIR  = os.path.join(self.home_dir, ".kde", "share", "applnk-%s" % flavor)

        ##directory contains files that match extensions to mimetypes (like .mime.types)
        MIMELNK_DIR = os.path.join(self.home_dir, ".kde", "share", "mimelnk", "application") 


        if not kde_exists: ##they're not running KDE, and they've never used Konquerer before...
            print "Home directory does not contain a .kde directory, creating tree now..."
            try:
                os.makedirs(MIMELNK_DIR)
                os.makedirs(APPLNK_DIR)
            
                mimelnk_file = open(os.path.join(MIMELNK_DIR, "x-chimerax.desktop"), 'w')
                writeChimeraxMimelnk(mimelnk_file)
            
                applnk_file = open(os.path.join(APPLNK_DIR,"chimera.desktop"), 'w')
                writeChimeraxApplnk(applnk_file)
            except:
                return (0, "Unable to create ~/.kde root directory")

        else:
            print "Home directory contains .kde directory, checking if chimera is registered...."

             ##Check if there is a ~/.kde/share/mimelnk/application directory
             ##there could be a ~/.kde/share/mimelnk/audio,video,image,text without there being an .../application
             ## (although this is highly unlikely)

            try:
                ##assumes that ~/.kde/share/mimelnk already exists
                os.mkdir(MIMELNK_DIR)
            except OSError, what:
                if what.errno == 17:
                    ##OK, means that ..../application already exists
                    print "~/.kde/share/mimelnk/application already exists..."
                elif what.errno == 2:
                    ##means that ~/.kde/share/mimelnk (or some subcomponent) doesn't exist
                    print "Problem recognizing .kde directory hierarchy..."
                    print "Creating directory(s) ~/.kde/share/mimelnk/application now"
                    try:
                        os.makedirs(MIMELNK_DIR)
                    except:
                        status = (0,"Unable to properly configure Konquerer!!")
                        sys.exit("Unable to establish chimera associations for Konquerer browser")

            if os.access(os.path.join(MIMELNK_DIR, "x-chimerax.desktop"), os.F_OK):
                print "x-chimerax is already registered as a MIME-type"
            else:
                try:
                    mimelnk_file = open(os.path.join(MIMELNK_DIR, "x-chimerax.desktop"), 'w')
                    writeChimeraxMimelnk(mimelnk_file)
                except:
                    return (0, "Unable to write file %s" % os.path.join(MIMELNK_DIR, "x-chimerax.desktop"))


             ##ONce again, assume that ~/.kde/share/applnk-LINUX/ already exists
            if os.access(os.path.join(APPLNK_DIR, "chimera.desktop"), os.F_OK):
                print "chimera is already registered to handle .chimerax files"
            else:
                try:
                    applnk_file = open(os.path.join(APPLNK_DIR, "chimera.desktop"), 'w')
                except IOError, what:
                    if what.errno == 2:
                        ##means that ~/.kde/share... probably does not exist
                        print "Problem recognizing .kde directory hierarchy..."
                        print "Creating directory(s) ~/.kde/share/applnk-%s now..." % flavor
                        try:
                            os.makedirs(APPLNK_DIR)
                        except:
                            status = (0,"Unable to properly configure Konquerer to open /'.chimerax/' files!!")
                            sys.exit("Unable to establish chimera associations for Konquerer browser")   
                        applnk_file = open(os.path.join(APPLNK_DIR, "chimera.desktop"), 'w')

                try:
                    writeChimeraxApplnk(applnk_file)
                except:
                    return (0, "Unable to write file %s" % os.path.join(APPLNK_DIR, "chimera.desktop"))
        return status

            
    ##This function registers application/x-chimerax as a mime-type
def writeChimeraxMime(mime_file):
    print "Registering x-chimerax MIME type"
    mime_file.write("#mime type added by Chimera\n")
    mime_file.write("application/x-chimerax chimerax\n")
    mime_file.close()

##This function associates an application with the application/x-chimerax mime-type 
def writeChimeraxMailcap(mc_file, data_root):
    print "Registering chimera to handle .chimerax files"
    mc_file.write("#mailcap entry added by Chimera\n")
    mc_file.write("application/x-chimerax;%s/DBPuppet/send_to_chimera %%s\n" % data_root)
    mc_file.close()


##FOR KONQUERER, writes a .desktop file that identifies the application/x-chimerax mime-type
def writeChimeraxMimelnk(mime_file):
    print "Writing MIMELNK file for KDE"
    mime_file.write("[Desktop Entry]\n")
    mime_file.write("Comment=Chimera Python Code\n")
    mime_file.write("Hidden=false\n")
    mime_file.write("Icon=\n")
    mime_file.write("MimeType=application/x-chimerax\n")
    mime_file.write("Patterns=*.chimerax\n")
    mime_file.write("Type=MimeType\n")
    mime_file.close()
      

##FOR KONQUERER, writes a .desktop file that associates an application with the application/x-chimerax mime-type
def writeChimeraxApplnk(app_file):
    print "Writing APPLNK file for KDE"
    app_file.write("[Desktop Entry]\n")
    app_file.write("Comment=\n")
    app_file.write("Exec=/usr/local/chimera/bin/chimera\n")
    app_file.write("Icon=unknown\n")
    app_file.write("InitialPreference=2\n")
    app_file.write("MimeType=application/x-chimerax;Application\n")
    app_file.write("Name=chimera\n")
    app_file.write("ServiceTypes=\n")
    app_file.write("Terminal=false\n")
    app_file.write("Type=Application\n")
    app_file.close()


#if __name__ == '__main__':        
#install = InstallDialog()
        
