import sys, string
from SocketServer import *


## WILL NOT SUBCLASS THIS FILE!!

class PuppetServer(TCPServer):
    
    def __init__(self, server_address, keys, doQueue, handler_class):
        TCPServer.__init__(self, server_address, handler_class)
        self.keys = keys
        self.doQueue = doQueue


    def verify_request(self, request, client_address):
        if client_address[0] != "127.0.0.1":
            self.printMsg("attempted connection from %s. Closing connection" % client_address[0])
            self.close_request(request)
            return 0
        
        msg = request.recv(8)
        if msg != "identify":
            self.printMsg("Error in initial client request: %s" % msg)
            self.close_request(request)
            return 0

        #self.printMsg( "GOT IDENTIFY" )
        #self.printMsg( "writing 'CHIMERA' to socket..." )
      
        numwritten = request.send("CHIMERA")

         ## attempt to read the key in from the data stream
        key = ''
        read_data = ''

        #self.printMsg("reading key...")
          
        read_data = request.recv(1)
        key = key + read_data

        #self.printMsg( "got *%s* for read_data" % read_data )
        
        while (read_data != '<'):
            read_data  = request.recv(1)
            key = key + read_data
        #self.printMsg( "OUT OF LOOP!!\nKEY is: *%s*" % (key) )

        key1, key2, key3 = key[:-1].split()
   
        ## make sure the keys supplied by the client (read over the socket stream)
        ## match the keys you wrote
        if map(string.atoi, (key1,key2,key3)) != self.keys:
            self.printMsg("failed verification, goodbye")
            self.close_request(request)
            return 0
        else:
            #self.printMsg("Verification OK")
            return 1

        
        
    def printMsg(self, msg):
        sys.__stdout__.write("[PuppetServer]:  %s\n" % msg)
        sys.__stdout__.flush()


