import Queue
from HTMLParser import HTMLParser
import tempfile, urlparse, urllib

import chimera
from chimera.baseDialog import ModelessDialog
import os, os.path, sys, socket, string

from ServerThread import ServerThread
import PuppetHandler ##need this in here so ChimeraExtension can access it


puppet = None

def ConfigBrowser():
  import GUI
  chimera.dialogs.register("Browser Configuration", GUI.InstallDialog, replace=1)
  chimera.dialogs.display("Browser Configuration")


class ListenStatusDialog(ModelessDialog):

    title = "DBPuppet Status"
    buttons = ('OK')
    highlight = 'OK'

    def __init__(self, text):
        self.text = text
        ModelessDialog.__init__(self, oneshot=1)

    def fillInUI(self, parent):
        import Tkinter
        l = Tkinter.Label(parent, text = "%s" % self.text)
        l.grid(row=0, column=0, sticky="nsew")
        parent.rowconfigure(0,weight=1)
        parent.columnconfigure(0, weight=1)


class DBPuppet:

  def __init__(self, name, handler):
    self.server_thread = None
    ## for security purposes. path to a file that will hold a 'key' which
    ## will allow Helper application to communicate with Chimera
    self.keypath = os.path.join("%s" % tempfile.gettempdir(), "puppet.key")

    self.name = name
    self.handler = handler

    self.doQueue = Queue.Queue(10)
    
  def printMsg(self, msg):
    sys.__stdout__.write("[%s]:  %s" % (self.name, msg) )
    sys.__stdout__.flush()
        

  def stop_listening(self, triggerName=None, closure=None, data=None):
    """make the DBPuppet extension stop listening to requests from browsers"""
    
    ## clean up after yourself!!!
    if os.path.exists(self.keypath):
      os.remove(self.keypath)

    ##join the server thread
    self.server_thread.CHIMERA_EXIT = 1
    self.server_thread.join()
    
    ## cancel the after handler (moot since chimera is exiting)
    if self.after_handle:
      chimera.tkgui.app.after_cancel(self.after_handle)
      
      
  def start_listening(self):
    """make the DBPuppet extension listen to requests from browsers"""
    
    self.useport = 44695

    ## open the 'key' file
    keyfile = open(self.keypath, 'w')
    ## make it owner readable/writable. This will ensure that chimera and client are being run
    ## by the same user.
    os.chmod(self.keypath, 0600)

    ## Write some random numbers into the key file
    ## client  will have to supply these numbers if it wants to do business
    import random
    self.keys = []
    for r in range(3):
      self.keys.append(random.randint(0,1000000))
    
    keystring = ''
    for k in self.keys:
      keystring = keystring + "%s " % k
      
    numwritten = keyfile.write(keystring)

    keyfile.close()
    
    if self.server_thread:
      #self.printMsg("already listening.")
      if self.server_thread.port_number == self.useport:
        return
      else:
        self.server_thread.close()
        self.server_thread = None
    #self.printMsg("start listening...")

    
    ## new server socket
    self.server_thread = ServerThread(self.useport, self.keys, self.handler, self)
    self.server_thread.start()

    self.exitHandler = chimera.triggers.addHandler("Chimera exit", self.stop_listening, None)
    
    self.after_handle = chimera.tkgui.app.after(500, self.processInChimera)
    

  def processInChimera(self):
    try:
      while not self.doQueue.empty():
        data = self.doQueue.get(block=False)
        #self.printMsg("GOT FROM QUEUE: %s %s" % (data[0], data[1]) )

        if data[0] == "LOCAL":
          chimera.openModels.open(data[1])
        elif data[0] == "PDB":
          chimera.openModels.open(data[1], type="PDB")
        elif data[0] == "CMD":
          doMidasCommand(str(data[1]))
        elif data[0] == "ERROR_MSG":
          ListenStatusDialog(data[1])
            
    except Queue.Empty:
      pass
      #self.printMsg( "Uh Oh. EMPTY QUEUE" )

    self.after_handle = chimera.tkgui.app.after(500, self.processInChimera)
    

class StripHTMLParser(HTMLParser):
  """This is a very general class that is written to get all the information
  between <pre> </pre> tags in an HTML document. It is needed because the URLs that
  were being fetched from ModBase were actual HTML documents and not just text files..."""

  def __init__(self):
    self.in_pre = 0
    HTMLParser.__init__(self)

    self.content=''
    
  def handle_starttag(self, tag, attrs):
    if tag == 'pre':
      self.in_pre = 1
  def handle_endtag(self, tag):
    if tag == 'pre':
      self.in_pre = 0
  def handle_data(self, data):
    if self.in_pre:
      self.content = data
  def get_content(self):
    return self.content


def stripHTML(file):
  """pass in a file in HTML, and it will extract all the informatin
  between the <pre> and </pre> tags. Possibly only useful for ModBase
  """

  shp = StripHTMLParser()
  f = open(file, 'r')
  shp.feed(f.read())
  f.close()

  f = open(file, 'w')
  f.write( (shp.get_content()).strip() )
  f.close()

def getURL(url, filename):
  """pass in a the url and the name of the file you'd like to save it to, and
  this function will return the location of that file"""
  
  urlparts = urlparse.urlparse(url.strip())
      
  d = str(filename)
  tmp_data = os.path.join(tempfile.gettempdir(), d)
  
  baseurl = "http://" + string.join(urlparts[1:3], "/")

  try:
    if urlparts[4]:
      urllib.urlretrieve(url=baseurl, filename=tmp_data, data=urlparts[4])
    else:
      urllib.urlretrieve(url=baseurl, filename=tmp_data)
  except IOError, what:
    raise "Error encountered while retrieving file %s" % (baseurl+"?"+urlparts[4]), what
    
  return tmp_data

def doMidasCommand(cmd):
  """execute a midas command in Chimera"""

  code = None

  try:
    import Midas.midas_text
  except ImportError: ##must be v.1700
    import Midas.midas_ui
    ui = Midas.midas_ui.MidasUI()
    code = ui.makeCommand(cmd)
  else: ##v 1864
    code = Midas.midas_text.makeCommand(cmd)

  if code is not None:
    exec code

