import threading, socket, sys
import PuppetServer


class ServerThread(threading.Thread):

    def __init__(self, port_number, keys, handler, puppet):
        threading.Thread.__init__(self, name="Server Socket Thread")
        self.port_number = port_number
        self.puppet = puppet
        self.keys = keys

        self.ph = PuppetServer.PuppetServer( ("localhost", self.port_number), self.keys, puppet.doQueue, handler)

        self.CHIMERA_EXIT = 0
        self._timeout = .5
        self.setDaemon(1)

    def printMsg(self, msg):
        sys.__stdout__.write("[DBPuppet]:  %s" % msg)
        sys.__stdout__.flush()
    
    def run(self):        
        #self.printMsg("waiting to accept")
        import select

        while 1:
            ready = select.select([self.ph.fileno()], [], [], self._timeout)
            if ready[0]:
                #self.printMsg("GOT REQUEST")
                self.ph.handle_request()
            else:
                #self.printMsg("NO REQUEST")
                pass

            if self.CHIMERA_EXIT:
                #self.printMsg("GOT CHIMERA EXIT")
                break

        #self.ph.serve_forever()

    def close(self):
        self.ph.server_close()
        del self.ph
