WIN_CHIMERA_LOCATION="C:\Program Files\Chimera"

def warning_dialog(title, message):

  import Tkinter
  m = Tkinter.Label(text = message, justify = 'left')
  m.pack(side = 'top')
  m.winfo_toplevel().wm_title(title)
  b = Tkinter.Button(text = 'Close', default = 'active', command = m.quit)
  b.pack(side = 'top')
  b.focus_set()
  b.bind('<KeyPress>', lambda e,b=b: b.invoke())
  m.mainloop()

def syntax():  
  msg = ('Syntax: send_to_chimera.py <filetype> <file> [port]\n' +
         '  <filetype> is a type any of the Chimera file types\n' +
         '     PDB, VRML, Mol2, Python, Gaussian formatted checkpoint\n' +
         '  [port] is an optional port number (default 44695)\n')
  title="Bad Syntax"
  warning_dialog(title,msg)
  sys.exit(1)


def send_to_chimera(path, type, port):
  
  f = open(path, 'r')
  ## read the contents of the file
  res = f.read()
  send_python_to_chimera(res, path, port)


def generate_input_file(path):
  import input_code

  file = tempfile.mktemp()
  f = open(file, 'w')

  #import string
  #mod_path = string.join(string.split(path, "\\"), "\\\\")
  
  f.write(input_code.parse_code % (path, path) + "\n")
  f.close()

  return file

def send_python_to_chimera(code, path, port):

  ## try to open that keyfile
  try:
    keyfile = open(os.path.join(tempfile.gettempdir(), "puppet.key"), 'r')
  except IOError, what:
    if what.errno == 13: ##don't have permission to open key file
      warning_dialog("Not Authorized", "You are not authorized to send information to Chimera!")
      return

  import time
  spawned = False
    
  ## open a socket to Chimera
  s = socket_to_chimera(port)

  if s == None:
    print "s is None"
    print "Nope, not spawned.."
    print "spawning now..."
    ## need to spawn chimera here...

    input_file = generate_input_file(path)
    #print "got %s for input_file" % input_file

    if sys.platform == "win32":
      chimera_cmd = os.path.join(WIN_CHIMERA_LOCATION, "bin", "chimera.exe")
      quote = "\""
    else:
      chimera_cmd = os.path.join("%s" % os.path.split(sys.executable)[0], "chimera")
      quote = ''
      
    print "chimera_cmd is %s" % chimera_cmd
    p_id = os.spawnv(os.P_NOWAIT, chimera_cmd, ("chimera", "--start",  "%sDatabase Control On%s" % (quote, quote), input_file) )
    print "got %s for p_id" % p_id
    
    ## don't want to return now, need to wait for chimera to start listening...
    return

  s.send("identify")
  
  ##establish that it is indeed chimera that you are talking to.
  print "receiving 7"
  verify = s.recv(7)
  
  if not verify=="CHIMERA":
    print "not talking to Chimera!!, got %s instead!" % verify
    s.close()
    del s
    return
  else:
    print "ahhh. contact with chimera"
    print "got %s" % verify

  #import time
  #time.sleep(3)

  ## read the 'keys' from the file. This is an authentication mechanism.
  ## if this was coming from a different computer or different user than
  ## chimerea was running on, you would be unable to open up the keyfile
  ## (because we made it user-only r/w)
  key = keyfile.read(24) ## read three [up-to] 8-digit integers

  ## send the key over. If it is the wrong key, chimera will break
  ## the socket connection
  
  ## then send over the actual XML file contents
    
  print "sending %s" % (key+code)
  s.sendall("%s" % (key + code))

  ## close the connection, not flushing out or something!!!?
  s.close()

  
def socket_chimera_server(port):
  import socket
  s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)

  try:
    s.bind(('localhost', port))
  except socket.error, e:
    print "ERROR making initial connection: %s" % e

  s.listen(1)
  return s


def socket_to_chimera(port):

  ## using Python sockets here..

  import socket
  ## use an internet socket, streaming transport
  s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)

  try:
    s.connect(('localhost', port))
  except socket.error, e:
    #msg = ('Could not connect to Chimera.\n\n'
    #       'You must manually start Chimera. Make sure that the ModPuppet\n'
    #       'extension is running.\n'
    #       'Chimera must be running on the same machine as your web browser.\n\n'
    #       'Socket error message: %s\n' % e[1])
    #msg = ('Could not connect to Chimera.\n\n'
    #       'Starting Chimera now...\n'
    #       )
    #warning_dialog('No Chimera Connection', msg)
    s.close()
    s = None

  return s


## Start here....
if __name__ == '__main__':
  import sys, os, tempfile
  argc = len(sys.argv)
  
  if argc != 2:
    syntax()

  import os
  
  ## 'path' is the path to an XML file (presumably downloaded from clicking in a link in a browser)

  type = 'Python'
  path = sys.argv[1]
  port = 44695

  send_to_chimera(path, type, port)
