import os, os.path, string
from bc import Biocore
import biocore


filemap = {}
dirmap  = {}


def dirmake(ids,path,dirs,files,b):
    global filemap
    global dirmap

    for dir in dirs:
        if dir.Id == '1' or dir.Id == '-1':
            continue

        try:
            i = ids.index(dir.Id)
        except ValueError:
            ids.append(dir.Id)

            os.mkdir( os.path.join(path, dir.Name) )
            o = open( os.path.join(path, dir.Name, ".myIdNumber"), 'w' )
            o.write("%s\n" % dir.Id)
            o.close()
            dirmap[dir.Name] = dir.Id

            d,f = b.listBiofsDirContents(dir.Id)
            dirmake(ids, os.path.join(path, dir.Name), d, f, b)
        else:
            continue

    for file in files:
        try:
            o = open( os.path.join(path, file.Name),'w')
            o.write("%s\n" % file.Id)
            o.close()
            filemap[file.Name] = file.Id
        except IOError:
            pass


def getIds(idmaps, dirname, names):
    o = open(os.path.join(dirname, ".myIdNumber"), 'r')
    idnum = o.readline()
    o.close()
    idmaps[0][ os.path.split(dirname)[1] ] = idnum.strip()
    
    for n in names:
        path = os.path.join(dirname, n)
        if os.path.isfile(path):
            o = open(path, 'r')
            idnum = o.readline()
            o.close()

            idmaps[1][n] = idnum.strip()
    

def buildMaps(startdir):
    ## dirmap, filemap
    idmaps = ({}, {})
    
    os.path.walk(startdir, getIds, idmaps)

    global dirmap
    global filemap

    dirmap   = idmaps[0]
    filemap  = idmaps[1]
