import chimera.extension

class BiocoreOpenSessEMO(chimera.extension.EMO):
    def name(self):
        return 'Open Session'
    def description(self):
        return 'Open session stored on BioCoRE'
    def categories(self):
        return ['BioCoRE']
    def icon(self):
        return None
    def activate(self):
        #self.module().checkLogin()
        self.module().openSavePanel(mode='open')

chimera.extension.manager.registerExtension(BiocoreOpenSessEMO(__file__))


class BiocoreSaveSessEMO(chimera.extension.EMO):
    def name(self):
        return 'Save Session'
    def description(self):
        return 'Save session to BioCoRE'
    def categories(self):
        return ['BioCoRE']
    def icon(self):
        return None
    def activate(self):
        self.module().openSavePanel(mode='save')

chimera.extension.manager.registerExtension(BiocoreSaveSessEMO(__file__))
