      integer function EFIMOV(PHI,PSI)
C
C calculates the Efimov assignment of the phi/psi state of a residue
C 0 for out of range
C 1 for alpha
C 2 for beta extended
C 3 for beta polyproline
C 4 for alpha left
C 5 for gamma
C 6 for epsilon
C 7 undefined
C 8 undefinable (usually terminus)
C
C Changed definitions to latest Thornton ones.
C
      integer IPHI, IPSI 
      real SMALL 
      real PHI, PSI
      real EFIDAT(36,36)
C         
      data SMALL/0.000001/
      data (EFIDAT(1,K), K=1,36) /2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,7,7,7,7,
     +                            7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6/
      data (EFIDAT(2,K), K=1,36) /2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,7,7,7,7,
     +                            7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6/
      data (EFIDAT(3,K), K=1,36) /2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,7,7,7,7,
     +                            7,7,7,7,7,7,6,6,6,6,6,6,7,7,2,6,2/
      data (EFIDAT(4,K), K=1,36) /2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,7,7,
     +                            7,7,7,7,7,7,7,6,6,6,7,7,7,7,7,2,2/
      data (EFIDAT(5,K), K=1,36) /2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,7,7,7,
     +                            7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,7,2/
      data (EFIDAT(6,K), K=1,36) /2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,7,7,7,
     +                            7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,7,2/
      data (EFIDAT(7,K), K=1,36) /2,2,2,2,2,2,2,2,3,2,3,3,3,3,3,3,7,7,7,
     +                            7,7,7,7,7,7,7,6,7,7,7,7,7,7,7,7,2/
      data (EFIDAT(8,K), K=1,36) /2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,7,7,
     +                            7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2/
      data (EFIDAT(9,K), K=1,36) /2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,7,7,
     +                            7,7,7,7,4,4,7,7,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(10,K),K=1,36) /2,2,2,2,2,2,2,2,3,3,3,3,3,3,7,7,7,7,7,
     +                            7,4,4,4,4,7,7,7,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(11,K),K=1,36) /2,2,2,2,2,2,2,2,2,3,3,3,7,7,7,7,7,7,7,
     +                            7,4,4,4,4,7,7,7,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(12,K),K=1,36) /7,2,2,2,2,2,2,2,2,3,3,3,3,7,7,7,7,7,7,
     +                            7,7,4,4,4,7,7,7,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(13,K),K=1,36) /7,7,2,2,2,2,2,2,2,2,3,3,3,7,7,7,7,7,7,
     +                            7,4,4,4,4,4,4,7,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(14,K),K=1,36) /7,7,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,
     +                            7,4,4,4,4,4,5,7,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(15,K),K=1,36) /7,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,
     +                            7,7,4,4,4,4,5,7,5,7,7,7,7,7,7,7,7/
      data (EFIDAT(16,K),K=1,36) /7,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,
     +                            7,7,4,4,4,4,4,5,5,7,7,7,7,7,7,7,7/
      data (EFIDAT(17,K),K=1,36) /7,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,
     +                            7,7,7,4,4,4,5,5,5,5,7,7,7,7,7,7,7/
      data (EFIDAT(18,K),K=1,36) /7,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,
     +                            7,7,7,7,4,4,4,5,5,5,5,7,7,7,7,7,7/
      data (EFIDAT(19,K),K=1,36) /7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,
     +                            7,7,7,4,7,4,4,5,5,5,5,5,7,7,7,7,7/
      data (EFIDAT(20,K),K=1,36) /7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,
     +                            7,7,7,7,7,5,5,5,5,5,5,5,7,7,7,7,7/
      data (EFIDAT(21,K),K=1,36) /7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,
     +                            7,7,7,7,7,5,5,5,5,5,5,7,5,7,7,7,7/
      data (EFIDAT(22,K),K=1,36) /7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,
     +                            7,7,7,7,7,7,5,5,5,5,7,7,7,7,7,7,7/
      data (EFIDAT(23,K),K=1,36) /7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,
     +                            7,7,7,7,7,7,5,7,5,7,7,7,7,7,7,7,7/
      data (EFIDAT(24,K),K=1,36) /7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,
     +                            7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(25,K),K=1,36) /1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,
     +                            7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(26,K),K=1,36) /7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,
     +                            7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(27,K),K=1,36) /7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,7,
     +                            7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(28,K),K=1,36) /7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,7,7,7,7,
     +                            7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(29,K),K=1,36) /7,7,7,7,7,7,7,7,7,7,7,1,7,7,7,7,7,7,7,
     +                            7,7,6,7,7,7,6,7,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(30,K),K=1,36) /7,7,7,7,7,7,7,2,2,7,7,7,7,7,7,7,7,7,7,
     +                            7,7,7,6,6,7,7,6,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(31,K),K=1,36) /7,7,7,7,7,2,2,2,7,7,7,7,7,7,7,7,7,7,7,
     +                            7,7,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7/
      data (EFIDAT(32,K),K=1,36) /7,7,7,7,7,7,2,2,2,2,7,7,7,7,7,7,7,7,7,
     +                            7,7,7,6,6,6,6,6,6,6,7,7,7,7,7,7,7/
      data (EFIDAT(33,K),K=1,36) /2,2,2,2,7,2,2,2,2,2,2,7,7,7,7,7,7,7,7,
     +                            7,7,7,7,6,6,6,6,6,6,6,6,6,6,7,7,6/
      data (EFIDAT(34,K),K=1,36) /2,2,2,2,2,2,2,2,2,3,3,3,3,3,7,7,7,7,7,
     +                            7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6/
      data (EFIDAT(35,K),K=1,36) /2,2,2,2,2,2,2,2,2,3,3,3,3,7,7,7,7,7,7,
     +                            7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6/
      data (EFIDAT(36,K),K=1,36) /2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,7,7,7,7,
     +                            7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6/
C
      if ((PHI .lt. 180.0 .and. PHI .ge. -180.0) .and.
     -    (PSI .le. 180.0 .and. PSI .gt. -180.0)) then
        IPHI=int((PHI+180.0-SMALL)/10.0) +1
CD       if (IPHI.gt.36.or.IPHI.lt.1) write (6,*) ' bad pointer-phi ',IPHI,PHI
        IPSI=36-(int((PSI+180.0-SMALL)/10.0))
CD       if (IPSI.gt.36.or.IPSI.lt.1) write (6,*) ' bad pointer-psi ',IPSI,PSI
        EFIMOV=EFIDAT(IPSI, IPHI)
      else 
CD       write (6,*) ' out of range ',phi,psi
        EFIMOV=8
      end if
C
      return
      end
