c     ------------------------------------------------------------------
c
c     Subroutine to report length of SVR's for each of the proteins
c     used to detemine topologically equivalent residues.
c
c     Input : Reads arrays produced by earlier subroutines in MNYFIT
c             NFITCA
c     Output: File SVRLEN.OUT containing file names of BRK files
c             loop numbers, start residue of loop (incl. overlap)
c             and length of loop. This file is read by CMPALL when
c             LOPHOM option is invoked
c
c     Author: PJT 01-02-90
c     
c     Notes : The array bound 42 is used for the max number of SVR's
c             since the maximum number of SCR's is 40
c
c     -----------------------------------------------------------------
c
      subroutine svrlen()
c     
c     ------------------------------------------------------------------
      include 'mnyfit.h'
c
      integer slen(42, maxmol), nsvr(maxmol), tsvr, stres(42, maxmol)
      character*15 name(maxmol)
c
      open(unit=95, file='svrlen.out', status='UNKNOWN', 
     -form='FORMATTED') 
      do 101 i=1,nm
        name(i)(1:15)='               '
        name(i)(1:4)=fname(i)(2:5)
        if(nchain(i).ne.0) then
          do 102 j=1,nchain(i)
            name(i)(j+4:j+4)=chains(j,i)
102       continue
        endif
101   continue
      write(unit=95, fmt=1) (name(i),i = 1, nm)
c
    1 format(10(a15))
      do 4 i = 1, nm
        nsvr(i) = 0
        do 5 j = 1, nf
          if (j.eq.1) then
            if(na(j,i).ne.1) then
              nsvr(i)=nsvr(i)+1
              stres(nsvr(i),i)=1
              slen(nsvr(i),i)=na(j,i)-1
            endif
            nold=na(1,i)
            goto 5
          endif
          if (j.eq.nf) then
            if (na(j,i).ne.nfitca(i)) then
              nsvr(i)=nsvr(i)+1
              stres(nsvr(i),i)=na(j,i)-2
              slen(nsvr(i),i)=nfitca(i)-na(j,i)
            endif
            goto 5
          endif
          if (na(j,i) .ne. (nold + 1)) then
            nsvr(i) = nsvr(i) + 1
            stres(nsvr(i),i) = nold - 2
            slen(nsvr(i),i) = (na(j,i) - nold) - 1
            nold=na(j,i)
          else
            nold=nold+1
          end if
    5   continue
        if (i.gt.1) then
          if (nsvr(i) .ne. nsvr(i - 1)) then
            write (STDERR,'(''mnyfit: unequal number of svrs'')')
c           write (STDERR, fmt=20) i, i - 1, nsvr(i), nsvr(i - 1)
c  20       format(1x,10hMolecules ,2i3,6h have ,i3,5h and ,i3,6h svr's)
            return 
          end if
        endif
    4 continue
      tsvr = nsvr(1)
      do 6 i = 1, tsvr 
      write(unit=95, fmt=3) i, (stres(i,j), slen(i,j),j = 1, nm)
    3 format(i3,10(1x,i5,1x,i3))
    6 continue
      return 
      end
