      program SITE 
C
C read a PDB file, and write out residues that are within a given range of
C the HETATM records
C
C ============================================================================
C
      include 'site.h'
C
      integer MAXARGS
      parameter (MAXARGS=256)
      character*(MAXFILELEN) INFILE, OUTFILE, FILES(MAXARGS)
      character*14 OPTIONS
      character*5 RESNUM(MAXRES), HETNUM(MAXHET)
      character*4 VERSION, HETATM(MAXHET)
      character*3 RESNAM(MAXRES), ATM(MAXATS,MAXRES), HETNAM(MAXHET)
      character*2 HBTYPE
      character*1 CHNNAM(MAXRES), SEQ(MAXRES), FLAG, ALT
      integer LENRES(MAXRES), NRES, NATS, NHET, IARGC, IOUT
      integer I, J, K, L, ISPAN, NCHN, IPREV, NCH, NFILES, III, N
      real COORDS(3,MAXATS,MAXRES), OCCUP(MAXATS,MAXRES)
      real BVAL(MAXATS,MAXRES)
      real HETCOORDS(3,MAXHET), DIST, ANGLCO, ANGLNH, HDIST, ENERGY
      real HATM(3,MAXRES), CATM(3), SHATM(3,MAXSIDE,MAXRES), HBENG
      logical DONOR(MAXATS,MAXRES), ACCEPTOR(MAXATS,MAXRES)
      logical DOHET, DOWAT, VERBOSE, TERMINUS(2,MAXRES)
      logical NEIGHBOUR, YES, DOCOV, COV, MUTUAL, NEIGHBOURM
C
      character*31 IDENT
      data IDENT /'@(#)  site.f - joy (c) jpo 1996'/
C
      include 'date.h'
C
      data DOHET    /.true./
      data DOWAT    /.true./
      data DOCOV    /.false./
      data VERBOSE  /.false./
      data MUTUAL   /.false./
C
C jpo 17-5-96: added mutual to define sites a little better
C
C -----------------------------------------------------------------------
C
C Get command line options
C
C Check no of arguments
C
      if (IARGC() .gt. MAXARGS) then
        call ERROR('site: argument list too long',' ',1)
      end if
C
C get first argument to see if it is an option, if it is then get all
C filenames
C If first argument not an option then get all filenames
C
C default output stream is 2 (IOUT)
C
      IOUT=2
C
C default distance cutoff
C
      DISTVAL=4.5
      DISTVAL2=DISTVAL*DISTVAL
C
      call GETARG(1,OPTIONS)
      if (OPTIONS(1:1) .eq. '-') then
        if (index(OPTIONS,'V') .gt. 0) then
          write (STDERR,'(''site - version '',A,'' ('',A,
     -           '') - copyright 1996 jpo, compiled - '',A)')
     -           VERSION(),LIBVERSION(),DATE
          if (IARGC() .lt. 2) then
            call EXIT(0)
          end if
        end if
        if (index(OPTIONS(2:),'c') .gt. 0) then
          DOCOV=.true.
        end if
        if (index(OPTIONS(2:),'-') .gt. 0) then
          IOUT=STDOUT
        end if
        if (index(OPTIONS(2:),'M') .gt. 0) then
          MUTUAL=.true.
        end if
        if (index(OPTIONS(2:),'d') .gt. 0) then
          read (OPTIONS(3:),'(F5.3)',err=904) DISTVAL
          DISTVAL2=DISTVAL*DISTVAL
        end if
        NFILES=0
        do I=2,IARGC()
          NFILES=NFILES+1
          call GETARG(I,FILES(NFILES))
        end do
        NFILES=IARGC()-1
      else
        do I=1,IARGC()
          call GETARG(I,FILES(I))
        end do
        NFILES=IARGC()
      end if
C
C -----------------------------------------------------------------------
C
C loop around all files in argument list
C
C control of files
C
      do III=1,NFILES
        INFILE=FILES(III)
C
C if file does not have an extension, generate one with .atm extension
C
        if (index(INFILE,'.') .lt. 1) then
          if (FILEEXIST(INFILE(1:LASTCHAR(INFILE))//'.atm')) then
            INFILE=INFILE(1:LASTCHAR(INFILE))//'.atm'
          end if
        end if
        if (.not. FILEEXIST(INFILE)) then
          call ERROR('site: cannot find file',INFILE,0)
        end if
C
C output file has same root as input file, and a 'sit' extension
C
        OUTFILE=INFILE(1:index(INFILE,'.'))//'sit'
C
C ------------------------------------------------------------------------
C
C Read in the PDB format data
C
        call RDPDB(INFILE,ATM,RESNUM,RESNAM,CHNNAM,COORDS,OCCUP,BVAL,
     -             LENRES,NATS,NRES,NHET,HETCOORDS,
     -             HETNUM,HETNAM,HETATM,VERBOSE)
C
C ------------------------------------------------------------------------
C
        if (IOUT .ne. STDOUT) then
          open (file=OUTFILE,unit=IOUT,status='UNKNOWN',form='FORMATTED',
     +          err=5)
        end if
C
        write (IOUT,'(''REMARK produced by site (c) jpo, Pfizer Ltd, 1996, version '',A,'' ('',A,
     +         '')'')') VERSION(),LIBVERSION()
        write (IOUT,'(''REMARK parameterized for '',I4,'' residues, '',I2
     +            ,'' atoms per residue, and '',
     +             I4,'' hetatoms'')') MAXRES, MAXATS, MAXHET
        write (IOUT,'(''REMARK coordinate data taken from file '',A)')
     +             INFILE(1:LASTCHAR(INFILE))
        write (IOUT,'(''REMARK coordinate cutoff  = '',F5.2)') DISTVAL
        write (IOUT,'(''REMARK number of atoms    = '',I5)') NATS
        write (IOUT,'(''REMARK number of residues = '',I5)') NRES
        write (IOUT,'(''REMARK number of hetatoms = '',I5)') NHET
        write (IOUT,'(''REMARK'')')
C
C --------------------------------------------------------------------------
C
        N=0
        do I=1,NRES
          YES=.false.
          do K=1,NHET
            if (NEIGHBOUR(COORDS(1,1,I),LENRES(I),HETCOORDS(1,K),DISTVAL2)) then
              YES=.true.
            end if
          end do
          if (YES) then
            do J=1,LENRES(I)
              N=N+1
              write (IOUT,'(''ATOM  '',I5,1X,A4,1X,A3,1X,A,A5,3X,3F8.3)',err=903)
     +            N,ATM(J,I),RESNAM(I),CHNNAM(I),RESNUM(I),(COORDS(K,J,I),K=1,3)
            end do
          end if
        end do
        write (IOUT,'(''TER'')',err=903) 
C
C look for COVALENT attachments
C
        if (DOCOV) then
          do I=1,NRES
            do K=1,NHET
              if (COV(COORDS(1,1,I),LENRES(I),HETCOORDS(1,K),DISTVAL2,
     +            RESNAM(I),RESNUM(I),CHNNAM(I),ATM(1,I))) continue
            end do
          end do
        end if
C
C write out HETATM itself (as ATOM record (for rasmol)
C
        if (.not. MUTUAL) then
          do I=1,NHET
            N=N+1
            write (IOUT,'(''HETATM'',I5,1X,A4,1X,A3,2X,A5,3X,3F8.3)',err=903)
     +            N,HETATM(I),HETNAM(I),HETNUM(I),(HETCOORDS(K,I),K=1,3)
          end do
        else
          do I=1,NHET
            do J=1,NRES
              if (NEIGHBOURM(COORDS(1,1,J),LENRES(J),HETCOORDS(1,I),DISTVAL2)) then
                N=N+1
                write (IOUT,'(''HETATM'',I5,1X,A4,1X,A3,2X,A5,3X,3F8.3)',err=903)
     +                 N,HETATM(I),HETNAM(I),HETNUM(I),(HETCOORDS(K,I),K=1,3)
                goto 10
              end if
            end do
10        end do
        end if
        write (IOUT,'(''TER'')',err=903) 
        write (IOUT,'(''END'')',err=903) 
C
        if (IOUT .ne. STDOUT) then
          close (unit=IOUT)
        end if
C
      end do
C
C --------------------------------------------------------------------------
C
      call EXIT(0)
C
C ---------------------------------------------------------------------------
C
C Catch bad distance value, etc.
C
5     call ERROR('site: error opening file',OUTFILE,1)
903   call ERROR('site: error writeing output !',' ',1)
904   call ERROR('site: error parsing options',OPTIONS,1)
C
      end 
