*
*-------------------------------------------------------------------------------
*
* SERF - an accessible surfaces program
*
* implements the following methods:
*        Lee and Richards (1972)
*        Richmond (1984)
*        Shrake and Rupley (1974)
*        Wodak and Janin (1980)
*
*     D R Flower 1997.
*
*-------------------------------------------------------------------------------
*
      PROGRAM SERF
*
* announce program.
*
      WRITE(*,1000)
*
* read control input.
*
      CALL READCARD
*
      WRITE(*,1001)
*
* format statements.
*
1000  FORMAT(/' SERF  version 2.0  D R Flower  1997.'/)
1001  FORMAT(' SERF has completed normally. ')
*
      END
*
*----------------------------------------------------------------------------------
*
* Read control input from keyworded cards.
*
      SUBROUTINE READCARD
*
* declarations.
*
      INTEGER IIH(80),NH,J1,GETFT,
     +IREAD,LOGDEC,ILOG,SETDEC,IFAIL
*
      REAL ANG(10),FFH(80),THETA,FIMAX
*
      CHARACTER 
     +A*80,
     +AOLD*80,
     +B*1,
     +CCLIS*20,
     +CARD*10,
     +CASE*10,
     +CCH(80)*1,
     +BLINE*80,
     +JJH*1,
     +C4H(500)*4,
     +FILNAM*80,
     +CASEALL*80
*
      CHARACTER SNAM*80,SNAM1*80,SNAM2*80,SNAM3*80,SNAM4*80
*
      INCLUDE 'SERF.INC'
*
* initialise
*
      DO 200 I=1,80
      BLINE(I:I)=' '
200   CONTINUE
*
      CALL RESET
*
* data reading control.
*
      IREAD=5
      ILOG=17
      LOGDEC=0
*
* open external channel to sys$input or text file.
*
      OPEN(UNIT=IREAD,STATUS='UNKNOWN',ERR=101)
*
* loop through cards until read some form of termination marker.
*
1     CONTINUE
*
* write prompt.
*
      IF (IREAD.EQ.5) WRITE(*,4000)
*
* read instruction line to parse.
*
      READ(IREAD,3000,END=120,ERR=1) A
*
* echo line.
*
      IF (IREAD.EQ.11) WRITE(*,4001) A
      IF (LOGDEC.EQ.1) WRITE(ILOG,3000) A
*
* cut any leading spaces.
*
      DO 10 I=1,80
      IF (A(I:I).NE.' ') THEN
      A(1:80)=A(I:80)//BLINE(1:I)
      L=I
      GOTO 20
      ENDIF
10    CONTINUE
*
20    CONTINUE
*
* check for comment marker.
*
      IF (A(1:1).EQ.'!') THEN
*
* recall previous command.
*
      IF (A(2:2).EQ.'!') THEN
      A=AOLD
      WRITE(*,4001) A
      ELSE
*
* Skip comment line.
*
      GOTO 1
      ENDIF
      ENDIF
*
* Check for comments.
*
      IEND=INDEX(A,'!')
      IF (IEND.EQ.0) IEND=80
*
* change case and get card.
*
      AOLD=A
      A=CASEALL(A,1)
      CARD=A(1:10)
*
* check for return or blank line only.
*
      IF (CARD(1:4).EQ.'    ') GOTO 1
*
* check for termination marker.
*
      IF (CARD(1:2).EQ.'##')   GOTO 101
      IF (CARD(1:3).EQ.'END')  GOTO 101
      IF (CARD(1:4).EQ.'QUIT') GOTO 101
      IF (CARD(1:4).EQ.'STOP') GOTO 101
      IF (CARD(1:4).EQ.'EXIT') GOTO 101
      IF (CARD(1:3).EQ.'BYE')  GOTO 101
*
* now check for each card in turn and then read arguments on card.
*
      IF (CARD(1:4).EQ.'READ') THEN
*
* parse file name.
*
      FILNAM=BLINE
      CALL PULWRD((IEND-4),FILNAM,AOLD(5:IEND))
      CALL LSTWRD(2,(IEND-4),SNAM1,A(5:IEND))
      CALL LSTWRD(3,(IEND-4),SNAM2,A(5:IEND))
*
* open files.
*
      IF (FILNAM(1:1).EQ.' ') THEN
*
      OPEN(UNIT=1,STATUS='OLD',ERR=1070,
     +READONLY,RECL=35000)
      REWIND(UNIT=1)
*
      CALL CLEAR1
*
      CALL FILEIN(1,IFAIL,CCLIS)
      CLOSE(UNIT=1)
*
      GOTO 1
*
      ELSEIF (FILNAM(1:1).EQ.'@') THEN
*
* file of filenames.
*
      CLOSE(UNIT=2)
      OPEN(UNIT=2,STATUS='OLD',FILE=FILNAM(2:),ERR=1070,
     +READONLY,RECL=1000)
      REWIND(UNIT=2)
*
* process many files.
*
      CALL DOMANY(2,CCLIS)
*
      ELSE
*
* single files.
*
      CLOSE(UNIT=1)
      OPEN(UNIT=1,STATUS='OLD',FILE=FILNAM,ERR=1070,
     +READONLY,RECL=35000)
      REWIND(UNIT=1)
*
      CALL FILEIN(1,IFAIL,CCLIS)
      CLOSE(UNIT=1)
*
      ENDIF
*
      GOTO 1
*
      ELSEIF (CARD(1:4).EQ.'PROC') THEN
*
* parse file name.
*
      FILNAM=BLINE
      CALL PULWRD((IEND-4),FILNAM,AOLD(5:IEND))
      CALL LSTWRD(2,(IEND-4),SNAM1,A(5:IEND))
      CALL LSTWRD(3,(IEND-4),SNAM2,A(5:IEND))
*
* open files.
*
      IF (FILNAM(1:1).EQ.' ') THEN
*
      OPEN(UNIT=1,STATUS='OLD',ERR=1070,
     +READONLY,RECL=35000)
      REWIND(UNIT=1)
*
      CALL DOMULT(1,CCLIS)
*
      GOTO 1
*
      ELSE
*
* file of filenames.
*
      OPEN(UNIT=1,STATUS='OLD',ERR=1070,FILE=FILNAM,
     +READONLY,RECL=35000)
      REWIND(UNIT=1)
*
* process many files.
*
      CALL DOMULT(1,CCLIS)
*
      ENDIF
*
      GOTO 1
*
* read from instruction file.
*
      ELSE IF (CARD(1:1).EQ.'@') THEN
*
* parse file name.
*
      IF (IREAD.EQ.5) THEN
      FILNAM=BLINE
      CALL PULWRD(IEND,FILNAM,AOLD(2:IEND))
*
* open input log file.
*
      OPEN(UNIT=11,FILE=FILNAM,STATUS='OLD',READONLY,
     +ERR=121)
*
* change to read log file.
*
      IOLD=IREAD
      IREAD=11
*
      ELSE
*
* log file within log file. not allowed.
*
      WRITE(*,4010)
      ENDIF
*
      GOTO 1
*
* open Log file.
*
      ELSE IF (CARD(1:3).EQ.'LOG') THEN
*
      IF (LOGDEC.EQ.0) THEN
      LOGDEC=1
      FILNAM=BLINE
      CALL PULWRD((IEND-3),FILNAM,AOLD(4:IEND))
      OPEN(UNIT=ILOG,FILE=FILNAM,STATUS='NEW',ERR=1071,
     +CARRIAGECONTROL='LIST')
      WRITE(*,4002)
      ELSE
      WRITE(*,4003)
      ENDIF
*
      GOTO 1
*
* close log file.
*
      ELSE IF (CARD(1:5).EQ.'NOLOG') THEN
*
      IF (LOGDEC.EQ.1) THEN      
      LOGDEC=0
      WRITE(*,4004)
      CLOSE(UNIT=17)
      ELSE
      WRITE(*,4005)
      ENDIF
*
      GOTO 1
*
      ELSE
*
* call all other options.
*
      CALL DOCARD(IFAIL,IEND,CCLIS,CARD,A,AOLD)
*
* Error trap.
*
      IF (IFAIL.EQ.1) THEN
      GOTO 750
      ELSEIF (IFAIL.EQ.2) THEN
      GOTO 100
      ELSEIF (IFAIL.EQ.3) THEN
      GOTO 1071
      ELSEIF (IFAIL.EQ.4) THEN
      GOTO 1071
      ELSE
      GOTO 1
      ENDIF
*
      ENDIF
*
* error trap and warn unknown card.
*
750   CONTINUE
*
      FILNAM=BLINE
      CALL PULWRD(IEND,FILNAM,AOLD(1:IEND))
      WRITE(*,3009) FILNAM(1:40)
      IF (LOGDEC.EQ.1) WRITE(ILOG,3009) FILNAM(1:40)
*
      GOTO 1
*
* Error trap error on failure on read.
*
100   CONTINUE
*
      FILNAM=BLINE
      CALL PULWRD(IEND,FILNAM,AOLD(1:IEND))
      WRITE(*,3005) FILNAM(1:40)
      IF (LOGDEC.EQ.1) WRITE(ILOG,3005) FILNAM(1:40)
*
      GOTO 1
*
* error trap read in.
*
120   CONTINUE
*
      CLOSE(UNIT=IREAD)
*
      IF (IREAD.EQ.11) THEN
      WRITE(*,3012)
      IREAD=5
      OPEN(UNIT=IREAD,STATUS='UNKNOWN')
      GOTO 1
      ELSE
      WRITE(*,3011)
      ENDIF
*     
      GOTO 101
*
* no file to open.
*
1070  CONTINUE
*
      WRITE(*,4059)
      GOTO 1
*
* no file to open.
*
1071  CONTINUE
*
      WRITE(*,4079)
      GOTO 1
*
* error trap for subsidiary input file.
*
121   CONTINUE
      WRITE(*,3020)
      GOTO 1
*
122   CONTINUE
      WRITE(*,3021)
      GOTO 1
*
101   CONTINUE
*
* close input and log files.
* 
      CLOSE(UNIT=5)
      IF (IREAD.EQ.11) CLOSE(UNIT=IREAD)
      IF (LOGDEC.EQ.1) CLOSE(UNIT=ILOG)
*
* format statements.
*
3000  FORMAT(A80)
3005  FORMAT(' Error parsing from command ',A40)
3009  FORMAT(' Unknown command ',A40)
3010  FORMAT(/
     +' Reading of commands has been completed with normal 
     +termination.')
3011  FORMAT(/
     +' Reading of commands has been terminated by end of file.')
3012  FORMAT(' Read end of subsidiary instruction file.')
3020  FORMAT(' Instruction file does not exist.')
3021  FORMAT(' Instruction file is empty.')
3050  FORMAT(/' ERROR: no instructions to read.')
*
4000  FORMAT(' Serf: '$)
4001  FORMAT(' Data line:'/,1X,A80)
4002  FORMAT(' LOG file opened.')
4003  FORMAT(' already writing a LOG file.')
4004  FORMAT(' LOG file now closed.')
4005  FORMAT(' no LOG file to close.')
4010  FORMAT(' already reading a LOG file.')
4050  FORMAT(' All parameters have been reset.')
4051  FORMAT(' Can not read input file. File type not given.')
4052  FORMAT(' Can not write output file. File type not given.')
4053  FORMAT(' Atom data cleared.')
4059  FORMAT(' Can not read input file.
     + Error in file specification.')
4060  FORMAT(' Creating sub-process.')
4079  FORMAT(' Can not open output file.
     + Error in file specification.')
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Read control input from keyworded cards.
*
      SUBROUTINE DOCARD(IFAIL,IEND,CCLIS,CARD,A,AOLD)
*
* declarations.
*
      INTEGER IFAIL
*
      INTEGER IIH(80),NH,J1,GETFT,
     +IREAD,LOGDEC,ILOG,SETDEC,IEND
*
      REAL ANG(10),FFH(80),THETA,FIMAX
*
      CHARACTER 
     +A*80,AOLD*80,
     +B*1,
     +CCLIS*20,
     +CARD*10,
     +CASE*10,
     +CCH(80)*1,
     +BLINE*80,
     +JJH*1,
     +C4H(500)*4,
     +FILNAM*80
*
      CHARACTER SNAM*80,SNAM1*80,SNAM2*80,SNAM3*80,SNAM4*80
*
      INCLUDE 'SERF.INC'
*
* Initialise.
*
      IFAIL=0
      BLINE='                                                               
     +                                                           '
*
* Input file format.
*
      IF (CARD(1:6).EQ.'FILEIN') THEN
*
* parse line.
*
      CALL PULWRD((IEND-6),SNAM,A(7:IEND))
      SNAM(1:10)=CASE(SNAM(1:10),1)
      CALL LSTWRD(2,(IEND-6),SNAM1,A(7:IEND))
      SNAM1(1:10)=CASE(SNAM1(1:10),1)
      CALL LSTWRD(3,(IEND-6),SNAM2,A(7:IEND))
      SNAM2(1:10)=CASE(SNAM2(1:10),1)
*
* get filetype.
* 
      FTYP=GETFT(SNAM,SNAM1,SNAM2)
*
      IF (FTYP.EQ.-1) THEN
      FIDEC=0
      GOTO 100
      ELSE
      FIDEC=1
      GOTO 1 
      ENDIF
*
* Output file type.
*
      ELSEIF (CARD(1:7).EQ.'FILEOUT') THEN
*
* parse line.
*
      CALL LRDRF(A(8:IEND),(IEND-7),IIH,FFH,CCH,NH)
      OTYP2=IIH(1)
      OTYP3=IIH(2)
*
      CALL PULWRD((IEND-7),SNAM,A(8:IEND))
      SNAM(1:10)=CASE(SNAM(1:10),1)
      CALL LSTWRD(2,(IEND-7),SNAM1,A(8:IEND))
      SNAM1(1:10)=CASE(SNAM1(1:10),1)
      CALL LSTWRD(3,(IEND-7),SNAM2,A(8:IEND))
      SNAM2(1:10)=CASE(SNAM2(1:10),1)
*
* get filetype.
* 
      OTYP=GETFT(SNAM,SNAM1,SNAM2)
*
      IF (OTYP.EQ.-1) THEN
      FODEC=0
      GOTO 100
      ELSE
      FODEC=1
*
* check for writing header.
*
      IY1=INDEX(A(1:IEND),' HEADER')
      IF (IY1.GT.0) THEN
      HEADEC=1
      ELSE
      HEADEC=0
      ENDIF
*
      GOTO 1
      ENDIF
*
* Define verbosity.
*
      ELSEIF (CARD(1:6).EQ.'SILENT') THEN
*
      VERBOS=1
      GOTO 1
*
* check for concatenated output.
*
      ELSEIF (CARD(1:4).EQ.'FILE') THEN
*
* Parse line.
*
      CALL PULWRD((IEND-4),SNAM,A(5:IEND))
      SNAM(1:10)=CASE(SNAM(1:10),1)
*
* Options.
*
      IF (SNAM(1:4).EQ.'MANY') THEN
      FILMNY=0
      ELSEIF (SNAM(1:6).EQ.'SINGLE') THEN
      FILMNY=1
      ENDIF
*
      GOTO 1
*
      ELSE IF (CARD(1:6).EQ.'METHOD') THEN
      CALL LRDRF(A(7:IEND),(IEND-4),IIH,FFH,CCH,NH)
      IF (NH.LT.1) GOTO 100
      IF (IIH(1).GT.6) GOTO 100
      METHDEC=IIH(1)
*
      IF (METHDEC.EQ.6) THEN
      IF (NH.LT.2) THEN
      METHDEC=-9
      ELSE
      METHDEC=-ABS(IIH(2))
      ENDIF
      ENDIF
      GOTO 1
*
      ELSE IF (CARD(1:5).EQ.'GROUP') THEN
*
      CALL LRDRF(A(6:IEND),(IEND-5),IIH,FFH,CCH,NH)
      IF (NH.LT.2) GOTO 100 
      CALL PICKCI(A(6:IEND),(IEND-5),JJ,'#')
      IF (NH.LT.3) GOTO 100
      GROUPN=MAX(GROUPN,JJ)
*
      I=1
      K=1
351   IF (I.GE.NH) GOTO 355
      GROUPA(K+NGROUP(JJ),JJ)=IIH(I)
      GROUPL(K+NGROUP(JJ),JJ)=CCH(I)
      I=I+1
      GROUPB(K+NGROUP(JJ),JJ)=IIH(I)
      I=I+1
      K=K+1
      GOTO 351
*
355   NGROUP(JJ)=K+NGROUP(JJ)
*
      GOTO 1
*
      ELSE IF (CARD(1:7).EQ.'COMPARE') THEN
      CALL LRDRF(A(8:IEND),(IEND-7),IIH,FFH,CCH,NH)
*
      IF (NH.LT.2) GOTO 100 
*
      K=0
442   IF (K.GE.NH) GOTO 443
      K=K+1
      NCOMP=NCOMP+1
      COMPG1(NCOMP)=IIH(K)
      K=K+1
      COMPG2(NCOMP)=IIH(K)
      GOTO 442 
443   CONTINUE
      GOTO 1
*
      ELSE IF (CARD(1:5).EQ.'RADII') THEN
      CALL LRDRF(A(6:IEND),(IEND-5),IIH,FFH,CCH,NH)
      CALL ATLIST(A(6:IEND),(IEND-5),C4H,IIH,NH)
      DO 591 I=1,NH
      REDP(RADNO+I)=FFH(I)
      CLN(RADNO+I)=IIH(I)
      ACC(RADNO+I)=C4H(I)
591   CONTINUE
      RADNO=RADNO+NH
      RADDEC=1
      GOTO 1
*
      ELSE IF (CARD(1:5).EQ.'PROBE') THEN
      CALL LRDRF(A(6:IEND),(IEND-5),IIH,FFH,CCH,NH)
      PROBE=FFH(1)
      GOTO 1
*
      ELSE IF (CARD(1:3).EQ.'RES') THEN
      RESDEC=1
      GOTO 1
*
      ELSE IF (CARD(1:3).EQ.'POL') THEN
      POLDEC=1
      GOTO 1
*
      ELSE IF (CARD(1:3).EQ.'JUR') THEN
      JURDEC=1
*
* Parse line.
*
      CALL PULWRD((IEND-4),SNAM,A(5:IEND))
      SNAM(1:10)=CASE(SNAM(1:10),1)
      IF (SNAM(1:4).EQ.'LONG') JURDEC=2
*
      GOTO 1
*
      ELSE IF (CARD(1:3).EQ.'ALL') THEN
      ALLDEC=1
      GOTO 1
*
      ELSE IF (CARD(1:6).EQ.'NORMAL') THEN
      CALL LRDRF(A(7:IEND),(IEND-6),IIH,FFH,CCH,NH)
      IF (NH.GT.0) THEN
      NORMDEC=IIH(1)
      ELSE
      NORMDEC=0
      ENDIF
*
      GOTO 1
*
*
* get location of compound name in header.
*
      ELSE IF (CARD(1:4).EQ.'NAME') THEN
*
      CALL LSTWRD(1,(IEND-4),SNAM1,A(5:IEND))
*
      IF (SNAM1(1:3).EQ.'SDF') THEN
      IE1=INDEX(A(1:IEND),'<')
      IE2=INDEX(A(1:IEND),'>')
      LIDEN=IE2-IE1+1
      IDLINE(1:LIDEN)=AOLD(IE1:IE2)
      CALL LSTWRD(3,(IEND-4),SNAM3,A(5:IEND))
      IF (SNAM3(1:4).EQ.'PACK') LIDEN=-ABS(LIDEN)
      ELSEIF (SNAM1(1:3).EQ.'RDF') THEN
      CALL LSTWRD(3,(IEND-4),SNAM3,AOLD(5:IEND))
      LIDEN=INDEX(SNAM3,' ')-1
      IDLINE(1:LIDEN)=SNAM3(1:LIDEN)
      ELSE
*
* get name from bit of file.
*
      CALL LRDRF(A(5:IEND),(IEND-4),IIH,FFH,CCH,NH)
*
      IF (NH.LT.2) THEN
      GOTO 100
      ELSE
      HEADL(1)=IIH(1)
      HEADL(2)=IIH(2)
      HEADL(3)=IIH(3)
      ENDIF
*
      ENDIF
*
      GOTO 1

*
* do calculations.
*
      ELSEIF (CARD(1:4).EQ.'CALC') THEN
*
      CALL OPENAL
      CALL DOSERF(CCLIS)
*
      ELSE
*
* unknown card.
*
      IFAIL=1
*
      ENDIF
*
* jump to end of look up.
*
1     CONTINUE
*
      RETURN
*
* error trap.
*
100   CONTINUE
*
      IFAIL=2
      RETURN
*
1070  CONTINUE
*
      IFAIL=3
      RETURN
*
1071  CONTINUE
*
      IFAIL=4
*
* format statements.
*
3000  FORMAT(A80)
3005  FORMAT(' Error parsing from command ',A4)
3009  FORMAT(' Unknown command ',A40)
3010  FORMAT(/
     +' Reading of commands has been completed with normal 
     +termination.')
3011  FORMAT(/
     +' Reading of commands has been terminated by end of file.')
3012  FORMAT(' Read end of subsidiary instruction file.')
3020  FORMAT(' Instruction file does not exist.')
3021  FORMAT(' Instruction file is empty.')
3050  FORMAT(/' ERROR: no instructions to read.')
*
4000  FORMAT(' Serf: '$)
4001  FORMAT(' Data line:'/,1X,A80)
4002  FORMAT(' LOG file opened.')
4003  FORMAT(' already writing a LOG file.')
4004  FORMAT(' LOG file now closed.')
4005  FORMAT(' no LOG file to close.')
4010  FORMAT(' already reading a LOG file.')
4050  FORMAT(' All parameters have been reset.')
4051  FORMAT(' Can not read input file. File type not given.')
4052  FORMAT(' Can not write output file. File type not given.')
4053  FORMAT(' Atom data cleared.')
4059  FORMAT(' Can not read input file.
     + Error in file specification.')
4060  FORMAT(' Creating sub-process.')
4079  FORMAT(' Can not open output file.
     + Error in file specification.')
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* open named files stemming from read in file.
*
      SUBROUTINE OPENAL
*
* declarations.
*
      INTEGER K1,K2,CL
      LOGICAL EXDEC,OPDEC
*
      CHARACTER LINE*80,FLINE*80,NM*80
*
      INCLUDE 'SERF.INC'
*
* initialise.
*
      LINE='                                                           
     +                                                     '
*
      FLINE(1:80)=MOLNAME(1:80)
*
* close any open files.
*
      CLOSE(UNIT=10)
      CLOSE(UNIT=11)
      CLOSE(UNIT=12)
      CLOSE(UNIT=20)
      CLOSE(UNIT=21)
      CLOSE(UNIT=22)
      CLOSE(UNIT=25)
      CLOSE(UNIT=29)
*
* now get names
*
      IF (ALLDEC.EQ.1) THEN
*
*  long file.
*
      CALL MAKEN(FLINE,NM,'LONG',4)
      OPEN(UNIT=10,FILE=NM,STATUS='NEW',
     +CARRIAGECONTROL='LIST',ERR=101)
*
101   CONTINUE
*
* atoms summary file.
*
      CALL MAKEN(FLINE,NM,'ATOMS',5)
      OPEN(UNIT=11,FILE=NM,STATUS='NEW',
     +CARRIAGECONTROL='LIST',ERR=102)
*
102   CONTINUE
*
* residue summary file.
*
      CALL MAKEN(FLINE,NM,'SUM',3)
      OPEN(UNIT=12,FILE=NM,STATUS='NEW',
     +CARRIAGECONTROL='LIST',ERR=103)
*
103   CONTINUE
*
* write headers to files.
*
      WRITE(10,8001)
      WRITE(11,8001)
      WRITE(12,8001)
*
      ENDIF
*
* Grouped interactions.
*
      IF (GROUPN.GT.0) THEN
*
* group summary file. 
*
      CALL MAKEN(FLINE,NM,'GRPSUM',6)
      OPEN(UNIT=20,FILE=NM,STATUS='NEW',
     +CARRIAGECONTROL='LIST',ERR=105)
*
105   CONTINUE
*
* groups by atoms file.
*
      CALL MAKEN(FLINE,NM,'GRPATM',6)
      OPEN(UNIT=21,FILE=NM,STATUS='NEW',
     +CARRIAGECONTROL='LIST',ERR=106)
*
106   CONTINUE
*
* groups by residue summary.
*
      CALL MAKEN(FLINE,NM,'GRPRES',6)
      OPEN(UNIT=22,FILE=NM,STATUS='NEW',
     +CARRIAGECONTROL='LIST',ERR=107)
*
107   CONTINUE
*
* write file headers.
*
      WRITE(20,8001)
      WRITE(21,8001)
      WRITE(22,8001)
*
      ENDIF
*
* Spheres for residues.
*
      IF (RESDEC.EQ.1) THEN
      CALL MAKEN(FLINE,NM,'SPHERE',6)
      OPEN(UNIT=25,FILE=NM,STATUS='NEW',
     +CARRIAGECONTROL='LIST',ERR=104)
104   CONTINUE
      WRITE(25,8001)
      ENDIF
*
* Polar surface file.
*
      IF (POLDEC.EQ.1) THEN
      CALL MAKEN(FLINE,NM,'POLAR',5)
      OPEN(UNIT=29,FILE=NM,STATUS='NEW',
     +CARRIAGECONTROL='LIST',ERR=117)
117   CONTINUE
      ENDIF
*
* Charge descriptors of Stanton and Jurs 1990.
*
      IF (JURDEC.GT.0) THEN
      CALL MAKEN(FLINE,NM,'JURS',4)
      OPEN(UNIT=28,FILE=NM,STATUS='NEW',
     +CARRIAGECONTROL='LIST',ERR=118)
      IF (JURDEC.EQ.2) WRITE(28,8001)
118   CONTINUE
      ENDIF
*
* format statements.
*
7000  FORMAT(/' Input File does not exist.'/)
7001  FORMAT(/' Input File exists but can not be opened.'/)
7002  FORMAT(/' Error opening Input File.'/)
8001  FORMAT(//'                                   S  E  R  F '//,
     +'                          Accessible  Surfaces  Program.'///)
*
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* make name of file from root.
*
      SUBROUTINE MAKEN(NLINE,VV,SXS,GG)
*
* declarations.
*
      CHARACTER NLINE*80,SXS*30,VV*80
*
      INTEGER I,K,GG
*
* do the stuff.
*
      DO 1 I=1,80 
      IF (NLINE(81-I:81-I).NE.' ') GOTO 2 
1     CONTINUE
      RETURN 
2     CONTINUE
      K=81-I
      VV(1:80)='                                                              
     +                  '
      VV(1:K+GG+1)=NLINE(1:K)//'.'//SXS(1:GG)
*
      RETURN
      END
*

*-------------------------------------------------------------------------------
*
* case swapping routine:
*' IFLAG=1 : lower to upper case.
*' IFLAG=0 : upper to lower case.
*
      CHARACTER*10 FUNCTION CASE(W,IFLAG)
*
* declarations
*
      IMPLICIT LOGICAL (A-Z)
*
      INTEGER I,AV,IFLAG
*
      CHARACTER W*10
*
* work through line.
*
      IF (IFLAG.EQ.1) THEN
      DO 1 I=1,10
      AV=ICHAR(W(I:I))
      IF (AV.GE.97.AND.AV.LE.122) AV=AV-32
      W(I:I)=CHAR(AV)
1     CONTINUE
      ELSE
      DO 11 I=1,10
      AV=ICHAR(W(I:I))
      IF (AV.GE.65.AND.AV.LE.90) AV=AV+32
      W(I:I)=CHAR(AV)
11    CONTINUE
      ENDIF
*
      CASE=W
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* pick key from line.
*
      SUBROUTINE PICKCI(A,N,NN,CC)
*
* declarations
*
      IMPLICIT INTEGER (A-Z)
*
      INTEGER IH(300),J1,N,NN,PP,I,ILAST,FCOUNT,MULT(300),FFT
*
      REAL FH(300)
*
      CHARACTER A*(*),CH(300)*1,CC*1,AA*80
*
* initialise.
*
      NN=0
      P1=INDEX(A,CC)
*
      IF (P1.LT.1) RETURN
*
      AA(1:N-P1)=A(P1:N)
*
      IF (AA(2:2).EQ.' ') RETURN
*
      J1=1
      ILAST=0
      IH(J1)=0
      FH(J1)=0.0
      FCOUNT=1
*
      DO 2 I=1,(N-P1)
      PP=INDEX('0123456789',AA(I:I))
*
      IF (PP.GT.0) THEN
*
      IF (ILAST.NE.2) THEN
      ILAST=1
      IH(J1)=(IH(J1)*10)+(PP-1)
      ELSE
      FFT=10**FCOUNT
      FH(J1)=FH(J1)+FLOAT(PP-1)/FLOAT(FFT)
      FCOUNT=FCOUNT+1
      ENDIF
*
      IF (A(I-1:I-1).EQ.'-') MULT(J1)=-1
*
      ELSE
*
      IF (A(I:I).EQ.'.') THEN 
      ILAST=2
      FCOUNT=1
      FH(J1)=FLOAT(IH(J1))
      IH(J1)=0
      GOTO 2
      ENDIF
* 
      IF (ILAST.EQ.1) THEN
      CH(J1)=A(I:I)
      J1=J1+1
      IH(J1)=0
      CH(J1)=' '
      ILAST=0
      ENDIF
*
      IF (ILAST.EQ.2) THEN
      J1=J1+1
      IH(J1)=0
      CH(J1)=' '
      ILAST=0
      ENDIF
*
      ENDIF
*
2     CONTINUE
*
      NN=J1-1
*
      DO 3 I=1,NN
      IF (MULT(I).EQ.-1) THEN
      IH(I)=-IH(I)
      FH(I)=-FH(I)
      ENDIF
3     CONTINUE
*
      NN=IH(1)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get set of atoms + wildcards.
*
      SUBROUTINE ATLIST(AB,NN,ATL,IH,NH)
*
* declarations
*
      INTEGER NN,NH,K,J,IH(80),KK,N1
*
      CHARACTER AA*80,ATL(80)*4,AB*(*)
*
* reinitialise.
*
      DO 1 I=1,40
      ATL(I)='    '
1     CONTINUE
*
      KK=0
      DO 1000 I=1,NN
      J=INDEX('1234567890.',AB(I:I))
      IF (J.GT.0) GOTO 1000
      KK=KK+1
      AA(KK:KK)=AB(I:I)
1000  CONTINUE
*
      N1=KK
      K=1
      KK=0
      J=0
*
      DO 2 I=1,N1
*
      IF (KK.GT.4) THEN
      IH(K)=4
      K=K+1
      KK=0
      ENDIF
*
      IF (AA(I:I).NE.' '.AND.AA(I:I).NE.'*')  THEN
*
      KK=KK+1
      ATL(K)(KK:KK)=AA(I:I)
*
      ELSE 
*
      IF (AA(I:I).EQ.'*') THEN
      IH(K)=KK
      K=K+1
      KK=0
      ELSE IF (AA(I:I).EQ.' ') THEN
      IF (KK.GT.0) THEN
      IH(K)=4
      KK=0
      K=K+1
      ENDIF
*
      ENDIF
*
      ENDIF
*
2     CONTINUE
*
      IH(K)=KK
*
      NH=K-1
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* automated transformation.
*
      SUBROUTINE DOMANY(IO1,CCLIS)
*
* Declarations.
*
      INTEGER IO1,IFAIL
      CHARACTER FLINE*80,BLINE*80
      CHARACTER FNAM1*80,CCLIS*20
*
      INCLUDE 'SERF.INC'
*
* Initialise.
*
      BLINE='                                                             
     +                                                '
*
* work through a file of file names.
*
1     CONTINUE
*
* read a file name.
*
      READ(IO1,1000,ERR=1,END=100) FLINE
*
* parse names.
*
      FNAM1=BLINE
      CALL PULWRD(80,FNAM1,FLINE)
*
* open input file.
*
      IF (FNAM1(1:1).EQ.' ') THEN
      GOTO 1
      ELSE
      OPEN(UNIT=1,STATUS='OLD',FILE=FNAM1,RECL=1000,
     +READONLY,ERR=70)
      REWIND(UNIT=1)
*
* reinitialise.
*
      CALL CLEAR1
*
* read file.
*
      CALL FILEIN(1,IFAIL,CCLIS)
      CLOSE(UNIT=1)
*
      ENDIF
*
* do analysis.
*
      IF (IFAIL.EQ.0) THEN
      CALL OPENAL
      CALL DOSERF(CCLIS)
      ENDIF
*
70    CONTINUE
*
* Close files.
*
      CLOSE(UNIT=1)
*
* return for next one.
*
      GOTO 1
*
100   CONTINUE
*
1000  FORMAT(A80)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* automated transformation.
*
      SUBROUTINE DOMULT(IO1,CCLIS)
*
* Declarations.
*
      INTEGER IO1,IFAIL
      CHARACTER FLINE*80,BLINE*80
      CHARACTER FNAM1*80,CCLIS*20
*
      INCLUDE 'SERF.INC'
*
* Initialise.
*
      BLINE='                                                             
     +                                                '
*
* create output name.
*
      CALL INQNAM2(1)
      CALL OPENAL
*
      SHUTDEC=1
      FILEND=0
*
* work through a multiple entry file.
*
1     CONTINUE
*
* reinitialise.
*
      CALL CLEAR1
*
* read file.
*
      CALL FILEIN(1,IFAIL,CCLIS)
*
      IF (FILEND.EQ.1) THEN
      SHUTDEC=0
      CLOSE(UNIT=1)
      CLOSE(UNIT=10)
      CLOSE(UNIT=11)
      CLOSE(UNIT=12)
      CLOSE(UNIT=20)
      CLOSE(UNIT=21)
      CLOSE(UNIT=22)
      CLOSE(UNIT=25)
      CLOSE(UNIT=29)

      RETURN
      ENDIF
*
* do analysis.
*
      IF (IFAIL.EQ.0) THEN
      CALL DOSERF(CCLIS)
      ENDIF
*
70    CONTINUE
*
* return for next one.
*
      GOTO 1
*
* format statements.
*
1000  FORMAT(A80)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* set/reset defaults.
*
      SUBROUTINE DOSERF(CCLIS)
*
* declarations.
*
      CHARACTER CCLIS*20
*
      INCLUDE 'SERF.INC'
*
* perform ASA calculations.
*
      CALL ARCALC(CCLIS)
*
* format statements.
*
      RETURN
      END
*
*--------------------------------------------------------------------------------
*
*  read in files.
*
      SUBROUTINE FILEIN(IO1,IFAIL,CCLIS)
*
* declarations.
*
      INTEGER IDEC,IO1,IFAIL
      CHARACTER CCLIS*20
*
      INCLUDE 'SERF.INC'
*
      IFAIL=0
*
      CALL INQNAM2(IO1)
*
      CMPNAME=MOLNAME
*
* read data.
*
      IF (FTYP.EQ.1)  CALL PROLSQIN(IO1,IFAIL)
      IF (FTYP.EQ.2)  CALL PDBIN(IO1,IFAIL)
      IF (FTYP.EQ.5)  CALL FRODOIN(IO1,IFAIL)
      IF (FTYP.EQ.10) CALL MACCIN(IO1,IFAIL)
      IF (FTYP.EQ.40) CALL MOL2IN(IO1,IFAIL)
*
      IF (IFAIL.EQ.0) THEN
*
* create atom lookup table.
*
      CALL LOOKUP(CCLIS)
*
      CALL ATOMNO
*
      ENDIF
*
      RETURN
      END
*  
*-------------------------------------------------------------------------------
*
      SUBROUTINE LOOKUP(CCLIS)
*
* declarations.
*
      INTEGER I,J,K,PP,CHDEC,ATMPCH(200)
      INTEGER IND(500),IDN2(500),LKL(500)
*
      CHARACTER CCLIS*20,CHLIST*20,
* lookup table:
     +ATLOOK(32)*4
*
      INCLUDE 'SERF.INC'
*
* form lookup table for standard atom names.
*
      DATA  ATLOOK /
     +'N   ','C   ','O   ','CA  ','CB  ',
     +'CG  ','CD  ','NE  ','CZ  ',
     +'NH1 ','NH2 ','OD1 ','OD2 ',
     +'CD1 ','CE1 ','CE2 ','CD2 ',
     +'SG  ','OE1 ','OE2 ','OH  ',
     +'OG1 ','CG2 ','CE  ','NZ  ',
     +'CG1 ','ND2 ','NE2 ','SD  ',
     +'OG  ','OT  ','OTX ' /
*
      DO 1 I=1,20
      CHLIST(I:I)=' '
1     CONTINUE
*
* Create lookup table for atoms.
*
      CHLIST(1:1)=RLAB(1)
      CHL=1
      RN1(1)=10000
      ATMPCH(1)=0
*
* loop through all atoms creating index as we go.
*
      DO 4 I=1,NN
*
* check in list of chain identifiers.
*
      PP=0
      CHDEC=INDEX(CHLIST(1:CHL),RLAB(I))
*
      IF (CHDEC.LT.1) THEN
      CHL=CHL+1
      CHLIST(CHL:CHL)=RLAB(I)
      CHDEC=CHL
      RN1(CHDEC)=10000
      ATMPCH(CHDEC)=1
      ELSE
      ATMPCH(CHDEC)=ATMPCH(CHDEC)+1
      ENDIF
*
      RN2(CHDEC)=MAX(RN2(CHDEC),RN(I))
      RN1(CHDEC)=MIN(RN1(CHDEC),RN(I))
*
      PP=POS(-1,RN(I),CHDEC)+1
      POS(-1,RN(I),CHDEC)=PP
*
      POS(PP,RN(I),CHDEC)=I
*
4     CONTINUE
*
      DO 10 I=1,CHL
      DO 10 J=RN1(I),RN2(I)
      IJ=0
      KJ=0
*      
      DO 11 K=1,POS(-1,J,I)
      JJ=POS(K,J,I)
*
      DO 12 L=1,32
      IF (ATNAM(JJ).EQ.ATLOOK(L)) THEN
      IJ=IJ+1
      LKL(IJ)=JJ
      IND(IJ)=L
      ENDIF
12    CONTINUE
*
      KJ=KJ+1      
*
11    CONTINUE
*
      IF (KJ.EQ.0) THEN
* no atoms.
      POS(0,J,I)=-1
      ELSE
* not a protein residue.
      IF (IJ.NE.KJ) THEN
      POS(0,J,I)=0
      ELSE
* a protein residue. sort atoms.
      POS(0,J,I)=1
      CALL ISORT(POS(-1,J,I),IND,IDN2)
      DO 16 L=1,POS(-1,J,I)
      POS(L,J,I)=LKL(IDN2(L))
16    CONTINUE
      ENDIF
      ENDIF
*
10    CONTINUE
*
* Write results: Summary of chain labels and size of chains.
*
      CCLIS(1:20)=CHLIST(1:20)
      WRITE(*,1000) CHL
      DO 7 I=1,CHL
      WRITE(*,1001) I,CHLIST(I:I),ATMPCH(I)
7     CONTINUE
*
* format statements.
*
1000  FORMAT(' Number of different chains:',I3)
1001  FORMAT('   chain',I4,' label:',1X,A1,' with',I5,' atoms.')
1010  FORMAT(' Unknown Atom Name: ',A4,' from chain:',I4)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* COMM. ACM Vol.12 #3 March 1969, R.C.Singleton.
* routine returns order of A in IN.
*
      SUBROUTINE ISORT(N,A,IN)
*
* declarations.
*
      INTEGER N,IN(N),IL(16),IU(16),T,TT,A(N)
*
      DO 1000 I=1,N
      IN(I)=I
1000  CONTINUE
*
      M=1
      I=1
      J=N
*
5     IF (I.GE.J) GOTO 70
10    K=I
      IJ=(I+J)/2
      T=IN(IJ)
      IF (A(IN(I)).LE.A(T)) GOTO 20
      IN(IJ)=IN(I)
      IN(I)=T
      T=IN(IJ)
20    L=J
      IF (A(IN(J)).GE.A(T)) GOTO 40
      IF (A(IN(J)).LT.A(IN(I))) GOTO 25
      IN(IJ)=IN(J)
      IN(J)=T
      T=IN(IJ)
      GOTO 40
*
25    IN(IJ)=IN(I)
      IN(I)=IN(J)
      IN(J)=T
      T=IN(IJ)
      GOTO 40
*
30    IN(L)=IN(K)
      IN(K)=TT
40    L=L-1
      IF (A(IN(L)).GT.A(T)) GOTO 40
      TT=IN(L)
50    K=K+1
      IF (A(IN(K)).LT.A(T)) GOTO 50
      IF (K.LE.L) GOTO 30
      IF ((L-I).LE.(J-K)) GOTO 60
      IL(M)=I
      IU(M)=L
      I=K
      M=M+1
      GOTO 80
60    IL(M)=K
      IU(M)=J
      J=L
      M=M+1
      GOTO 80
*
70    M=M-1
      IF (M.EQ.0) GOTO 900
      I=IL(M)
      J=IU(M)
80    IF ((J-I).GE.11) GOTO 10
      IF (I.EQ.1) GOTO 5
      I=I-1
90    I=I+1
      IF (I.EQ.J) GOTO 70
      T=IN(I+1)
      IF (A(IN(I)).LE.A(T)) GOTO 90
      K=I
100   IN(K+1)=IN(K)
      K=K-1
      IF (A(T).LT.A(IN(K))) GOTO 100
      IN(K+1)=T
      GOTO 90
*
900   CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
*' read in FRODO type DIAMOND format file.
*
      SUBROUTINE FRODOIN(II,IFAIL)
*
* declarations.
*
      INTEGER J,IFAIL
*
      INCLUDE 'SERF.INC'
*
* announce subroutine.
*
      WRITE(*,7001)
*
      DO 11 J=1,3
      READ(II,101) DFLINE(J)
11    CONTINUE
*
      J=1
*
1     CONTINUE
*
      READ(II,100,ERR=50,END=500)
     +X(J),Y(J),Z(J),
     +BFAC(J),AT(J),RN(J),AN(J),ATR(J),
     +RNAM(J),RLAB(J),ATNAM(J)
*
      J=J+1
*
      IF (J.GT.7000) THEN
      WRITE(*,7010)
      NN=7000
      RETURN
      ENDIF
*
50    CONTINUE
      GOTO 1
500   CONTINUE
      WRITE(*,7000)
*
      NN=J-1
*
      IF (NN.GT.0) THEN
      WRITE(*,7002) NN
      ELSE 
      WRITE(*,7003) 
      IFAIL=1
      ENDIF
*
* format statements:
*
100   FORMAT(4F10.5,3I5,F9.4,1X,A3,4X,A1,2X,A4)                           DIAMF
101   FORMAT(A80)
7000  FORMAT(/' Read-in of file completed.')
7001  FORMAT(/' Reading Frodo type Diamond format file (5).')
7002  FORMAT(/1X,I5,' atoms read in.'/)
7003  FORMAT(/' ERROR: no atoms read from file.'/)
7010  FORMAT(/' Too many atoms in file. 7000 atoms read from file.'/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
*' read in BROOKHAVEN format file.
*
      SUBROUTINE PDBIN(II,IFAIL)
*
* declarations.
*
      INTEGER J,II,IFAIL
      CHARACTER IDEN*6
*
      INCLUDE 'SERF.INC'
*
* announce subroutine.
*
      WRITE(*,7001)
*
* read file.
*
      J=1
1     CONTINUE
*
      READ(II,100,END=500,ERR=50)
     +IDEN,AN(J),ATNAM(J),RNAM(J),RLAB(J),
     +RN(J),
     +X(J),Y(J),Z(J),QOCC(J),BFAC(J)
*
      IF (IDEN.EQ.'ATOM  ') THEN 
      ELSE IF (IDEN.EQ.'HETATM') THEN
      ATY(J)=2
      ELSE
      GOTO 1
      ENDIF
*
      J=J+1
*
      IF (J.GT.7000) THEN
      NN=7000
      RETURN
      ENDIF      
*
50    CONTINUE
      GOTO 1
500   CONTINUE
      WRITE(*,7000)
*
      NN=J-1
*
      IF (NN.GT.0) THEN
      WRITE(*,7002) NN
      ELSE 
      WRITE(*,7003) 
      IFAIL=1
      ENDIF
*
* format statements:
*
100   FORMAT(A6,I5,2X,A4,A3,1X,A1,I4,4X,3F8.3,2F6.2)                      PDB
7000  FORMAT(/' Read-in of file completed.')
7001  FORMAT(/' Reading Brookhaven format file.')
7002  FORMAT(/1X,I5,' atoms read in.'/)
7003  FORMAT(/' ERROR: no atoms read from file.'/)
7010  FORMAT(/' Too many atoms in file. 7000 atoms read from file.'/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* read in PROLSQ type DIAMOND format file.
*
      SUBROUTINE PROLSQIN(II,IFAIL)
*
* declarations.
*
      INTEGER J,II,IFAIL
*
      INCLUDE 'SERF.INC'
*
* announce subroutine
*
      WRITE(*,7001)
*
      DO 11 J=1,3
      READ(II,101) DFLINE(J)
11    CONTINUE
*
      J=1
*
1     CONTINUE
*
      READ(II,100,ERR=50,END=500)
     +X(J),Y(J),Z(J),
     +BFAC(J),AT(J),RN(J),AN(J),ATR(J),
     +RNAM(J),RLAB(J),ATNAM(J)
*
      J=J+1
*
      IF (J.GT.7000) THEN
      WRITE(*,7010)
      NN=7000
      RETURN
      ENDIF
*
50    CONTINUE
      GOTO 1
500   CONTINUE
      WRITE(*,7000)
*
      NN=J-1
*
      IF (NN.GT.0) THEN
      WRITE(*,7002) NN
      ELSE 
      WRITE(*,7003) 
      IFAIL=1
      ENDIF
*
* format statements:
*
100   FORMAT(4F10.5,3I5,F9.4,1X,A3,3X,A1,3X,A4)                           DIAMP
101   FORMAT(A80)
7000  FORMAT(/' Read-in of file completed.')
7001  FORMAT(/' Reading a Prolsq type Diamond format file.')
7002  FORMAT(/1X,I5,' atoms read in.'/)
7003  FORMAT(/' ERROR: no atoms read from file.'/)
7010  FORMAT(/' Too many atoms in file. 7000 atoms read from file.'/)
*
      RETURN 
      END
*
*-------------------------------------------------------------------------------
*
* ' read in MACCS MOL format file.
*
      SUBROUTINE MACCIN(II,IFAIL)
*
* declarations.
*
      INTEGER I,J,K,II,IATM,IT,IBND,IMVAL(10),IKI,IFAIL
      CHARACTER AD*2,FLINE*80,GLINE(4)*80
*
      INCLUDE 'SERF.INC'
*
* announce subroutine.
*
      IF (VERBOS.EQ.0) WRITE(*,1001)
*
* read header.
*
      DO 700 I=1,4
      READ(II,103,ERR=501,END=600) GLINE(I)
700   CONTINUE
*
* get stuff from header.
*
      READ(GLINE(1),101,ERR=501,END=600) DFLINE(1)(1:60)
      READ(GLINE(2),102,ERR=501,END=600) AD,DFLINE(2)(1:10)
      READ(GLINE(3),103,ERR=501,END=600) FLINE
      READ(GLINE(4),104,ERR=501,END=600) IATM,IBND
*
* Parse compound identifier.
*
      IF (HEADL(3).GT.0.AND.HEADL(3).LT.5) THEN
      IF (HEADL(1).GT.0.AND.HEADL(2).GE.HEADL(1)) THEN
      IKI=(HEADL(2)-HEADL(1)+1)
      CALL LSTWRD(1,IKI,CMPNAME(1:IKI),
     +GLINE(HEADL(3))(HEADL(1):HEADL(2)))
      ELSE
      CALL LSTWRD(1,16,CMPNAME(1:16),GLINE(HEADL(3)))
      ENDIF
      ENDIF
*
* initialise atom counter.
*
      J=1
*
* read atom entries.
*
      DO 1 I=1,IATM
*
* read line.
*
      READ(II,100,ERR=1,END=600)
     +X(J),Y(J),Z(J),
     +ATNAM(J)(1:3),
     +(IMVAL(K1),K1=1,6)
*
* fill tables.
*
      AN(J)=J 
      RN(J)=1
      ATNAM(J)(4:4)=' '
      RLAB(J)=' '
      RNAM(J)='XXX'
*
* Charge.
*
      IK=IMVAL(2)
      IF (IK.GT.0) THEN
      IF (IK.GT.3) THEN
      IK=-ABS(IK-4)
      ELSE
      IK=ABS(4-IK)
      ENDIF
      ELSE
      IK=0
      ENDIF
*
* save it.
*
*      CHARGE(J)=FLOAT(IK)
*
* hydrogens.
*
      IF (IMVAL(4).GT.0) THEN
*     IHYD(J)=IMVAL(4)-1
      ENDIF
*
* increment counter.
*
      J=J+1
*
* error trap.
*
      IF (J.GT.9000) THEN
      IF (VERBOS.EQ.0) WRITE(*,1100)
      NN=9000
      GOTO 500
      ENDIF
*
1     CONTINUE
*
500   CONTINUE
*
      IF (VERBOS.EQ.0) WRITE(*,1000)
*
      NN=J-1
*
* error trap.
*
      IF (NN.GT.0) THEN
      ELSE
      IF (VERBOS.EQ.0) WRITE(*,1003)
      ENDIF
*
* now read bonds.
*
      DO 2 I=1,IBND
*
* read a bond line.
*
      READ(II,105,ERR=2,END=600) 
     +I1,I2,IRD
*
* expand connectivity tables.
*
*      IF (I1.GT.0.AND.I1.LE.NN) THEN
*      IF (I2.GT.0.AND.I2.LE.NN) THEN
*
*      NCON(I1)=NCON(I1)+1
*      NCON(I2)=NCON(I2)+1
*      ICON(NCON(I1),I1)=I2
*      ICON(NCON(I2),I2)=I1
*      OCON(NCON(I1),I1)=IRD
*      OCON(NCON(I2),I2)=IRD
*
*      ENDIF
*      ENDIF
*
2     CONTINUE
*
* check for SDF file terminator.
*
5     CONTINUE
*
* read lines.
*
      READ(II,103,END=600,ERR=5) FLINE
*
* get code.
*
      IF (ABS(LIDEN).GT.0) THEN
      IF (INDEX(FLINE,IDLINE(1:ABS(LIDEN))).GT.0) THEN
      READ(1,103,ERR=5,END=600) FLINE
      IF (LIDEN.LT.0) THEN
      CALL PACK80(FLINE)
      ELSE
      CALL LSTWRD(1,80,CMPNAME,FLINE)
      ENDIF
      ENDIF
      ENDIF
*
* check for characters.
*
      IF (FLINE(1:4).EQ.'$$$$') THEN
      ELSE
      GOTO 5
      ENDIF
*
501   CONTINUE
*
* report number of atoms.
*
      IF (NN.GT.0) THEN
      IF (VERBOS.EQ.0) WRITE(*,1002) NN
      ELSE
      IFAIL=1
      ENDIF
*
      RETURN
*
* Error trap end of file.
*
600   CONTINUE
*
* report number of atoms.
*
      IF (NN.GT.0) THEN
      IF (VERBOS.EQ.0) WRITE(*,1002) NN
      ELSE
      IFAIL=1
      ENDIF
*
      FILEND=1
*
* format statements:
*
100   FORMAT(3F10.4,1X,A3,I2,5I3)
101   FORMAT(A60)
102   FORMAT(20X,A2,24X,A10)
103   FORMAT(A80)
104   FORMAT(2I3)
105   FORMAT(3I3)
106   FORMAT(A4)
1000  FORMAT(/' Read-in of atom data completed.')
1001  FORMAT(/' Reading a MACCS MOL format file (10).')
1002  FORMAT(/' Read-in of file completed.',
     +/1X,I5,' atoms read in.'/)
1003  FORMAT(/' ERROR: no atoms read from file.'/)
1100  FORMAT(/' Read-in aborted. More than 9000 atoms.'/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* pack a string.
*
      SUBROUTINE PACK80(AA)
*
* Declarations.
*
      CHARACTER AA*80,VV*80
*
      INTEGER I,J,K,HH
*
* work through string.
*
      J=0
      DO 1 I=1,80
      VV(I:I)=' '
      IF  (AA(I:I).NE.' ') THEN
      J=J+1
      VV(J:J)=AA(I:I)
      ENDIF
1     CONTINUE
*
* copy back packed string.
*
      AA=VV
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
* ' read in SYBYL MOL2 format file.
*
      SUBROUTINE MOL2IN(II,IFAIL)
*
* declarations.
*
      INTEGER I,J,K,II,IATM,IT,IBND,NB,IIH(80),NH,IFAIL
      REAL FFH(80)
      CHARACTER GLINE*80,A4*80,A10*10,CCH(80)*1
*
      INCLUDE 'SERF.INC'
*
* announce subroutine.
*
      IF (VERBOS.EQ.0) WRITE(*,1001)
*
* reinitialise.
*
      NN=0
      NB=0
*
400   CONTINUE
*
* read header including number of atoms expecting and compound name.
*
      READ(II,104,ERR=400,END=600) GLINE
*
      IF (GLINE(1:17).EQ.'@<TRIPOS>MOLECULE') THEN
*
      READ(II,104,ERR=400,END=600) GLINE
*
* Parse compound identifier.
*
      IF (HEADL(1).GT.0.AND.HEADL(2).GE.HEADL(1)) THEN
      IKI=(HEADL(2)-HEADL(1)+1)
      CALL LSTWRD(1,IKI,CMPNAME(1:IKI),
     +GLINE(HEADL(1):HEADL(2)))
      ELSE
      CALL LSTWRD(1,40,CMPNAME(1:40),GLINE(1:80))
      ENDIF
*
      READ(II,104,ERR=400,END=600) GLINE
*
      CALL LRDRF(GLINE(1:80),80,IIH,FFH,CCH,NH)
      IATM=IIH(1)
      IBND=IIH(2)
*
* Error trap.
*
      IF (IATM.LT.1) THEN
      RETURN
      ENDIF
*
      GOTO 400
*
      ELSEIF (GLINE(1:13).EQ.'@<TRIPOS>ATOM') THEN
*
* initialise atom counter.
*
      J=1
*
* read atom entries.
*
1     CONTINUE
*
* read line.
*
      READ(II,104,ERR=1,END=600) GLINE
*
* Parse
*
      CALL LRDRA(GLINE(1:80),80,IIH,FFH,CCH,NH)
      AN(J)=IIH(1)
      X(J)=FFH(2)
      Y(J)=FFH(3)
      Z(J)=FFH(4)
      RN(J)=IIH(5)
      CHARGE(J)=FFH(6)
      CALL LSTWRD(2,80,A4,GLINE(1:80))
      ATNAM(J)=A4(1:4)
      CALL LSTWRD(8,80,A4,GLINE(1:80))
      RNAM(J)=A4(1:3)
*
* default some missing values.
*
      BFAC(J)=20.0
      QOCC(J)=1.0
      RLAB(J)=' '
*
* Error trap too many atoms.
*
      IF (J.LT.IATM) THEN
*
* increment counter.
*
      J=J+1
*
* error trap.
*
      IF (J.GT.9000) THEN
      IF (VERBOS.EQ.0) WRITE(*,1100)
      NN=9000
      RETURN
      ENDIF
*
      GOTO 1
*
      ENDIF
*
500   CONTINUE
*
* Save number of atoms.
*
      NN=J
*
* error trap.
*
      IF (NN.GT.0) THEN
      IF (VERBOS.EQ.0) WRITE(*,1002) NN
      ELSE
      IF (VERBOS.EQ.0) WRITE(*,1003)
      RETURN
      ENDIF
*
      GOTO 400
*
      ELSEIF (GLINE(1:13).EQ.'@<TRIPOS>BOND') THEN      
*
* Reset counter.
*
      IL=0
2     CONTINUE
*
* Increment counter.
*
      IL=IL+1
*
* Error trap.
*
      IF (IL.GT.IBND) GOTO 501
*
* read line.
*
      READ(II,104,ERR=1,END=600) GLINE
*
* Parse bond line.
*
      CALL LRDRA(GLINE(1:80),80,IIH,FFH,CCH,NH)
      IT=IIH(1)
      I1=IIH(2)
      I2=IIH(3)
      CALL LSTWRD(4,80,A4,GLINE(1:80))
*
* change bond types to internal standard.
*
      IF (A4(1:4).EQ.'1   ') THEN
      IRD=1
      ELSEIF (A4(1:4).EQ.'2   ') THEN
      IRD=2
      ELSEIF (A4(1:4).EQ.'3   ') THEN
      IRD=3
      ELSEIF (A4(1:4).EQ.'ar  ') THEN
      IRD=4
      ELSEIF (A4(1:4).EQ.'am  ') THEN
      IRD=5
      ENDIF
*
* expand connectivity tables.
*
*      IF (I1.GT.0.AND.I1.LE.NN) THEN
*      IF (I2.GT.0.AND.I2.LE.NN) THEN
*
* Update connection list.
*
*      NCON(I1)=NCON(I1)+1
*      ICON(NCON(I1),I1)=I2
*      OCON(NCON(I1),I1)=IRD
*
*      NCON(I2)=NCON(I2)+1
*      ICON(NCON(I2),I2)=I1
*      OCON(NCON(I2),I2)=IRD
*
*      ENDIF
*      ENDIF
*
* return for next line.
*
      GOTO 2
*
501   CONTINUE
*
* report number of bonds.
*
      IF (IL.GT.0) THEN
      IF (VERBOS.EQ.0) WRITE(*,1004) IL
      ELSE
      IF (VERBOS.EQ.0) WRITE(*,1005)
      RETURN
      ENDIF
*
* report finish of read.
*
      IF (NN.GT.0) THEN
      IF (VERBOS.EQ.0) WRITE(*,1000)
      ELSE
      IFAIL=1
      ENDIF
*
      RETURN
*
      ELSE
      GOTO 400
      ENDIF
*
      GOTO 400
*
600   CONTINUE
*
* report number of atoms.
*
      IF (NN.GT.0) THEN
      IF (VERBOS.EQ.0) WRITE(*,1002) NN
      ELSE
      IFAIL=1
      ENDIF
*
      FILEND=1
*
* format statements:
*
100   FORMAT(I7,1X,A4,4X,3F10.4,6X,I6,1X,A3,4X,F10.4)
101   FORMAT(I5,I6)
102   FORMAT(I4)
103   FORMAT(I6,2I5,1X,A4)
104   FORMAT(A80)
1000  FORMAT(/' Read-in of file completed.')
1001  FORMAT(/' Reading a SYBYL MOL2 format file (31).')
1002  FORMAT(/1X,I5,' atoms read in.'/)
1003  FORMAT(/' ERROR: no atoms read from file.'/)
1004  FORMAT(/1X,I5,' bonds read in.'/)
1005  FORMAT(/' ERROR: no bonds read from file.'/)
1100  FORMAT(/' Read-in aborted. More than 9000 atoms.'/)
*
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* simple but fairly robust parser.
*     picks up lists of integer and real numbers. 
*     plus a letter if it follows an integer directly.
*
* nb:
*
*  ILAST = 0 not a number.
*  ILAST = 1 integer number.
*  ILAST = 2 real number.
*
      SUBROUTINE LRDRA(A,N,IH,FH,CH,NN)
*
* decalarations.
*
      INTEGER J1,J2,N,NN,NNN,PP,I,J,ILAST,FCOUNT,FFT
      INTEGER IH(80),MULT(80)
*
      REAL FH(80)
*
      CHARACTER A*(*),B*80,CH(80)*1 
*
* initialise.
*
      DO 10 I=1,80
      IH(I)=0
      FH(I)=0.0
      CH(I)=' '
      MULT(I)=1
10    CONTINUE
*
      J1=0
      ILAST=0
      FCOUNT=1
*
* Work through line.
*
      DO 2 I=1,N
*
* check for number.
*
      PP=INDEX('0123456789',A(I:I))
*
* have found one.
*
      IF (PP.GT.0) THEN
*
* new number.
*
      IF (ILAST.EQ.0) THEN
*
* Isolated number.
*
      IF (A(I-1:I-1).EQ.' ') THEN
      J1=J1+1
      IH(J1)=0
      FH(J1)=0.0
      ILAST=1
      MULT(J1)=1
*
* signed number.
*
      ELSEIF (A(I-1:I-1).EQ.'-'.AND.A(I-2:I-2).EQ.' ') THEN
      J1=J1+1
      IH(J1)=0
      FH(J1)=0.0
      MULT(J1)=-1
      ILAST=1
      ELSE
      GOTO 2
      ENDIF
*
      ENDIF
*
* integer
*
      IF (ILAST.EQ.1) THEN
*
      ILAST=1
*
      IF (IH(J1).GT.0) THEN
      IH(J1)=(IH(J1)*10)+(PP-1)
      ELSE
      IH(J1)=(PP-1)
      ENDIF
*
* real number.
*
      ELSEIF (ILAST.EQ.2) THEN
*
      FFT=10**FCOUNT
      FH(J1)=FH(J1)+(FLOAT(PP-1)/FLOAT(FFT))
*
      FCOUNT=FCOUNT+1
*
      ILAST=2
*
      ENDIF
*
      ELSE
*
* found a decimal point.
*
      IF (A(I:I).EQ.'.') THEN 
*
* check for isolation.
*
      IF (A(I-1:I-1).EQ.'-') THEN
*
* positive real.
*
      IF (A(I-2:I-2).EQ.' ') THEN
      J1=J1+1
      MULT(J1)=-1
      ILAST=2
      FCOUNT=1
      FH(J1)=0
      IH(J1)=0
      ENDIF
*
* positive small real.
*
      ELSEIF (A(I-1:I-1).EQ.' ') THEN
      J1=J1+1
      ILAST=2
      FCOUNT=1
      FH(J1)=0
      IH(J1)=0
*
* positive large real.
*
      ELSEIF (INDEX('0123456789',A(I-1:I-1)).GT.0) THEN
      ILAST=2
      FCOUNT=1
      FH(J1)=FLOAT(IH(J1))
      IH(J1)=0
      ENDIF
*
      ELSE
*
* end of number.
*
      ILAST=0
*
      ENDIF
*
      ENDIF
*
2     CONTINUE
*
* get number of numbers found.
*
      NN=J1
*
* get correct sign for each number.
*
      DO 3 I=1,NN
      IF (MULT(I).EQ.-1) THEN
      IH(I)=-IH(I)
      FH(I)=-FH(I)
      ENDIF
3     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Get name of input file.
*
      SUBROUTINE INQNAM(IO)
*
* declarations
*
      INTEGER IO,EXDEC,OPDEC
      CHARACTER FLINE*80,LINE*80
*
* Initialise.
*
      IFAIL=1
      FLINE='                                                              
     +                                                   '
*
* get name of file.
*
      INQUIRE(UNIT=IO,NAME=LINE,EXIST=EXDEC,OPENED=OPDEC,ERR=1080)
*
* report filename.
*
      WRITE(*,1002) LINE(1:79)
*
1080  CONTINUE
*
* format statements.
*
1000  FORMAT(/' ERROR: no input filetype given.'/) 
1001  FORMAT(/' ERROR: can not recover file name.'/) 
1002  FORMAT(/' Reading from file:'/,1X,A79) 
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Get first word from a line
*
      SUBROUTINE PULWRD(II,B,A)
*
* declarations.
*
      INTEGER II,ICOUNT,IDEC
      CHARACTER A*(*),B*80
*
* initialise
*
      ICOUNT=0
      IDEC=0
      B(1:80)='                                        
     +                                  '
*
* work through line.
*
      DO 1 I=1,II
*
      IF (A(I:I).NE.' ') THEN
      IDEC=1
      ICOUNT=ICOUNT+1
      B(ICOUNT:ICOUNT)=A(I:I)
      ENDIF
*
      IF (A(I:I).EQ.' '.AND.IDEC.EQ.1) RETURN
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Get first word from a line
*
      SUBROUTINE LSTWRD(IW,II,B,A)
*
* declarations.
*
      INTEGER II,ICOUNT,IDEC
      CHARACTER A*(*),B*80
*
* initialise
*
      ICOUNT=0
      IDEC=0
      B(1:80)='                                                  
     +                                             '
      IT=1
*
* work through line.
*
      DO 1 I=1,II
*
* a non-blank character.
*
      IF (A(I:I).NE.' ') THEN
*
* set flags and counters.
*
      IDEC=1
      ICOUNT=ICOUNT+1
*
* Error trap.
*
      IF (ICOUNT.LT.81) THEN
      B(ICOUNT:ICOUNT)=A(I:I)
      ENDIF
*
      ENDIF
*
* end of a word.
*
      IF (A(I:I).EQ.' '.AND.IDEC.EQ.1) THEN
*
* reset flags and counters.
*
      ICOUNT=0
      IDEC=0
*
* increment word counter.
*
      IT=IT+1
*
* Check if we have the word required.
*
      IF (IT.EQ.IW+1) RETURN
*
* default word string.
*
      B(1:80)='                                                  
     +                                             '
      ENDIF
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* case swapping routine:
*' IFLAG=1 : lower to upper case.
*' IFLAG=0 : upper to lower case.
*
      CHARACTER*80 FUNCTION CASEALL(W,IFLAG)
*
* declarations.
*
      INTEGER I,AV,IFLAG
*
      CHARACTER W*80
*
* do change.
*
      IF (IFLAG.EQ.1) THEN
      DO 1 I=1,80
      AV=ICHAR(W(I:I))
      IF (AV.GE.97.AND.AV.LE.122) AV=AV-32
      W(I:I)=CHAR(AV)
1     CONTINUE
      ELSE
      DO 11 I=1,80
      AV=ICHAR(W(I:I))
      IF (AV.GE.65.AND.AV.LE.90) AV=AV+32
      W(I:I)=CHAR(AV)
11    CONTINUE
      ENDIF
*
      CASEALL=W
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get filetype from names.
*
      INTEGER FUNCTION 
     +GETFT(SNAM,SNAM1,SNAM2)
*
* Declarations.
*
      INTEGER ITYPE,ITYPE2,ITYPE3,SQTYP
      INTEGER SEQTYP,MTTYP,MTRTYP
      CHARACTER SNAM*80,SNAM1*80,SNAM2*80
*
* reset.
*
      ITYPE=0
      ITYPE2=0
      ITYPE3=0
*
* check for get file type
*
      IF (SNAM(1:4).EQ.'DIAM') THEN
*
* varieties of Diamond file.
*
      IF (SNAM1(1:5).EQ.'FRODO') THEN
      ITYPE=1
      ELSEIF (SNAM1(1:4).EQ.'LESK') THEN
      ITYPE=4
      ELSEIF (SNAM1(1:4).EQ.'CCP4') THEN
      ITYPE=5
      ELSE
      ITYPE=5
      ENDIF
*
* Brookhaven format.
*
      ELSEIF (SNAM(1:3).EQ.'PDB'.OR.SNAM(1:5).EQ.'BROOK') THEN
*
      ITYPE=2
*
* variations.
*
      IF (SNAM1(1:5).EQ.'XPLOR'.OR.SNAM2(1:5).EQ.'XPLOR') THEN
      ITYPE2=1
      ELSEIF (SNAM1(1:3).EQ.'TER'.OR.SNAM2(1:3).EQ.'TER') THEN
      ITYPE2=2
      ENDIF
*
      IF (SNAM1(1:3).EQ.'CON'.OR.SNAM2(1:3).EQ.'CON') THEN
      ITYPE3=1
      ELSEIF (SNAM1(1:4).EQ.'DGEO'.OR.SNAM2(1:4).EQ.'DGEO') THEN
      ITYPE3=2
      ELSEIF (SNAM1(1:4).EQ.'MULT'.OR.SNAM2(1:4).EQ.'MULT') THEN
      ITYPE3=2
      ENDIF
*
* other formats.
*
      ELSEIF (SNAM(1:2).EQ.'WH') THEN
      ITYPE=3
*
* Sybyl formats.
*
      ELSEIF (SNAM(1:5).EQ.'SYBYL') THEN
      ITYPE=12
*
      IF (SNAM1(1:5).EQ.'CHARG') THEN
      ITYPE2=1
      ENDIF
*
      IF (SNAM1(1:4).EQ.'MOL2') THEN
      ITYPE=40
      ENDIF
*
* MDL Maccs MOL file format.
*
      ELSEIF (SNAM(1:5).EQ.'MACCS') THEN
*
      ITYPE=10
*
* variations.
*
      IF (SNAM1(1:2).EQ.'3D'.OR.SNAM2(1:2).EQ.'3D') THEN
      ITYPE2=1
      ENDIF
*
      IF (SNAM1(1:4).EQ.'NAME'.OR.SNAM2(1:4).EQ.'NAME') THEN
      ITYPE3=1
      ENDIF
*
* MDL Reaccs file format.
*
      ELSEIF (SNAM(1:6).EQ.'REACCS') THEN
*
      ITYPE=36
*
* Other file formats.
*
      ELSEIF (SNAM(1:3).EQ.'TNT') THEN
      ITYPE=7
      ELSEIF (SNAM(1:5).EQ.'AMSON') THEN
      ITYPE=9
      ELSEIF (SNAM(1:7).EQ.'TRIBBLE') THEN
      ITYPE=11
      ELSEIF (SNAM(1:6).EQ.'MERLOT') THEN
      ITYPE=8
      ELSEIF (SNAM(1:3).EQ.'SMD') THEN
      ITYPE=13
      ELSEIF (SNAM(1:7).EQ.'CHEMLAB') THEN
      ITYPE=14
*
* Daylight formats.
*
      ELSEIF (SNAM(1:6).EQ.'SMILES') THEN
      ITYPE=15
      ITYPE2=0
*
      ELSEIF (SNAM(1:3).EQ.'TDT') THEN
      ITYPE=15
      ITYPE2=1
*
* Amber Input files.
*
      ELSEIF (SNAM(1:5).EQ.'AMBER') THEN
      ITYPE=16
*
* variations.
*
      IF (SNAM1(1:6).EQ.'UNITED') THEN
      ITYPE2=1
      ELSE
      ITYPE2=2
      ENDIF
*
      ELSEIF (SNAM(1:6).EQ.'GROMOS') THEN
      ITYPE=19
      ELSEIF (SNAM(1:5).EQ.'MOPAC') THEN
      ITYPE=20
*
      IF (SNAM1(1:3).EQ.'XYZ') THEN
      ITYPE2=1
      ELSEIF (SNAM1(1:5).EQ.'INTERN') THEN
      ITYPE2=0
      ELSE
      ITYPE2=0
      ENDIF 
*
      ELSEIF (SNAM(1:8).EQ.'RESIDUES') THEN
      ITYPE=21
*
      ELSEIF (SNAM(1:4).EQ.'GRID') THEN
      ITYPE=23
*
      ELSEIF (SNAM(1:6).EQ.'MACROM') THEN
      ITYPE=24
*
      ELSEIF (SNAM(1:3).EQ.'BGF') THEN
      ITYPE=25
*
      ELSEIF (SNAM(1:7).EQ.'ATOMXYZ') THEN
      ITYPE=26
*
* Cambridge Structural Database (CSD) file formats.
*
      ELSEIF (SNAM(1:4).EQ.'CSSR') THEN
*
      ITYPE=6
*
* variations.
*
      IF (SNAM1(1:5).EQ.'CHEMX') THEN
      ITYPE2=1
      ENDIF
*
      ELSEIF (SNAM(1:4).EQ.'FDAT') THEN
      ITYPE=17
      ELSEIF (SNAM(1:4).EQ.'FCON') THEN
      ITYPE=18
      ELSEIF (SNAM(1:4).EQ.'FBIB') THEN
      ITYPE=28
      ELSEIF (SNAM(1:3).EQ.'CSD') THEN
      ITYPE=29
      ELSEIF (SNAM(1:4).EQ.'CLIX') THEN
      ITYPE=29
      ITYPE2=1
      ELSEIF (SNAM(1:6).EQ.'PREMER') THEN
      ITYPE=30
*
* POVRAY options.
*
      ELSEIF (SNAM(1:6).EQ.'POVRAY') THEN
*
      ITYPE=31
*
      IF (SNAM1(1:3).EQ.'CYL') THEN
      ITYPE2=1
      ELSEIF (SNAM1(1:4).EQ.'BALL') THEN
      ITYPE2=2
      ELSEIF (SNAM1(1:4).EQ.'BLOB') THEN
      ITYPE2=3
      ELSEIF (SNAM1(1:5).EQ.'TRACE') THEN
      ITYPE2=4
      ELSEIF (SNAM1(1:5).EQ.'RIBBO') THEN
      ITYPE2=5
      ELSEIF (SNAM1(1:5).EQ.'ALIGN') THEN
      ITYPE2=7
      ELSE
      ITYPE2=0
      ENDIF 
*
* ligand type.
*
      IF (ITYPE2.EQ.4.OR.ITYPE2.EQ.5) THEN
      IF (SNAM2(1:3).EQ.'CYL') THEN
      ITYPE3=1
      ELSEIF (SNAM2(1:4).EQ.'BALL') THEN
      ITYPE3=2
      ELSE
      ITYPE3=0
      ENDIF
      ENDIF
*
* STEREO postscript output.
*
      ELSEIF (SNAM(1:6).EQ.'STEREO') THEN
*
      ITYPE=32
*
* subtypes.
*
      IF (SNAM1(1:5).EQ.'TRACE') THEN
*
* Calpha Trace with ligands.
*
      ITYPE2=1
*
      ELSEIF (SNAM1(1:5).EQ.'PLUTO') THEN
*
* Pluto-style small molecule plot.
*
      ITYPE2=2
*
* colour.
*
      IF (SNAM2(1:3).EQ.'COL') THEN
      ITYPE3=1
      ENDIF
*
      ELSE
      ITYPE2=1
      ENDIF 
*
* write sterimol parameters B1, B5, and L to file.
*
      ELSEIF (SNAM(1:5).EQ.'STERI') THEN
*
      ITYPE=33
*
* write topological descriptors to file.
*
      ELSEIF (SNAM(1:5).EQ.'TOPOL') THEN
*
      ITYPE=34
*
      IF (SNAM1(1:6).EQ.'DISSIM') THEN
      ITYPE2=1
      ELSEIF (SNAM1(1:5).EQ.'GOLPE') THEN
      ITYPE2=2
      ELSEIF (SNAM1(1:4).EQ.'LIST') THEN
      ITYPE2=3
      ELSEIF (SNAM1(1:4).EQ.'CORR') THEN
      ITYPE2=4
      ELSEIF (SNAM1(1:5).EQ.'SHORT') THEN
      ITYPE2=5
      ELSE
      ITYPE2=1
      ENDIF
*
* count of hbond donors and acceptors.
*
      ELSEIF (SNAM(1:6).EQ.'HBCOUN') THEN
*
      ITYPE=35
*
* Projection onto principal axes.
*
      ELSEIF (SNAM(1:4).EQ.'PRAX') THEN
*
      ITYPE=37
*
* Mono picture of ligand.
*
      ELSEIF (SNAM(1:6).EQ.'PSPLOT') THEN
*
      ITYPE=32
      ITYPE2=3
*
      IF (SNAM1(1:3).EQ.'COL') THEN
      ITYPE3=1
      ELSE
      ITYPE3=0
      ENDIF
*
      ELSE
*
* Error trap unidentified file format.
*
      ITYPE=-1
      ENDIF
*
* pass type back.
*
      GETFT=ITYPE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* set/reset defaults.
*
      SUBROUTINE RESET
*
* declarations.
*
      INCLUDE 'SERF.INC'
*
* initialise.
*
* file flags.
*
      FTYP=0
      FTYP1=0
      FTYP2=0
      FTYP3=0
      OTYP=0
      OTYP1=0
      OTYP2=0
      OTYP3=0
      SOTYP=0
      SITYP=0
      FILMNY=1
*
* transformation controls.
*
      ALLDEC=0
      RESDEC=0
      POLDEC=0
      JURDEC=0
      SHUTDEC=0
      PROTRAD=0
*
* Other stuff.
*
      VERBOS=0
      HEADEC=0
*
* other control parameters.
*
      RENUMA=0
      RENUMR=0
      ORDER=0
      GROUPN=0
      NCOMP=0
*
      FILDEC=0
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* set/reset defaults.
*
      SUBROUTINE CLEAR1
*
* declarations.
*
      INTEGER I,J,II
      INCLUDE 'SERF.INC'
*
* initialise atom indexing.
*
      CALL CLEAR2
*
* clear connectivities and other information.
*
      DO 3 I=1,7000
*
* clear attributes.
*
      IAT(I)=0
      RN(I)=1
      AT(I)=0
      ATY(I)=0
      ATR(I)=0
*
      X(I)=0.0
      Y(I)=0.0
      Z(I)=0.0
      CHARGE(I)=0.0
*
      RLAB(I)=' '
      ATNAM(I)='    '
      RNAM(I)='   '
*
      QOCC(I)=0.0
      BFAC(I)=0.0
*
* clear connection table.
*
3     CONTINUE
*
* Other stuff.
*
      MOLNAME='                                                       
     +                                          '
*
* reset number of atoms
*
      NN=0
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* set/reset defaults.
*
      SUBROUTINE CLEAR2
*
* declarations.
*
      INTEGER I,J,II,I1,I2
      INCLUDE 'SERF.INC'
*
* initialise atom indexing.
*
      DO 1 I=1,50
*
      DO 2 J=1,800
      DO 2 II=-2,50
      POS(II,J,I)=0
2     CONTINUE
      RN1(I)=0
      RN2(I)=0
1     CONTINUE
*
      CHL=0
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Get name of input file.
*
      SUBROUTINE INQNAM2(IO)
*
* declarations
*
      INTEGER IO,EXDEC,OPDEC
      CHARACTER FLINE*80,LINE*80
*
      INCLUDE 'SERF.INC'
*
* Initialise.
*
      IFAIL=1
      FLINE='                                                              
     +                                                   '
*
* get name of file.
*
      INQUIRE(UNIT=IO,NAME=LINE,EXIST=EXDEC,OPENED=OPDEC,ERR=1080)
*
* report filename.
*
      IF (VERBOS.EQ.0) WRITE(*,1002) LINE(1:79)
*
* parse root name from file name string.
*
      CALL FINDN(80,IFAIL,LINE,FLINE)
*
1080  CONTINUE
*
* Error trap.
*
      IF (IFAIL.EQ.1) THEN
      FLINE(1:5)='ALTER'
      IF (VERBOS.EQ.0) WRITE(*,1001)
      ENDIF
*
* Save it.
*
      MOLNAME=FLINE
*
* format statements.
*
1000  FORMAT(/' ERROR: no input filetype given.'/) 
1001  FORMAT(/' ERROR: can not recover file name.'/) 
1002  FORMAT(/' Reading from file:'/,1X,A79) 
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get root name from line.
*
      SUBROUTINE FINDN(IL,IFAIL,LINE,FLINE)
*
* declarations.
*
      INTEGER IL,K1,K2,IFAIL,CL
      CHARACTER LINE*(*),FLINE*(*)
*
* initialise.
*
      IFAIL=0
      K1=0
      K2=0
      FLINE='                                                            
     +                                         '
*
* find root from input string.
*
      DO 1 I=IL,1,-1
*
* Vax delimiter.
*
      IF (LINE(I:I).EQ.']') GOTO 11
*
* Unix delimiter.
*
      IF (LINE(I:I).EQ.'/') GOTO 11
*
1     CONTINUE
*
* trap just name.
*
      I=0
*
11    CONTINUE
*
      K1=I+1
*
      DO 2 I=IL,K1,-1
      IF (LINE(I:I).EQ.'.') GOTO 12
2     CONTINUE
*
* trap just name.
*
      I=IL+1
*
12    CONTINUE
*
      K2=I-1
*
* error trap.
*
      IF (K2.LT.K1) THEN 
*
* fail.
*
      IFAIL=1
*
      ELSE
*
* create root name string.
*
      IFAIL=0
      CL=(K2-K1)+1
      FLINE(1:CL)=LINE(K1:K2)
*
      ENDIF 
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get element symbol given atomic number.
*
      SUBROUTINE ATOMNO
*
* Declarations.
*
      INTEGER I,II
      INCLUDE 'SERF.INC'
*
* work through all atoms.
*
      DO 1 I=1,NN
      IF (IAT(I).LT.1) THEN
      CALL GETIAT(ATNAM(I),II)
      IAT(I)=II
      ENDIF
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get element symbol given atomic number.
*
      SUBROUTINE GETIAT(ELENAM,INUM)
*
* Declarations.
*
      INTEGER INUM,IFAIL,AV
      CHARACTER ENAM*2,ELENAM*4
*
* lookup tables:
*
      CHARACTER ATLOOK(39)*4,ELEM(109)*2
*
* form lookup table for IUPAC-IUB amino acid atom names.
*
      DATA  ATLOOK /
     +'N   ','C   ','O   ','CA  ','CB  ',
     +'CG  ','CD  ','NE  ','CZ  ',
     +'NH1 ','NH2 ','OD1 ','OD2 ',
     +'CD1 ','CE1 ','CE2 ','CD2 ',
     +'SG  ','OE1 ','OE2 ','OH  ',
     +'OG1 ','CG2 ','CE  ','NZ  ',
     +'CG1 ','ND2 ','NE2 ','SD  ',
     +'OG  ','OT  ','OTX ', 
     +'ND1 ',
     +'NE1 ',
     +'CZ2 ',
     +'CH2 ',
     +'CZ3 ',
     +'CE3 ',
     +'OXT ' /
*
      DATA ELEM / 'H ','He',
     + 'Li','Be','B ','C ','N ','O ','F ','Ne',
     + 'Na','Mg','Al','Si','P ','S ','Cl','Ar',
     + 'K ','Ca','Sc','Ti','V ','Cr','Mn','Fe',
     + 'Co','Ni','Cu','Zn','Ga','Ge','As','Se',
     + 'Br','Kr','Rb','Sr','Y ','Zr','Nb','Mo',
     + 'Tc','Ru','Rh','Pd','Ag','Cd','In','Sn',
     + 'Sb','Te','I ','Xe','Cs','Ba','La','Ce',
     + 'Pr','Nd','Pm','Sm','Eu','Gd','Tb','Dy',
     + 'Ho','Er','Tm','Yb','Lu','Hf','Ta','W ',
     + 'Re','Os','Ir','Pt','Au','Hg','Tl','Pb',
     + 'Bi','Po','At','Rn','Fr','Ra','Ac','Th',
     + 'Pa','U ','Np','Pu','Am','Cm','Bk','Cf',
     + 'Es','Fm','Md','No','Lr','Rf','Ha','Sg',
     + 'Ns','Hs','Mt'/
*
* Reinitialise.
*
      INUM=0
*
* trap IUPAC-IUB protein atoms.
*
      DO 1 I=1,39
*
* Compare to Standard time.
*
      IF (ELENAM.EQ.ATLOOK(I)) THEN
*
* Get atom number.
*
      IF (ELENAM(1:1).EQ.'C') THEN
      INUM=6
      ELSEIF (ELENAM(1:1).EQ.'N') THEN
      INUM=7
      ELSEIF (ELENAM(1:1).EQ.'O') THEN
      INUM=8
      ELSEIF (ELENAM(1:1).EQ.'S') THEN
      INUM=16
      ENDIF
*
      RETURN
      ENDIF
*
1     CONTINUE
*
* Local copy.
*
      ENAM(1:2)=ELENAM(1:2)
*
* get atom name.
*
      AV1=ICHAR(ENAM(1:1))
      AV2=ICHAR(ENAM(2:2))
*
      ID1=0
      IF ((AV1.GE.97.AND.AV1.LE.122).OR.
     +(AV1.GE.65.AND.AV1.LE.90)) THEN
*
* caseify.
*
      IF (AV1.GE.97.AND.AV1.LE.122) THEN
      AV=AV1-32
      ENAM(1:1)=CHAR(AV)
      ENDIF
*
      IF ((AV2.GE.97.AND.AV2.LE.122).OR.
     +(AV2.GE.65.AND.AV2.LE.90)) THEN
*
* caseify.
*
      IF (AV2.GE.65.AND.AV2.LE.90) THEN
      AV=AV2+32
      ENAM(2:2)=CHAR(AV)
      ENDIF
*
      ELSE
      ENAM(2:2)=' '
      ENDIF
*
* lookup name of element.
*
      DO 2 I=1,109
      IF (ENAM.EQ.ELEM(I)) THEN
      INUM=I
      RETURN
      ENDIF
2     CONTINUE
*
      IF (ENAM(1:2).EQ.'D ') THEN
      INUM=1
      RETURN
      ENDIF
*
* try best match.
*
      DO 3 I=1,109
      IF (ENAM(1:1).EQ.ELEM(I)(1:1)) THEN
      INUM=I
      RETURN
      ENDIF
3     CONTINUE
*
* can not match name.
*
      INUM=0
*
      ELSE
*
* meaningless name.
*
      INUM=0
*
      ENDIF
*
* format statements:
*
1000  FORMAT(' unknown atom name: ',A2)
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
* Calculate accessible surfaces.
*
      SUBROUTINE ARCALC(CCLIS)
*
* declarations.
*
      INTEGER 
     +IDN(7000),IDN2(7000),IDN1(7000),KK,K1,K2,IE,IPA(3)
*
      REAL ADIF,XF(3),POLS1,NPOLS1,TOTS1
*
      CHARACTER CCLIS*20
*
      REAL ACS(7000),RACC(7000),ACSF(7000),XD(7000),YD(7000),
     +     ZD(7000),RDP(7000),RD(7000),XV(7000),YV(7000),ZV(7000),
     +     RV(7000)
*
      INCLUDE 'SERF.INC'
*
* Initialise.
*
      DO 566 I=1,7000
      ACS(I)=0.0
      RACC(I)=0.0
      ACSF(I)=0.0
      RDP(I)=0.0
      RV(I)=0.0
      RD(I)=0.0
      IDN(I)=0
      IDN2(I)=0
      IDN1(I)=0
566   CONTINUE
*
* Residue data.
*
      CALL RESBLK
*
* Get radii.
*
      CALL GETRAD(RDP)
*
* Echo method Choice.
*
      IF (METHDEC.EQ.1) WRITE(*,4001)
      IF (METHDEC.EQ.2) WRITE(*,4002)
      IF (METHDEC.EQ.3) WRITE(*,4003)
      IF (METHDEC.EQ.4) WRITE(*,4004)
      IF (METHDEC.EQ.5) WRITE(*,4005)
      IF (METHDEC.EQ.7) WRITE(*,4006)
*
* Echo probe radius.
*
      WRITE(*,4100) PROBE
*
* Initialise point arrays for symmetry version of Shrake and Rupley.
*
      IF (METHDEC.LT.0) THEN 
      CALL SRINIT(ABS(METHDEC))
      METHDEC=6
      ENDIF
*
* calculate accessibilities using spheres for residues.
*
      IF (RESDEC.EQ.1) THEN
      WRITE(*,1020)
      CALL RESASA1(CCLIS)
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=25)
      ELSE
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=25,DISPOSE='DELETE')
      ENDIF
*
* calculate polar and hydrophobic surface areas.
*
      IF (POLDEC.EQ.1) THEN
*
      WRITE(*,1030)
*
      IF (NN.GT.0) THEN
*
* Choose method and calculate in situ accessibility.
*
      CALL METHOD(METHDEC,
     +NN,PROBE,X,Y,Z,RDP,ACSF)
*
      POLS1=0.0
      NPOLS1=0.0
      TOTS1=0.0
*
      DO 75 I=1,NN
      TOTS1=TOTS1+ACSF(I)
      IF (IAT(I).EQ.7.OR.IAT(I).EQ.8) THEN
      POLS1=POLS1+ACSF(I)
*
* Eisenhaber and Argos increment.
*
      RDP(I)=RDP(I)+0.42
*
      ENDIF
75    CONTINUE
*
      CALL METHOD(METHDEC,
     +NN,PROBE,X,Y,Z,RDP,ACSF)
*
      DO 78 I=1,NN
      IF (IAT(I).EQ.7.OR.IAT(I).EQ.8) THEN
*
* remove Eisenhaber and Argos increment.
*
      RDP(I)=RDP(I)-0.42
*
      ELSE
*
* non-polar surface.
*
      NPOLS1=NPOLS1+ACSF(I)
*
      ENDIF
78    CONTINUE
*
      WRITE(29,2500) CMPNAME,POLS1,TOTS1-POLS1,NPOLS1
*
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=29)
*
      ENDIF
      ELSE
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=29,DISPOSE='DELETE')
      ENDIF
*
* Jurs Descriptors.
*
      IF (JURDEC.GT.0) THEN
      WRITE(*,1031)
*
      IF (NN.GT.0) THEN
*
* Choose method and calculate in situ accessibility.
*
      CALL METHOD(METHDEC,
     +NN,PROBE,X,Y,Z,RDP,ACSF)
*
      CALL GETJUR(ACSF)
*
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=28)
*
      ENDIF
*
      ELSE
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=28,DISPOSE='DELETE')
*
      ENDIF
*
* Calculate normalised accessiblities for whole file.
*
      IF (ALLDEC.EQ.1) THEN
*
* load temporary arrays.
*
      DO 11 I=1,NN
      RD(I)=RDP(I)
      XD(I)=X(I)
      YD(I)=Y(I)
      ZD(I)=Z(I)
11    CONTINUE
*
* announce calculation of normalised accessibilities.
*
      WRITE(*,1010) 
*
* Choose method and calculate in situ accessibility.
*
      IF (NN.GT.0) THEN
      CALL METHOD(METHDEC,
     +NN,PROBE,XD,YD,ZD,RD,ACSF)
      ENDIF
*
* Store accessibilities.
*
      DO 12 I=1,NN
      ACS(I)=ACSF(I)
12    CONTINUE
*
* now do residue by residue.
*
      DO 1 I=1,CHL
      DO 1 J=RN1(I),RN2(I)
*
      IF (POS(0,J,I).LT.0) GOTO 1
*
* get atoms of this residue
*
      KK=0
      DO 2 K=1,POS(-1,J,I)
      II=POS(K,J,I)
      IF (II.LT.1) GOTO 2
      KK=KK+1
      ACSF(KK)=0.0
      IDN(KK)=II
      IF (II.LT.1) GOTO 2
      RD(KK)=RDP(II)
      XD(KK)=X(II)
      YD(KK)=Y(II)
      ZD(KK)=Z(II)
2     CONTINUE
*
      K1=KK
*
      IF (NORMDEC.EQ.1) THEN
*
      IF (POS(0,J,I).EQ.1) THEN
*
* Now get atoms of flanking backbones.
*  i-1:
*
      IF (POS(0,J-1,I).EQ.1) THEN
      DO 21 K=1,MIN(4,POS(-1,J-1,I)) 
      II=POS(K,J-1,I)
      IF (II.LT.1) GOTO 21
      KK=KK+1
      ACSF(KK)=0.0
      IDN(KK)=II
      RD(KK)=RDP(II)
      XD(KK)=X(II)
      YD(KK)=Y(II)
      ZD(KK)=Z(II)
21    CONTINUE
      ENDIF
*
*  i+1:
*
      IF (POS(0,J+1,I).EQ.1) THEN
      DO 221 K=1,MIN(4,POS(-1,J-1,I))
      II=POS(K,J+1,I)
      IF (II.LT.1) GOTO 221
      KK=KK+1
      ACSF(KK)=0.0
      IDN(KK)=II
      RD(KK)=RDP(II)
      XD(KK)=X(II)
      YD(KK)=Y(II)
      ZD(KK)=Z(II)
221   CONTINUE
      ENDIF
*
      ENDIF
      ENDIF
*
* Choose method.
*
      IF (KK.GT.0) THEN
      CALL METHOD(METHDEC,
     +KK,PROBE,XD,YD,ZD,RD,ACSF)
      ENDIF
*
* Store isolated accessibilities
*
      DO 3 K=1,K1
      RACC(IDN(K))=ACSF(K)
3     CONTINUE
*
1     CONTINUE
*
* display results.
*
      CALL DISPLAY(CCLIS,ACS,RACC)
*
* Close output files.
*
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=10)
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=11)
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=12)
*
      ELSE
*
* delete unused files.
*
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=10,DISPOSE='DELETE')
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=11,DISPOSE='DELETE')
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=12,DISPOSE='DELETE')
*
      ENDIF
*
* Calculate accessibilities for comparison groups.
*
      IF (NCOMP.GT.0) THEN
*
* work through set of comparisons.
*
      DO 20 I=1,NCOMP
*
      CMPDEC1=COMPG1(I)
      CMPDEC2=COMPG2(I)
*
      IF (CMPDEC1.GT.GROUPN.OR.
     +    CMPDEC1.LT.1) THEN 
      WRITE(*,1011)
      GOTO 20
      ENDIF
*
      IF (CMPDEC2.GT.GROUPN.OR.
     +    CMPDEC2.LT.1) THEN
      WRITE(*,1011)
      GOTO 20
      ENDIF
*
* First group.
*
      KK=0
      SUM4=0.0
      DO 22 II=1,NGROUP(CMPDEC1)
      L=INDEX(CCLIS,GROUPL(II,CMPDEC1))
      DO 22 JJ=GROUPA(II,CMPDEC1),GROUPB(II,CMPDEC1)
*
      IF (POS(0,JJ,L).LT.0) GOTO 22
*
      DO 23 K=1,POS(-1,JJ,L)
      IE=POS(K,JJ,L)
      IF (IE.LT.1) GOTO 23
      KK=KK+1
      ACSF(KK)=0.0
      IDN1(KK)=IE
      RD(KK)=RDP(IE)
      XD(KK)=X(IE)
      YD(KK)=Y(IE)
      ZD(KK)=Z(IE)
23    CONTINUE
*
22    CONTINUE
*
      K1=KK
*
* Choose method.
*
      IF (KK.GT.0) THEN
      CALL METHOD(METHDEC,
     +KK,PROBE,XD,YD,ZD,RD,ACSF)
      ENDIF
*
      SUM1=0.0
      DO 24 K=1,KK
      RACC(IDN1(K))=ACSF(K)
      SUM4=SUM4+ACSF(K)
      SUM1=SUM1+ACSF(K)
24    CONTINUE
*
* Second group.
*
      KK=0
      DO 32 II=1,NGROUP(CMPDEC2)
      L=INDEX(CCLIS,GROUPL(II,CMPDEC2))
      DO 32 JJ=GROUPA(II,CMPDEC2),GROUPB(II,CMPDEC2)
      IF (POS(0,JJ,L).LT.0) GOTO 32
      DO 33 K=1,POS(-1,JJ,L)
      IE=POS(K,JJ,L)
      IF (IE.LT.1) GOTO 33
      KK=KK+1
      IDN2(KK)=IE
      ACSF(KK)=0.0
      RV(KK)=RDP(IE)
      XV(KK)=X(IE)
      YV(KK)=Y(IE)
      ZV(KK)=Z(IE)
33    CONTINUE
*
32    CONTINUE
*
      K2=KK
*
      IF (KK.GT.0) THEN
      CALL METHOD(METHDEC,
     +KK,PROBE,XV,YV,ZV,RV,ACSF)
      ENDIF
*
      SUM2=0.0
      DO 34 K=1,KK
      RACC(IDN2(K))=ACSF(K)
      SUM4=SUM4+ACSF(K)
      SUM2=SUM2+ACSF(K)
34    CONTINUE
*
      DO 667 JJ=1,KK
      IDN(JJ)=IDN2(JJ)
667   CONTINUE
*
      DO 41 JJ=1,K1
      KK=KK+1
      IDN(KK)=IDN1(JJ)
      XV(KK)=XD(JJ)
      YV(KK)=YD(JJ)
      ZV(KK)=ZD(JJ)
      RV(KK)=RD(JJ)
41    CONTINUE
*
      DO 55 JJ=1,KK
      ACSF(JJ)=0.0
55    CONTINUE
*
      IF (KK.GT.0) THEN
      CALL METHOD(METHDEC,
     +KK,PROBE,XV,YV,ZV,RV,ACSF)
      ENDIF
*
      SUM3=0.0
      SUM22=0.0
      DO 44 JJ=1,K2
      ACS(IDN(JJ))=ACSF(JJ)
      SUM3=SUM3+ACSF(JJ)
      SUM22=SUM22+ACSF(JJ)
44    CONTINUE
*
      SUM12=0.0
      K1=K2+1
      DO 45 JJ=K1,KK
      ACS(IDN(JJ))=ACSF(JJ)
      SUM3=SUM3+ACSF(JJ)
      SUM12=SUM12+ACSF(JJ)
45    CONTINUE
*
* Write changes in accessibilities on forming groups.
*
* First group
*
      WRITE(20,2001)
      WRITE(21,2001)
      WRITE(21,2002) 
     +CMPDEC1,CMPDEC2 
      WRITE(22,2002) 
     +CMPDEC1,CMPDEC2 
*
* work through group.
*
      DO 722 IJ=1,NGROUP(CMPDEC1)
      L=INDEX(CCLIS,GROUPL(IJ,CMPDEC1))
      DO 722 JJ=GROUPA(IJ,CMPDEC1),GROUPB(IJ,CMPDEC1)
*
      IF (POS(0,JJ,L).LT.0) GOTO 722
      IF (POS(1,JJ,L).LT.1) GOTO 722
*
      WRITE(21,3002) RNAM(POS(1,JJ,L)),RN(POS(1,JJ,L)),CCLIS(L:L)
*
      KK=0
      ASUM=0.0
      RSUM=0.0
      DO 723 K=1,POS(-1,JJ,L)
      II=POS(K,JJ,L)
      IF (II.LT.1) GOTO 723
      KK=KK+1
*
      IF (RACC(II).GT.0.0) THEN 
      RATIO=ACS(II)/RACC(II)
      ELSE
      RATIO=0.0
      ENDIF
*
* write accessibility changes.
*
      ADIF=ABS(ACS(II)-RACC(II))
      IF (ADIF.GT.0.0) THEN 
      WRITE(21,3001) ATNAM(II),ACS(II),RACC(II),RATIO,ADIF
      ELSE
      WRITE(21,3000) ATNAM(II),ACS(II),RACC(II),RATIO,ADIF
      ENDIF
*
* increment overall summations.
*
      ASUM=ASUM+ACS(II)
      RSUM=RSUM+RACC(II)
*
723   CONTINUE
*
      IF (RSUM.GT.0.0) THEN 
      RATIO=ASUM/RSUM
      ELSE
      RATIO=0.0
      ENDIF
*
* write accessibility changes.
*
      WRITE(21,3003) ASUM,RSUM,RATIO,ABS(RSUM-ASUM)
*
      ADIF=ABS(RSUM-ASUM)
*
      IF (ADIF.GT.0.0) THEN 
      WRITE(22,3011) RNAM(POS(1,JJ,L)),RN(POS(1,JJ,L)),CCLIS(L:L),
     +ASUM,RSUM,RATIO,ADIF
      ELSE
      WRITE(22,3010) RNAM(POS(1,JJ,L)),RN(POS(1,JJ,L)),CCLIS(L:L),
     +ASUM,RSUM,RATIO,ADIF
      ENDIF
*
722   CONTINUE
*
*  Second Group.
*
      DO 822 IJ=1,NGROUP(CMPDEC2)
      L=INDEX(CCLIS,GROUPL(IJ,CMPDEC2))
      DO 822 JJ=GROUPA(IJ,CMPDEC2),GROUPB(IJ,CMPDEC2)
*
      IF (POS(0,JJ,L).LT.0) GOTO 822
      IF (POS(1,JJ,L).LT.1) GOTO 822
*
      WRITE(21,3002) RNAM(POS(1,JJ,L)),RN(POS(1,JJ,L)),CCLIS(L:L)
*
      KK=0
      ASUM=0.0
      RSUM=0.0
      DO 823 K=1,POS(-1,JJ,L)
      II=POS(K,JJ,L)
      IF (II.LT.1) GOTO 823
      KK=KK+1
*
      IF (RACC(II).GT.0.0) THEN 
      RATIO=ACS(II)/RACC(II)
      ELSE
      RATIO=0.0
      ENDIF
*
* write accessibility changes.
*
      ADIF=ABS(ACS(II)-RACC(II))
      IF (ADIF.GT.0.0) THEN 
      WRITE(21,3001) ATNAM(II),ACS(II),RACC(II),RATIO,ADIF
      ELSE
      WRITE(21,3000) ATNAM(II),ACS(II),RACC(II),RATIO,ADIF
      ENDIF
*
      ASUM=ASUM+ACS(II)
      RSUM=RSUM+RACC(II)
*
823   CONTINUE
*
* error trap division by zero.
*
      IF (RSUM.GT.0.0) THEN 
      RATIO=ASUM/RSUM
      ELSE
      RATIO=0.0
      ENDIF
*
* write accessibility changes.
*
      WRITE(21,3003) ASUM,RSUM,RATIO,ABS(RSUM-ASUM)
*
      ADIF=ABS(RSUM-ASUM)
*
      IF (ADIF.GT.0.0) THEN 
      WRITE(22,3011) RNAM(POS(1,JJ,L)),RN(POS(1,JJ,L)),CCLIS(L:L),
     +ASUM,RSUM,RATIO,ADIF
      ELSE
      WRITE(22,3010) RNAM(POS(1,JJ,L)),RN(POS(1,JJ,L)),CCLIS(L:L),
     +ASUM,RSUM,RATIO,ADIF
      ENDIF
*
822   CONTINUE
*
      WRITE(20,2000) 
     +CMPDEC1,CMPDEC2,SUM1,SUM2,SUM4,SUM12,SUM22,SUM3,
     +ABS(SUM1-SUM12),ABS(SUM2-SUM22),ABS(SUM4-SUM3)
      WRITE(21,2000) 
     +CMPDEC1,CMPDEC2,SUM1,SUM2,SUM4,SUM12,SUM22,SUM3,
     +ABS(SUM1-SUM12),ABS(SUM2-SUM22),ABS(SUM4-SUM3)
      WRITE(22,2000) 
     +CMPDEC1,CMPDEC2,SUM1,SUM2,SUM4,SUM12,SUM22,SUM3,
     +ABS(SUM1-SUM12),ABS(SUM2-SUM22),ABS(SUM4-SUM3)
*
20    CONTINUE
*
* close output files.
*
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=20)
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=21)
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=22)
*
* Delete unused files.
*
      ELSE
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=20,DISPOSE='DELETE')
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=21,DISPOSE='DELETE')
      IF (SHUTDEC.EQ.0) CLOSE(UNIT=22,DISPOSE='DELETE')
      ENDIF
*
* Format Statements
*
1000  FORMAT(' ')
1010  FORMAT(/
     +' Calculating the normalised accessibilites of all residues.'/)
1011  FORMAT(/' No such group found. No comparison done.'/)
1020  FORMAT(/' Calculating residue-sphere accessibilites.'/)
1030  FORMAT(/' Calculating polar and non-polar surface areas.'/)
1031  FORMAT(/' Calculating partial charge surface area descriptors of'/,
     +        ' Stanton & Jurs 1990.'/)
2000  FORMAT(/' Groups: ',I3,' and ',I3//,
     +' separated areas: ',F9.2,2X,F9.2/,
     +'      total area: ',F11.2/,
     +'  combined areas: ',F9.2,2X,F9.2/,
     +'      total area: ',F11.2/,
     +'     Differences:'/,
     +'               1: ',F11.2/,
     +'               2: ',F11.2/,
     +'           Total: ',F11.2/)
2500  FORMAT(A40,3F12.4)
2001  FORMAT(80('-'))
2002  FORMAT(/' Groups: ',I3,' and ',I3/)
3000  FORMAT(1X,A4,2(1X,F8.3),3X,F5.3,1X,F10.2) 
3001  FORMAT(1X,A4,2(1X,F8.3),3X,F5.3,1X,F10.2,3X,'*') 
3002  FORMAT(/' residue: ',A4,I5,A1/)
3003  FORMAT('     Total: ',2(1X,F9.3),3X,F5.3,1X,F10.2)
3004  FORMAT(/'     Total for this chain: ',2(1X,F9.3),2(3X,F5.3))
3010  FORMAT(2X,A4,I5,A1,2X,2(1X,F9.3),2X,F5.3,1X,F8.2)
3011  FORMAT(2X,A4,I5,A1,2X,2(1X,F9.3),2X,F5.3,1X,F8.2,3X,'*')
4001  FORMAT(/' Using the method of Richmond (1984).'/)
4002  FORMAT(/' Using the method of Lee and Richards (1972).'/)
4003  FORMAT(/' Using the method of Wodak and Janin (1980).'/)
4004  FORMAT(/' Using the method of Shrake and Rupley (1973)'/
     +' with 162 points.'/)
4005  FORMAT(/' Using the method of Shrake and Rupley (1973)'/
     +' with 642 points.'/)
4006  FORMAT(/' Using the method of Connolly (1983)'/)
4100  FORMAT(' Probe Radius: ',F10.4/)
*
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Choose method of calculating accessible surface.
*
      SUBROUTINE METHOD(MD,NH,PROBE,XW,YW,ZW,RW,AW)
*
* Declarations.
*
      INTEGER MD,NH
*
      REAL PROBE,XW(NH),YW(NH),ZW(NH),RW(NH),AW(NH)
*
* Richmond 1984.
*
      IF (MD.EQ.1) 
     +CALL ANAREA(NH,
     +PROBE,EE,
     +XW,YW,ZW,RW,AW)
*
* Lee and Richards 1973.
*
      IF (MD.EQ.2) 
     +CALL ACCLEE(NH,
     +PROBE,
     +XW,YW,ZW,RW,AW)
*
* Wodak and Janin 1980.
*
      IF (MD.EQ.3) 
     +CALL WJACAL(NH,
     +PROBE,
     +XW,YW,ZW,RW,AW)
*
* Shrake and Rupley with various numbers and arrangements of points.
*
* 162 points.
*
      IF (MD.EQ.4) 
     +CALL SHR162(NH,PROBE,
     +XW,YW,ZW,RW,AW)
*
* 642 points.
*
      IF (MD.EQ.5) 
     +CALL SHR642(NH,PROBE,
     +XW,YW,ZW,RW,AW)
*
* icosahedral points.
*
      IF (MD.EQ.6) 
     +CALL SRPOLY(NH,PROBE,
     +XW,YW,ZW,RW,AW)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Initialise point arrays for symmetry based Shrake and Rupley.
*
      SUBROUTINE SRINIT(T)
*
* declarations.
*
      INTEGER T,NPTS
      REAL PTS
*
* common blcoks
*
      COMMON /POLYPP/ NPTS,PTS(3,1000)
*
      CALL SYMDOT(T,NPTS,PTS)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* fill table of atomic radii.
*
      SUBROUTINE GETRAD(R)
* 
* declarations.
*
      INTEGER I,J
*
      REAL R(7000)
*
      INCLUDE 'SERF.INC'
*
* fill radii arrays.
*
      DO 1 I=1,NN
      CALL ATMRAD(IAT(I),RV)
      R(I)=RV
1     CONTINUE
*
* special protein atom radii.
*
      IF (PROTRAD.GT.0) THEN
*
* work through all atoms.
*
      DO 2 I=1,NN
*
* get radius from atom name.
*
      IF (IAT(I).EQ.6) THEN
      R(I)=1.82
      ENDIF
*
2     CONTINUE
      ENDIF
*
* user supplied radii.
*
      IF (RADNO.GT.0) THEN
*
* Select on atom types.
*
      WRITE(*,1003)
      DO 55 I=1,RADNO
      WRITE(*,1004) ACC(I)(1:4),REDP(I)
55    CONTINUE
*
* work through list of atoms.
*
      DO 47 I=1,NN
*
* work through list of radii.
*
      DO 5 II=1,RADNO
      IF (ATNAM(I)(1:CLN(II)).EQ.ACC(II)(1:CLN(II))) THEN
      R(I)=REDP(II)
      GOTO 47
      ENDIF
5     CONTINUE
*
47    CONTINUE
*
      ENDIF
*
* Echo radii.
*
      WRITE(*,1006)
      DO 20 I=1,NN
      WRITE(*,1005) ATNAM(I),R(I)
20    CONTINUE
*
* Format Statements.
*
1000  FORMAT(' Unknown atom encountered: ',A4/,
     +       '  radius set to 1.5.')
1003  FORMAT(/' User atoms types:')
1004  FORMAT('  atom: ',A4,' radius: ',F9.3)
1005  FORMAT(2X,A4,': ',F9.5,'.')
1006  FORMAT(/' radii to be used:'/) 

*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get Van der Vaals Radius given atomic number.
*
      SUBROUTINE ATMRAD(INUM,RVAL)
*
* Declarations.
*
      INTEGER INUM
      REAL RVAL,VDW(109)
*
* lookup tables:
*
      DATA VDW /
     + 1.10,1.38,1.78,1.10,1.72,1.70,1.65,1.42,1.45,1.55,
     + 2.25,1.75,1.45,2.12,1.92,1.85,1.78,1.90,2.72,2.00,
     + 1.65,1.46,1.34,1.30,1.38,1.24,1.28,1.62,1.41,1.40, 
     + 1.90,1.40,1.83,1.91,1.84,2.05,2.52,2.17,1.70,1.62,
     + 1.50,1.42,1.34,1.33,1.35,1.65,1.70,1.61,1.97,2.15,
     + 1.59,2.10,2.00,2.16,2.76,2.25,1.86,1.84,1.83,1.80,
     + 1.82,1.78,2.10,1.81,1.76,1.80,1.75,1.80,1.76,1.91,
     + 1.80,1.60,1.50,1.40,1.40,1.35,1.36,1.74,1.70,1.54,
     + 1.94,2.05,1.80,1.65,1.55,2.42,2.92,2.45,1.85,1.80,
     + 1.60,1.84,1.56,1.60,1.75,1.75,1.75,1.87,1.87,1.86,
     + 1.86,1.85,1.85,1.61,1.50,1.45,1.42,1.40,1.38 /
*
* get radius.
*
      IF (INUM.GT.0.AND.INUM.LT.110) THEN
      RVAL=VDW(INUM)
      ENDIF
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* display results of normalised accessible surface calculation.
*
      SUBROUTINE DISPLAY(CCLIS,ACS,RACC)
*
* declarations
*
      INTEGER I,J,K
*
      REAL RATIO,ASUM,RSUM,TASUM,TRSUM
*
      CHARACTER CCLIS*20
*
      REAL ACS(7000),RACC(7000)
*
      INCLUDE 'SERF.INC'
*
* work through chains for greater clarity.
*
      DO 11 I=1,CHL
*
      TASUM=0.0
      TRSUM=0.0
*
      WRITE(10,1001) I,CCLIS(I:I)
*
* work through the residues of this chain.
*
      DO 1 J=RN1(I),RN2(I)
*
      IF (POS(0,J,I).LT.0) GOTO 1
*
      WRITE(10,1002) RNAM(POS(1,J,I)),RN(POS(1,J,I))
*
      KK=0
      ASUM=0.0
      RSUM=0.0
*
* loop over atoms of this residue.
*
      DO 2 K=1,POS(-1,J,I)
*
      KK=KK+1
      II=POS(K,J,I)
*
      IF (RACC(II).GT.0.0) THEN 
      RATIO=ACS(II)/RACC(II)
      ELSE
      RATIO=0.0
      ENDIF
*
      WRITE(10,1000) ATNAM(II),ACS(II),RACC(II),RATIO 
      WRITE(11,1010) 
     +ATNAM(II),ACS(II),RACC(II),RATIO,BFAC(II),QOCC(II)
*
      ASUM=ASUM+ACS(II)
      RSUM=RSUM+RACC(II)
*
2     CONTINUE
*
* error trap for division by zero.
*
      IF (RSUM.GT.0.0) THEN 
      RATIO=ASUM/RSUM
      ELSE
      RATIO=0.0
      ENDIF
*
      TASUM=TASUM+ASUM
      TRSUM=TRSUM+RSUM
*
      WRITE(10,1003) ASUM,RSUM,RATIO
      WRITE(12,1005) 
     +RNAM(II),RN(II),RLAB(II),ASUM,RSUM,RATIO
*
1     CONTINUE
*
* write summary for chain.
*
      IF (TRSUM.GT.0.0) THEN
      RATIO=TASUM/TRSUM
      ELSE
      RATIO=0.0
      ENDIF
*
      WRITE(10,1004) TASUM,TRSUM,RATIO
*
11    CONTINUE
*
* Format Statements
*
1000  FORMAT(1X,A4,2(1X,F8.3),3X,F5.3) 
1001  FORMAT(/'  Chain',I3,' label: ',A1,'.')
1002  FORMAT(/' residue: ',A4,I5/)
1003  FORMAT('     Total: ',2(1X,F9.3),3X,F5.3)
1004  FORMAT(/'     Total for this chain: ',2(1X,F9.3),3X,F5.3)
1005  FORMAT(2X,A3,I5,A1,1X,2(1X,F9.3),3X,F5.3)
1010  FORMAT(1X,A4,2(1X,F8.3),3X,F5.3,3X,F9.3,F5.1) 
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE RESBLK
*
* declarations.
*
      INCLUDE 'SERF.INC'
*
      DATA AVAL /
     + 118.0,
     + 256.0,
     + 166.0,
     + 159.0,
     + 146.0,
     + 193.0,
     + 186.0,
     +  88.0,
     + 203.0,
     + 181.0,
     + 193.0,
     + 226.0,
     + 203.0,
     + 223.0,
     + 147.0,
     + 130.0,
     + 153.0,
     + 266.0,
     + 237.0,
     + 165.0 /
*
      DATA RADVAL /
     + 3.06,
     + 4.51,
     + 3.63,
     + 3.56,
     + 3.41,
     + 3.92,
     + 3.85,
     + 2.65,
     + 4.02,
     + 3.80,
     + 3.92,
     + 4.24,
     + 4.02,
     + 4.21,
     + 3.42,
     + 3.22,
     + 3.49,
     + 4.60,
     + 4.34,
     + 3.62 /
*
      DATA RSVAL /
     + 1.55,
     + 3.66,
     + 2.49,
     + 2.38,
     + 2.15,
     + 2.89,
     + 2.79,
     + 0.00,
     + 3.03,
     + 2.72,
     + 2.89,
     + 3.31,
     + 3.03,
     + 3.28,
     + 2.17,
     + 1.83,
     + 2.27,
     + 3.76,
     + 3.44,
     + 2.48 /
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Partial Charge Descriptors of Stanton and Jurs 1990.
*
      SUBROUTINE GETJUR(ACSF)
*
* declarations.
*
      REAL R1,R2
      REAL ACSF(7000)
      REAL PPSA1,PNSA1,PPSA2,PNSA2,PPSA3,PNSA3,
     + FPSA1,FNSA1,FPSA2,FNSA2,FPSA3,FNSA3,DPSA1,DPSA2,DPSA3,POS1,NEG,MS1
*
      CHARACTER A1*1,CCLIS*20
*
      INCLUDE 'SERF.INC'
*
* Initialise.
*
      PPSA1=0.0
      PNSA1=0.0
      PPSA3=0.0
      PNSA3=0.0
      POS1=0.0
      NEG1=0.0
      MS1=0.0
*
* atomic values.
*
      IF (JURDEC.EQ.2) THEN
      WRITE(28,1010) CMPNAME
      DO 1 I=1,NN
      R1=CHARGE(I)/ACSF(I)
      WRITE(28,1000) ATNAM(I),R1,CHARGE(I),ACSF(I)
1     CONTINUE
      WRITE(28,*)
      ENDIF
*
* partitioned surfaces.
*
      DO 2 I=1,NN
      MS1=MS1+ACSF(I)      
      IF (CHARGE(I).LT.0.0) THEN
      NEG1=NEG1+CHARGE(I)
      PNSA1=PNSA1+ACSF(I)
      PNSA3=PNSA3+ACSF(I)*CHARGE(I)
      ELSE
      POS1=POS1+CHARGE(I)
      PPSA1=PPSA1+ACSF(I)
      PPSA3=PPSA3+ACSF(I)*CHARGE(I)
      ENDIF
2     CONTINUE
*
      PPSA2=PPSA1*POS1
      PNSA2=PNSA1*NEG1
*
      DPSA1=PPSA1-PNSA1
      DPSA2=PPSA2-PNSA2
      DPSA3=PPSA3-PNSA3
*
      FPSA1=PPSA1/MS1
      FPSA2=PPSA2/MS1
      FPSA3=PPSA3/MS1
*
      FNSA1=PNSA1/MS1
      FNSA2=PNSA2/MS1
      FNSA3=PNSA3/MS1
*
      IF (JURDEC.EQ.2) THEN
      WRITE(28,1001) PPSA1,PNSA1,PPSA2,PNSA2,PPSA3,PNSA3,
     +               FPSA1,FNSA1,FPSA2,FNSA2,FPSA3,FNSA3,
     +               DPSA1,DPSA2,DPSA3
      ELSE
      WRITE(28,1002) CMPNAME,
     +               PPSA1,PNSA1,PPSA2,PNSA2,PPSA3,PNSA3,
     +               FPSA1,FNSA1,FPSA2,FNSA2,FPSA3,FNSA3,
     +               DPSA1,DPSA2,DPSA3
      ENDIF
*
* format statements
*
1000  FORMAT(2X,A4,3F10.4)
1001  FORMAT(/'PPSA1:',F12.4,/'PNSA1:',F12.4,/'PPSA2:',F12.4,
     +       /'PNSA2:',F12.4,/'PPSA3:',F12.4,/'PNSA3:',F12.4,
     +       /'FPSA1:',F12.4,/'FNSA1:',F12.4,/'FPSA2:',F12.4,
     +       /'FNSA2:',F12.4,/'FPSA3:',F12.4,/'FNSA3:',F12.4,
     +       /'DPSA1:',F12.4,/'DPSA2:',F12.4,/'DPSA3:',F12.4)
1002  FORMAT(A40,15F12.5)
1010  FORMAT(/' Molecule: ',A40/)
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* Calculate residue accessibilities using spheres for residues.
*
      SUBROUTINE RESASA1(CCLIS)
*
* declarations.
*
      INTEGER IDN(7000)
      REAL R1,R2
      REAL XT(7000),YT(7000),ZT(7000),RAD1(7000),ACSF(7000)
      REAL FOURPI
*
      CHARACTER A1*1,CCLIS*20
*
      INCLUDE 'SERF.INC'
*
* Initialise.
*
      FOURPI=4.0*ACOS(-1.0)
*
* work through all chains.
*
      II=0
      DO 1 I=1,CHL
*
* work through residues.
*
      DO 2 J=RN1(I),RN2(I)
*
* Get pointer to Calpha.
*
      IK=POS(4,J,I)
*
* Error trap.
* 
      IF (IK.GT.0) THEN
      II=II+1
      IDN(IK)=II      
      XT(II)=X(IK)
      YT(II)=Y(IK)
      ZT(II)=Z(IK)
      CALL GETR1(RNAM(IK),A1,AA,R1,R2)
      RAD1(II)=R1
      ENDIF
*
2     CONTINUE
*
1     CONTINUE
*
* calculate accessible surface areas. 
*
      IF (II.GT.0) THEN
      CALL METHOD(METHDEC,
     +II,PROBE,XT,YT,ZT,RAD1,ACSF)
      ELSE
      RETURN
      ENDIF
*
* Display.
*
      DO 11 I=1,CHL
*
* initialise chain summaries.
*
      TASUM=0.0
      TRSUM=0.0
*
* write chain out.
*
      WRITE(25,1001) I,CCLIS(I:I)
*
* work through the residues of this chain.
*
      DO 5 J=RN1(I),RN2(I)
*
* get pointer.
*
      IL=POS(4,J,I)
*
* display accessible areas and ratios.
*
      IF (IL.GT.0) THEN
*
* get pointer.
*
      IP=IDN(IL)
*
* get radius of residue.
*
      CALL GETR1(RNAM(IL),A1,AA,R1,R2)
*
* calculate expanded area.
*
      AA=FOURPI*(R1+PROBE)**2
*
* error trap for division by zero.
*
      IF (AA.GT.0.0) THEN 
      RATIO=ACSF(IP)/AA
      ELSE
      RATIO=0.0
      ENDIF
*
* increment chain sums.
*
      TASUM=TASUM+ACSF(IP)
      TRSUM=TRSUM+AA
*
* write it out.
*
      WRITE(25,1005) 
     +RNAM(IL),RN(IL),RLAB(IL),ACSF(IP),AA,RATIO
*
      ENDIF
*
5     CONTINUE
*
* write summary for chain.
*
      IF (TRSUM.GT.0.0) THEN
      RATIO=TASUM/TRSUM
      ELSE
      RATIO=0.0
      ENDIF
*
      WRITE(25,1004) TASUM,TRSUM,RATIO
*
11    CONTINUE
*
* Format Statements
*
1000  FORMAT(1X,A4,2(1X,F8.3),3X,F5.3) 
1001  FORMAT(/'  Chain',I3,' label: ',A1,'.')
1002  FORMAT(/' residue: ',A4,I5/)
1003  FORMAT('     Total: ',2(1X,F9.3),3X,F5.3)
1004  FORMAT(/'     Total for this chain: ',2(1X,F9.3),3X,F5.3)
1005  FORMAT(2X,A3,I5,A1,1X,2(1X,F9.3),3X,F5.3)
1010  FORMAT(1X,A4,2(1X,F8.3),3X,F5.3,3X,F9.3,F5.1) 
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* get 1 letter code given three letter code.
*
      SUBROUTINE GETR1(RLONG,R1,AREA,RAD1,RAD2)
*
* declarations.
*
      INTEGER I
      REAL RAD1,RAD2
      CHARACTER RLONG*3,R1*1
      CHARACTER*4 RLIST(20)
*
      INCLUDE 'SERF.INC'
*
* initialise.
*
      DATA RLIST /
     +'ALAA',
     +'ARGR',
     +'ASNN',
     +'ASPD',
     +'CYSC',
     +'GLNQ',
     +'GLUE',
     +'GLYG',
     +'HISH',
     +'ILEI',
     +'LEUL',
     +'LYSK',
     +'METM',
     +'PHEF',
     +'PROP',
     +'SERS',
     +'THRT',
     +'TRPW',
     +'TYRY',
     +'VALV' /
*
* run through list.
*
      DO 1 I=1,20
      IF (RLONG(1:3).EQ.RLIST(I)(1:3)) GOTO 2
1     CONTINUE
      R1(1:1)='X'
      RAD1=4.0
      RAD2=4.0
      AREA=100.0
      RETURN
*
2     CONTINUE
*
* return values.
*
      R1(1:1)=RLIST(I)(4:4)
      RAD1=RADVAL(I)
      RAD2=RSVAL(I)
      AREA=AVAL(I)
*
      RETURN
      END
*
*----------------------------------------------------------------------------
*
* ASA Calculation Algorithms.
*
*----------------------------------------------------------------------------
*
* access: calculate accessible contact surface area for a group of atoms.
* the accessible area for a given atom is calculated by the formula,
* (arcsum) x (atom radius+probe radius) x (deltaz).
* numerical integration is carried out over z. in each z-section, the arcsum.
* for a given atom is the arclength of the circle (intersection of the atom.
* sphere with the z-section) that is not interior to any other atom circles.
* in the same z-section.
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE ACCLEE(NATOM,
     +RPROBR,
     +X,Y,Z,RAD,ACC)
*
* declarations.
*
      INTEGER TAG,CUBE,NATOM
*
      REAL X(7000),Y(7000),Z(7000),ACC(7000),RAD(7000)
*
      DIMENSION TAG(10000),INOV(10000),ARCI(10000),
     +ARCF(10000),ITAB(10000),NATM(50,10000),
     +RADSQ(10000),
     +DX(10000),DY(10000),D(10000),DSQ(10000),CUBE(10000)
*
* initialise.
*
      DATA XMIN,YMIN,ZMIN,XMAX,YMAX,ZMAX/3*9999.,3*-9999./
*
      ICT=600
      NCUBE=3200
      PI=ACOS(-1.0)
      PIX2=2.0*PI
*
* atom records input, 60 bytes/record.
* if key=1, then accessible contact surface area not found for this atom.
*
15    FORMAT(1X,I1,6X,2A4,I5,3X,3F8.4,4X,F8.4)
41    FORMAT(' INCREASE L')
80    FORMAT(' ERROR=',F4.2/' PROBE RADIUS=',F6.2/
     +' NO. ATOMS FROM UNIT 10=',I4/' IACC=',I1////)
*
* the radius of an atom sphere = atom radius + probe radius.
*
      IB=0
      RMAX=0.0
      KARC=ICT
*
      DO 13 I=1,NATOM
      RAD(I)=RAD(I)+RPROBR
      RADSQ(I)=RAD(I)**2
      IF (RAD(I).GT.RMAX) RMAX=RAD(I)
      IF (XMIN.GT.X(I)) XMIN=X(I)
      IF (YMIN.GT.Y(I)) YMIN=Y(I)
      IF (ZMIN.GT.Z(I)) ZMIN=Z(I)
      IF (XMAX.LT.X(I)) XMAX=X(I)
      IF (YMAX.LT.Y(I)) YMAX=Y(I)
      IF (ZMAX.LT.Z(I)) ZMAX=Z(I)
13    CONTINUE
*
      DMAX=RMAX*2.
*
* cubicals containing the atoms are setup. the dimension of an edge equals.
* the radius of the largest atom sphere the cubes have a single index.
*
      IDIM=INT((XMAX-XMIN)/DMAX+1.0)
      IF (IDIM.LT.3) IDIM=3
      JIDIM=INT((YMAX-YMIN)/DMAX+1.0)
      IF (JIDIM.LT.3) JIDIM=3
      JIDIM=IDIM*JIDIM
      KJIDIM=INT((ZMAX-ZMIN)/DMAX+1.0)
      IF (KJIDIM.LT.3) KJIDIM=3
      KJIDIM=JIDIM*KJIDIM
*
98    FORMAT(' INCREASE M')
*
* prepare upto ncube cubes each containing upto nac atoms. the cube index.
* is kji. the atom index for each cube is in itab.
*
      DO 7 L=1,NCUBE
      ITAB(L)=0
7     CONTINUE
*
      DO 4 L=1,NATOM
      I=INT((X(L)-XMIN)/DMAX+1.0)
      J=INT((Y(L)-YMIN)/DMAX)
      K=INT((Z(L)-ZMIN)/DMAX)
      KJI=K*JIDIM+J*IDIM+I
      N=ITAB(KJI)+1
97    FORMAT(' INCREASE N')
      ITAB(KJI)=N
      NATM(N,KJI)=L
      CUBE(L)=KJI
4     CONTINUE
*
* process each atom.
*
      DO 5 IR=1,NATOM
      KJI=CUBE(IR)
*      IF (KEY(IR).EQ.1) GOTO 5
      IO=0
      AREA=0.
      XR=X(IR)
      YR=Y(IR)
      ZR=Z(IR)
      RR=RAD(IR)
      RRX2=RR*2.
      RRSQ=RADSQ(IR)
*
* find the 'MKJI' cubes neighboring the kji cube.
*
      DO 6 KK=1,3
      K=KK-2
      DO 6 JJ=1,3
      J=JJ-2
      DO 6 I=1,3
      MKJI=KJI+K*JIDIM+J*IDIM+I-2
      IF (MKJI.LT.1) GOTO 6
      IF (MKJI.GT.KJIDIM) GOTO 14
      NM=ITAB(MKJI)
      IF (NM.LT.1) GOTO 6
*
* record the atoms in inov that neighbor atom ir.
*
      DO 12 M=1,NM
      IN=NATM(M,MKJI)
      IF (IN.EQ.IR) GOTO 12
      IO=IO+1
      IF (IO.GT.ICT) GOTO 2
      DX(IO)=XR-X(IN)
      DY(IO)=YR-Y(IN)
      DSQ(IO)=DX(IO)**2+DY(IO)**2
      D(IO)=SQRT(DSQ(IO))
      INOV(IO)=IN
12    CONTINUE
6     CONTINUE
14    IF (IO.NE.0) GOTO 17
      AREA=PIX2*RRX2
      GOTO 18
*
* z resolution determined.
*
17    CONTINUE
*
      NZP=1.0/0.05+0.5
      ZRES=RRX2/NZP
      ZGRID=Z(IR)-RR-ZRES/2.
*
* section atom spheres perpendicular to the z axis.
*
      DO 9 I=1,NZP
      ZGRID=ZGRID+ZRES
*
* find the radius of the circle of intersection of the ir sphere.
* on the current z-plane.
*
      RSEC2R=RRSQ-(ZGRID-ZR)**2
      RSECR=SQRT(RSEC2R)
      DO 34 K=1,KARC
      ARCI(K)=0.0
34    CONTINUE
      KARC=0
      DO 10 J=1,IO
      IN=INOV(J)
*
* find radius of circle locus.
*
      RSEC2N=RADSQ(IN)-(ZGRID-Z(IN))**2
      IF (RSEC2N.LE.0.0) GOTO 10
      RSECN=SQRT(RSEC2N)
*
* find intersections of n.circles with ir circles in section.
*
      IF (D(J).GE.RSECR+RSECN) GOTO 10
*
* do the circles intersect, or is one circle completely inside the other?.
*
      B=RSECR-RSECN
      IF (D(J).GT.ABS(B)) GOTO 20
      IF (B.LE.0.0) GOTO 9
      GOTO 10
*
* if the circles intersect, find the points of intersection.
*
20    CONTINUE
      KARC=KARC+1
      IF (KARC.LT.ICT) GOTO 45
2     CONTINUE     
90    FORMAT(' INCREASE ICT FOR ATOM NO.',I4)
      GOTO 5
*
* initial and final arc endpoints are found for the ir circle intersected.
* by a neighboring circle contained in the same plane. the initial endpoint.
* of the enclosed arc is stored in arci, and the final arc in arcf.
* law of cosines.
*
45    CONTINUE
      ALPHA=ACOS((DSQ(J)+RSEC2R-RSEC2N)/(2.*D(J)*RSECR))
*
* alpha is the angle between a line containing a point of intersection and.
* the reference circle center and the line containing both circle centers.
*
      BETA=ATAN2(DY(J),DX(J))+PI
*
* beta is the angle between the line containing both circle centers and the.
* x-axis.
*
      TI=BETA-ALPHA
      TF=BETA+ALPHA
      IF (TI.LT.0.0) TI=TI+PIX2
      IF (TF.GT.PIX2) TF=TF-PIX2
      ARCI(KARC)=TI
      IF (TF.GE.TI) GOTO 3
*
* if the arc crosses zero, then it is broken into two segments.
* the first ends at pix2 and the second begins at zero.
*
      ARCF(KARC)=PIX2
      KARC=KARC+1
3     CONTINUE
      ARCF(KARC)=TF
10    CONTINUE
*
* find the accessible contact surface area for the sphere ir on.
* this section.
*
      IF (KARC.NE.0) GOTO 19
      ARCSUM=PIX2
      GOTO 25
*
* the arc endpoints are sorted on the value of the initial arc endpoint.
*
19    CONTINUE
      CALL SORTAG(ARCI(1),KARC,TAG)
*
* calculate the accessible area.
*
      ARCSUM=ARCI(1)
      T=ARCF(TAG(1))
      IF (KARC.EQ.1) GOTO 11
      DO 27 K=2,KARC
      IF (T.LT.ARCI(K)) ARCSUM=ARCSUM+ARCI(K)-T
      TT=ARCF(TAG(K))
      IF (TT.GT.T) T=TT
27    CONTINUE
11    CONTINUE
*
      ARCSUM=ARCSUM+PIX2-T
*
* the area/radius is equal to the accessible arc length x.
* the section thickness.
*
25    CONTINUE
      PAREA=ARCSUM*ZRES
*
* add the accessible area for this atom in this section to the area for this
* atom for all the section encountered thus far.
*
      AREA=AREA+PAREA
9     CONTINUE
*
* scale area to vdw shell.
*
18    CONTINUE
*
      B=(AREA*(RR)**2)/RR
*
* output atom identifiers and accessible surface area.
* 48 bytes/record.
*
      IB=IB+1
      ACC(IR)=B
*
29    FORMAT(2(4X,I5),2(4X,A4),4X,F10.4)
5     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* local sorting routine.
*
      SUBROUTINE DSORTAG(A,N,TAG)
*
* Declarations.
*
      INTEGER TAG,TG
      DIMENSION A(N),IU(16),IL(16),TAG(N)
*
      DO 1  I=1,N
      TAG(I)=I
1     CONTINUE
      M=1
      I=1
      J=N
5     IF (I.GE.J) GOTO 70
10    K=I
      IJ=(J+I)/2
      T=A(IJ)
      IF (A(I).LE.T) GOTO 20
      A(IJ)= A(I)
      A(I)=T
      T=A(IJ)
      TG=TAG(IJ)
      TAG(IJ)=TAG(I)
      TAG(I)=TG
20    L=J
      IF (A(J).GE.T) GOTO 40
      A(IJ)=A(J)
      A(J)=T
      T=A(IJ)
      TG=TAG(IJ)
      TAG(IJ)=TAG(J)
      TAG(J)=TG
      IF (A(I).LE.T) GOTO 40
      A(IJ)=A(I)
      A(I)=T
      T=A(IJ)
      TG=TAG(IJ)
      TAG(IJ)=TAG(I)
      TAG(I)=TG
      GOTO 40
30    A(L)=A(K)
      A(K)=TT
      TG=TAG(L)
      TAG(L)=TAG(K)
      TAG(K)=TG
40    L=L-1
      IF (A(L).GT.T) GOTO 40
      TT=A(L)
50    K=K+1
      IF (A(K).LT.T) GOTO 50
      IF (K.LE.L) GOTO 30
      IF (L-I.LE.J-K) GOTO 60
      IL(M)=I
      IU(M)=L
      I=K
      M=M+1
      GOTO 80
60    IL(M)=K
      IU(M)=J
      J=L
      M=M+1
      GOTO 80
70    M=M-1
      IF (M.EQ.0) RETURN
      I=IL(M)
      J=IU(M)
80    IF (J-I.GE.1) GOTO 10
      IF (I.EQ.1) GOTO 5
      I=I-1
90    I=I+1
      IF (I.EQ.J) GOTO 70
      T=A(I+1)
      IF (A(I).LE.T) GOTO 90
      TG=TAG(I+1)
      K=I
100   A(K+1)=A(K)
      TAG(K+1)=TAG(K)
      K=K-1
      IF (T.LT.A(K)) GOTO 100
      A(K+1)=T
      TAG(K+1)=TG
      GOTO 90
      END
*
*
*-------------------------------------------------------------------------------
*
* indices:
* marc = max. no. of partial arcs for ir sphere (ith sphere).
* mnat = max. no. of atoms.
* mov  = max. no. of in overlapping spheres (j & k spheres for the ith).
* mpt  = max. no. of overlap end pts. on a circle of intersection.
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE ANAREA(
     +MNAT,
     +PROBR,EE,
     +X,Y,Z,R,ACC)
*
* Declarations.
*
      LOGICAL ISKIP(200)
      LOGICAL LONE,LTOP,ISKIPS
*
      INTEGER INTAG1(200),INTAG(200),ITAG(200),IDER(200)
*
      REAL*4  R(7000),X(7000),Y(7000),Z(7000),
     +GX(7000),GY(7000),GZ(7000)
      REAL*4  XC1(200),YC1(200),ZC1(200),
     +BG(200),THER(200),RI(200),RISQ(200),
     +B1(200),DSQ1(200),BSQ1(200),GR(200),
     +XC(200),YC(200),ZC(200),
     +UX(200),UY(200),UZ(200),
     +DSQ(200),BSQ(200),B(200)
      REAL*4 KENT(201),KOUT(201)
      REAL*4 ARCI(300),ARCF(300),EX(300),LT(300)
      REAL*4 ACC(7000)
*
* Initialisation.
*
      DATA MARC,MMNAT,MOV,MPT/201,7000,200,300/
*
* probe radius.
*
* overlap significance (also used to test if spheres colinear).
*
      SIG=.001
      SIGSQ=SIG**2
      PI=ACOS(-1.0)
      PIX2=2.0*PI
      PIX4=4.0*PI
      PID2=PI/2.0
*
* read sphere coordinates and vdw radii.
* key other than zero excludes calculation for atom, but used for others.
*
      DO 2 I=1,MNAT
      R(I)=R(I)+PROBR
2     CONTINUE
*
      EE=0.
      DO 32 I=1,MOV
      IDER(I)=0
32    CONTINUE
*
* process each atom.
* find the in spheres which overlap the ir sphere.
*
      DO 5 IR=1,MNAT
      LONE=.FALSE.
      IO=1
      JB=0
      IB=0
      ARCLEN=0.
      EXANG=0.
      AREA=0.
      XR=X(IR)
      YR=Y(IR)
      ZR=Z(IR)
      RR=R(IR)
      RRX2=RR*2.0
      RRSQ=RR**2
      DO 12 IN=1,MNAT
*
* is the in sphere next to the ir sphere.
*
      RPLUS=RR+R(IN)
      TX=X(IN)-XR
      IF (ABS(TX).GE.RPLUS) GOTO 12
      TY=Y(IN)-YR
      IF (ABS(TY).GE.RPLUS) GOTO 12
      TZ=Z(IN)-ZR
      IF (ABS(TZ).GE.RPLUS) GOTO 12
      IF (IN.EQ.IR) GOTO 12
*
* check for overlap of spheres by testing center to center distance.
* against sum and difference of radii.
*
      XYSQ=TX**2+TY**2
      IF (XYSQ.GE.SIGSQ) GOTO 57
      TX=SIG
      TY=0.
      XYSQ=SIGSQ
57    CCSQ=XYSQ+TZ**2
      CC=SQRT(CCSQ)
      IF (RPLUS-CC.LE.SIG) GOTO 12
      RMINUS=RR-R(IN)
      IF (CC-ABS(RMINUS).GT.SIG) GOTO 17
*
* ir sphere completely buried?.
*
      IF (RMINUS.LE.0.) GOTO 4
      GOTO 12
*
* calc. overlap parameters.
*
17    XC1(IO)=TX
      YC1(IO)=TY
      ZC1(IO)=TZ
      DSQ1(IO)=XYSQ
      BSQ1(IO)=CCSQ
      B1(IO)=CC
      GR(IO)=(CCSQ+RPLUS*RMINUS)/(RRX2*B1(IO))
      INTAG1(IO)=IN
      IO=IO+1
      IF (IO.GT.MOV) WRITE(6,96)
96    FORMAT(' INCREASE MOV')
12    CONTINUE
      IO=IO-1
      IF (IO.NE.0) GOTO 13
      AREA=PIX4
      GOTO 16
13    IF (IO.NE.1) GOTO 1
      K=1
      LONE=.TRUE.
      TXK=XC1(1)
      TYK=YC1(1)
      TZK=ZC1(1)
      BSQK=BSQ1(1)
      BK=B1(1)
      INTAG(1)=INTAG1(1)
      GOTO 39
*
* sort in spheres by degree of overlap with ir sphere.
*
1     CONTINUE
      CALL SORTAG(GR,IO,ITAG)
      DO 11 L=1,IO
      K=ITAG(L)
      IN=INTAG1(K)
      INTAG(L)=IN
      XC(L)=XC1(K)
      YC(L)=YC1(K)
      ZC(L)=ZC1(K)
      DSQ(L)=DSQ1(K)
      B(L)=B1(K)
      BSQ(L)=BSQ1(K)
      ISKIP(L)=.FALSE.
11    CONTINUE
      DO 8 L=1,IO
      GL=GR(L)*RR
      BG(L)=B(L)*GL
      RISQ(L)=RRSQ-GL**2
      RI(L)=SQRT(RISQ(L))
*
* radius of the in circle on the surface of the sphere.
*
      THER(L)=PID2-ASIN(GR(L))
8     CONTINUE
*
* find boundary of inaccessible area on ir sphere.
*
      IO1=IO-1
      DO 30 K=1,IO1
      IF (ISKIP(K)) GOTO 30
      TXK=XC(K)
      TYK=YC(K)
      TZK=ZC(K)
      BK=B(K)
      THERK=THER(K)
      K1=K+1
      DO 31 L=K1,IO
      IF (ISKIP(L)) GOTO 31
*
* is l circle intersecting k circle?.
* distance between circle centers and sum of radii.
*
      CC=ACOS((TXK*XC(L)+TYK*YC(L)+TZK*ZC(L))/(BK*B(L)))
      TD=THERK+THER(L)
*
* circles enclose separate regions?.
*
      IF (CC.GE.TD) GOTO 31
*
* circle l completely inside circle k?.
*
      IF (CC+THER(L).LT.THER(K)) GOTO 10
*
* circles essentially parallel?.
*
      IF (CC.GT.SIG) GOTO 25
10    ISKIP(L)=.TRUE.
      GOTO 31
*
* ir sphere completely buried?.
*
25    IF (PIX2-CC.LE.TD) GOTO 4
31    CONTINUE
30    CONTINUE
*
* find t value of circle intersections.
*
      DO 14 K=1,IO
      IF (ISKIP(K)) GOTO 14
      ISKIPS=ISKIP(K)
      ISKIP(K)=.TRUE.
      KARC=0
      LTOP=.FALSE.
      TXK=XC(K)
      TYK=YC(K)
      TZK=ZC(K)
      DK=SQRT(DSQ(K))
      BSQK=BSQ(K)
      BK=B(K)
      GK=GR(K)*RR
      RISQK=RISQ(K)
      RIK=RI(K)
      THERK=THER(K)
*
* rotation matrix elements.
*
      T1=TZK/(BK*DK)
      AXX=TXK*T1
      AXY=TYK*T1
      AXZ=DK/BK
      AYX=TYK/DK
      AYY=TXK/DK
      AZX=TXK/BK
      AZY=TYK/BK
      AZZ=TZK/BK
      DO 15 L=1,IO
      IF (ISKIP(L)) GOTO 15
      TXL=XC(L)
      TYL=YC(L)
      TZL=ZC(L)
*
* rotate spheres so k vector colinear with z-axis.
*
      UXL=TXL*AXX+TYL*AXY-TZL*AXZ
      UYL=TYL*AYY-TXL*AYX
      UZL=TXL*AZX+TYL*AZY+TZL*AZZ
      IF (ACOS(UZL/B(L)).GE.THERK+THER(L)) GOTO 15
      GL=GR(L)*RR
      DSQL=UXL**2+UYL**2
      TB=UZL*GK-BG(L)
      TXB=UXL*TB
      TYB=UYL*TB
      TD=RIK*DSQL
      TR=SQRT(RISQK*DSQL-TB**2)
      TXR=UXL*TR
      TYR=UYL*TR
*
* t values of intersection for k circle.
*
      TB=(TXB+TYR)/TD
      IF (ABS(TB).GT.1.) TB=SIGN(1.,TB)
      TK1=ACOS(TB)
      IF (TYB-TXR.LT.0.) TK1=PIX2-TK1
      TB=(TXB-TYR)/TD
      IF (ABS(TB).GT.1.) TB=SIGN(1.,TB)
      TK2=ACOS(TB)
      IF (TYB+TXR.LT.0.) TK2=PIX2-TK2
      THE=-ACOS((RRSQ*UZL-GK*BG(L))/(RIK*RI(L)*B(L)))
*
* is tk1 entry or exit point?  check t=0 point.
* ti is exit pt., tf is entry pt.
*
      IF ((ACOS((UZL*GK-UXL*RIK)/(B(L)*RR))-THER(L))*(TK2-TK1).LE.0)
     +GOTO 71
      TI=TK1
      TF=TK2
      GOTO 70
71    TI=TK2
      TF=TK1
70    KARC=KARC+1
      IF (KARC.GE.MPT) WRITE(6,20)
20    FORMAT(' INCREASE MPT')
      IF (TF.GT.TI) GOTO 72
      ARCF(KARC)=TF
      ARCI(KARC)=0.
      TF=PIX2
      LT(KARC)=L
      EX(KARC)=THE
      LTOP=.TRUE.
      KARC=KARC+1
72    ARCF(KARC)=TF
      ARCI(KARC)=TI
      LT(KARC)=L
      EX(KARC)=THE
      UX(L)=UXL
      UY(L)=UYL
      UZ(L)=UZL
15    CONTINUE
      ISKIP(K)=ISKIPS
*
*** special case: k circle without intersections?.
*
      IF (KARC.LE.0) GOTO 39
*
* general case: sum up arclength and set connectivity code.
*
      CALL SORTAG(ARCI,KARC,ITAG)
      ARCSUM=ARCI(1)
      MI=ITAG(1)
      T=ARCF(MI)
      N=MI
      IF (KARC.EQ.1) GOTO 18
      DO 21 J=2,KARC
      M=ITAG(J)
      IF (T.GE.ARCI(J)) GOTO 24
      ARCSUM=ARCSUM+ARCI(J)-T
      EXANG=EXANG+EX(N)
      JB=JB+1
      IF (JB.GE.MARC) WRITE(6,22)
22    FORMAT(' INCREASE MARC')
      L=INT(LT(N))
      IDER(L)=IDER(L)+1
      KENT(JB)=L*1024+K
      L=INT(LT(M))
      IDER(L)=IDER(L)+1
      KOUT(JB)=K*1024+L
24    TT=ARCF(M)
      IF (TT.LT.T) GOTO 21
      T=TT
      N=M
21    CONTINUE
18    ARCSUM=ARCSUM+PIX2-T
      IF (LTOP) GOTO 74
      EXANG=EXANG+EX(N)
      JB=JB+1
      L=INT(LT(N))
      IDER(L)=IDER(L)+1
      KENT(JB)=L*1024+K
      L=INT(LT(MI))
      IDER(L)=IDER(L)+1
      KOUT(JB)=K*1024+L
*
*  calculate derivatives.
*
74    CONTINUE
      DO 51 L=1,IO
      IF (IDER(L).EQ.0) GOTO 51
      RCN=IDER(L)*RRSQ
      IDER(L)=0
      UZL=UZ(L)
      GL=GR(L)*RR
      BGL=BG(L)
      BSQL=BSQ(L)
      RISQL=RISQ(L)
      WXLSQ=BSQL-UZL**2
      WXL=SQRT(WXLSQ)
      P=BGL-GK*UZL
      V=RISQK*WXLSQ-P**2
      IF (V.LE..000001) V=.000001
      V=SQRT(V)
      T1=RR*(GK*(BGL-BSQL)+UZL*(BGL-RRSQ))/(V*RISQL*BSQL)
      DEAL=-WXL*T1
      DECL=-UZL*T1-RR/V
      DTKAL=(WXLSQ-P)/(WXL*V)
      DTKCL=(UZL-GK)/V
      S=GK*B(L)-GL*UZL
      W=WXLSQ*RISQL-S**2
      IF (W.LT..000001) W=.000001
      W=SQRT(W)
      T1=2.*GK-UZL
      T2=RRSQ-BGL
      DTLAL=-(RISQL*WXLSQ*B(L)*T1-S*(WXLSQ*T2+RISQL*BSQL))
     +/(RISQL*WXL*BSQL*W)
      DTLCL=-(RISQL*B(L)*(UZL*T1-BGL)-UZL*T2*S)/(RISQL*BSQL*W)
      GACA=RCN*(DEAL-(GK*DTKAL-GL*DTLAL)/RR)/WXL
      FACA=UX(L)*GACA
      FACB=UY(L)*GACA
      FACC=RCN*(DECL-(GK*DTKCL-GL*DTLCL)/RR)
      DAX=AXX*FACA-AYX*FACB+AZX*FACC
      DAY=AXY*FACA+AYY*FACB+AZY*FACC
      DAZ=AZZ*FACC-AXZ*FACA
      IN=INTAG(L)
      GX(IR)=GX(IR)+DAX
      GY(IR)=GY(IR)+DAY
      GZ(IR)=GZ(IR)+DAZ
      GX(IN)=GX(IN)-DAX
      GY(IN)=GY(IN)-DAY
      GZ(IN)=GZ(IN)-DAZ
51    CONTINUE
      GOTO 19
39    ARCSUM=PIX2
      IB=IB+1
19    ARCLEN=ARCLEN+GR(K)*ARCSUM
      IN=INTAG(K)
      T1=ARCSUM*RRSQ*(BSQK-RRSQ+R(IN)**2)/(RRX2*BSQK*BK)
      GX(IR)=GX(IR)-TXK*T1
      GY(IR)=GY(IR)-TYK*T1
      GZ(IR)=GZ(IR)-TZK*T1
      GX(IN)=GX(IN)+TXK*T1
      GY(IN)=GY(IN)+TYK*T1
      GZ(IN)=GZ(IN)+TZK*T1
      IF (LONE) GOTO 56
14    CONTINUE
      IF (ARCLEN.EQ.0.) GOTO 4
      IF (JB.EQ.0) GOTO 56
*
* find number of independent boundaries.
*
      J=0
      DO 60 K=1,JB
      IF (KOUT(K).EQ.0) GOTO 60
      I=K
62    N=INT(KOUT(I))
      KOUT(I)=0
      J=J+1
      DO 61 II=1,JB
      IF (N.NE.KENT(II)) GOTO 61
      IF (II.NE.K) GOTO 64
      IB=IB+1
      IF (J.EQ.JB) GOTO 56
      GOTO 60
64    I=II
      GOTO 62
61    CONTINUE
60    CONTINUE
      IB=IB+1
*
      WRITE(*,26) IR
*
56    AREA=IB*PIX2+EXANG+ARCLEN
      AREA=MOD(AREA,PIX4)
16    AREA=AREA*RRSQ
      EE=EE+AREA
      ACC(IR)=AREA 
4     CONTINUE
5     CONTINUE
3     CONTINUE
*
9     FORMAT(' TOTAL AREA =',F8.2)
23    FORMAT(1X,I5,4F8.3)
26    FORMAT(' Connectivity Error on circle',I5'.')
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE SORTAG(A,N,TAG)
*
      INTEGER TAG,TG
      DIMENSION A(N),IU(16),IL(16),TAG(N)
      DO 1  I=1,N
      TAG(I)=I
1     CONTINUE
      M=1
      I=1
      J=N
5     IF (I.GE.J) GOTO 70
10    K=I
      IJ=(J+I)/2
      T=A(IJ)
      IF (A(I).LE.T) GOTO 20
      A(IJ)= A(I)
      A(I)=T
      T=A(IJ)
      TG=TAG(IJ)
      TAG(IJ)=TAG(I)
      TAG(I)=TG
20    L=J
      IF (A(J).GE.T) GOTO 40
      A(IJ)=A(J)
      A(J)=T
      T=A(IJ)
      TG=TAG(IJ)
      TAG(IJ)=TAG(J)
      TAG(J)=TG
      IF (A(I).LE.T) GOTO 40
      A(IJ)=A(I)
      A(I)=T
      T=A(IJ)
      TG=TAG(IJ)
      TAG(IJ)=TAG(I)
      TAG(I)=TG
      GOTO 40
30    A(L)=A(K)
      A(K)=TT
      TG=TAG(L)
      TAG(L)=TAG(K)
      TAG(K)=TG
40    L=L-1
      IF (A(L).GT.T) GOTO 40
      TT=A(L)
50    K=K+1
      IF (A(K).LT.T) GOTO 50
      IF (K.LE.L) GOTO 30
      IF (L-I.LE.J-K) GOTO 60
      IL(M)=I
      IU(M)=L
      I=K
      M=M+1
      GOTO 80
60    IL(M)=K
      IU(M)=J
      J=L
      M=M+1
      GOTO 80
70    M=M-1
      IF (M.EQ.0) RETURN
      I=IL(M)
      J=IU(M)
80    IF (J-I.GE.1) GOTO 10
      IF (I.EQ.1) GOTO 5
      I=I-1
90    I=I+1
      IF (I.EQ.J) GOTO 70
      T=A(I+1)
      IF (A(I).LE.T) GOTO 90
      TG=TAG(I+1)
      K=I
100   A(K+1)=A(K)
      TAG(K+1)=TAG(K)
      K=K-1
      IF (T.LT.A(K)) GOTO 100
      A(K+1)=T
      TAG(K+1)=TG
      GOTO 90
      END
*
*-------------------------------------------------------------------------------
*
*  subroutine to calculate accessible surface area using the method of
*  Wodak and Janin (1980), as modified by Hasel et al. (1988).
*
      SUBROUTINE WJACAL(
     +NA,PROBR,X,Y,Z,RAD,ACCR)
*
* declarations.
*
      INTEGER I,J,NA
*
      REAL AR,BR,B,BB,R12P,RPI,RNEG,R12,SS,
     +     RPTWO,FOURPI,PROBR,RR
*
      REAL X(NA),Y(NA),Z(NA),
     +     RAD(NA),ACCR(NA)
*
      REAL RADP(10000)
*
* set up mathematical constants, etc.
*
      PI=ACOS(-1.0)
      RPTWO=PROBR+PROBR
      FOURPI=(PI+PI+PI+PI)
*
* get expanded atom radii = (radii+probe).
*
      DO 3 I=1,NA
      RADP(I)=RAD(I)+PROBR
3     CONTINUE
*
* Work through atoms.
*
      DO 1 I=1,NA
*
      AR=1.0
      BR=0.0
      SS=FOURPI*(RADP(I)**2)
*
      DO 2 J=1,NA
*
      IF (I.EQ.J) GOTO 2
*
      DD=(X(I)-X(J))**2 + 
     +   (Y(I)-Y(J))**2 + 
     +   (Z(I)-Z(J))**2
*
      IF (DD.GT.0.0) THEN
*
      DD=SQRT(DD)
*
      RR=(RADP(I)+RADP(J))
*
      IF (DD.GT.RR) GOTO 2
*
*      R12=RAD(I)+RAD(J)+RPTWO-DD
      R12=RR-DD
*
      RPI=PI*RADP(I)
      RNEG=RAD(J)-RAD(I)
      VV=(1.0+(RNEG/DD))
*
      B=RPI*R12*VV
*
      IF (D.LT.2.0) THEN
      B=0.88*B
      ELSE
      B=B*0.35
      ENDIF
*
      AR=AR*(1.0-(B/SS))
*
      ENDIF
*
2     CONTINUE
*
      AR=SS*AR
*
      ACCR(I)=MAX(0.0,AR)
*
1     CONTINUE
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
*  subroutine to calculate accessible surface area using the method of
*  Wodak and Janin (1980).
*
      SUBROUTINE WJACALO(
     +NA,PROBR,X,Y,Z,RAD,ACCR)
*
* declarations.
*
      INTEGER I,J,NA
*
      REAL AR,BR,B,BB,R12P,RPI,RNEG,R12,SS,
     +     RPTWO,FOURPI,PROBR,RR
*
      REAL X(NA),Y(NA),Z(NA),
     +     RAD(NA),ACCR(NA)
*
      REAL RADP(10000)
*
* set up mathematical constants, etc.
*
      PI=ACOS(-1.0)
      RPTWO=PROBR+PROBR
      FOURPI=(PI+PI+PI+PI)
*
* get expanded atom radii = (radii+probe).
*
      DO 3 I=1,NA
      RADP(I)=RAD(I)+PROBR
3     CONTINUE
*
* Work through atoms.
*
      DO 1 I=1,NA
*
      AR=1.0
      BR=0.0
      SS=FOURPI*(RADP(I)**2)
*
      DO 2 J=1,NA
*
      IF (I.EQ.J) GOTO 2
*
      DD=(X(I)-X(J))**2 + 
     +   (Y(I)-Y(J))**2 + 
     +   (Z(I)-Z(J))**2
*
      IF (DD.GT.0.0) THEN
*
      DD=SQRT(DD)
*
      RR=(RADP(I)+RADP(J))
      IF (DD.GT.RR) GOTO 2
*
      R12=RAD(I)+RAD(J)+RPTWO-DD
      R12P=RAD(I)+RAD(J)-DD
      RPI=PI*RADP(I)
      RNEG=RAD(J)-RAD(I)
      VV=(1.0+(RNEG/DD))
*
      B =RPI*R12*VV
      BB=RPI*R12P*VV
      IF (BB.LT.0.0) BB=0.0
*
      AR=AR*(1.0-((B-BB)/SS))
      BR=BR+BB
*
      ENDIF
*
2     CONTINUE
*
      AR=SS*AR
*
      ACCR(I)=MAX(0.0,(AR-BR))
*
1     CONTINUE
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
* use SHRAKE and RUPLEY algorithm.
*
      SUBROUTINE SHR642(NA,PROBR,X,Y,Z,RAD,ACCR)
*
* declarations.
*
      INTEGER I,J,NA,ISKIP(648)
*
      REAL SS,
     +     FOURPI,PROBR,RR,PP,RJ
*
      REAL X(NA),Y(NA),Z(NA),
     +     RAD(NA),ACCR(NA),SP(3,642)
*
       REAL RADP(10000),RDS(10000)
*
       REAL 
     +SP1(3,50),
     +SP2(3,50),
     +SP3(3,50),
     +SP4(3,50),
     +SP5(3,50),
     +SP6(3,50),
     +SP7(3,50),
     +SP8(3,50),
     +SP9(3,50),
     +SP10(3,50),
     +SP11(3,50),
     +SP12(3,50),
     +SP13(3,42)
*
* data statements.
*
      DATA SP1 /
     +-0.617671,0.752344,-0.229045,-0.850651,0.525731,0.000000,
*
     +0.082324,0.399607,0.912982, -0.599106,  0.709911,0.370268,
     +0.082324,-0.399607,0.912982, -0.370603,  0.846716,0.381742,
     +-0.082324,0.399607,0.912982, -0.617671,  0.752344,0.229045,
     +0.000000,0.266405,0.963861, -0.709911,  0.370268,0.599106,
     +-0.082324,-0.399607,0.912982, -0.759464,  0.450447,0.469375,
     +0.000000,-0.266405,0.963861, -0.839643,  0.160357,0.518928,
     +0.082324,  0.399607,-0.912982, -0.889196,  0.240536,0.389196,
     +0.082324, -0.399607,-0.912982, -0.752344,  0.229045,0.617671,
     +-0.082324,  0.399607,-0.912982, -0.846715,  0.381741,0.370603,
     +0.000000,  0.266405,-0.963861, -0.709911,  0.370268,-0.599106,
     +-0.082324, -0.399607,-0.912982, -0.759464,  0.450447,-0.469375,
     +0.000000, -0.266405,-0.963861, -0.839643,0.160357,-0.518928,
     +-0.266405,  0.963861,0.000000, -0.889196,0.240536,-0.389196,
     +-0.399607,  0.912982, -0.082324, -0.752344,0.229045,-0.617671,
     +-0.399607,  0.912982,  0.082324, -0.846715,0.381741,-0.370603,
     +-0.513375,  0.564254,  0.646578, -0.389196,-0.889196,-0.240536,
     +-0.564254,  0.646578,  0.513375, -0.469375,-0.759464,-0.450447,
     +-0.646578,  0.513375,  0.564254, -0.518928,-0.839643,-0.160357,
     +-0.513375,  0.564254, -0.646578, -0.599106,-0.709911,-0.370268,
     +-0.564254,  0.646578, -0.513375, -0.370603,-0.846716,-0.381742,
     +-0.646578,  0.513375, -0.564254, -0.617671,-0.752344,-0.229045,
     +-0.266405, -0.963861,  0.000000, -0.389196,-0.889196,0.240536,
     +-0.399607, -0.912982, -0.082324, -0.469375,-0.759464,0.450447,
     +-0.399607, -0.912982,  0.082324, -0.518928,-0.839643,0.160357/
*
      DATA SP2 /
     +-0.513375, -0.564254,  0.646578, -0.599106, -0.709911,  0.370268,
     +-0.564254, -0.646578,  0.513375, -0.370603, -0.846716,  0.381742,
     +-0.646578, -0.513375,  0.564254, -0.617671, -0.752344,  0.229045,
     +-0.513375, -0.564254, -0.646578, -0.709911, -0.370268,  0.599106,
     +-0.564254, -0.646578, -0.513375, -0.839643, -0.160357,  0.518928,
     +-0.646578, -0.513375, -0.564254, -0.759464, -0.450447,  0.469375,
     +-0.912982,  0.082324,  0.399607, -0.889196, -0.240536,  0.389196,
     +-0.912982,  0.082324, -0.399607, -0.752344, -0.229045,  0.617671,
     +-0.912982, -0.082324,  0.399607, -0.846715, -0.381741,  0.370603,
     +-0.963861,  0.000000,  0.266405, -0.709911, -0.370268, -0.599106,
     +-0.912982, -0.082324, -0.399607, -0.839643, -0.160357, -0.518928,
     +-0.963861,  0.000000, -0.266405, -0.759464, -0.450447, -0.469375,
     +0.266405,  0.963861,  0.000000, -0.889196, -0.240536, -0.389196,
     +0.399607,  0.912982, -0.082324, -0.752344, -0.229045, -0.617671,
     +0.399607,  0.912982,  0.082324, -0.846715, -0.381741, -0.370603,
     +0.513375,  0.564254,  0.646578, -0.988302,  0.080179,  0.129732,
     +0.564254,  0.646578,  0.513375, -0.988302,  0.080179, -0.129732,
     +0.646578,  0.513375,  0.564254, -0.988302, -0.080179,  0.129732,
     +0.513375,  0.564254, -0.646578, -0.988302, -0.080179, -0.129732,
     +0.564254,  0.646578, -0.513375, -0.988273,  0.152697,  0.000000,
     +0.646578,  0.513375, -0.564254, -0.988273, -0.152697,  0.000000,
     +0.266405, -0.963861,  0.000000,  0.389196,  0.889196, -0.240536,
     +0.399607, -0.912982, -0.082324,  0.469375,  0.759464, -0.450447,
     +0.399607, -0.912982,  0.082324,  0.518928,  0.839643, -0.160357,
     +0.513375, -0.564254,  0.646578,  0.599106,  0.709911, -0.370268/
*
      DATA SP3 /
     +0.564254, -0.646578,  0.513375,  0.370603,  0.846716, -0.381742,
     +0.646578, -0.513375,  0.564254,  0.617671,  0.752344, -0.229045,
     +0.513375, -0.564254, -0.646578,  0.389196,  0.889196,  0.240536,
     +0.564254, -0.646578, -0.513375,  0.469375,  0.759464,  0.450447,
     +0.646578, -0.513375, -0.564254,  0.518928,  0.839643,  0.160357,
     +0.912982,  0.082324,  0.399607,  0.599106,  0.709911,  0.370268,
     +0.912982,  0.082324, -0.399607,  0.370603,  0.846716,  0.381742,
     +0.912982, -0.082324,  0.399607,  0.617671,  0.752344,  0.229045,
     +0.963861,  0.000000,  0.266405,  0.709911,  0.370268,  0.599106,
     +0.912982, -0.082324, -0.399607,  0.759464,  0.450447,  0.469375,
     +0.963861,  0.000000, -0.266405,  0.839643,  0.160357,  0.518928,
     +-0.126520,  0.963828, -0.234580,  0.889196,  0.240536,  0.389196,
     +0.126520,  0.963828, -0.234580,  0.752344,  0.229045,  0.617671,
     +0.078193,  0.632596, -0.770524,  0.846715,  0.381741,  0.370603,
     +0.282906,  0.710790, -0.644005,  0.709911,  0.370268, -0.599106,
     +-0.078193,  0.632596, -0.770524,  0.759464,  0.450447, -0.469375,
     +-0.282906,  0.710790, -0.644005,  0.839643,  0.160357, -0.518928,
     +0.000000,  0.724505, -0.689270,  0.889196,  0.240536, -0.389196,
     +-0.253039,  0.915502, -0.312773,  0.752344,  0.229045, -0.617671,
     +-0.331232,  0.788983, -0.517485,  0.846715,  0.381741, -0.370603,
     +-0.120751,  0.919883, -0.373140,  0.389196, -0.889196, -0.240536,
     +-0.195379,  0.799133, -0.568519,  0.469375, -0.759464, -0.450447,
     +0.253039,  0.915502, -0.312773,  0.518928, -0.839643, -0.160357,
     +0.331232,  0.788983, -0.517485,  0.599106, -0.709911, -0.370268,
     +0.120751,  0.919883, -0.373140,  0.370603, -0.846716, -0.381742 /
*
      DATA SP4 /
     +0.195379,  0.799133, -0.568519,  0.617671, -0.752344, -0.229045,
     +-0.126520,  0.963828,  0.234580,  0.389196, -0.889196,  0.240536,
     +0.126520,  0.963828,  0.234580,  0.469375, -0.759464,  0.450447,
     +0.078193,  0.632596,  0.770524,  0.518928, -0.839643,  0.160357,
     +0.282906,  0.710790,  0.644005,  0.599106, -0.709911,  0.370268,
     +-0.078193,  0.632596,  0.770524,  0.370603, -0.846716,  0.381742,
     +-0.282906,  0.710790,  0.644005,  0.617671, -0.752344,  0.229045,
     +0.000000,  0.724505,  0.689270,  0.709911, -0.370268,  0.599106,
     +-0.253039,  0.915502,  0.312773,  0.839643, -0.160357,  0.518928,
     +-0.331232,  0.788983,  0.517485,  0.759464, -0.450447,  0.469375,
     +-0.120751,  0.919883,  0.373140,  0.889196, -0.240536,  0.389196,
     +-0.195379,  0.799133,  0.568519,  0.752344, -0.229045,  0.617671,
     +0.253039,  0.915502,  0.312773,  0.846715, -0.381741,  0.370603,
     +0.331232,  0.788983,  0.517485,  0.709911, -0.370268, -0.599106,
     +0.120751,  0.919883,  0.373140,  0.839643, -0.160357, -0.518928,
     +0.195379,  0.799133,  0.568519,  0.759464, -0.450447, -0.469375,
     +-0.126520, -0.963828, -0.234580,  0.889196, -0.240536, -0.389196,
     +0.126520, -0.963828, -0.234580,  0.752344, -0.229045, -0.617671,
     +0.078193, -0.632596, -0.770524,  0.846715, -0.381741, -0.370603,
     +0.282906, -0.710790, -0.644005,  0.988302,  0.080179,  0.129732,
     +-0.078193, -0.632596, -0.770524,  0.988302,  0.080179, -0.129732,
     +-0.282906, -0.710790, -0.644005,  0.988302, -0.080179,  0.129732,
     +0.000000, -0.724505, -0.689270,  0.988302, -0.080179, -0.129732,
     +-0.253039, -0.915502, -0.312773,0.988273,0.152697,0.000000,
     +-0.331232, -0.788983, -0.517485,0.988273,-0.152697,0.000000/
*
      DATA SP5 /
     +-0.120751, -0.919883, -0.373140,  0.000000,  0.907272, -0.420544,
     +-0.195379, -0.799133, -0.568519,  0.070091,  0.793863, -0.604043,
     +0.253039, -0.915502, -0.312773, -0.070091,  0.793863, -0.604043,
     +0.331232, -0.788983, -0.517485, -0.113409,  0.863954, -0.490634,
     +0.120751, -0.919883, -0.373140,  0.113409,  0.863954, -0.490634,
     +0.195379, -0.799133, -0.568519,  0.000000,  0.907272,  0.420544,
     +-0.126520, -0.963828,  0.234580,  0.070091,  0.793863,  0.604043,
     +0.126520, -0.963828,  0.234580, -0.070091,  0.793863,  0.604043,
     +0.078193, -0.632596,  0.770524, -0.113409,  0.863954,  0.490634,
     +0.282906, -0.710790,  0.644005,  0.113409,  0.863954,  0.490634,
     +-0.078193, -0.632596,  0.770524,  0.000000, -0.907272, -0.420544,
     +-0.282906, -0.710790,  0.644005,  0.070091, -0.793863, -0.604043,
     +0.000000, -0.724505,  0.689270, -0.070091, -0.793863, -0.604043,
     +-0.253039, -0.915502,  0.312773, -0.113409, -0.863954, -0.490634,
     +-0.331232, -0.788983,  0.517485,  0.113409, -0.863954, -0.490634,
     +-0.120751, -0.919883,  0.373140,  0.000000, -0.907272,  0.420544,
     +-0.195379, -0.799133,  0.568519,  0.070091, -0.793863,  0.604043,
     +0.253039, -0.915502,  0.312773, -0.070091, -0.793863,  0.604043,
     +0.331232, -0.788983,  0.517485, -0.113409, -0.863954,  0.490634,
     +0.120751, -0.919883,  0.373140,  0.113409, -0.863954,  0.490634,
     +0.195379, -0.799133,  0.568519,  0.490634,  0.113409,  0.863954,
     +0.312773,  0.253039,  0.915502,  0.490634, -0.113409,  0.863954,
     +0.517485,  0.331232,  0.788983,  0.420544,  0.000000,  0.907272,
     +0.312773, -0.253039,  0.915502,  0.604043,  0.070091,  0.793863,
     +0.517485, -0.331232,  0.788983,  0.604043, -0.070091,  0.793863/
*
      DATA SP6 /
     +0.234580,  0.126520,  0.963828,  0.490634,  0.113409, -0.863954,
     +0.234580, -0.126520,  0.963828,  0.490634, -0.113409, -0.863954,
     +0.373140,  0.120751,  0.919883,  0.420544,  0.000000, -0.907272,
     +0.373140, -0.120751,  0.919883,  0.604043,  0.070091, -0.793863,
     +0.644005,  0.282906,  0.710790,  0.604043, -0.070091, -0.793863,
     +0.770524,  0.078193,  0.632596, -0.490634,  0.113409,  0.863954,
     +0.568519,  0.195379,  0.799133, -0.490634, -0.113409,  0.863954,
     +0.644005, -0.282906,  0.710790, -0.420544,  0.000000,  0.907272,
     +0.770524, -0.078193,  0.632596, -0.604043,  0.070091,  0.793863,
     +0.568519, -0.195379,  0.799133, -0.604043, -0.070091,  0.793863,
     +0.689270,  0.000000,  0.724505, -0.490634,  0.113409, -0.863954,
     +0.312773,  0.253039, -0.915502, -0.490634, -0.113409, -0.863954,
     +0.517485,  0.331232, -0.788983, -0.420544,  0.000000, -0.907272,
     +0.312773, -0.253039, -0.915502, -0.604043,  0.070091, -0.793863,
     +0.517485, -0.331232, -0.788983, -0.604043, -0.070091, -0.793863,
     +0.234580,  0.126520, -0.963828, -0.793863,  0.604043, -0.070091,
     +0.234580, -0.126520, -0.963828, -0.793863,  0.604043,  0.070091,
     +0.373140,  0.120751, -0.919883, -0.863954,  0.490634,  0.113409,
     +0.373140, -0.120751, -0.919883, -0.863954,  0.490634, -0.113409,
     +0.644005,  0.282906, -0.710790, -0.907272,  0.420544,  0.000000,
     +0.770524,  0.078193, -0.632596, -0.793863, -0.604043, -0.070091,
     +0.568519,  0.195379, -0.799133, -0.793863, -0.604043,  0.070091,
     +0.644005, -0.282906, -0.710790, -0.863954, -0.490634,  0.113409,
     +0.770524, -0.078193, -0.632596, -0.863954, -0.490634, -0.113409,
     +0.568519, -0.195379, -0.799133,-0.907272,-0.420544,0.000000/
*
      DATA SP7 /
     +0.689270,  0.000000, -0.724505,  0.793863,  0.604043, -0.070091,
     +-0.312773,  0.253039,  0.915502,  0.793863,  0.604043,  0.070091,
     +-0.517485,  0.331232,  0.788983,  0.863954,  0.490634,  0.113409,
     +-0.312773, -0.253039,  0.915502,  0.863954,  0.490634, -0.113409,
     +-0.517485, -0.331232,  0.788983,  0.907272,  0.420544,  0.000000,
     +-0.234580,  0.126520,  0.963828,  0.793863, -0.604043, -0.070091,
     +-0.234580, -0.126520,  0.963828,  0.793863, -0.604043,  0.070091,
     +-0.373140,  0.120751,  0.919883,  0.863954, -0.490634,  0.113409,
     +-0.373140, -0.120751,  0.919883,  0.863954, -0.490634, -0.113409,
     +-0.644005,  0.282906,  0.710790,  0.907272, -0.420544,  0.000000,
     +-0.770524,  0.078193,  0.632596,  0.000000,  0.525731,  0.850651,
     +-0.568519,  0.195379,  0.799133,  0.000000, -0.525731,  0.850651,
     +-0.644005, -0.282906,  0.710790,  0.162460,  0.262866,  0.951056,
     +-0.770524, -0.078193,  0.632596,  0.162460, -0.262866,  0.951056,
     +-0.568519, -0.195379,  0.799133, -0.162460,  0.262866,  0.951056,
     +-0.689270,  0.000000,  0.724505, -0.162460, -0.262866,  0.951056,
     +-0.312773,  0.253039, -0.915502,  0.000000,  0.525731, -0.850651,
     +-0.517485,  0.331232, -0.788983,  0.000000, -0.525731, -0.850651,
     +-0.312773, -0.253039, -0.915502,  0.162460,  0.262866, -0.951056,
     +-0.517485, -0.331232, -0.788983,  0.162460, -0.262866, -0.951056,
     +-0.234580,  0.126520, -0.963828, -0.162460,  0.262866, -0.951056,
     +-0.234580, -0.126520, -0.963828, -0.162460, -0.262866, -0.951056,
     +-0.373140,  0.120751, -0.919883, -0.262866,  0.951056, -0.162460,
     +-0.373140, -0.120751, -0.919883, -0.425325,  0.688191, -0.587785,
     +-0.644005,  0.282906, -0.710790, -0.262866,  0.951056,  0.162460/
*
      DATA SP8 /
     +-0.770524,  0.078193, -0.632596, -0.425325,  0.688191,  0.587785,
     +-0.568519,  0.195379, -0.799133, -0.525731,  0.850651,  0.000000,
     +-0.644005, -0.282906, -0.710790, -0.587785,  0.425325,  0.688191,
     +-0.770524, -0.078193, -0.632596, -0.688191,  0.587785,  0.425325,
     +-0.568519, -0.195379, -0.799133, -0.587785,  0.425325, -0.688191,
     +-0.689270,  0.000000, -0.724505, -0.688191,  0.587785, -0.425325,
     +-0.632596,  0.770524, -0.078193, -0.262866, -0.951056, -0.162460,
     +-0.710790,  0.644005, -0.282906, -0.425325, -0.688191, -0.587785,
     +-0.632596,  0.770524,  0.078193, -0.262866, -0.951056,  0.162460,
     +-0.710790,  0.644005,  0.282906, -0.425325, -0.688191,  0.587785,
     +-0.724505,  0.689270,  0.000000, -0.525731, -0.850651,  0.000000,
     +-0.788983,  0.517485,  0.331232, -0.587785, -0.425325,  0.688191,
     +-0.915502,  0.312773,  0.253039, -0.850651,  0.000000,  0.525731,
     +-0.799133,  0.568519,  0.195379, -0.688191, -0.587785,  0.425325,
     +-0.788983,  0.517485, -0.331232, -0.587785, -0.425325, -0.688191,
     +-0.915502,  0.312773, -0.253039, -0.850651,  0.000000, -0.525731,
     +-0.799133,  0.568519, -0.195379, -0.688191, -0.587785, -0.425325,
     +-0.963828,  0.234580,  0.126520, -0.951056,  0.162460,  0.262866,
     +-0.963828,  0.234580, -0.126520, -0.951056,  0.162460, -0.262866,
     +-0.919883,  0.373140,  0.120751, -0.951056, -0.162460,  0.262866,
     +-0.919883,  0.373140, -0.120751, -0.951056, -0.162460, -0.262866,
     +-0.632596, -0.770524, -0.078193,  0.262866,  0.951056, -0.162460,
     +-0.710790, -0.644005, -0.282906,  0.425325,  0.688191, -0.587785,
     +-0.632596, -0.770524,  0.078193,  0.262866,  0.951056,  0.162460,
     +-0.710790, -0.644005,  0.282906,  0.425325,  0.688191,  0.587785/
*
      DATA SP9 /
     +-0.724505, -0.689270,  0.000000,  0.525731,  0.850651,  0.000000,
     +-0.788983, -0.517485,  0.331232,  0.587785,  0.425325,  0.688191,
     +-0.915502, -0.312773,  0.253039,  0.688191,  0.587785,  0.425325,
     +-0.799133, -0.568519,  0.195379,  0.587785,  0.425325, -0.688191,
     +-0.788983, -0.517485, -0.331232,  0.688191,  0.587785, -0.425325,
     +-0.915502, -0.312773, -0.253039,  0.262866, -0.951056, -0.162460,
     +-0.799133, -0.568519, -0.195379,  0.425325, -0.688191, -0.587785,
     +-0.963828, -0.234580,  0.126520,  0.262866, -0.951056,  0.162460,
     +-0.963828, -0.234580, -0.126520,  0.425325, -0.688191,  0.587785,
     +-0.919883, -0.373140,  0.120751,  0.525731, -0.850651,  0.000000,
     +-0.919883, -0.373140, -0.120751,  0.587785, -0.425325,  0.688191,
     +0.632596,  0.770524, -0.078193,  0.850651,  0.000000,  0.525731,
     +0.710790,  0.644005, -0.282906,  0.688191, -0.587785,  0.425325,
     +0.632596,  0.770524,  0.078193,  0.587785, -0.425325, -0.688191,
     +0.710790,  0.644005,  0.282906,  0.850651,  0.000000, -0.525731,
     +0.724505,  0.689270,  0.000000,  0.688191, -0.587785, -0.425325,
     +0.788983,  0.517485,  0.331232,  0.951056,  0.162460,  0.262866,
     +0.915502,  0.312773,  0.253039,  0.951056,  0.162460, -0.262866,
     +0.799133,  0.568519,  0.195379,  0.951056, -0.162460,  0.262866,
     +0.788983,  0.517485, -0.331232,  0.951056, -0.162460, -0.262866,
     +0.915502,  0.312773, -0.253039,  0.000000,  0.955423, -0.295242,
     +0.799133,  0.568519, -0.195379,  0.147621,  0.716567, -0.681718,
     +0.963828,  0.234580,  0.126520, -0.147621,  0.716567, -0.681718,
     +0.963828,  0.234580, -0.126520, -0.238856,  0.864188, -0.442863,
     +0.919883,  0.373140,  0.120751,  0.238856,  0.864188, -0.442863/
*
      DATA SP10 /
     +0.919883,  0.373140, -0.120751,  0.000000,  0.955423,  0.295242,
     +0.632596, -0.770524, -0.078193,  0.147621,  0.716567,  0.681718,
     +0.710790, -0.644005, -0.282906, -0.147621,  0.716567,  0.681718,
     +0.632596, -0.770524,  0.078193, -0.238856,  0.864188,  0.442863,
     +0.710790, -0.644005,  0.282906,  0.238856,  0.864188,  0.442863,
     +0.724505, -0.689270,  0.000000,  0.000000, -0.955423, -0.295242,
     +0.788983, -0.517485,  0.331232,  0.147621, -0.716567, -0.681718,
     +0.915502, -0.312773,  0.253039, -0.147621, -0.716567, -0.681718,
     +0.799133, -0.568519,  0.195379, -0.238856, -0.864188, -0.442863,
     +0.788983, -0.517485, -0.331232,  0.238856, -0.864188, -0.442863,
     +0.915502, -0.312773, -0.253039,  0.000000, -0.955423,  0.295242,
     +0.799133, -0.568519, -0.195379,  0.147621, -0.716567,  0.681718,
     +0.963828, -0.234580,  0.126520, -0.147621, -0.716567,  0.681718,
     +0.963828, -0.234580, -0.126520, -0.238856, -0.864188,  0.442863,
     +0.919883, -0.373140,  0.120751,  0.238856, -0.864188,  0.442863,
     +0.919883, -0.373140, -0.120751,  0.442863,  0.238856,  0.864188,
     +-0.129732,  0.988302, -0.080179,  0.442863, -0.238856,  0.864188,
     +-0.129732,  0.988302,  0.080179,  0.295242,  0.000000,  0.955423,
     +0.129732,  0.988302, -0.080179,  0.681718,  0.147621,  0.716567,
     +0.129732,  0.988302,  0.080179,  0.681718, -0.147621,  0.716567,
     +0.000000,  0.988273, -0.152697,  0.442863,  0.238856, -0.864188,
     +0.000000,  0.988273,  0.152697,  0.442863, -0.238856, -0.864188,
     +-0.129732, -0.988302, -0.080179,  0.295242,  0.000000, -0.955423,
     +-0.129732, -0.988302,  0.080179,  0.681718,  0.147621, -0.716567,
     +0.129732, -0.988302, -0.080179,  0.681718, -0.147621, -0.716567/
*
      DATA SP11 /
     +0.129732, -0.988302,  0.080179, -0.442863,  0.238856,  0.864188,
     +0.000000, -0.988273, -0.152697, -0.442863, -0.238856,  0.864188,
     +0.000000, -0.988273,  0.152697, -0.295242,  0.000000,  0.955423,
     +0.160357,  0.518928,  0.839643, -0.681718,  0.147621,  0.716567,
     +0.240536,  0.389196,  0.889196, -0.681718, -0.147621,  0.716567,
     +0.370268,  0.599106,  0.709911, -0.442863,  0.238856, -0.864188,
     +0.450447,  0.469375,  0.759464, -0.442863, -0.238856, -0.864188,
     +0.229045,  0.617671,  0.752344, -0.295242,  0.000000, -0.955423,
     +0.381742,  0.370603,  0.846716, -0.681718,  0.147621, -0.716567,
     +0.160357, -0.518928,  0.839643, -0.681718, -0.147621, -0.716567,
     +0.240536, -0.389196,  0.889196, -0.716567,  0.681718, -0.147621,
     +0.370268, -0.599106,  0.709911, -0.716567,  0.681718,  0.147621,
     +0.450447, -0.469375,  0.759464, -0.864188,  0.442863,  0.238856,
     +0.229045, -0.617671,  0.752344, -0.864188,  0.442863, -0.238856,
     +0.381742, -0.370603,  0.846716, -0.955423,  0.295242,  0.000000,
     +0.160357,  0.518928, -0.839643, -0.716567, -0.681718, -0.147621,
     +0.240536,  0.389196, -0.889196, -0.716567, -0.681718,  0.147621,
     +0.370268,  0.599106, -0.709911, -0.864188, -0.442863,  0.238856,
     +0.450447,  0.469375, -0.759464, -0.864188, -0.442863, -0.238856,
     +0.229045,  0.617671, -0.752344, -0.955423, -0.295242,  0.000000,
     +0.381742,  0.370603, -0.846716,  0.716567,  0.681718, -0.147621,
     +0.160357, -0.518928, -0.839643,  0.716567,  0.681718,  0.147621,
     +0.240536, -0.389196, -0.889196,  0.864188,  0.442863,  0.238856,
     +0.370268, -0.599106, -0.709911,  0.864188,  0.442863, -0.238856,
     +0.450447, -0.469375, -0.759464,  0.955423,  0.295242,  0.000000/
      DATA SP12 /
     +0.229045, -0.617671, -0.752344,  0.716567, -0.681718, -0.147621,
     +0.381742, -0.370603, -0.846716,  0.716567, -0.681718,  0.147621,
     +-0.160357,  0.518928,  0.839643,  0.864188, -0.442863,  0.238856,
     +-0.240536,  0.389196,  0.889196,  0.864188, -0.442863, -0.238856,
     +-0.370268,  0.599106,  0.709911,  0.955423, -0.295242,  0.000000,
     +-0.450447,  0.469375,  0.759464,  0.000000,  1.000000,  0.000000,
     +-0.229045,  0.617671,  0.752344,  0.000000, -1.000000,  0.000000,
     +-0.381742,  0.370603,  0.846716,  0.309017,  0.500000,  0.809017,
     +-0.160357, -0.518928,  0.839643,  0.309017, -0.500000,  0.809017,
     +-0.240536, -0.389196,  0.889196,  0.309017,  0.500000, -0.809017,
     +-0.370268, -0.599106,  0.709911,  0.309017, -0.500000, -0.809017,
     +-0.450447, -0.469375,  0.759464, -0.309017,  0.500000,  0.809017,
     +-0.229045, -0.617671,  0.752344, -0.309017, -0.500000,  0.809017,
     +-0.381742, -0.370603,  0.846716,  0.000000,  0.000000,  1.000000,
     +0.080179,  0.129732,  0.988302, -0.309017,  0.500000, -0.809017,
     +0.080179, -0.129732,  0.988302, -0.309017, -0.500000, -0.809017,
     +-0.080179,  0.129732,  0.988302,  0.000000,  0.000000, -1.000000,
     +-0.080179, -0.129732,  0.988302, -0.500000,  0.809017, -0.309017,
     +0.152697,  0.000000,  0.988273, -0.500000,  0.809017,  0.309017,
     +-0.152697,  0.000000,  0.988273, -0.809017,  0.309017,  0.500000,
     +-0.160357,  0.518928, -0.839643, -0.809017,  0.309017, -0.500000,
     +-0.240536,  0.389196, -0.889196, -0.500000, -0.809017, -0.309017,
     +-0.370268,  0.599106, -0.709911, -0.500000, -0.809017,  0.309017,
     +-0.450447,  0.469375, -0.759464, -0.809017, -0.309017,  0.500000,
     +-0.229045,  0.617671, -0.752344, -0.809017, -0.309017, -0.500000/
      DATA SP13 /
*
     +-0.381742,  0.370603, -0.846716, -1.000000,  0.000000,  0.000000,
     +-0.160357, -0.518928, -0.839643,  0.500000,  0.809017, -0.309017,
     +-0.240536, -0.389196, -0.889196,  0.500000,  0.809017,  0.309017,
     +-0.370268, -0.599106, -0.709911,  0.809017,  0.309017,  0.500000,
     +-0.450447, -0.469375, -0.759464,  0.809017,  0.309017, -0.500000,
     +-0.229045, -0.617671, -0.752344,  0.500000, -0.809017, -0.309017,
     +-0.381742, -0.370603, -0.846716,  0.500000, -0.809017,  0.309017,
     +0.080179,  0.129732, -0.988302,  0.809017, -0.309017,  0.500000,
     +0.080179, -0.129732, -0.988302,  0.809017, -0.309017, -0.500000,
     +-0.080179,  0.129732, -0.988302,  1.000000,  0.000000,  0.000000,
     +-0.080179, -0.129732, -0.988302,  0.000000,  0.850651, -0.525731,
     +0.152697,  0.000000, -0.988273,0.000000,  0.850651,  0.525731,
     +-0.152697,  0.000000, -0.988273,0.000000, -0.850651, -0.525731,
     +-0.389196,  0.889196, -0.240536,0.000000, -0.850651,  0.525731,
     +-0.469375,  0.759464, -0.450447,0.525731,  0.000000,  0.850651,
     +-0.518928,  0.839643, -0.160357,0.525731,  0.000000, -0.850651,
     +-0.599106,0.709911,-0.370268,-0.525731,  0.000000,  0.850651,
     +-0.370603,0.846716,-0.381742,-0.525731,  0.000000, -0.850651,
     +-0.389196,0.889196,0.240536,-0.850651, -0.525731,0.000000,
     +-0.469375,0.759464,0.450447,0.850651,  0.525731,  0.000000,
     +-0.518928,0.839643,0.160357,0.850651,-0.525731,0.000000/
*
* set up mathematical constants, etc.
*
      DO 700 I=1,50
      DO 700 J=1,3
      SP(J,I+550)=SP12(J,I)
      SP(J,I+500)=SP11(J,I)
      SP(J,I+450)=SP10(J,I)
      SP(J,I+400)=SP9(J,I)
      SP(J,I+350)=SP8(J,I)
      SP(J,I+300)=SP7(J,I)
      SP(J,I+250)=SP6(J,I)
      SP(J,I+200)=SP5(J,I)
      SP(J,I+150)=SP4(J,I)
      SP(J,I+100)=SP3(J,I)
      SP(J,I+50)=SP2(J,I)
      SP(J,I)=SP1(J,I)
700   CONTINUE
*
      DO 701 I=1,42
      DO 701 J=1,3
      SP(J,I+600)=SP13(J,I)
701   CONTINUE
*
      PI=3.1415926
      FOURPI=4.0*PI
*
* get expanded atom radii = (radii+probe).
*
      DO 3 I=1,NA
      RADP(I)=RAD(I)+PROBR
      RDS(I)=RADP(I)**2
3     CONTINUE
*
* work through atoms.
*
      DO 1 I=1,NA
*
      RR=RADP(I)
      SS=RADP(I)**2
*
      DO 11 J=1,642
      ISKIP(J)=1
11    CONTINUE
*
      DO 2 J=1,NA
*
      RJ=RADP(J)
*
      IF (I.EQ.J) GOTO 2
*
      DD=(X(I)-X(J))**2 +
     +   (Y(I)-Y(J))**2 +
     +   (Z(I)-Z(J))**2
*
      IF (DD.LE.0.0) GOTO 2
*
      IF (DD.GT.(RR+RADP(J))**2) GOTO 2
*
      DO 4 II=1,642
*
      IF (ISKIP(II).EQ.0) GOTO 4
*
      DX=ABS((X(I)+RR*SP(1,II))-X(J))
      IF (DX.LE.RJ) THEN
      DY=ABS((Y(I)+RR*SP(2,II))-Y(J))
      IF (DY.LE.RJ) THEN
      DZ=ABS((Z(I)+RR*SP(3,II))-Z(J))
      IF (DZ.LE.RJ) THEN
*
      DP=DX*DX+DY*DY+DZ*DZ
*
      IF (DP.LE.RDS(J)) ISKIP(II)=0
*
      ENDIF
      ENDIF
      ENDIF
*
4     CONTINUE
*
2     CONTINUE
*
      KK=0
      DO 10 J=1,642
10    KK=KK+ISKIP(J)
*
      PP=FLOAT(KK)/642.0
      ACCR(I)=FOURPI*SS*PP
*
1     CONTINUE
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
* use SHRAKE and RUPLEY algorithm.
*
      SUBROUTINE SHR162(NA,PROBR,X,Y,Z,RAD,ACCR)
*
* declarations.
*
      INTEGER I,J,NA,ISKIP(162)
*
      REAL SS,
     +     FOURPI,PROBR,RR,PP
*
      REAL X(NA),Y(NA),Z(NA),
     +     RAD(NA),ACCR(NA),
     +     SP(3,162),SP1(3,48),SP2(3,50),SP3(3,50),SP4(3,14)
*
      REAL RADP(10000),RDS(10000)
*
      DATA  SP1 /
     + 0.000000, 0.525731, 0.850651, 0.406384, 0.320524, 0.855638,
     + 0.000000,-0.525731, 0.850651, 0.406384,-0.320524, 0.855638,
     + 0.162460, 0.262866, 0.951056, 0.208289, 0.000000, 0.978067,
     + 0.162460,-0.262866, 0.951056, 0.726908, 0.198095, 0.657543,
     +-0.162460, 0.262866, 0.951056, 0.726908,-0.198095, 0.657543,
     +-0.162460,-0.262866, 0.951056, 0.406384, 0.320524,-0.855638,
     + 0.000000, 0.525731,-0.850651, 0.406384,-0.320524,-0.855638,
     + 0.000000,-0.525731,-0.850651, 0.208289, 0.000000,-0.978067,
     + 0.162460, 0.262866,-0.951056, 0.726908, 0.198095,-0.657543,
     + 0.162460,-0.262866,-0.951056, 0.726908,-0.198095,-0.657543,
     +-0.162460, 0.262866,-0.951056,-0.406384, 0.320524, 0.855638,
     +-0.162460,-0.262866,-0.951056,-0.406384,-0.320524, 0.855638,
     +-0.262866, 0.951056,-0.162460,-0.208289, 0.000000, 0.978067,
     +-0.425325, 0.688191,-0.587785,-0.726908, 0.198095, 0.657543,
     +-0.262866, 0.951056, 0.162460,-0.726908,-0.198095, 0.657543,
     +-0.425325, 0.688191, 0.587785,-0.406384, 0.320524,-0.855638,
     +-0.525731, 0.850651, 0.000000,-0.406384,-0.320524,-0.855638,
     +-0.587785, 0.425325, 0.688191,-0.208289, 0.000000,-0.978067,
     +-0.688191, 0.587785, 0.425325,-0.726908, 0.198095,-0.657543,
     +-0.587785, 0.425325,-0.688191,-0.726908,-0.198095,-0.657543,
     +-0.688191, 0.587785,-0.425325,-0.657543, 0.726908,-0.198095,
     +-0.262866,-0.951056,-0.162460,-0.657543, 0.726908, 0.198095,
     +-0.425325,-0.688191,-0.587785,-0.855638, 0.406384, 0.320524,
     +-0.262866,-0.951056, 0.162460,-0.855638, 0.406384,-0.320524 /
      DATA SP2 /
     +-0.425325,-0.688191, 0.587785,-0.978067, 0.208289, 0.000000,
     +-0.525731,-0.850651, 0.000000,-0.657543,-0.726908,-0.198095,
     +-0.587785,-0.425325, 0.688191,-0.657543,-0.726908, 0.198095,
     +-0.850651, 0.000000, 0.525731,-0.855638,-0.406384, 0.320524,
     +-0.688191,-0.587785, 0.425325,-0.855638,-0.406384,-0.320524,
     +-0.587785,-0.425325,-0.688191,-0.978067,-0.208289, 0.000000,
     +-0.850651, 0.000000,-0.525731, 0.657543, 0.726908,-0.198095,
     +-0.688191,-0.587785,-0.425325, 0.657543, 0.726908, 0.198095,
     +-0.951056, 0.162460, 0.262866, 0.855638, 0.406384, 0.320524,
     +-0.951056, 0.162460,-0.262866, 0.855638, 0.406384,-0.320524,
     +-0.951056,-0.162460, 0.262866, 0.978067, 0.208289, 0.000000,
     +-0.951056,-0.162460,-0.262866, 0.657543,-0.726908,-0.198095,
     + 0.262866, 0.951056,-0.162460, 0.657543,-0.726908, 0.198095,
     + 0.425325, 0.688191,-0.587785, 0.855638,-0.406384, 0.320524,
     + 0.262866, 0.951056, 0.162460, 0.855638,-0.406384,-0.320524,
     + 0.425325, 0.688191, 0.587785, 0.978067,-0.208289, 0.000000,
     + 0.525731, 0.850651, 0.000000, 0.000000, 1.000000, 0.000000,
     + 0.587785, 0.425325, 0.688191, 0.000000,-1.000000, 0.000000,
     + 0.688191, 0.587785, 0.425325, 0.309017, 0.500000, 0.809017,
     + 0.587785, 0.425325,-0.688191, 0.309017,-0.500000, 0.809017,
     + 0.688191, 0.587785,-0.425325, 0.309017, 0.500000,-0.809017,
     + 0.262866,-0.951056,-0.162460, 0.309017,-0.500000,-0.809017,
     + 0.425325,-0.688191,-0.587785,-0.309017, 0.500000, 0.809017,
     + 0.262866,-0.951056, 0.162460,-0.309017,-0.500000, 0.809017,
     + 0.425325,-0.688191, 0.587785, 0.000000, 0.000000, 1.000000 /
      DATA SP3 /
     + 0.525731,-0.850651, 0.000000,-0.309017, 0.500000,-0.809017,
     + 0.587785,-0.425325, 0.688191,-0.309017,-0.500000,-0.809017,
     + 0.850651, 0.000000, 0.525731, 0.000000, 0.000000,-1.000000,
     + 0.688191,-0.587785, 0.425325,-0.500000, 0.809017,-0.309017,
     + 0.587785,-0.425325,-0.688191,-0.500000, 0.809017, 0.309017,
     + 0.850651, 0.000000,-0.525731,-0.809017, 0.309017, 0.500000,
     + 0.688191,-0.587785,-0.425325,-0.809017, 0.309017,-0.500000,
     + 0.951056, 0.162460, 0.262866,-0.500000,-0.809017,-0.309017,
     + 0.951056, 0.162460,-0.262866,-0.500000,-0.809017, 0.309017,
     + 0.951056,-0.162460, 0.262866,-0.809017,-0.309017, 0.500000,
     + 0.951056,-0.162460,-0.262866,-0.809017,-0.309017,-0.500000,
     + 0.000000, 0.978067,-0.208289,-1.000000, 0.000000, 0.000000,
     + 0.198095, 0.657543,-0.726908, 0.500000, 0.809017,-0.309017,
     +-0.198095, 0.657543,-0.726908, 0.500000, 0.809017, 0.309017,
     +-0.320524, 0.855638,-0.406384, 0.809017, 0.309017, 0.500000,
     + 0.320524, 0.855638,-0.406384, 0.809017, 0.309017,-0.500000,
     + 0.000000, 0.978067, 0.208289, 0.500000,-0.809017,-0.309017,
     + 0.198095, 0.657543, 0.726908, 0.500000,-0.809017, 0.309017,
     +-0.198095, 0.657543, 0.726908, 0.809017,-0.309017, 0.500000,
     +-0.320524, 0.855638, 0.406384, 0.809017,-0.309017,-0.500000,
     + 0.320524, 0.855638, 0.406384, 1.000000, 0.000000, 0.000000,
     + 0.000000,-0.978067,-0.208289, 0.000000, 0.850651,-0.525731,
     + 0.198095,-0.657543,-0.726908, 0.000000, 0.850651, 0.525731,
     +-0.198095,-0.657543,-0.726908, 0.000000,-0.850651,-0.525731,
     +-0.320524,-0.855638,-0.406384, 0.000000,-0.850651, 0.525731 /
      DATA SP4 /
     + 0.320524,-0.855638,-0.406384, 0.525731, 0.000000, 0.850651,
     + 0.000000,-0.978067, 0.208289, 0.525731, 0.000000,-0.850651,
     + 0.198095,-0.657543, 0.726908,-0.525731, 0.000000, 0.850651,
     +-0.198095,-0.657543, 0.726908,-0.525731, 0.000000,-0.850651,
     +-0.320524,-0.855638, 0.406384,-0.850651, 0.525731, 0.000000,
     + 0.320524,-0.855638, 0.406384,-0.850651,-0.525731, 0.000000,
     + 0.850651, 0.525731, 0.000000,0.850651,-0.525731, 0.000000 /
*
* set up mathematical constants, etc.
*
      DO 700 I=1,50
      DO 700 J=1,3
      SP(J,I+50)=SP2(J,I)
      SP(J,I)=SP3(J,I)
700   CONTINUE
*
      DO 701 I=1,48
      DO 701 J=1,3
      SP(J,I+100)=SP1(J,I)
701   CONTINUE
*
      DO 702 I=1,14
      DO 702 J=1,3
      SP(J,I+148)=SP4(J,I)
702   CONTINUE
*
      PI=3.1415926
      FOURPI=4.0*PI
*
* get expanded atom radii = (radii+probe).
*
      DO 3 I=1,NA
      RADP(I)=RAD(I)+PROBR
      RDS(I)=RADP(I)**2
3     CONTINUE
*
      DO 1 I=1,NA
*
      RR=RADP(I)
      SS=RADP(I)**2
*
      DO 11 J=1,162
      ISKIP(J)=1
11    CONTINUE
*
      DO 2 J=1,NA
*
      IF (I.EQ.J) GOTO 2
*
      RJ=RADP(J)
*
      DD=(X(I)-X(J))**2 +
     +   (Y(I)-Y(J))**2 +
     +   (Z(I)-Z(J))**2
*
      IF (DD.LE.0.0) GOTO 2
*
      IF (DD.GT.(RADP(I)+RADP(J))**2) GOTO 2
*
      DO 4 II=1,162
*
      IF (ISKIP(II).EQ.0) GOTO 4
*
      DX=ABS((X(I)+RR*SP(1,II))-X(J))
      IF (DX.LE.RJ) THEN
      DY=ABS((Y(I)+RR*SP(2,II))-Y(J))
      IF (DY.LE.RJ) THEN
      DZ=ABS((Z(I)+RR*SP(3,II))-Z(J))
      IF (DZ.LE.RJ) THEN
*
      DP=DX*DX+DY*DY+DZ*DZ
*
      IF (DP.LE.RDS(J)) ISKIP(II)=0
*
      ENDIF
      ENDIF
      ENDIF
*
4     CONTINUE
*
2     CONTINUE
*
      KK=0
      DO 10 J=1,162
      KK=KK+ISKIP(J)
10    CONTINUE
*
      PP=FLOAT(KK)/162.0
      ACCR(I)=FOURPI*SS*PP
*
1     CONTINUE
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
* apply Shrake and Rupley Algorithm using symmetry generated points.
*
      SUBROUTINE 
     +SRPOLY(NA,PROBR,X,Y,Z,RAD,ACCR)
*
      INTEGER I,J,NA,ISKIP(10000),NPNTS
*
      REAL 
     +     X(NA),Y(NA),Z(NA),
     +     RAD(NA),ACCR(NA)
*
      REAL SS,
     +     FOURPI,PROBR,RR,PP,SP
*
      REAL RADP(10000),RDS(10000)
*
      COMMON /POLYPP/ NPNTS,SP(3,1000)
*
* set up mathematical constants, etc.
*
      PI=3.1415926
      FOURPI=4.0*PI
*
* get expanded atom radii = (radii+probe).
*
      DO 3 I=1,NA
      RADP(I)=RAD(I)+PROBR
      RDS(I)=RADP(I)**2
3     CONTINUE
*
      DO 1 I=1,NA
*
      RR=RADP(I)
      SS=RADP(I)**2
*
      DO 11 J=1,NPNTS
      ISKIP(J)=1
11    CONTINUE
*
      DO 2 J=1,NA
*
      IF (I.EQ.J) GOTO 2
*
      RJ=RADP(J)
*
      DD=(X(I)-X(J))**2 +
     +   (Y(I)-Y(J))**2 +
     +   (Z(I)-Z(J))**2
*
      IF (DD.LE.0.0) GOTO 2
*
      IF (DD.GT.(RR+RADP(J))**2) GOTO 2
*
      DO 4 II=1,NPNTS
*
      IF (ISKIP(II).EQ.0) GOTO 4
*
      DX=ABS((X(I)+RR*SP(1,II))-X(J))
      IF (DX.LE.RJ) THEN
      DY=ABS((Y(I)+RR*SP(2,II))-Y(J))
      IF (DY.LE.RJ) THEN
      DZ=ABS((Z(I)+RR*SP(3,II))-Z(J))
      IF (DZ.LE.RJ) THEN
*
      DP=DX*DX+DY*DY+DZ*DZ
*
      IF (DP.LE.RDS(J)) ISKIP(II)=0
*
      ENDIF
      ENDIF
      ENDIF
*
4     CONTINUE
*
2     CONTINUE
*
      KK=0
      DO 10 J=1,NPNTS
      KK=KK+ISKIP(J)
10    CONTINUE 
*
      PP=FLOAT(KK)/FLOAT(NPNTS)
      ACCR(I)=FOURPI*SS*PP
*
1     CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* generate symmetry derived surface lattices.
*
      SUBROUTINE SYMDOT(IT,NPOINT,X)
*
* generate icosahedral surface net on sphere with various numbers of points
* radius 1.0.
*
*  points on sphere at hex pent positions for t=1,3,4,7,9.
*  giving 12,32,42,72,92 points. also "t" = 2 :  20-point icosahedron.
*  and "t" = 6 : 60-point .
*  t = 5 treated as =4, t = 8 treated as t = 7.
*
* on entry:  it = triangulation number  (1 to 9)  2 and 6 are not.
*                  proper t numbers.
*
* on exit:   it =  corrected t number, default = 9, 5 ->4, 8->7.
*             npoint   number of points.
*             x(3,npoint) coordinates of points.
*
* variables.
*
      REAL X(3,1000),XH(3,120)
*
      LOGICAL PENT
*
      DO 1 I=1,120
      DO 1 J=1,3
1     XH(J,I)=0.0 
*
* check valid t number, if invalid treat as 7.
*
      IF (IT.LE.0.OR.IT.GT.9) IT=7
      IF (IT.EQ.5) IT=4
      IF (IT.EQ.8) IT=7
*
* use merck routine for t = 9.
*
      IF (IT.EQ.9) THEN
      CALL POL92(X)
      NPOINT=92
      RETURN
      ENDIF
*
* set flag for pent points, "t" = 2 & 6 have no pents.
*
      PENT=.TRUE.
      IF (IT.EQ.2.OR.IT.EQ.6) PENT=.FALSE.
*
* initialise  pent coordinates.
*
      IF (PENT) THEN
      X(1,1)=0.851
      X(2,1)=0.526
      X(3,1)=0.
      NP0=1
      CALL ROTN(3,54.736,45.,NP0,X)
      CALL ROTN(2,0.,0.,NP0,X)
      CALL ROTN(2,90.,0.,NP0,X)
      ELSE
      NP0=0
      ENDIF
*
* np0 is number of coordinates sofar.
* branch on t number.
*
      GOTO (100,200,300,400,500,600,700),IT
*
* t = 1, pents only.
*
100   CONTINUE
      NPOINT=NP0
      RETURN
*
* initialise hex for t=3 or "t" = 2.
*
200   CONTINUE
300   CONTINUE
      XH(1,1)=0.357
      XH(2,1)=0.934
      XH(3,1)=0.
      NHEX=1
      GOTO 1000
*
* initialise hex for t=4.
*
400   CONTINUE
500   CONTINUE
      XH(1,1)=1.
      XH(2,1)=0.
      XH(3,1)=0.
      NHEX=1
      GOTO 1000
*
* initialise hex for "t"=6.
*
600   CONTINUE
      XH(1,1)=0.979
      XH(2,1)=0.203
      XH(3,1)=0.0
      NHEX=1
      GOTO 1000
*
* initialise hex for t=7.
*
700   CONTINUE
      XH(1,1)=0.917
      XH(2,1)=0.275
      XH(3,1)=0.289
      NHEX=1
      GOTO 1000
*
* generate icosahedrally related points.
*
1000  CONTINUE
      CALL ROTN(5,90.,31.718,NHEX,XH)
      CALL ROTN(3,54.736,45.,NHEX,XH)
      CALL ROTN(2,0.,0.,NHEX,XH)
      CALL ROTN(2,90.,0.,NHEX,XH)
*
* now select unique set.
*
      X(1,NP0+1)=XH(1,1)
      X(2,NP0+1)=XH(2,1)
      X(3,NP0+1)=XH(3,1)
      IPICK=1
*
      DO 1200 I=2,NHEX
      DO 1210 IP=1,IPICK
      IF ((ABS(XH(1,I)-X(1,IP+NP0)).LT.0.01).AND.
     +(ABS(XH(2,I)-X(2,IP+NP0)).LT.0.01).AND.
     +(ABS(XH(3,I)-X(3,IP+NP0)).LT.0.01)) GOTO 1200
1210  CONTINUE
*
      IPICK=IPICK+1
      X(1,IPICK+NP0)=XH(1,I)
      X(2,IPICK+NP0)=XH(2,I)
      X(3,IPICK+NP0)=XH(3,I)
1200  CONTINUE
*
      NPOINT=IPICK+NP0
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE ROTN(NSYM,THETA,PHI,NPT,XX)
*
* apply nsym rotations of 1/nsym about axis theta,phi to npt points in.
* array xx. on return  npt := npt * nsym
*
      DIMENSION XX(3,*),ROT(3,3)
      CRAD=0.0174532
      DELPSI=6.283185/NSYM
      PSI=0.
      NSYM1=NSYM-1
      TH=THETA*CRAD
      CTH=COS(TH)
      STH=SIN(TH)
      PH=PHI*CRAD
      CPH=COS(PH)
      SPH=SIN(PH)
      NP0=NPT
*
* for each rotation about this axis.
*
      DO 100 NS=1,NSYM1
      PSI=PSI+DELPSI
      CPS=COS(PSI)
      SPS=SIN(PSI)
      CPS1=1.-CPS
*
* elements of rotation matrix.
*
      ROT(1,1)= CPS        +CPS1*((STH*CPH)**2)
      ROT(1,2)=-CTH*SPS    +CPS1*STH*STH*SPH*CPH
      ROT(1,3)= STH*SPH*SPS+CPS1*STH*CTH*CPH
      ROT(2,1)= CTH*SPS    +CPS1*STH*STH*SPH*CPH
      ROT(2,2)= CPS        +CPS1*((STH*SPH)**2)
      ROT(2,3)=-STH*CPH*SPS+CPS1*STH*CTH*SPH
      ROT(3,1)=-STH*SPH*SPS+CPS1*STH*CTH*CPH
      ROT(3,2)= STH*CPH*SPS+CPS1*STH*CTH*SPH
      ROT(3,3)= CPS        +CPS1*CTH*CTH
*
      DO 110 NP=1,NPT
      DO 120 ND1=1,3
      XX(ND1,NP0+NP)=0.0
      DO 120 ND2=1,3
120   XX(ND1,NP0+NP)=XX(ND1,NP0+NP)+ROT(ND1,ND2)*XX(ND2,NP)
110   CONTINUE
      NP0=NP0+NPT
100   CONTINUE
      NPT=NPT*NSYM
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE POL92(ARR)
*
*  polhed.for   12 june 81      merck mmgf.
*   polyhedron routines:  pol92(arr) real*4 arr(3,92) constructs.
*   a unit polyhedron of 92 vertices.
*
      REAL ARR(3,1000),XYZ0(3),XYZ1(3),ROOT5
*
      SAVE
      ROOT5=SQRT(5.0)
      X0SQ=(5.0+ROOT5)/30.0
      XYZ0(1)=SQRT(X0SQ)
      Y0SQ=(15.0-5.0*ROOT5)/30.0
      XYZ0(2)=SQRT(Y0SQ)
      Z0SQ=(10.+4.0*ROOT5)/30.0
      XYZ0(3)=SQRT(Z0SQ)
      COS72=(ROOT5-1.0)/4.0
      SIN72=SQRT(1.0-COS72**2)
*
      DO 10 I=1,3
10    ARR(I,1)=XYZ0(I)
*
      CALL MAKE5(ARR,1,2,3,4,5,COS72,SIN72)
      THETA1=ACOS(XYZ0(3))+ACOS(ROOT5/3.)
      XYZ1(3)=COS(THETA1)
      XYZ1(2)=0.0
      XYZ1(1)=-SIN(THETA1)
      DO 20 I=1,3
20    ARR(I,8)=XYZ1(I)
*
      CALL MAKE5(ARR,8,9,10,6,7,COS72,SIN72)
      DO 30 J=1,10
      DO 30 I=1,3
30    ARR(I,93-J)=-ARR(I,J)
      ANORM5=SQRT(15.0-6.0*ROOT5)/5.0
      ANORM2=1./SQRT(2.0+2.0*XYZ0(3))
      ANORM3=1./SQRT(5.0-4.0*Y0SQ+4.0*XYZ0(3))
      A23=ANORM3
*
      CALL AVGE5(ARR,11,1,2,3,4,5,ANORM5,A23)
      CALL AVGE5(ARR,17,1,6,84,7,2,ANORM5,A23)
      CALL AVGE5(ARR,23,2,7,83,8,3,ANORM5,A23)
      CALL AVGE5(ARR,29,3,8,87,9,4,ANORM5,A23)
      CALL AVGE5(ARR,35,4,9,86,10,5,ANORM5,A23)
      CALL AVGE5(ARR,41,5,10,85,6,1,ANORM5,A23)
*
      DO 40 J=11,46
      DO 40 I=1,3
      ARR(I,93-J)=-ARR(I,J)
40    CONTINUE
*
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE MAKE5(ARR,I1,I2,I3,I4,I5,C,S)
*
* declarations
*
      REAL ARR(3,1000)
*
      DIMENSION ISUB(4)
*
      SAVE
      ISUB(1)=I2
      ISUB(2)=I3
      ISUB(3)=I4
      ISUB(4)=I5
      I=I1
      DO 10 K=1,4
      LAST=I
      I=ISUB(K)
      ARR(3,I)=ARR(3,LAST)
      ARR(1,I)=ARR(1,LAST)*C-ARR(2,LAST)*S
      ARR(2,I)=ARR(1,LAST)*S+ARR(2,LAST)*C
10    CONTINUE
      RETURN
      END
*
*
*-------------------------------------------------------------------------------
*
      SUBROUTINE AVGE5(ARR,IC,IV1,IV2,IV3,IV4,IV5,A5,A23)
*
      REAL ARR(3,1000)
*
      DIMENSION IV(6),M(6)
      DIMENSION XYZ(3)
*
      SAVE
      IV(1)=IV1
      IV(2)=IV2
      IV(3)=IV3
      IV(4)=IV4
      IV(5)=IV5
      IV(6)=IV1
*
      DO 10 K=1,5
10    M(K)=IC+K
      IF (IC.LT.0.OR.IC.GT.87) GOTO 990
      DO 20 K=1,5
      IF (IV(K).LT.1.OR.IV(K).GT.92) GOTO 990
20    CONTINUE
      DO 30 I=1,3
30    XYZ(I)=0.0
      DO 40 K=1,5
      DO 40 I=1,3
      XYZ(I)=XYZ(I)+ARR(I,IV(K))
40    CONTINUE
      DO 50 I=1,3
50    ARR(I,IC)=A5*XYZ(I)
      DO 60 K=1,5
      DO 60 I=1,3
      ARR(I,M(K))=
     +A23*(ARR(I,IC)+ARR(I,IV(K))+ARR(I,IV(K+1)))
60    CONTINUE
      RETURN
990   CONTINUE
*
      RETURN
      END
*
*-------------------------------------------------------------------------------
*
* simple but fairly robust parser.
*     picks up lists of integer and real numbers. 
*     plus a letter if it follows an integer directly.
*
* nb:
*
*  ILAST = 0 not a number.
*  ILAST = 1 integer number.
*  ILAST = 2 real number.
*
      SUBROUTINE LRDRF(A,N,IH,FH,CH,NN)
*
* decalarations.
*
      IMPLICIT INTEGER (A-Z)
*
      INTEGER J1,J2,N,NN,NNN,PP,I,J,ILAST,FCOUNT,FFT
      INTEGER IH(80),MULT(80)
*
      REAL FH(80)
*
      CHARACTER A*(*),B*80,CH(80)*1 
*
* initialise.
*
      DO 10 I=1,80
      IH(I)=0
      FH(I)=0.0
      CH(I)=' '
10    CONTINUE
*
      J1=1
      ILAST=0
      IH(J1)=0
      FH(J1)=0.0
      MULT(J1)=1
      FCOUNT=1
*
* Work through line.
*
      DO 2 I=1,N
      PP=INDEX('0123456789',A(I:I))
*
      IF (PP.GT.0) THEN
*
      IF (ILAST.NE.2) THEN
* integer
      ILAST=1
      IH(J1)=(IH(J1)*10)+(PP-1)
      ELSE
* real
      FFT=10**FCOUNT
      FH(J1)=FH(J1)+(FLOAT(PP-1)/FLOAT(FFT))
      FCOUNT=FCOUNT+1
      ENDIF
*
* get sign.
*
      IF (A(I-1:I-1).EQ.'-') MULT(J1)=-1
*
      ELSE
*
* found a decimal point.
*
      IF (A(I:I).EQ.'.') THEN 
      ILAST=2
      FCOUNT=1
      FH(J1)=FLOAT(IH(J1))
      IH(J1)=0
* get sign.
      IF (A(I-1:I-1).EQ.'-') MULT(J1)=-1
      GOTO 2
      ENDIF
*
* get chain label.
* 
      IF (ILAST.EQ.1) THEN
      CH(J1)=A(I:I)
      J1=J1+1
      MULT(J1)=1
      IH(J1)=0
      CH(J1)=' '
      ILAST=0
      ENDIF
*
* last was decimal point.
*
      IF (ILAST.EQ.2) THEN
      J1=J1+1
      MULT(J1)=1
      IH(J1)=0
      CH(J1)=' '
      ILAST=0
      ENDIF
*
      ENDIF
*
2     CONTINUE
*
* get number of numbers found.
*
      NN=J1-1
*
* get correct sign for each number.
*
      DO 3 I=1,NN
      IF (MULT(I).EQ.-1) THEN
      IH(I)=-IH(I)
      FH(I)=-FH(I)
      ENDIF
3     CONTINUE
*
      RETURN
      END
*
