      program cloner

C***********************************************************************
C                                   
C     Program CLON ERROR  ready to WWW.
C     Analisis of Sequence and Aminoacid Probability
C                                     
C     The Rockefeller University
C     Marc A. Marti-Renom, last revision: April'97
C                                   
C***********************************************************************

C********************* Variable definition *****************************

      implicit real*8 (a-h,o-z)
      real*8    n_esp,n_calc,z_score,az_score,avez_score,aave_z_score
      character line*300,input*11,bgcolor*7,blank
      character cleanseq*3000,sequence*3000,tmpseq*3000
      character detseq*5,randseq*3000,r_seq_best_zs*5,r_seq_worst_zs*5
      character seq_best_zs*5,seq_worst_zs*5
      character*100 dataref2,dataref3,dataref4,data_dev,title*24
      character header*80,footer*80,sig*8,label*100,case*27

      integer resp1,linput,lsequence,testlseq,standar
      integer ltmpseq,count,llabel,iran,indev

      parameter (min=4,maxprint=8,medium=3000,max=160001)

      dimension sdev(min),sdevdev(min),avedev(min),sd_dev(min)
      dimension n_esp(min,max),n_calc(min,max),iran(medium)
      dimension indev(min,maxprint),dev_ran(min,maxprint)
      dimension best_zs(min),worst_zs(min)
      dimension r_best_zs(min),r_worst_zs(min)
      dimension seq_best_zs(min),seq_worst_zs(min)
      dimension r_seq_best_zs(min),r_seq_worst_zs(min)

C********************* Initializing variables **************************
      
      do i=0,3000
	 sequence(i:i) = ' '
	 cleanseq(i:i) = ' '
      enddo
      linput = 0
      lsequence = 0
      testlseq = 0
      count = 0
      do i=2,4
	 total_al = 20**i
	 do n=1,total_al
	    n_esp(i,n) = 0.0   
            n_calc(i,n) = 0
         enddo
	 do n=1,8
            indev(i,n) = 0
            dev_ran(i,n) = 0
         enddo
	 best_zs(i) = 0.0
	 worst_zs(i) = 0.0
	 r_best_zs(i) = 0.0
	 r_worst_zs(i) = 0.0
      enddo
      k = 0
      standar = 1
      header  = '../ClonErrNet/xtras/header.txt'
      footer  = '../ClonErrNet/xtras/footer.txt'


C********************* I/O data files **********************************
      
      read(5,'(I1)')resp1
      read(5,'(Q,A)')llabel,label
      do while (.true.)
	 read(5,'(Q,A)',END=220)ltmpseq,tmpseq
         do j=1,ltmpseq
	    jj = jj + 1
            sequence(jj:jj) = tmpseq(j:j)
	    lsequence = lsequence + 1
         enddo
	 if (tmpseq(ltmpseq:ltmpseq) .eq. "*") goto 220
      enddo
220   continue

C********************* Initializing i/o files *************************

C---- Read tables from files of OWN database
      if (resp1 .eq. 1) then
	 do i=2,4
	    read(5,'(A)')blank
	    read(5,'(A)')blank
	    read(5,'(A)')blank
	    read(5,'(A)')blank
	    read(5,'(2F10.6)')avedev(i),sd_dev(i)
	    total_al = 20**i
	    do n=1,total_al
	       read(5,'(F10.2,F9.0)')n_esp(i,n),n_calc(i,n)
            enddo
         enddo
         title = '     your own           '
      endif

      if (resp1 .eq. 2) then
         dataref2 = '../ClonErrNet/data/yeast/yeast.bs2.dir'
	 dataref3 = '../ClonErrNet/data/yeast/yeast.bs3.dir'
         dataref4 = '../ClonErrNet/data/yeast/yeast.bs4.dir'
         data_dev = '../ClonErrNet/data/yeast/yeast.dev'
         title = 'Saccharomyces cerevisiae'
      endif

      if (resp1 .eq. 3) then
         dataref2 = '../ClonErrNet/data/ecoli/ecoli.bs2.dir'
         dataref3 = '../ClonErrNet/data/ecoli/ecoli.bs3.dir'
         dataref4 = '../ClonErrNet/data/ecoli/ecoli.bs4.dir'
         data_dev = '../ClonErrNet/data/ecoli/ecoli.dev'
         title = 'Escherichia coli'
      endif

C************************** Open data files ****************************
      
      open(unit=7,file=header,status='old')
      open(unit=8,file=footer,status='old')

      if (resp 1 .ne. 1) then
	 open(unit=12,file=dataref2,form='formatted',access='direct',
     &     recl=19,status='old')
         open(unit=13,file=dataref3,form='formatted',access='direct',
     &     recl=19,status='old')
         open(unit=14,file=dataref4,form='formatted',access='direct',
     &     recl=19,status='old')
         open(unit=15,file=data_dev,status='old')
      endif

C********************* Reading database average and SD *****************

      if (resp 1 .ne. 1) then
	 read(15,'(A)')blank
	 read(15,'(A)')blank
	 read(15,'(A)')blank
	 read(15,'(A)')blank
	 do i=2,4
	    read(15,'(2F10.6)')avedev(i),sd_dev(i)
         enddo
      endif

C********************* Reading the sequence ****************************
      
C---- Clean sequence of possible spaces
      k = 0
      do i=1,lsequence 
         if(sequence(i:i) .eq. "A" .or. sequence(i:i) .eq. "B" .or.
     &      sequence(i:i) .eq. "C" .or. sequence(i:i) .eq. "D" .or.
     &      sequence(i:i) .eq. "E" .or. sequence(i:i) .eq. "F" .or.
     &      sequence(i:i) .eq. "G" .or. sequence(i:i) .eq. "H" .or.
     &      sequence(i:i) .eq. "I" .or. sequence(i:i) .eq. "K" .or.
     &      sequence(i:i) .eq. "L" .or. sequence(i:i) .eq. "M" .or.
     &      sequence(i:i) .eq. "N" .or. sequence(i:i) .eq. "P" .or.
     &      sequence(i:i) .eq. "Q" .or. sequence(i:i) .eq. "R" .or.
     &      sequence(i:i) .eq. "S" .or. sequence(i:i) .eq. "T" .or.
     &      sequence(i:i) .eq. "V" .or. sequence(i:i) .eq. "W" .or.
     &      sequence(i:i) .eq. "Y" .or. sequence(i:i) .eq. "Z") then 
	    k = k + 1
	    cleanseq(k:k) = sequence(i:i)
	    if (cleanseq(k:k) .eq. " ") write(6,*)'<br>EP!!'
         endif
      enddo
      lsequence = k

C---- Calculate 150 random number sequences and their z-scores
      iseed=itime(time(1))
      do n=1,150
         call iran1(iseed,1,lsequence,iran)
         do j=1,lsequence
            randseq(j:j) = cleanseq(iran(j):iran(j))
         enddo
         do i=2,4
            do j=1,lsequence-(i-1)
               detseq = randseq(j:j+4)
               call num_seq(detseq,i,number)
               if (resp1 .ne. 1) then
                  read(10+i,300,REC=number,ERR=1100)
     &                   n_esp(i,number),n_calc(i,number)
               endif
               if (n_calc(i,number) .eq. 0.0) n_calc(i,number) = 0.9
               dev = log10(n_calc(i,number)) - log10(n_esp(i,number))
               diff  = n_calc(i,number) - n_esp(i,number)
               z_score = dev - avedev(i)
               z_score = z_score/sd_dev(i)
               az_score  = abs(z_score)
C---- Calculate Best and worst Z-score
	       if (z_score .gt. r_best_zs(i)) then
	          r_best_zs(i) = z_score
	          r_seq_best_zs(i) = detseq(1:i)
               endif
	       if (z_score .lt. r_worst_zs(i)) then
	          r_worst_zs(i) = z_score
	          r_seq_worst_zs(i) = detseq(1:i)
               endif

C---- Calculate individual value of deviation
               if (diff .lt. 0 .and. az_score .gt. 2.33) then
                  dev_ran(i,1) = dev_ran(i,1) + 1
               else if (diff .lt. 0 .and. az_score .gt. 1.65) then
                  dev_ran(i,2) = dev_ran(i,2) + 1
               else if (diff .lt. 0 .and. az_score .gt. 1.28) then
                  dev_ran(i,3) = dev_ran(i,3) + 1
               else if (diff .gt. 0 .and. az_score .gt. 2.33) then
                  dev_ran(i,7) = dev_ran(i,7) + 1
               else if (diff .gt. 0 .and. az_score .gt. 1.65) then
                  dev_ran(i,6) = dev_ran(i,6) + 1
               else if (diff .gt. 0 .and. az_score .gt. 1.28) then
                  dev_ran(i,5) = dev_ran(i,5) + 1
               else
                  dev_ran(i,4) = dev_ran(i,4) + 1
               endif
            enddo
         enddo
      enddo
      do i=2,4
         do n=1,7
            dev_ran(i,n) = dev_ran(i,n)/150
         enddo
      enddo

C********************** Write output file ******************************

C---- HTML Header
      do while (.true.)
         read(7,'(Q,A)',END=230,ERR=1000)lline,line
         write(6,'(A)')line(1:lline)
      enddo
230   continue

C---- General data from the database
      write(6,'(A)')'<p>'
      write(6,*)'<br><font size=+1>Calculated statistics for <i>',
     &'<font color="#663366">',title,'<b></font>&nbsp;</i>database',
     &'</b></font><br>'
      do i=2,4
         write(6,'(A)')'<table BORDER COLS=2 WIDTH="100%" NOSAVE >'
         write(6,'(A)')'<tr BGCOLOR="#CCCCCC" NOSAVE>'
         write(6,'(A)')'<td NOSAVE>'
         write(6,'(A,I,A)')'<center><b>Average diff (exp-real) for '
     &   ,i,' residues</b></center>'
         write(6,'(A)')'</td>'
         write(6,'(A)')'<td>'
         write(6,'(A)')'<center><b>Standard error difference (exp-real)'
         write(6,'(A)')'</b></center></td>'
         write(6,'(A)')'</tr>'
         write(6,'(A)')'<tr>'
         write(6,'(A)')'<td>'
         write(6,'(A,F10.5,A)')'<center>',avedev(i),
     &   '</center></td>'
         write(6,'(A)')'<td>'
         write(6,'(A,F10.2,A)')'<center>',sd_dev(i),'</center>'
         write(6,'(A)')'</td>'
         write(6,'(A)')'</tr>'
         write(6,'(A)')'</table>'
      enddo

C---- Result table for your sequence
      write(6,'(A)')'<p><hr WIDTH="100%"><br><font size=+1><center>'
      write(6,'(A)')'Results for your sequence:'
      write(6,'(A)')'<font color="#663366">',label(1:llabel),'</font>'
      write(6,'(A)')'<br><font size=-1>(See color significance '
      write(6,'(A)')'and output explanation at the end of the page)'
      write(6,'(A)')'</font>'
      write(6,'(A)')'<hr><p>'
      do i=2,4
         write(6,'(A)')'<p>'
         write(6,'(A,I1,A)')'Results over ',i,
     &   ' residues table: <br>'
         write(6,'(A)')'<p>'
         write(6,'(2A)')'<table CELLSPACING=0 COLS=100 ',
     &                  'WIDTH="100%" NOSAVE>'
         write(6,'(A)')'<tr NOSAVE>'

C---- Clean some variables used in previous loop         
	 k = 0
         nnn = 0
         avediff = 0
         avez_score = 0

C---- Calculate z-scores residue by residue
         do j=1,lsequence-(i-1)
            k = k + 1
	    detseq = cleanseq(j:j+4)
	    call num_seq(detseq,i,number)
	    if (resp1 .ne. 1) then
               read(10+i,300,REC=number,ERR=1100)
     &                   n_esp(i,number),n_calc(i,number)
            endif
	    if (n_calc(i,number) .eq. 0.0) n_calc(i,number) = 0.9
	    dev = log10(n_calc(i,number)) - log10(n_esp(i,number))
            diff  = n_calc(i,number) - n_esp(i,number)
	    z_score = dev - avedev(i)
            z_score = z_score/sd_dev(i)
	    az_score  = abs(z_score)
            avez_score = avez_score + az_score
            avediff = avediff + diff

C---- Calculate Best and worst Z-score
	    if (z_score .gt. best_zs(i)) then
	       best_zs(i) = z_score
	       seq_best_zs(i) = detseq(1:i)
            endif
	    if (z_score .lt. worst_zs(i)) then
	       worst_zs(i) = z_score
	       seq_worst_zs(i) = detseq(1:i)
            endif
	    
C---- Calculate individual bgcolor            
	    if (diff .lt. 0 .and. az_score .gt. 2.33) then
               write(6,'(A)')'<td BGCOLOR="#FF0000">&nbsp;</td>'
	       indev(i,1) = indev(i,1) + 1
            else if (diff .lt. 0 .and. az_score .gt. 1.65) then
               write(6,'(A)')'<td BGCOLOR="#FF6666">&nbsp;</td>'
	       indev(i,2) = indev(i,2) + 1
            else if (diff .lt. 0 .and. az_score .gt. 1.28) then
               write(6,'(A)')'<td BGCOLOR="#FFCCCC">&nbsp;</td>'
	       indev(i,3) = indev(i,3) + 1
            else if (diff .gt. 0 .and. az_score .gt. 2.33) then
               write(6,'(A)')'<td BGCOLOR="#33FF33">&nbsp;</td>'
	       indev(i,7) = indev(i,7) + 1
            else if (diff .gt. 0 .and. az_score .gt. 1.65) then
               write(6,'(A)')'<td BGCOLOR="#66FF99">&nbsp;</td>'
	       indev(i,6) = indev(i,6) + 1
            else if (diff .gt. 0 .and. az_score .gt. 1.28) then
               write(6,'(A)')'<td BGCOLOR="#99FFCC">&nbsp;</td>'
	       indev(i,5) = indev(i,5) + 1
            else 
               write(6,'(A)')'<td BGCOLOR="#CCCCCC">&nbsp;</td>'
	       indev(i,4) = indev(i,4) + 1
	    endif

C---- Write sequence and number
            if (k .eq. 100 .or. j .eq. lsequence-(i-1)) then
	       nn = 0
               if (j .eq. lsequence-(i-1)) then
		  nn = lsequence-(i-1) - nnn*100 - 1
               else 
		  nn = 99
		  nnn = nnn + 1
               endif
	       write(6,'(A)')'</tr>'
               write(6,'(A)')'<tr>'
               do kk=j-nn,j
                  write(6,'(A,A1,A)')'<td><font size=-2>',
     &                     cleanseq(kk:kk),'</font></td>'
               enddo
               write(6,'(A)')'</tr>'
               write(6,'(A)')'<tr>'
               kkk = 0
               do kk=j-nn,j
                  kkk = kkk + 1
                  if (kkk .eq. 5) then 
                     write(6,'(A,I4,A)')'<td><font size=-2>',
     &                                  kk,'</font></td>'
                     kkk = 0
                  else
                     write(6,'(A)')'<td><font size=-2> - </font></td>'
                  endif
               enddo
               write(6,'(A)')'</tr>'
               write(6,'(A)')'<tr>'
               k = 0
            endif
         enddo

C---- Calculate average differences and Z scores
         avez_score = avez_score/(lsequence - (i-1))
         avediff = avediff/(lsequence - (i-1))
         aavez_score = abs(avez_score)

C---- Calculate bgcolor for average sequence
         if (avediff .lt. 0 .and. aavez_score .gt. 2.33) then
	    bgcolor = '#FF0000'
            sig = 'sig 0.01'
         else if (avediff .lt. 0 .and. aavez_score .gt. 1.65) then
	    bgcolor = '#FF6666'
            sig = 'sig 0.05'
         else if (avediff .lt. 0 .and. aavez_score .gt. 1.28) then
	    bgcolor = '#FFCCCC'
            sig = 'sig 0.10'
         else if (avediff .gt. 0 .and. aavez_score .gt. 2.33) then
	    bgcolor = '#33FF33'
            sig = 'sig 0.01'
         else if (avediff .gt. 0 .and. aavez_score .gt. 1.65) then
	    bgcolor = '#66FF99'
            sig = 'sig 0.05'
         else if (avediff .gt. 0 .and. aavez_score .gt. 1.28) then
	    bgcolor = '#99FFCC'
            sig = 'sig 0.10'
         else 
	    bgcolor = '#CCCCCC'
            sig = 'No sig  '
         endif
         write(6,'(A)')'</table>'
         write(6,'(A)')'<p>'
         write(6,'(4A)')'<table BGCOLOR="',bgcolor,'" BORDER COLS=1 ',
     &   'WIDTH="100%" NOSAVE >'
         write(6,'(A)')'<tr><td>'
         write(6,'(A)')'<center>'
         write(6,'(A,F8.2,A,I1,3A)')'Average Z score for your seq:',
     &   avez_score,' against ',i,' residues table [',sig,']'
         write(6,'(A)')'</center>'
         write(6,'(A)')'</td></tr>'
         write(6,'(A)')'</table>'

C---- Write distribution of z-scores in your sequence
         write(6,'(A)')'<p><br>Distribution of z-scores:'
         write(6,'(A)')'<table CELLSPACING=0 OLS=2 WIDTH="100%">'
         write(6,'(A)')'<tr><td>'
         write(6,'(A)')'<b> Your sequence </b></td><td>'
         write(6,'(A)')'<b> Random sequences </b></td>'
         write(6,'(A)')'</tr>'
         write(6,'(A)')'<tr><td>'
         do j=1,7
            if(j .eq. 1) then
               bgcolor = '#FF0000'
               case = 'Low represented  (0.01 sig)'
            endif
            if(j .eq. 2) then
               bgcolor = '#FF6666'
               case = 'Low represented  (0.05 sig)'
            endif
            if(j .eq. 3) then
               bgcolor = '#FFCCCC'
               case = 'Low represented  (0.10 sig)'
            endif
            if(j .eq. 4) then
               bgcolor = '#CCCCCC'
               case = 'Normal represented         '
            endif
            if(j .eq. 5) then
               bgcolor = '#99FFCC'
               case = 'High represented (0.10 sig)'
            endif
            if(j .eq. 6) then
               bgcolor = '#66FF99'
               case = 'High represented (0.05 sig)'
            endif
            if(j .eq. 7) then
               bgcolor = '#33FF33'
               case = 'High represented (0.01 sig)'
            endif
            col = indev(i,j)*200/(lsequence-i)
            if (indev(i,j) .eq. 0) then
	       per = 0.0
            else
	       per = indev(i,j)*100/(lsequence-i)
            endif
            write(6,'(A)')'<table BORDER=0 NOSAVE >'
            write(6,'(A)')'<tr NOSAVE><td WIDTH="200" NOSAVE>'
            write(6,'(3A)')'<div align=right><font size=-1>',
     &      case,'</font></div></td>'
            write(6,'(A,F4.0,3A)')'<td WIDTH="',col,
     &           '" BGCOLOR="',bgcolor,
     &           '" NOSAVE><font size=-1>&nbsp;</font></td>'
            write(6,'(A,F6.1,A,I6,A)')'<td><font size=-1>',per,
     &           '% (',indev(i,j),' seq)</font></td></tr></table>'
         enddo
         write(6,'(A)')'<table BORDER=0 NOSAVE >'
         write(6,'(A)')'<tr NOSAVE><td WIDTH="200" NOSAVE>'
         write(6,'(2A)')'<div align=right><font size=-1>',
     &   'Best Z-score: </font></div></td>'
         write(6,'(A,F6.1,3A)')'<td><font size=-1>',best_zs(i),
     &        ' of sequence: ',seq_best_zs(i),'</font></td></tr>'
         write(6,'(2A)')'<tr><td><div align=right><font size=-1>',
     &        'Worst Z-score:</font></div></td>'
         write(6,'(A,F6.1,3A)')'<td><font size=-1>',worst_zs(i),
     &   ' of sequence: ',seq_worst_zs(i),'</font></td></tr>'
         write(6,'(2A)')'<tr><td><div align=right><font size=-1>',
     &        'Median Z-score:</font></div></td>'
         write(6,'(A,F6.1,A)')'<td><font size=-1>',
     &        (worst_zs(i)+best_zs(i))/2,'</font></td></tr></table>'
         write(6,'(A)')'</td>'

C---- Write distribution of random z-scores
         write(6,'(A)')'<td>'
         do j=1,7
            if(j .eq. 1) then
               bgcolor = '#FF0000'
               case = 'Low represented  (0.01 sig)'
            endif
            if(j .eq. 2) then
               bgcolor = '#FF6666'
               case = 'Low represented  (0.05 sig)'
            endif
            if(j .eq. 3) then
               bgcolor = '#FFCCCC'
               case = 'Low represented  (0.10 sig)'
            endif
            if(j .eq. 4) then
               bgcolor = '#CCCCCC'
               case = 'Normal represented         '
            endif
            if(j .eq. 5) then
               bgcolor = '#99FFCC'
               case = 'High represented (0.10 sig)'
            endif
            if(j .eq. 6) then
               bgcolor = '#66FF99'
               case = 'High represented (0.05 sig)'
            endif
            if(j .eq. 7) then
               bgcolor = '#33FF33'
               case = 'High represented (0.01 sig)'
            endif
	    col = dev_ran(i,j)*200/(lsequence-i)
            if (indev(i,j) .eq. 0) then
               per = 0.0
            else
               per = dev_ran(i,j)*100/(lsequence-i)
            endif
            write(6,'(A)')'<table BORDER=0 NOSAVE >'
            write(6,'(A)')'<tr NOSAVE><td WIDTH="200" NOSAVE>'
            write(6,'(3A)')'<div align=right><font size=-1>',
     &      case,'</font></div></td>'
            write(6,'(A,F4.0,3A)')'<td WIDTH="',col,
     &           '" BGCOLOR="',bgcolor,
     &           '" NOSAVE><font size=-1>&nbsp;</font></td>'
            write(6,'(A,F6.1,A,F6.1,A)')'<td><font size=-1>',per,
     &           '% (',dev_ran(i,j),' seq)</font></td></tr></table>'
         enddo
         write(6,'(A)')'<table BORDER=0 NOSAVE >'
         write(6,'(A)')'<tr NOSAVE><td WIDTH="200" NOSAVE>'
         write(6,'(2A)')'<div align=right><font size=-1>',
     &   'Best Z-score: </font></div></td>'
         write(6,'(A,F6.1,3A)')'<td><font size=-1>',r_best_zs(i),
     &        ' of sequence: ',r_seq_best_zs(i),'</font></td></tr>'
         write(6,'(2A)')'<tr><td><div align=right><font size=-1>',
     &        'Worst Z-score:</font></div></td>'
         write(6,'(A,F6.1,3A)')'<td><font size=-1>',r_worst_zs(i),
     &   ' of sequence: ',r_seq_worst_zs(i),'</font></td></tr>'
         write(6,'(2A)')'<tr><td><div align=right><font size=-1>',
     &        'Median Z-score:</font></div></td>'
         write(6,'(A,F6.1,A)')'<td><font size=-1>',
     &        (r_worst_zs(i)+r_best_zs(i))/2,'</font></td></tr></table>'
         write(6,'(A)')'</td>'
         write(6,'(A)')'</td></tr></table>'
         write(6,'(A)')'<hr><p>'
C---- End of aminoacid-loop
      enddo

C---- Color significance
      write(6,'(A)')'<hr><p>'
      write(6,'(2A)')'<font color="#000000"><font size=+0>Color ',
     &'significance:</font></font></h1>'
      write(6,'(A)')'<table COLS=7 WIDTH="100%" NOSAVE >'
      write(6,'(A)')'<tr NOSAVE><td BGCOLOR="#FF0000" NOSAVE>' 
      write(6,'(A)')'<center>Low represented (0.01 sig)</td>'
      write(6,'(A)')'<td BGCOLOR="#FF6666" NOSAVE>'
      write(6,'(A)')'<center>Low represented (0.05 sig)</td>'
      write(6,'(A)')'<td BGCOLOR="#FFCCCC" NOSAVE>'
      write(6,'(A)')'<center>Low represented (0.10 sig)</td>'
      write(6,'(A)')'<td BGCOLOR="#CCCCCC" NOSAVE>'
      write(6,'(A)')'<center>Normal represented <center></td>'
      write(6,'(A)')'<td BGCOLOR="#99FFCC" NOSAVE>'
      write(6,'(A)')'<center>High represented (0.10 sig)</td>'
      write(6,'(A)')'<td BGCOLOR="#66FF99" NOSAVE>'
      write(6,'(A)')'<center>High represented (0.05 sig)</td>'
      write(6,'(A)')'<td BGCOLOR="#33FF33" NOSAVE>'
      write(6,'(A)')'<center>High represented (0.01 sig)</td>'
      write(6,'(A)')'</tr>'
      write(6,'(A)')'</table><p>'
      write(6,'(A)')'<font size=+0>All individual z-scores are '
      write(6,'(A)')'for the residue (i) and consecutive i+n residues'
      write(6,'(A)')'(where n is 2, 3 or 4 depending on the table of'
      write(6,'(A)')'comparison).<br>'

C---- date and run time
      write(6,*)'<hr WIDTH="100%"><br>'
      call dattim(6)
      call porcpu(cputime)
      write(6,*)'<p>CPU-TIME nim.',cputime/60.d0
      write(6,'(A)')'<p>END SEARCH<br><hr WIDTH="100%"></body></html>'

C---- HTML Footer
      do while (.true.)
         read(8,'(Q,A)',END=240,ERR=1000)lline,line
         write(6,'(A)')line(1:lline)
      enddo
240   continue

      goto 999

C******************* Errors and formats ******************************

1000  write(6,'(A)')'Content-type: html/text\n'
      write(6,'(A)')'WARNNING!!! Error in input file.'
      stop
1100  write(6,'(A)')'Content-type: html/text\n'
      write(6,'(A)')'WARNNING!!! Error in reference file.'
      write(6,'(A)')'Please send a Mail to the webmaster.'
      write(6,'(A,I)')'Error in unit file: ',i+10
      stop

110   FORMAT(15X,A)
130   FORMAT(X)
300   FORMAT(1X,F9.2,3X,F7.0)
310   FORMAT(I4,3X,3(3X,F5.2),3X,I1)

C******************* End of the program ******************************
999   continue
      end

C******************* Subrrutines *************************************

C---------------------------------------------------------------------
C---- NUM_SEQ
      subroutine num_seq(testseq,lseq,num)
C---------------------------------------------------------------------

      character testseq
      integer num,lseq,num_aa

      num = 0
      
      do j=1,lseq
	 if (testseq(j:j) .eq. 'A') num_aa = 0
	 if (testseq(j:j) .eq. 'C') num_aa = 1
	 if (testseq(j:j) .eq. 'D') num_aa = 2
	 if (testseq(j:j) .eq. 'E') num_aa = 3
	 if (testseq(j:j) .eq. 'F') num_aa = 4
	 if (testseq(j:j) .eq. 'G') num_aa = 5
	 if (testseq(j:j) .eq. 'H') num_aa = 6
	 if (testseq(j:j) .eq. 'I') num_aa = 7
	 if (testseq(j:j) .eq. 'K') num_aa = 8
	 if (testseq(j:j) .eq. 'L') num_aa = 9
	 if (testseq(j:j) .eq. 'M') num_aa = 10
	 if (testseq(j:j) .eq. 'N') num_aa = 11
	 if (testseq(j:j) .eq. 'P') num_aa = 12
	 if (testseq(j:j) .eq. 'Q') num_aa = 13
	 if (testseq(j:j) .eq. 'R') num_aa = 14
	 if (testseq(j:j) .eq. 'S') num_aa = 15
	 if (testseq(j:j) .eq. 'T') num_aa = 16
	 if (testseq(j:j) .eq. 'V') num_aa = 17
	 if (testseq(j:j) .eq. 'W') num_aa = 18
	 if (testseq(j:j) .eq. 'Y') num_aa = 19
	 num = num + (num_aa*(20**(lseq-j)))
      enddo
      num = num + 1
      return
      end

C---------------------------------------------------------------------
C---- IRAN1 Generates random numbers not identical between jhi and jlw
      subroutine iran1(idum,jlo,jhi,iran)
C---------------------------------------------------------------------
      
      integer ia,ic,idum,im,jhi,jlo,iran2
      parameter (ia=8121)
      parameter (ic=28411)
      parameter (im=134456)
      parameter (max=3000)
      dimension iran(max)
      
      do n=1,jhi
2000     continue
         idum = mod(idum*ia+ic,im)
         iran(n) = abs(jlo + ((jhi-jlo+1)*idum)/im)
         do nn=1,n-1
            if(iran(nn) .eq. iran(n)) goto 2000
         enddo
C         write (6,*)iran(n),n
      enddo
      return
      end
C-----------------------------------------------------------------------
C---- PORCPU Calculates CPU time
      subroutine porcpu(t1)
C-----------------------------------------------------------------------

      implicit double precision (a-h,o-z)
      external etime
      real time(2)

      T0 = etime(time)
      T1 = time(1) + time(2)

      return
      end
C---------------------------------------------------------------------
C---- DATTIM data and time of the process
      subroutine dattim(io)
C-----------------------------------------------------------------------

      implicit double precision (a-h,o-z)
      character cdate*9,ctime*8

      call date(cdate)
      call time(ctime)
      write(6,1100)cdate,ctime

      return

1100  FORMAT(1X,'date ',A9,3X,' time ',A8)

      end
C-----------------------------------------------------------------------
