#!/usr/local/bin/perl
use CGI qw/:standard/;

############################################
##                                        ##
##               Gener perl               ##
##              ASAP Programs             ##
##           by Marc A Marti              ##
## e-mail marcius@guitar.rockefeller.edu  ##
##                                        ##
##             version:  1.0              ##
##         last modified: 27/05/98        ##
##                                        ##
############################################

# Cleaning all tmp files that has been more than one day in the server
system ("find ../GenerNet/tmp/*.txt -mtime +1 -exec rm {} \;");

# Initialize
$Used_pl     = "GenerNet";
$header_file = "../GenerNet/xtras/header.txt";
$footer_file = "../GenerNet/xtras/footer.txt";
$log_file    = "../GenerNet/xtras/gener.log";
$time        = localtime;

# Get parameters from HTML input
$file = param('inputfile');

# Checking input from HTML
if (!$file) {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter a file and try again </H1>\n";
   &Footer("Search Results");
   exit;
}

# Executing programs & printing output
open(INP, "| ../GenerNet/bin/gener-net") || die ("Can't open output file\n");
print INP "$$.\n";
print INP "$file\n";
while (<$file>) {
   print INP $_;
}
close INP;
wait;

# Write log file with several information about use of SeqDetNet
&Writelogfile;

# End of perl
exit;

# Functions

sub Header {
        if ($header_file) {
                open (HEADER,"$header_file");
                @header = <HEADER>;
                close (HEADER);
                foreach $line (@header) {
                        print "$line";
                }
        }
}

sub Footer {
        if ($footer_file) {
                open (FOOTER,"<$footer_file");
                @footer = <FOOTER>;
                close (FOOTER);
                foreach $line (@footer) {
                        print "$line";
                }
        }
}

sub Writelogfile {
        # Geting remote information
        $remote_host = remote_host();
        $remote_addr = remote_addr();
        $remote_user = remote_user();

        # Writting
        open (LOG, ">>$log_file");
        print LOG "---------------------------------------->>\n";
        print LOG "New user for $Used_pl\n";
        print LOG "Date: $time\n";
        print LOG "Num user: $numusuari\n";
        print LOG "Remote host: $remote_host\n";
        print LOG "Remote address: $remote_addr\n";
        print LOG "Remote user: $remote_user\n";
        print LOG "<<----------------------------------------\n";
        print LOG "\n";
        close (LOG);
}

