#!/usr/local/bin/perl
use CGI qw/:standard/;

############################################
##                                        ##
##               ClonErr perl             ##
##           by Marc A Marti              ##
## e-mail marcius@guitar.rockefeller.edu  ##
##                                        ##
##             version:  1.0              ##
##         last modified: 27/05/98        ##
##                                        ##
############################################

# Initialize
$Used_pl     = "ClonErrNet";
$header_file = "../ClonErrNet/xtras/header.txt";
$footer_file = "../ClonErrNet/xtras/footer.txt";
$log_file    = "../ClonErrNet/xtras/clonerr.log";
$time        = localtime;

# Get parameters from HTML input
$label = param('label');
$seq   = param('seq');
$dbinp = param('db');
$file2 = param('inputfile2');
$file3 = param('inputfile3');
$file4 = param('inputfile4');

if ($dbinp eq "Your own DB") {
   $db = 1;
}
if ($dbinp eq "S. cerevisiae") {
   $db = 2;
}
if ($dbinp eq "E. coli") {
   $db = 3;
}

# Checking input from HTML
if ($db eq "") {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter a DATA BASE and try again </H1>\n";
   &Footer("Search Results");
   exit;
}
if ($seq eq "") {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter the SEQUENCE and try again </H1>\n";
   &Footer("Search Results");
   exit;
}
if ($db eq 1 and !$file2) {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter the TWO RESIDUE TABLE file and try again </H1>\n";
   &Footer("Search Results");
   exit;
}
if ($db eq 1 and !$file3) {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter the THREE RESIDUE TABLE file and try again </H1>\n";
   &Footer("Search Results");
   exit;
}
if ($db eq 1 and !$file4) {
   &Header("Search Results");
   print "<H1 ALIGN=CENTER>Enter the FOUR RESIDUE TABLE file and try again </H1>\n";
   &Footer("Search Results");
   exit;
}

# HTML output
# Printing  & Executing programs
open(INP, "| ../ClonErrNet/bin/clonerr-net") || die ("Can't open output file\n");
print INP "$db\n";
print INP "$label\n";
print INP "$seq*\n";
if ($db eq 1) {
   while (<$file2>) {
      print INP $_;
   }
   while (<$file3>) {
      print INP $_;
   }
   while (<$file4>) {
      print INP $_;
   }
}
close (INP);
wait;

# Write log file with several information about use of SeqDetNet
&Writelogfile;

# End of perl
exit;

# Functions

sub Header {
        if ($header_file) {
                open (HEADER,"$header_file");
                @header = <HEADER>;
                close (HEADER);
                foreach $line (@header) {
                        print "$line";
                }
        }
}

sub Footer {
        if ($footer_file) {
                open (FOOTER,"<$footer_file");
                @footer = <FOOTER>;
                close (FOOTER);
                foreach $line (@footer) {
                        print "$line";
                }
        }
}

sub Writelogfile {
        # Geting remote information
        $remote_host = remote_host();
        $remote_addr = remote_addr();
        $remote_user = remote_user();

        # Writting
        open (LOG, ">>$log_file");
        print LOG "---------------------------------------->>\n";
        print LOG "New user for $Used_pl\n";
        print LOG "Date: $time\n";
        print LOG "Num user: $numusuari\n";
        print LOG "Remote host: $remote_host\n";
        print LOG "Remote address: $remote_addr\n";
        print LOG "Remote user: $remote_user\n";
        print LOG "<<----------------------------------------\n";
        print LOG "\n";
        close (LOG);
}

