cf ----------------------------------------------------------------------------
cf
cf    ORTHOG() will re-normalize a 3D rotation matrix to remove small problems.
cf    This routine is modelled on that from RESTRAIN Ver 12.
cf
cf    subroutine orthog(rm)
cf
cf ----------------------------------------------------------------------------

      subroutine orthog(rm)
c
c     THIS SUBROUTINE CHECKS DETERMINANT OF 3*3 ORTHOGONAL ROTATION
c     MATRIX AND RENORMALISES
c     THE CHECKING CAN BE BYPASSED BY CALLING ENTRY RENORM
c
      implicit none
      real small
      parameter (small = 1.0E-4)
      integer i,j,k,ifail,nrot
      real rm(3,3),s(3,3),t(3,3),rsq(3),csq(3),detrm,temp
      real a(3,3),d(3),v(3,3)

c      real aa(3,3)
c      do  i = 1, 3
c        do  j = 1, 3
c          aa(i,j) = rm(i,j)
c        end do
c      end do

c
c   COMPUTE DETERMINANT OF A 3*3 MATRIX
c
      detrm=      rm(1,1)*rm(2,2)*rm(3,3)
      detrm=detrm+rm(2,1)*rm(3,2)*rm(1,3)
      detrm=detrm+rm(1,2)*rm(2,3)*rm(3,1)
      detrm=detrm-rm(3,1)*rm(2,2)*rm(1,3)
      detrm=detrm-rm(2,1)*rm(1,2)*rm(3,3)
      detrm=detrm-rm(3,2)*rm(2,3)*rm(1,1)
C
C   DETERMINE MATRIX ELEMENT CAUSING ORTHOGONALITY ERROR
C
      if (abs(detrm-1.00000).gt.small) then
        write(*,900) detrm,((rm(i,j),j=1,3),i=1,3)
900     format(//'Determinant ',f10.5,' for rotation matrix :'//
     &           3(3x,3f8.4/))
C
        rsq(1)=rm(1,1)*rm(1,1)+rm(1,2)*rm(1,2)+rm(1,3)*rm(1,3)
        rsq(2)=rm(2,1)*rm(2,1)+rm(2,2)*rm(2,2)+rm(2,3)*rm(2,3)
        rsq(3)=rm(3,1)*rm(3,1)+rm(3,2)*rm(3,2)+rm(3,3)*rm(3,3)
        csq(1)=rm(1,1)*rm(1,1)+rm(2,1)*rm(2,1)+rm(3,1)*rm(3,1)
        csq(2)=rm(1,2)*rm(1,2)+rm(2,2)*rm(2,2)+rm(3,2)*rm(3,2)
        csq(3)=rm(1,3)*rm(1,3)+rm(2,3)*rm(2,3)+rm(3,3)*rm(3,3)
C
        write(*,905)
905     format(1x,t2,'matrix element',t20,'sum of squares for row',
     &            t48,'sum of squares for column'/)

        do 920 i=1,3
          do 930 j=1,3
            if (abs(rsq(i)-1.00000).gt.small.and.
     &          abs(csq(j)-1.00000).gt.small) then
              write(*,940) i,j,rsq(i),csq(j)
940           format(1x,t6,i2,',',i2,t26,f10.5,t54,f10.5)
            endif
930       continue
920     continue
C
        write(*,950)
950     format(/'Error[orthog]: orthogonality error in rotation matrix'
     &          ,' - check if serious')
      endif
C
      entry renorm(rm)
C
C     NORMALISE 3*3 ROTATION MATRIX
C
C---FORM (A)=(RM).(RM-TRANSPOSE)
C
      do 1055 i=1,3
        do 1050 j=1,3
          a(i,j)=0.0
          do 1060 k=1,3
            a(i,j)=a(i,j)+rm(i,k)*rm(j,k)
1060      continue
1050    continue
1055  continue
C
C---DETERMINE EIGENVALUES AND EIGENVECTORS OF REAL SYMMETRIC MATRIX A
C
      call jacob2(a,3,3,d,v,ifail,nrot)
      if (ifail.eq.1) then
        write(*,830) ((rm(i,j),j=1,3),i=1,3)
830     format(//' For rotation matrix :'//
     &           3(3x,3f8.4/))
        write(*,840)
840     format(/'Error[orthog]: more than 50*3(3-1)/2 rotats in JACOBI'
     &          ,' should never happen - run terminated.')
        stop
      endif
C
C---DETERMINE (EIGENVALUES)**(-1/2)
C
      d(1)=1.0/sqrt(max(d(1),1.0e-12))
      d(2)=1.0/sqrt(max(d(2),1.0e-12))
      d(3)=1.0/sqrt(max(d(3),1.0e-12))
C
C---FORM (RM-RENORM)=(V).D.(V-TRANSPOSE).(RM)
C
C---(S)=(V).D
      do 970 i=1,3
        do 965 j=1,3
          s(i,j)=v(i,j)*d(j)
965     continue
970   continue

C---(T)=(V-TRANSPOSE).(RM)
      do 980 i=2,3
        do 975 j=1,i-1
          temp=v(i,j)
          v(i,j)=v(j,i)
          v(j,i)=temp
975     continue
980   continue
C
      do 990 i=1,3
        do 985 j=1,3
          temp=0.0
          do 983 k=1,3
            temp=temp+v(i,k)*rm(k,j)
983       continue
          t(i,j)=temp
985     continue
990   continue

C---(RM-RENORM)=(S).(T)
      do 1015 i=1,3
        do 1010 j=1,3
          temp=0.0
          do 1020 k=1,3
            temp=temp+s(i,k)*t(k,j)
1020      continue
          rm(i,j)=temp
1010    continue
1015  continue
C

c      do  i = 1, 3
c        write(*,*) ((rm(i,j)-aa(i,j)),j=1,3)
c      end do

      return
      end


cf ----------------------------------------------------------------------------
cf
cf    JACOB2() will calculate a Jacobian of a matrix. This routine is from 
cf    Numerical Recipes (Press et al., 1986).
cf
cf    subroutine jacob2(a,n,np,d,v,ifail,nrot)
cf
cf ----------------------------------------------------------------------------

      subroutine jacob2(a,n,np,d,v,ifail,nrot)
      implicit none
C
C     THIS SUBROUTINE COMPUTES ALL EIGENVALUES AND VECTORS OF A REAL
C     SYMMETRIC MATRIX A USING THE JACOBI METHOD
C
C     PARAMETERS:
C
C     A     = REAL SYMMETRIC MATRIX, WHICH IS OF SIZE N BY N, STORED IN
C             A PHYSICAL NP BY NP ARRAY. ON EXIT, ELEMENTS OF A ABOVE
C             THE DIAGONAL ARE DESTROYED.
C     N     = ON ENTRY, ORDER OF MATRIX A FOR WHICH COMPUTATIONS ARE
C             DONE. UNCHANGED ON EXIT.
C     NP    = PHYSICAL ARRAY SUBSCRIPTS OF MATRIX A. UNCHANGED ON EXIT.
C     D     = REAL ARRAY OF PHYSICAL DIMENSION NP WHICH, ON EXIT,
C             CONTAINS EIGENVALUES OF A IN ITS FIRST N ELEMENTS.
C     V     = REAL MATRIX WITH THE SAME LOGICAL AND PHYSICAL DIMENSIONS
C             AS A WHOSE COLUMNS CONTAIN, ON EXIT, THE NORMALIZED
C             EIGENVECTORS OF A.
C     IFAIL = FAILURE INDICATOR. THIS IS SET TO 0 FOR NORMAL RETURN, AND
C             TO 1 WHEN MORE THAN 50 * N(N-1)/2 ROTATIONS ARE NEEDED.
C     NROT  = COUNTER WHICH, ON EXIT, CONTAINS THE NUMBER OF ROTATIONS.
C
C     DURING COMPUTATION:
C
C     Z    = VECTOR WHICH ACCUMULATES TERMS OF FORM TA(PQ)
C     B    = VECTOR WHICH CONTAINS CURRENT EIGENVALUES OF A
C
C     OPERATION COUNT:
C
C     TYPICAL MATRICES REQUIRE 6 TO 10 SWEEPS OF N*(N-1)/2 JACOBI
C     ROTATIONS TO ACHIEVE CONVERGENCE, OR 3*N**2 TO 5*N**2
C     ROTATIONS. EACH ROTATION REQUIRES OF ORDER 6*N OPERATIONS, SO
C     THE TOTAL LABOR IS OF THE ORDER 18*N**3 TO 30*N**3.
C
C
      integer nmax
      parameter (nmax=100)
      integer ifail,ip,iq,i,j,n,np,nrot
      real c,g,h,s,sm,t,tau,theta,tresh
      real a(np,np),d(np),v(np,np),b(nmax),z(nmax)
      ifail=0
C
C   JACOBI METHOD NOT MOST EFFICIENT METHOD FOR MATRICES OF ORDER
C   GREATER THAN 10 ; MAXIMUM ALLOWED PRESET BY NMAX
C
      if (n.gt.nmax) then
      write(*,10)
10    format(/'Error[JACOBI]: max numb of elements exceeded in routine '
     &       ,' JACOBI; change NMAX - run terminated.')
      stop
      endif
C
C   INITIALISE V TO THE IDENTITY MATRIX
C
      do 12 ip=1,n
      do 11 iq=1,n
      v(ip,iq)=0.0
11    continue
      v(ip,ip)=1.0
12    continue
C
C   INITIALISE B AND D TO THE DIAGONAL OF A AND Z TO 0.0
C
      do 13 ip=1,n
      b(ip)=a(ip,ip)
      d(ip)=b(ip)
      z(ip)=0.0
13    continue
C
C   START OF SWEEPS
C
      nrot=0
      do 24 i=1,50
C
C---SUM OFF-DIAGONAL ELEMENTS OF MATRIX A
C
      sm=0.0
      do 15 ip=1,n-1
      do 14 iq=ip+1,n
      sm=sm+abs(a(ip,iq))
 14   continue
 15   continue
C
C---NORMAL RETURN ON QUADRATIC CONVERGENCE TO MACHINE UNDERFLOW
C
      if (sm.eq.0.0) return
C
C---SET TRESHOLD
C
C---ON THE FIRST THREE SWEEPS
      if (i.lt.4) then
      tresh=0.2*sm/n**2
      else
C---THEREAFTER
      tresh=0.0
      endif
C
C---PERFORM PQ ROTATIONS
C
      do 22 ip=1,n-1
      do 21 iq=ip+1,n
      g=100.0*abs(a(ip,iq))
C---AFTER 4 SWEEPS, SKIP ROTATION IF THE OFF-DIAGONAL ELEMENT IS SMALL
      if ( (i.gt.4) .and. (abs(d(ip))+g.eq.abs(d(ip)))
     &              .and. (abs(d(iq))+g.eq.abs(d(iq))) ) then
      a(ip,iq)=0.0
C---OTHERWISE ROTATE DEPENDENT ON THE TRESHOLD
      else if (abs(a(ip,iq)).gt.tresh) then
      h=d(iq)-d(ip)
      if (abs(h)+g.eq.abs(h)) then
C   T=1/(2THETA)
      t=a(ip,iq)/h
      else
C   T=SIGN(THETA) / (ABS(THETA)+ SQRT(THETA**2 + 1))
      theta=0.5*h/a(ip,iq)
      t=1.0/(abs(theta)+sqrt(1.0+theta**2))
      if (theta.lt.0.0) t=-t
      endif
      c=1.0/sqrt(1+t**2)
      s=t*c
      tau=s/(1.0+c)
      h=t*a(ip,iq)
      z(ip)=z(ip)-h
      z(iq)=z(iq)+h
      d(ip)=d(ip)-h
      d(iq)=d(iq)+h
      a(ip,iq)=0.0
C   CASE OF ROTATIONS 1.LE.J.LT.P
      do 16 j=1,ip-1
      g=a(j,ip)
      h=a(j,iq)
      a(j,ip)=g-s*(h+g*tau)
      a(j,iq)=h+s*(g-h*tau)
16    continue
C   CASE OF ROTATIONS P.LT.J.LT.Q
      do 17 j=ip+1,iq-1
      g=a(ip,j)
      h=a(j,iq)
      a(ip,j)=g-s*(h+g*tau)
      a(j,iq)=h+s*(g-h*tau)
17    continue
C   CASE OF ROTATIONS Q.LT.J.LE.N
      do 18 j=iq+1,n
      g=a(ip,j)
      h=a(iq,j)
      a(ip,j)=g-s*(h+g*tau)
      a(iq,j)=h+s*(g-h*tau)
18    continue
      do 19 j=1,n
      g=v(j,ip)
      h=v(j,iq)
      v(j,ip)=g-s*(h+g*tau)
      v(j,iq)=h+s*(g-h*tau)
19    continue
      nrot=nrot+1
      endif
21    continue
22    continue
C
C---END OF PQ ROTATIONS
C
C
C---UPDATE D WITH THE SUM OF TA(PQ) AND REINITIALIZE Z TO 0.0
C
        do ip=1,n
          b(ip)=b(ip)+z(ip)
          d(ip)=b(ip)
          z(ip)=0.0
        end do
24    continue
C
C   END OF SWEEPS
C
C---ABNORMAL RETURN; 50 SWEEPS IN JACOBI SHOULD NEVER HAPPEN
C
      ifail=1
      return
      end
