cf ----------------------------------------------------------------------------
cf
cf    INITMDTDAT() initializes the MDT system for constructing
cf    the MDT pdf: it reads the mdt1.ini and mdt1.bin files.
cf    It is also called when using MDTs.
cf
cf    subroutine initmdtdat
cf
cf ----------------------------------------------------------------------------

      subroutine initmdtdat
      implicit none
#include "io.cst"
#include "mdt_all.cmn"
      integer i
      logical iowr

c --- default decimal places to be taken care of by the code in rdini():
      do  i = 1, maxfeats
        ndecpl(i) = 0
      end do

c --- read feature library file containing data about feature types
      call rdini

c --- dimensions and bins file:
      call rdbin(ioinp,iolog,binfil,ndimen,maxfeats,maxrng,symb1,symb2,
     &           featnam,rang1,rang2,ndecpl,itsymb,nrescls(iselgrp),
     &           nmnch2,mnchcls)

c --- get the function forms for the distance calculations:

c --- Distance type 1:
      idstyp1 = 1
c --- these will caculate the closest atom-atom distance where the atoms
c     are selected from the specified atom sets:
      if ((index(dstatm(1),'SDCH') .gt. 0) .and.
     &    (index(dstatm(2),'SDCH') .gt. 0)) idstyp1 = 2
      if ((index(dstatm(1),'MNCH') .gt. 0) .and.
     &    (index(dstatm(2),'MNCH') .gt. 0)) idstyp1 = 3
      if ((index(dstatm(1), 'ALL') .gt. 0) .and.
     &    (index(dstatm(2), 'ALL') .gt. 0)) idstyp1 = 4

c --- Distance type 2:
      idstyp2 = 1
      if ((index(dst2atm(1),'SDCH') .gt. 0) .and.
     &    (index(dst2atm(2),'SDCH') .gt. 0)) idstyp2 = 2
      if ((index(dst2atm(1),'MNCH') .gt. 0) .and.
     &    (index(dst2atm(2),'MNCH') .gt. 0)) idstyp2 = 3
      if ((index(dst2atm(1), 'ALL') .gt. 0) .and.
     &    (index(dst2atm(2), 'ALL') .gt. 0)) idstyp2 = 4

      if (iowr(2))
     &  write(iolog,'(/a,2i4)') 
     & 'initmdtd_> Distance function types: ', idstyp1, idstyp2

      return
      end




cf ----------------------------------------------------------------------------
cf
cf    IRDDATA() processes the data read from the mdt1.ini file. Given the
cf    selected features it decides what kind of data about the proteins 
cf    should be read in and also how the sample should be constructed
cd    (proteins, residues, residue pairs, ...).
cf
cf    subroutine irddata
cf
cf ----------------------------------------------------------------------------

      subroutine irddata
      implicit none
#include "io.cst"
#include "mdt_all.cmn"
      integer i,j,n,naa
      logical f(maxfeats), iowr

c --- flag the data to be read in (to avoid multiple reading and procesing)
      do  i = 1, maxdatatyp
        readin(i) = .false.
      end do
      do  i = 1, nfeat
        do  j = 1, ndatfil(ifeat(i))
          readin(idatfil(j,ifeat(i))) = .true.
        end do
      end do

      n = 0
      naa = 0
      do  i = 1, nfeat
c ----- you will compare proteins, residues or residue pairs if at least one
c       feature requires comparison of proteins, residues or residue pairs, 
c       respectively.
        n = max(n, iresfeat(ifeat(i)))
c ----- you will generate all NxN residue pairs if any of the relationships
c       is asymmetric
        naa = max(naa, isymm(ifeat(i)))
      end do
      nresfeat = n + 1
      symmetric = (naa .eq. 0)
      if (iusrsym .eq. 2) symmetric = .false.
      if (iusrsym .eq. 3) symmetric = .true.
      if (iowr(2))
     &  write(iolog,'(a,i3,1x,l7/a/a/a)')
     &  'irddata__> USER SYMMETRY, SYMMETRY: ', iusrsym,symmetric,
     &  '           SYMMETRIC = .T. ==> NALN*NALN/2',
     &  '           SYMMETRIC = .F. ==> NALN*NALN',
     &  '           all protein pairs always generated'

c --- see if you have to generate proteins/pairs/triplets for comparison 
c     (consider whether you selected features of A/B/C or features defined
c     with A/B/C simultaneously):
      do   i = 1, maxfeats
        f(i) = .false.
      end do
      do  i = 1, nfeat
        f(iknown(ifeat(i))) = .true.
      end do

c --- assume only one protein
      nprotcmp = 1

c --- is it a pair of proteins
      if (f(1).and.f(2)) nprotcmp = 2
      if (f(1).and.f(4)) nprotcmp = 2
      if (f(2).and.f(4)) nprotcmp = 2
      if (f(3).or.f(5)) nprotcmp = 2

c --- is it a triple
      if (f(1).and.f(2).and.f(4)) nprotcmp = 3
      if (f(3).and.f(4)) nprotcmp = 3
      if (f(3).and.f(5)) nprotcmp = 3
      if (f(2).and.f(5)) nprotcmp = 3
 
      return
      end
