cf ----------------------------------------------------------------------------
cf
cf    Create a specified data file, using a specified PDB file, in the 
cf    current or in the depository directory specified by the environment
cf    variable. Only a segment RNG,CHNRNG from the PDB file is used.
cf    PDB file name is PDBCOD, PDBCOD.atm, PDBCOD.pdb, or it is found
cf    in the list of PDB code <--> PDB file pairs in the file ${PDBENT}.
cf
cf    subroutine mkfile(dirpath,pdbcod,rng,chnrng,type,fname,
cf   &                  ifndflg,compressed,istop,outdir)
cf
cf ----------------------------------------------------------------------------

      subroutine mkfile(dirpath,pdbcod,rng,chnrng,type,fname,
     &                  ifndflg,compressed,istop,outdir)
        implicit none
        integer ntypes,mdir
        parameter (ntypes = 5, mdir=20)
        character delim*(1)
        parameter (delim='_')

c ----------------------------------------------------------------------------
c
c ----- rdpdb() definitions for the calling routine:
c
#include "io.cst"
#include "protsize.cst"
#include "segment.cst"
#include "mdt_aln.cst"
#include "mdt_top.cmn"

        integer nsegmmk,iress1mk(maxseg),iress2mk(maxseg)
        integer ierr,iresatm(maxatm)
        integer natm,nres,iatmr1(maxres)
        real x(maxatm),y(maxatm),z(maxatm),biso(maxatm)
        character rng(2)*(5),chnrng(2)*(1),header*(80)
        character chain(maxres)*(1),atmnam(maxatm)*(4)
        character resnam(maxres)*(3),resnum(maxres)*(5)
        character dirpath2*(255)
c        character brkname*(255)
c        logical hetatm,water,hydrogen

c        data rng,chnrng /'@@@@@','@@@@@','@','@'/
c
c -----------------------------------------------------------------------------

        integer itype,ifindword,lenr,ifndflg,istop,lr
        character pdbcod*(*), type*(*),types(ntypes)*(10)
        character dirpath*(*), direnv*(255)
        character envs(ntypes)*(20),fname*(*),dirout*(255),outdir*(*)
        character pdbloc*(100), cmd*(512),  tmpent*(255)
        character cmds(ntypes)*(512),root*(255)
        logical compressed,iowr

c        data hetatm,water,hydrogen /.true.,.true.,.true./
c        data hetatm,water,hydrogen /.false.,.false.,.false./
        data types /'.ngh', '.sst', '.psa', '.dih', '.hbd'/
        data envs  /'PDBNGH', 'PDBSST', 'PDBPSA', 'PDBDIH', 'PDBHBD'/

c ----- AS neighbours program:
        cmds(1)='(cd OUTDIR; ngh OFF 6.0 modeller_tmp.ent;'//
     &          'mv modeller_tmp.ngh OUTFIL;'//
     &          'compress -f OUTFIL;rm modeller_tmp.ent)'
c ----- DS secondary structure program:
        cmds(2)='(cd OUTDIR; sstruc f modeller_tmp.ent;'//
     &          'mv modeller_tmp.sst OUTFIL;'//
     &          'compress -f OUTFIL;rm modeller_tmp.ent)'
c ----- AS & JPO accessibility program:
        cmds(3)='(cd OUTDIR; psa -p1.4 -e0.05 -r -c -V -w -h '//
     &               '-o modeller_tmp.ent;'//
     &          'mv modeller_tmp.psa OUTFIL;'//
     &          'compress -f OUTFIL;rm modeller_tmp.ent)'
c ----- AS dihedrals program:
        cmds(4)='(cd OUTDIR; dih modeller_tmp.ent;'//
     &          'mv modeller_tmp.dih OUTFIL;'//
     &          'compress -f OUTFIL;rm modeller_tmp.ent)'
c ----- JPO H-bond program:
        cmds(5)='(cd OUTDIR; hbond modeller_tmp.ent;'//
     &          'mv modeller_tmp.hbd OUTFIL;'//
     &          'compress -f OUTFIL;rm modeller_tmp.ent)'

        itype = ifindword(type, types, ntypes)
        call getenv(envs(itype), direnv)

c ----- remove possible directory prefix and possible .Z extension
c       from the atom filename to get the output filename root:
        lr = lenr(pdbcod)
        if (lr .gt. 2) then
          if (pdbcod(lr-1:) .eq. '.Z') then
            call rootfn3(pdbcod(1:lr-2), root)
          else
            call rootfn3(pdbcod, root)
          end if
        else
          call rootfn3(pdbcod, root)
        end if

c------ should possibly remove the .atm, ... extensions too

c ----- get the basename of the output file with extension and without
c       directory prefix:
        call addstr(root, delim)
        call addstr(root, rng(1))
        call addstr(root, delim)
        call addstr(root, chnrng(1))
        call addstr(root, delim)
        call addstr(root, rng(2))
        call addstr(root, delim)
        call addstr(root, chnrng(2))
        call addstr(root, types(itype))

c ----- try to find the 'output' file:
        call concat(dirpath, ':', dirpath2)
        call addstr(dirpath2, direnv)
        call fullfn(dirpath2,root,' ',fname,ifndflg,compressed,0,0)

        if (ifndflg .eq. 0) return

c ----- file does not exist anywhere on the specified path; 
c       try to create the compressed output file from the PDB atom file:

c ----- first, extract the correct range of ATOMs from the PDB file:
        call pdbnam(dirpath,pdbcod,pdbloc,ifndflg,compressed,0,0)
        if (ifndflg .gt. 0) then
          if (istop .eq. 1) then
            write(iolog,'(/2a)') 'mkfile__E> non-existing PDB file: ',
     &      pdbcod(1:max(1,lr))
            stop
          else
            write(iolog,'(/2a)') 'mkfile__W> non-existing PDB file: ',
     &      pdbcod(1:max(1,lr))
          end if
          return
        end if
        call rdpdb(ioinp,iolog,pdbloc,water,hetatm,hydrogen,x,y,z,
     &       maxatm,maxres,natm,nres,resnam,resnum,atmnam,iatmr1,
     &       chain,header,rng,chnrng,iresatm,biso,ierr,iress1mk,
     &       iress2mk,maxseg,nsegmmk)
        if (ierr .ne. 0) then
          write(iolog,'(a)') 'mkfile__E> reading PDB'
          if (istop .eq. 1) stop
          ifndflg = 1
          return
        end if

c ----- get the directory DIROUT for the output file:
        if (ifndflg .lt. 0) then
c ------- the standard depository directory for data type ITYPE, if the 
c         PDB atom source is the PDB atom database, is the PDB data database:
          dirout = direnv
        else
c          dirout = outdir
          dirout = direnv
c ------- the directory of the PDB atom file:
c         call direct(pdbloc, dirout)
        end if
        if (lenr(dirout) .lt. 1) then
          dirout = './'
        else
          call adddir(dirout)
        end if

c ----- the temporary PDB file:
        call concat(dirout,'modeller_tmp.ent',tmpent)
        call wrpdb2(ioout,iolog,tmpent,x,y,z,natm,nres,resnam,
     &             resnum,atmnam,iresatm,chain,biso,natm,1)
        cmd = cmds(itype)
        call subs2(cmd, 'OUTDIR', dirout(1:lenr(dirout)))
        call subs2(cmd, 'OUTFIL', root(1:max(1,lenr(root))))
        if (iowr(1))
     &    write(iolog,'(/2a)')
     &   'mkfile___> Executing: ',cmd(1:max(1,lenr(cmd)))
c ----- make the compressed data file:
        call mysystem(cmd)
        compressed = .true.
c ----- get the final output file name:
        call concat(dirout, root, fname)
        call addstr(fname, '.Z')

        return
      end
