cf ----------------------------------------------------------------------------
cf
cf    IUNDEFD() returns .T. if an integer argument X has a value indicating
cf    that it is undefined (-999).
cf
cf    logical function iundefd(x)
cf
cf ----------------------------------------------------------------------------

      logical function iundefd(x)
        implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
        integer x
        iundefd = x .eq. nundf
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    IDEFD() returns .T. if an integer argument X has a value indicating
cf    that it is defined (<> -999).
cf
cf    logical function idefd(x)
cf
cf ----------------------------------------------------------------------------

      logical function idefd(x)
        implicit none
        integer  x
        logical iundefd
        idefd = .not. iundefd(x)
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    ZERO() returns .T. if a real argument X is close to 0.
cf
cf    logical function zero(x)
cf
cf ----------------------------------------------------------------------------

      logical function zero(x)
        implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
        real x
        zero = abs(x) .lt. fpequal
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    NZERO() returns .T. if a real argument X is not close to 0.
cf
cf    logical function nzero(x)
cf
cf ----------------------------------------------------------------------------

      logical function nzero(x)
        implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
        real x
        logical zero
        nzero = .not. zero(x)
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    IZERO() returns .T. if an integer argument X is 0.
cf
cf    logical function izero(x)
cf
cf ----------------------------------------------------------------------------

      logical function izero(x)
        implicit none
        integer x
        izero = x .eq. 0
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    INZERO() returns .T. if an integer argument X is not 0.
cf
cf    logical function inzero(x)
cf
cf ----------------------------------------------------------------------------

      logical function inzero(x)
        implicit none
        integer x
        inzero = x .ne. 0
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    UNDEFD() returns .T. if a real argument X has a value that indicates
cf    it is not defined (-999 or 9999.9).
cf
cf    logical function undefd(x)
cf
cf ----------------------------------------------------------------------------

      logical function undefd(x)
        implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
        real x,fp
        logical equal
        fp = nundf
        undefd = equal(x,fp) .or. equal(x,rundf2)
        return
      end

cf ----------------------------------------------------------------------------
cf
cf    DEFD() returns .T. if a real argument X has a value that indicates
cf    it is defined (<> -999).
cf
cf    logical function defd(x)
cf
cf ----------------------------------------------------------------------------

      logical function defd(x)
        implicit none
        real x
        logical undefd
        defd = .not. undefd(x)
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    DEGREES2() returns an argument in radians to degrees, but it also takes
cf    into account that the argument may be undefined, and returns the 
cf    undefined result itself in that case.
cf
cf    real function degrees2(rad)
cf
cf ----------------------------------------------------------------------------

      real function degrees2(rad)
      implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
      real rad
      logical defd
      if (defd(rad)) then
        degrees2 = rad2deg*rad
      else
        degrees2 = nundf
      end if
      return
      end


cf ----------------------------------------------------------------------------
cf
cf    DEGREES() returns an argument in radians to degrees, but it also takes
cf    into account that the argument may be undefined, and returns the 
cf    undefined result itself in that case. In addition, it makes sure that
cf    the result is in the range from -180 .. 180 degrees.
cf
cf    real function degrees(rad)
cf
cf ----------------------------------------------------------------------------

      real function degrees(rad)
      implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
      real rad,angdeg
      logical defd
      if (defd(rad)) then
        degrees = angdeg(rad2deg*rad)
      else
        degrees = nundf
      end if
      return
      end


cf ----------------------------------------------------------------------------
cf
cf    RADIANS() transforms the argument in degrees to the radians. The argument
cf    may be undefined (the result is undefined) and the result is always in
cf    the range from -Pi .. Pi.
cf
cf    real function radians(deg)
cf
cf ----------------------------------------------------------------------------

      real function radians(deg)
      implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
      real deg,angrad
      logical defd
      if (defd(deg)) then
        radians = angrad(deg2rad*deg)
      else
        radians = nundf
      end if
      return
      end


cf ----------------------------------------------------------------------------
cf
cf    RADIANS2() transforms the argument in degrees to the radians. The argument
cf    may be undefined, inwhich case the result is undefined, too.
cf
cf    real function radians(deg)
cf
cf ----------------------------------------------------------------------------

      real function radians2(deg)
      implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
      real deg
      logical defd
      if (defd(deg)) then
        radians2 = deg2rad*deg
      else
        radians2 = nundf
      end if
      return
      end

cf ----------------------------------------------------------------------------
cf
cf    ANGDEG() takes an angle in degrees and returns angle in degrees in 
cf    the range from -180 .. 180 degrees.
cf
cf    real function angdeg(ang)
cf
cf ----------------------------------------------------------------------------

      real function angdeg(ang)
      implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
      real a, ang
      logical defd
      if (defd(ang)) then
        a = mod(ang,pi2degr)
        if (a .lt. -pidegr) a = a + pi2degr
        if (a .gt.  pidegr) a = a - pi2degr
        angdeg = a
      else
        angdeg = nundf
      end if
      return
      end


cf ----------------------------------------------------------------------------
cf
cf    ANGRAD() takes an angle in radians and returns an angle in radians 
cf    in the range from -Pi .. Pi radians. 
cf
cf    real function angrad(ang)
cf
cf ----------------------------------------------------------------------------

      real function angrad(ang)
      implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
      real a, ang
      logical defd
      if (defd(ang)) then
        a = mod(ang,pi2)
        if (a .lt. -pi) a = a + pi2
        if (a .gt.  pi) a = a - pi2
        angrad = a
      else
        angrad = nundf
      end if
      return
      end


cf ----------------------------------------------------------------------------
cf
cf    DIFFDEG() returns the difference (in degrees) of two angles 
cf    (in degrees): ANG2-ANG1.  The difference is in the interval 
cf    from -180 -- 180 degrees. It is defined as the shortest path 
cf    around the circle from ANG1 to ANG2 (clockwise is +). 
cf
cf    real function diffdeg(ang2,ang1)
cf
cf ----------------------------------------------------------------------------

      real function diffdeg(ang2,ang1)
      implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
      real ang1,ang2,a1,a2,d
      logical defd
      if (defd(ang1) .and. defd(ang2)) then
        a1 = mod(ang1,pi2degr)
        a2 = mod(ang2,pi2degr)
        d = a2 - a1
        if (d .lt. -pidegr) d = d + pi2degr
        if (d .gt.  pidegr) d = d - pi2degr
        diffdeg = d
      else
        diffdeg = nundf
      end if
      return
      end


cf ----------------------------------------------------------------------------
cf
cf    DIFFRAD() returns the difference (in radians) of two angles 
cf    (in radians): ANG2-ANG1.  The difference is in the interval 
cf    from -Pi -- Pi radians. It is defined as the shortest path 
cf    around the circle from ANG1 to ANG2 (clockwise is +). 
cf
cf    real function diffrad(ang2,ang1)
cf
cf ----------------------------------------------------------------------------

      real function diffrad(ang2,ang1)
      implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
      real ang2,ang1,a1,a2,d
      logical defd
      if (defd(ang1).and. defd(ang2)) then
        a1 = mod(ang1,pi2)
        a2 = mod(ang2,pi2)
        d = a2 - a1
        if (d .lt. -pi) d = d + pi2
        if (d .gt.  pi) d = d - pi2
        diffrad = d
      else
        diffrad = nundf
      end if
      return
      end


cf ----------------------------------------------------------------------------
cf
cf    DIFF() returns a difference between two real arguments: X2-X1.
cf
cf    real function diff(x2,x1)
cf
cf ----------------------------------------------------------------------------

      real function diff(x2,x1)
      implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
      real x2,x1
      logical defd
      if (defd(x1).and.defd(x2)) then
        diff = x2 - x1
      else
        diff = nundf
      end if
      return
      end


cf ----------------------------------------------------------------------------
cf
cf    JOULES() returns Joules from calories. The argument may be undefined,
cf    in which case the result is udnefined, too.
cf
cf    real function joules(cal)
cf
cf ----------------------------------------------------------------------------

      real function joules(cal)
        implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
        real cal
        logical defd
        if (defd(cal)) then
          joules = cal2joul*cal
        else
          joules = nundf
        end if
        return
      end



cf ----------------------------------------------------------------------------
cf
cf    EQUAL() returns .T. if its two single precision floating-point
cf    arguments are not different for more than a small number.
cf
cf ----------------------------------------------------------------------------

      logical function equal(x1, x2)
        implicit none
        real x1, x2
        logical zero

        equal = zero(x2-x1)

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    DIVIDE() returns the value that has the same sign as the argument
cf    but is at least DIVISOR large, so that division can be safely done.
cf
cf    real function divide(arg)
cf
cf ----------------------------------------------------------------------------

      real function divide(arg)
        implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
        real arg

        if (abs(arg) .lt. divisor) then
          write(*,'(a,2g20.6)') 
     &    'divide__W> approximate division: ', arg, divisor
        end if

        divide = sign(max(divisor,abs(arg)), arg)
        
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    DIVIDE2() returns arg1/arg2 unless arg2 is so small that division 
cf    cannot be done accurately. In that case, 0 is returned.
cf
cf    real function divide2(arg1,arg2)
cf
cf ----------------------------------------------------------------------------

      real function divide2(arg1,arg2)
        implicit none

cf ----------------------------------------------------------------------------
cf
cf    NUMBERS.CST constants are general number and string constants.
cf
cf    nundf     = -999        ... an undefined quantity (integer or real)
cf    rundf2    = 9999.9      ... an undefined quantity (integer or real)
cf    tenm1     = 1.0E-1
cf    tenm2     = 1.0E-2
cf    tenm3     = 1.0E-3
cf    tenm4     = 1.0E-4
cf    tenm5     = 1.0E-5
cf    tenm6     = 1.0E-6
cf    tenm7     = 1.0E-7
cf    tenm8     = 1.0E-8
cf    tenm9     = 1.0E-9
cf    tenm10    = 1.0E-10
cf    tenm20    = 1.0E-20
cf    ten1      = 1.0E1
cf    ten2      = 1.0E2
cf    ten3      = 1.0E3
cf    ten4      = 1.0E4
cf    ten5      = 1.0E5
cf    ten6      = 1.0E6
cf    ten7      = 1.0E7
cf    ten8      = 1.0E8
cf    ten9      = 1.0E9
cf    ten10     = 1.0E10
cf    ten20     = 1.0E20
cf    fpequal   = 1E+1*eps          ... for judging the equality of two reals
cf
cf    cal2joul  = 4.1868      ... conversion factor for Joules from calories
cf    deg2rad   = 0.017453293 ... conversion factor for radians from degrees
cf    rad2deg   = 57.29577951 ... conversion factor for degrees from radians
cf
cf    pi        = 3.14159265358979323846
cf    pi2       = 2.0*pi
cf    pidegr    = 180.0
cf    pi2degr   = 2.0*pidegr
cf    spi2      = 2.50662827  ... sqrt(2 * pi)
cf    gascst    = 8.31441E-10 ... gas constant 
cf                                [kg Angstrom^2 / (femtosecond^2 mol K)]
cf    cmass     = 0.012011    ... mass in kg of 1 mol of atoms of the type 
cf                                that will be used in MD (12C)
cf
cf    rt        = 0.5900991   ... RT / 1000 cal2joul) [kcal/mole]; 
cf                                T = 297.15 K; R = 8.31441 J/mol K;
cf    rthalf    = 0.5*rt
cf    srthalf   = 0.54318464  ... SQRT(RTHALF) ; T = 297.15 K; 
cf                                R = 8.31441 J/mol K
cf
cf    eps0    =  8.854187818E-12 ... permitivity of vacuum [F/m = C/V/m]
cf    echrg   =  1.6021892E-19   ... electron charge [C=Amp s]
cf    planck  =  1.0545887E-34   ... Planck constant / (2pi) 
cf                                   [Js = Nms = kg m^2 s^2]
cf    avogdr  =  6.022045E+23    ... Avogadro number [/mol]
cf    emass   =  9.109534E-31    ... electron rest mass [kg]
cf
cf
cf
cf    delme     = '####'      ... MODELLER atmnam code for marking the atom 
cf                                for deletion
cf    psdext    = '.psd'      ... extension for the pseudo atoms file.
cf
cf ----------------------------------------------------------------------------




cf ----------------------------------------------------------------------------
cf
cf    SINGLE PRECISION (REAL*4; from machar.f)
cf
cf
cf
cf    eps       = 1.192092896E-07  ... single floating-point precision 
cf    largest   = 3.402823466E+38  ... largest single FP number (machar.f)
cf    smallest  = 1.175494351E-38  ... smallest single FP number (machar.f)
cf    divisor   = 1.0E-20          ... smallest FP number for accurate division
cf                                     implies the largest divided number
cf                                     (|MAX / divisor| < largest)
cf    acconmin  = eps              ... accuracy for CONMIN()
cf
cf
cf    When a normalized feature violation is larger than rgauss1, the
cf    second regime starts and goes up to rgauss2; when rgauss2 is reached, 
cf    arg in exp(arg) is rviolmax. If the transformed violation is larger 
cf    than rviolmax, then print error message and ignore the term.
cf
cf    rviolmax  = 12.0             ... 1/2*rviolmax^2 has to be smaller than
cf                                     the largest argument to exp() 
cf                                     ( 88 for single FP precision)
cf                                     (709 for double FP precision)
cf    rgauss1 =   4.0
cf    rgauss2 = 100.0
cf    agauss  = 1.0/rviolmax*(rgauss2-rviolmax)/(rgauss2-rgauss1)
cf    bgauss  = rgauss2/rviolmax*(rviolmax-rgauss1)/(rgauss2-rgauss1)
cf
cf
cf ----------------------------------------------------------------------------

      real eps,rviolmax,largest,smallest,acconmin,agauss,bgauss
      real rgauss1,rgauss2,divisor

c --- make sure that these numbers apply to and are within the range of all machines:
      parameter (
     &           eps      = 1.2E-7,
     &           acconmin = eps,
     &           divisor  = 1.0E-15,
     &           smallest = 1.2E-38,
     &           largest  = 8.5E+37)


        parameter (rviolmax =   12.0,
     &             rgauss1  =    4.0, 
     &             rgauss2  =  100.0,
     &             agauss   =  1.0/rviolmax*(rgauss2-rviolmax)/
     &                         (rgauss2-rgauss1),
     &             bgauss   =  rgauss2/rviolmax*(rviolmax-rgauss1)/
     &                         (rgauss2-rgauss1))


      integer nundf

      real rt,rthalf,srthalf,fpequal,rundf2
      real spi2,pi2,pi,pidegr,pi2degr,cal2joul,deg2rad,rad2deg
      real tenm1,tenm2,tenm3,tenm4,tenm5,tenm6,tenm7,tenm8
      real tenm9,tenm10,tenm20
      real ten1,ten2,ten3,ten4,ten5,ten6,ten7,ten8
      real ten9,ten10,ten20
      real cmass, gascst

      real eps0, echrg, planck, emass, avogdr
      parameter (eps0    =  8.854187818E-12,
     &           echrg   =  1.6021892E-19,
     &           planck  =  1.0545887E-34,
     &           avogdr  =  6.022045E+23,
     &           emass   =  9.109534E-31)

      parameter (cmass  = 0.012011)
      parameter (gascst = 8.31441E-10)

      parameter (nundf    = -999)
      parameter (rundf2   =  9999.9)

      parameter (cal2joul =  4.1868, 
     &           deg2rad  =  0.0174532925199433,
     &           rad2deg  =  57.295779513082320877)

      parameter (pi       = 3.14159265358979323846,
     &           pi2      = 2.0*pi,
     &           pidegr   = 180.0, 
     &           pi2degr  = 2.0*pidegr,
     &           spi2     = 2.50662827,
     &           rt       = 0.5900991, 
     &           rthalf   = 0.5*rt,
     &           srthalf  = 0.54318464)

      parameter (tenm1    = 1.0E-1,
     &           tenm2    = 1.0E-2,
     &           tenm3    = 1.0E-3,
     &           tenm4    = 1.0E-4,
     &           tenm5    = 1.0E-5,
     &           tenm6    = 1.0E-6,
     &           tenm7    = 1.0E-7,
     &           tenm8    = 1.0E-8,
     &           tenm9    = 1.0E-9,
     &           tenm10   = 1.0E-10,
     &           tenm20   = 1.0E-20,
     &           fpequal  = 1E+1*eps)

      parameter (ten1    = 1.0E1,
     &           ten2    = 1.0E2,
     &           ten3    = 1.0E3,
     &           ten4    = 1.0E4,
     &           ten5    = 1.0E5,
     &           ten6    = 1.0E6,
     &           ten7    = 1.0E7,
     &           ten8    = 1.0E8,
     &           ten9    = 1.0E9,
     &           ten10   = 1.0E10,
     &           ten20   = 1.0E20)

      character delme*(4), psdext*(4)

      parameter (delme   = '####',
     &           psdext  = '.psd')
        real arg1, arg2

        if (abs(arg2) .lt. divisor) then
          divide2 = 0.0
        else
          divide2 = arg1 / arg2
        end if

        
        return
      end
