cf ----------------------------------------------------------------------------
cf
cf    Comments on all of the alignment routines:
cf
cf    They return the best score in SCORE and the alignment in the unusual
cf    format in array IALN(MAXRES) (processed by mkaln() into the usual
cf    IALN2(2,MAXRES) format). The routines use the global dynamic programming
cf    with the two sequences in ISEQ1() and ISEQ2(), their lengths in NA and
cf    NB, type by type weights in RRWGHT(MRESTP,MRESTP), gap constants
cf    U and V (G = U + V*LEN), diagonal speedup NDIAG2, and the
cf    similarity/distance selection in SIMILAR. Optionally, the whole
cf    weight matrix may be specified in RRWGHT(MAXRES,MAXRES) instead
cf    of in ISEQ1(), ISEQ2(), RRWGHT(MRESTP,MRESTP). The routines are:
cf
cf    NAME        TYPE     INPUT        OUTPUT
cf    -----------------------------------------------------------
cf
cf    ALIGN1  ... integer  sequence     score
cf    ALIGN2  ... integer  sequence     score, alignment
cf
cf    ALIGN5  ... real     sequence     score, alignment
cf    ALIGN6  ... real     weights      score
cf    ALIGN7  ... real     sequence     score
cf    ALIGN8  ... real     weights      score, alignment
cf    ALIGN9  ... real     weights      score, alignment, gap pen a function of res ind
cf    ALIGN10 ... real     weights      score, alignment, str. dependent variable gap pen 2xN
cf    ALIGN11 ... real     weights      score, alignment, str. dependent variable gap pen NxN
cf
cf ----------------------------------------------------------------------------



      subroutine align1(iseq1,iseq2,rrwght,mrestp,na,nb,u,v,score,dist,
     &                  p,q,ip,iq,maxres,ndiag,similar,novrhng,local,
     &                  offset,ipoint)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, novrhng, iopt, jopt
        integer pq,p1,q1,p2,q2,uppv
        integer na,nb,maxres,mrestp,ndiag
        integer dist(0:maxres,0:maxres)
        integer p(0:maxres), q(0:maxres)
        integer ipoint(0:maxres,0:maxres)
        integer rrwght(mrestp,mrestp)
        integer ip(maxres),iq(maxres)
        integer iseq1(na), iseq2(nb)
        integer u,v,score,similar,forbid,offset
        real rdiag
        logical local,idefd

#include "distdp1-1.inc"
c --------- substitution score:
            pq = dist(i1,j1)+rrwght(iseq1(i),iseq2(j))
#include "distdp2.inc"
#include "distdp3.inc"

        return
      end




      subroutine align2(iseq1,iseq2,rrwght,mrestp,na,nb,u,v,score,
     &                  ialn1,ialn2,naln,dist,p,q,ip,iq,ipoint,
     &                  maxres,ndiag,similar,novrhng,local,offset)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, novrhng
        integer pq,p1,q1,p2,q2,uppv,iopt,jopt
        integer maxres, ialn1(maxres), ialn2(maxres)
        integer naln, na, nb, mrestp, ndiag
        integer ipoint(0:maxres,0:maxres)
        integer ip(maxres),iq(maxres)
        integer iseq1(na), iseq2(nb)
        integer dist(0:maxres,0:maxres)
        integer p(0:maxres), q(0:maxres)
        integer rrwght(mrestp,mrestp)
        integer u,v,score,similar,forbid,offset
        real rdiag
        logical local,idefd

#include "distdp1-1.inc"
c --------- substitution score:
            pq = dist(i1,j1)+rrwght(iseq1(i),iseq2(j))
#include "distdp2.inc"
#include "distdp3.inc"

        call pntdp(na,nb,ialn1,ialn2,naln,ipoint,iopt,jopt,maxres)

        return
      end




      subroutine align5(iseq1,iseq2,rrwght,mrestp,na,nb,u,v,score,
     &                  ialn1,ialn2,naln,dist,p,q,ip,iq,ipoint,maxres,
     &                  ndiag,similar,novrhng,local,offset)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, iopt,jopt, novrhng
        real    pq,p1,q1,p2,q2,uppv
        integer maxres,ndiag
        integer ialn1(maxres), ialn2(maxres), naln, na, nb, mrestp
        integer ipoint(0:maxres,0:maxres)
        integer ip(maxres),iq(maxres)
        integer iseq1(na), iseq2(nb)
        real dist(0:maxres,0:maxres)
        real p(0:maxres), q(0:maxres)
        real rrwght(mrestp,mrestp)
        real u,v,score,similar,forbid,offset
        real rdiag
        logical local,idefd

#include "distdp1-1.inc"
c --------- substitution score:
            pq = dist(i1,j1)+rrwght(iseq1(i),iseq2(j))
#include "distdp2.inc"
#include "distdp3.inc"

        call pntdp(na,nb,ialn1,ialn2,naln,ipoint,iopt,jopt,maxres)

        return
      end



      subroutine align6(rrwght,na,nb,u,v,score,dist,p,q,ip,iq,maxres,
     &                  ndiag,similar,novrhng,local,offset,ipoint)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, iopt, jopt, novrhng
        real    pq,p1,q1,p2,q2,uppv
        integer maxres,ndiag
        integer na, nb
        integer ip(maxres),iq(maxres)
        integer ipoint(0:maxres,0:maxres)
        real dist(0:maxres,0:maxres),rrwght(maxres,maxres)
        real p(0:maxres), q(0:maxres)
        real u,v,score,similar,forbid,offset
        real rdiag
        logical local,idefd

#include "distdp1-1.inc"
c --------- substitution score:
            pq = dist(i1,j1)+rrwght(i,j)
#include "distdp2.inc"
#include "distdp3.inc"

        return
      end




      subroutine align7(iseq1,iseq2,rrwght,mrestp,na,nb,u,v,score,
     &                  dist,p,q,ip,iq,maxres,ndiag,similar,novrhng,
     &                  local,offset,ipoint)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, iopt, jopt, novrhng
        integer maxres,ndiag
        integer ipoint(0:maxres,0:maxres)
        real    pq,p1,q1,p2,q2,uppv
        integer na, nb, mrestp
        integer ip(maxres),iq(maxres)
        integer iseq1(na), iseq2(nb)
        real dist(0:maxres,0:maxres)
        real p(0:maxres), q(0:maxres)
        real rrwght(mrestp,mrestp)
        real u,v,score,similar,forbid,offset
        real rdiag
        logical local,idefd

#include "distdp1-1.inc"
c --------- substitution score:
            pq = dist(i1,j1)+rrwght(iseq1(i),iseq2(j))
#include "distdp2.inc"
#include "distdp3.inc"

        return
      end




      subroutine align8(rrwght,na,nb,u,v,score,ialn1,ialn2,naln,dist,
     &           p,q,ip,iq,ipoint,maxres,ndiag,similar,novrhng,local,
     &           offset)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, iopt, jopt, novrhng
        real    pq,p1,q1,p2,q2,uppv
        integer maxres,ndiag
        integer ialn1(maxres), ialn2(maxres), naln, na, nb
        integer ipoint(0:maxres,0:maxres)
        integer ip(maxres),iq(maxres)
        real dist(0:maxres,0:maxres),rrwght(maxres,maxres)
        real p(0:maxres), q(0:maxres)
        real u,v,score,similar,forbid
        real rdiag,offset
        logical local,idefd

#include "distdp1-1.inc"

c ----- substitution score:
        pq = dist(i1,j1)+rrwght(i,j)

#include "distdp2.inc"
#include "distdp3.inc"

        call pntdp(na,nb,ialn1,ialn2,naln,ipoint,iopt,jopt,maxres)

cdeb    write(*,*)
cdeb    do  i = 0, na
cdeb      write(*,'(99f6.2)') (dist(i,j),j=0,nb)
cdeb    end do
cdeb    write(*,*)
cdeb    do  i = 0, na
cdeb      write(*,'(99i5)') (ipoint(i,j),j=0,nb)
cdeb    end do
cdeb    write(*,*)
cdeb    write(*,'(2i5,f6.2)') iopt, jopt, score
cdeb    write(*,*)
cdeb    write(*,'(99i5)') (ialn(i),i=1,naln)

        return
      end




      subroutine align9(rrwght,na,nb,u,v,score,ialn1,ialn2,naln,dist,
     &           p,q,ip,iq,ipoint,maxres,ndiag,similar,novrhng,local,
     &           offset,gap1,gap2)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, iopt, jopt, novrhng
        real    pq,p1,q1,p2,q2,uppv
        integer maxres,ndiag
        integer ialn1(maxres), ialn2(maxres), naln, na, nb
        integer ipoint(0:maxres,0:maxres)
        integer ip(maxres),iq(maxres)
        real dist(0:maxres,0:maxres),rrwght(maxres,maxres)
        real p(0:maxres), q(0:maxres), gap1(maxres), gap2(maxres)
        real u,v,score,similar,forbid
        real rdiag,offset
        logical local,idefd

#include "distdp1-2.inc"

c ----- substitution score:
        pq = dist(i1,j1)+rrwght(i,j)

#include "distdp2.inc"
#include "distdp3.inc"

        call pntdp(na,nb,ialn1,ialn2,naln,ipoint,iopt,jopt,maxres)

c        write(*,*) iopt, jopt
c        do  i = 1, naln
c          write(*,'(3i5)') i, ialn1(i), ialn2(i)
c        end do
c
c        write(*,'(/a)') 'DIST(i,j):'
c        do  i = 0, na
c          write(*,'(99i5)') (nint(dist(i,j)),j=0,nb)
c        end do
c        write(*,'(/a)') 'IPOINT(i,j):'
c        do  i = 0, na
c          write(*,'(99i5)') (ipoint(i,j),j=0,nb)
c        end do

        return
      end


      subroutine align10(rrwght,na,nb,u,v,score,ialn1,ialn2,naln,dist,
     &           p,q,ip,iq,ipoint,maxres,ndiag,similar,novrhng,local,
     &           offset,gap1,gap2,gapdst)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax
        integer ipnt, jpnt, iopt, jopt, novrhng, maxres
        real    pq,p1,q1,q2,gapdst(0:maxres+1,0:maxres+1),uppv
        integer ndiag
        integer ialn1(maxres), ialn2(maxres), naln, na, nb
        integer ipoint(0:maxres,0:maxres)
        integer ip(maxres),iq(maxres)
        real dist(0:maxres,0:maxres),rrwght(maxres,maxres)
        real p(0:maxres), q(0:maxres), gap1(maxres), gap2(maxres)
        real u,v,score,similar,forbid
        real rdiag,offset
        logical local,idefd

#include "distdp1-a.inc"

c --------- the best score for gap openning in seq 2 (j):
c           gap2(i) effect: avoid aligning i in seq 1 with a gap

c --------- deletion of length 1 in seq 2:
c           1:    ... i-1  i    ...
c           2:    ... j    -    ...

c --------- find the best length insertion at this point:
            p(j) = similar*largest
            do  i1 = max(0,i-max(1,ndiag)), i-1
              p1=dist(i1,j) + (gap2(i1+1)+gapdst(i1,i+1))*u + (i-i1)*v
              if (p1*similar .lt. p(j)*similar) then
                p(j) = p1
                ipnt = i - i1
              end if
            end do

c --------- the best score for a gap openning in seq 1 (i):
c           gap1(i) effect: avoid openning a gap at i in seq 1

c --------- deletion of length 1 in seq 1:
c           1:    ... i    -    ...
c           2:    ... j-1  j    ...

            q1 = dist(i,j1) + gap1(i) * u + v
c            q1 = dist(i,j1) + uppv

            q2 = q(i) + v
            if (q1*similar .lt. q2*similar) then
              q(i) = q1
              iq(i) = j1
              jpnt = 1
            else
              q(i) = q2
              jpnt = j - iq(i)
            end if

c ----- substitution score:
        pq = dist(i-1,j-1)+rrwght(i,j)

#include "distdp2.inc"
#include "distdp3.inc"

        call pntdp(na,nb,ialn1,ialn2,naln,ipoint,iopt,jopt,maxres)

c        write(*,*) iopt, jopt
c        do  i = 1, maxres
c          write(*,'(3i5)') i, ialn1(i), ialn2(i)
c        end do
c
c        write(*,'(/a)') 'DIST(i,j):'
c        do  i = 0, na
c          write(*,'(99i5)') (nint(dist(i,j)),j=0,nb)
c        end do
c        write(*,'(/a)') 'IPOINT(i,j):'
c        do  i = 0, na
c          write(*,'(99i5)') (ipoint(i,j),j=0,nb)
c        end do

c        write(*,'(/a/2i5,f5.2)') 'IOPT,JOPT,SCORE:',
c     &          iopt, jopt, score/1000.0
c        write(*,'(/a12/99i5)') 'IALN: ', (ialn(i),i=1,naln)
c
c        write(*,'(/a)') 'RRWGHT(i,j):'
c        do  i = 1, na
c          write(*,'(99i5)') (nint(rrwght(i,j)),j=1,nb)
c        end do
c        write(*,'(/a/99f5.2)') 'GAP1: ', (gap1(i),i=1,na)
c        write(*,*)
c        write(*,'(/a/99f5.2)') 'GAP2: ', (gap2(i),i=1,na)
c        write(*,'(/a)') 'GAPDST(i,j):'
c        do  i = 0, na+1
c          write(*,'(99f6.2)') (gapdst(i,j),j=0,nb+1)
c        end do
c
        return
      end


      subroutine align11(rrwght,na,nb,u,v,score,ialn1,ialn2,naln,dist,
     &                   ipoint,jpoint,maxres,ndiag,similar,novrhng,
     &                   local,offset,gap1,gap2,gapdst,ngap)
        implicit none
#include "numbers.cst"
        integer i, j, i1, j1, jmin, jmax, ngap, i0, j0, ndiag
        integer ipnt, jpnt, iopt, jopt, novrhng, maxres
        real    pq,bestgap,gapdst(0:maxres+1,0:maxres+1)
        integer ialn1(maxres), ialn2(maxres), naln, na, nb
        integer ipoint(0:maxres,0:maxres), jpoint(0:maxres,0:maxres)
        real dist(0:maxres,0:maxres),rrwght(maxres,maxres)
        real gap1(maxres), gap2(maxres), gappen, gap
        real u,v,score,similar,forbid
        real rdiag,offset
        logical local,idefd
        external gappen

        novrhng = max(novrhng, 0)
        if (local .and. novrhng.gt.0)
     &    write(*,'(a)')
     &    'distdp1__W> use NOVRHNG=0 with local alignment'

c ----- must also make sure that OFFSET is somewhere inbetween the
c       smallest and largest element of the score matrix.

        rdiag = ndiag / sqrt(2.0) * ((na+1.0)/(nb+1.0) +
     &          (nb+1.0)/(na+1.0)) / sqrt((na+1.0)**2+(nb+1.0)**2)
        forbid = ten7*similar

c ----- do not penalize any gaps of up to novrhng residues long at any of
c       the termini (any sequence, N- or C-terminus):
        dist(0,0) = 0.0
        do  i = 1, min(na,novrhng)
          dist(i,0) = 0.0
        end do
        do  j = 1, min(nb,novrhng)
          dist(0,j) = 0.0
        end do
        do i = novrhng+1, na
          dist(i,0) = u + (i-novrhng)*v
        end do
        do j = novrhng+1, nb
          dist(0,j) = u + (j-novrhng)*v
        end do

c ----- initialize the triangles outside the relevant part of DIST:
        do  i = 1, na
          j1 = (nb+1)*(i/(na+1.0)-rdiag)
          do j = 1, j1
            dist(i,j) = forbid
          end do
          j1 = (nb+1)*(i/(na+1.0)+rdiag)
          do j = j1, nb
            dist(i,j) = forbid
          end do
        end do

        do i = 1, na
          j1   = (nb+1)*(i/(na+1.0)-rdiag)
          jmin = max( 1, j1)
          j1   = (nb+1)*(i/(na+1.0)+rdiag)
          jmax = min(nb, j1)
          do j = jmin, jmax

c --------- find the best 'general gap' from (i1,j1) to (i,j):
            i0 = max(0, i - ngap)
            j0 = max(0, j - ngap)
            bestgap = similar*largest
            do  i1 = i0, i
              do  j1 = j0, j
                if (i1 .ne. i .or. j1 .ne. j) then
                  gap = dist(i1,j1) +
     &                  gappen(i,j,i1,j1,u,v,gap1,gap2,gapdst,maxres)
                  if (gap*similar .lt. bestgap*similar) then
                    bestgap = gap
                    ipnt = i - i1
                    jpnt = j - j1
                  end if
                end if
              end do
            end do

c --------- substitution score:
            pq = dist(i-1,j-1)+rrwght(i,j)

c --------- get the best score for this step and also store the step
c           direction (0 for substitution, <0 for step in direction j
c           (insertion in seq 2) and >0 for step in direction i (insertion
c           in seq 1; NUNDF for starting from scratch for LOCAL=.T.):

            if (bestgap*similar .lt. pq*similar) then
              dist(i,j) = bestgap
              ipoint(i,j) = ipnt
              jpoint(i,j) = jpnt
            else
              dist(i,j) = pq
              ipoint(i,j) = 0
              jpoint(i,j) = 0
            end if

            if (local) then
              if (similar*dist(i,j) .gt. similar*offset) then
                dist(i,j) = 0.0
                ipoint(i,j) = nundf
              end if
            end if

          end do
        end do

c ----- the best score (overhangs are not penalized):

        if (local) then
c ------- for local alignment it returns the first lowest score subalignment
c         that it finds, not the longest one.
          iopt = 0
c ------- assuming that novrhng is 0 for local=.T.
          do  i = na, 1, -1
            do  j = nb, 1, -1
              if (idefd(ipoint(i,j))) then
                if (iopt.eq.0) then
                  iopt = i
                  jopt = j
                else
                  if(similar*dist(i,j).lt.similar*dist(iopt,jopt))then
c                  if(dist(i,j).lt.similar*dist(iopt,jopt))then
                    iopt = i
                    jopt = j
                  end if
                end if
              end if
            end do
          end do
          if (similar*dist(iopt,jopt).gt.similar*offset .or. iopt.eq.0)
     &      write(*,'(a)')
     &      'distdp3__E> your MATRIX_OFFSET is probably strange.'
        else
          iopt = na
          do  i = na-1, max(na-novrhng,1), -1
            if (similar*dist(i,nb) .lt. similar*dist(iopt,nb)) iopt = i
          end do
          jopt = nb
          do  j = nb-1, max(nb-novrhng,1), -1
            if (similar*dist(na,j) .lt. similar*dist(na,jopt)) jopt = j
          end do
        end if

        score = dist(iopt,jopt)

        call pntdp2(na,nb,ipoint,jpoint,iopt,jopt,maxres,ialn1,
     &              ialn2,naln)
c        write(*,*) iopt, jopt
c        do  i = 1, naln
c          write(*,'(3i5)') i, ialn1(i), ialn2(i)
c        end do
c
c        write(*,'(/a)') 'DIST(i,j):'
c        do  i = 0, na
c          write(*,'(99i5)') (nint(dist(i,j)),j=0,nb)
c        end do
c        write(*,'(/a)') 'IPOINT(i,j):'
c        do  i = 0, na
c          write(*,'(99i5)') (ipoint(i,j),j=0,nb)
c        end do
c        write(*,'(/a)') 'JPOINT(i,j):'
c        do  i = 0, na
c          write(*,'(99i5)') (jpoint(i,j),j=0,nb)
c        end do

        return
      end


      real function gappen(i,j,i1,j1,u,v,gap1,gap2,gapdst,maxres)
        implicit none
        integer i, j, i1, j1, l1, l2, maxres
        real u, v, gapdst(0:maxres+1,0:maxres+1)
        real gap1(maxres), gap2(maxres)

        l1 = i - i1
        l2 = j - j1
        if (l1 .gt. 0 .and. l2 .gt. 0) then
          gappen = -1.0e32
        else
c          gappen = u + max(l1, l2)*v
          if (l1 .eq. 0) then
            gappen = gap1(i) * u + v*l2
          else
            gappen = (gap2(i1+1)+gapdst(i1,i+1))*u + l1*v
          end if
        end if

        return
      end



      subroutine pntdp2(na,nb,ipoint,jpoint,iopt,jopt,maxres,ialn1,
     &                  ialn2,naln)
        implicit none
#include "numbers.cst"
        integer maxres, ialn1(maxres), ialn2(maxres), naln, na, nb
        integer ipoint(0:maxres,0:maxres), jpoint(0:maxres,0:maxres)
        integer i, j, i1, j1, i0, j0, iopt, jopt
        logical recover
        external recover

c ----- for local alignments:
        i = na
        j = nb
        naln = 0
        do  i1 = 1, na-iopt
          naln = naln + 1
          if (naln.ge.maxres) then
            write(*,'(a)') 'pntdp2___E> increase MAXRES or gap pen'
            if (recover(.true., 1)) return
          end if
          ialn1(naln) = i
          ialn2(naln) = 0
          i = i - 1
        end do
        do  j1 = 1, nb-jopt
          naln = naln + 1
          if (naln.ge.maxres) then
            write(*,'(a)') 'pntdp2___E> increase MAXRES or gap pen'
            if (recover(.true., 1)) return
          end if
          ialn1(naln) = 0
          ialn2(naln) = j
          j = j - 1
        end do

10      if (i.eq.0 .or. j.eq.0 .or. ipoint(i,j).eq.nundf) go to 100

          if (ipoint(i,j).eq.0 .and. jpoint(i,j).eq.0) then
            naln = naln + 1
            if (naln.ge.maxres) then
              write(*,'(a)') 'pntdp2___E> increase MAXRES or gap pen'
              if (recover(.true., 1)) return
            end if
            ialn1(naln) = i
            ialn2(naln) = j
            i = i - 1
            j = j - 1
          else
            do  i1 = 1, ipoint(i,j)
              naln = naln + 1
              if (naln.ge.maxres) then
                write(*,'(a)') 'pntdp2___E> increase MAXRES or gap pen'
                if (recover(.true., 1)) return
              end if
              ialn1(naln) = i
              ialn2(naln) = 0
              i = i - 1
            end do
            do  j1 = 1, jpoint(i,j)
              naln = naln + 1
              if (naln.ge.maxres) then
                write(*,'(a)') 'pntdp2___E> increase MAXRES or gap pen'
                if (recover(.true., 1)) return
              end if
              ialn1(naln) = 0
              ialn2(naln) = j
              j = j - 1
            end do
          end if

          go to 10
100     continue

        i0 = i
        do  i1 = 1, i0
          naln = naln + 1
          if (naln.ge.maxres) then
            write(*,'(a)') 'pntdp2___E> increase MAXRES or gap pen'
            if (recover(.true., 1)) return
          end if
          ialn1(naln) = i
          ialn2(naln) = 0
          i = i - 1
        end do
        j0 = j
        do  j1 = 1, j0
          naln = naln + 1
          if (naln.ge.maxres) then
            write(*,'(a)') 'pntdp2___E> increase MAXRES or gap pen'
            if (recover(.true., 1)) return
          end if
          ialn1(naln) = 0
          ialn2(naln) = j
          j = j - 1
        end do

c ----- reverse the order:
        do i = 1, naln/2
          call iswap(ialn1(i), ialn1(naln-i+1))
          call iswap(ialn2(i), ialn2(naln-i+1))
        end do

        return
      end



cf ----------------------------------------------------------------------------
cf
cf    PNTDP re-traces the dynamic programming pointer array to infer the
cf    best alignment.
cf
cf    subroutine pntdp(na,nb,ialn1,ialn2,naln,ipoint,iopt,jopt,maxres)
cf
cf ----------------------------------------------------------------------------

      subroutine pntdp(na,nb,ialn1,ialn2,naln,ipoint,iopt,jopt,maxres)
        implicit none
#include "numbers.cst"
        integer maxres, ialn1(maxres), ialn2(maxres), naln, na, nb
        integer ipoint(0:maxres,0:maxres)
        integer i, j, i1, j1, i0, j0, iopt, jopt
        logical recover
        external recover


c ----- for local alignments:
        i = na
        j = nb
        naln = 0
        do  i1 = 1, na-iopt
          naln = naln + 1
          if (naln.ge.maxres) then
            write(*,'(a)') 'pntdp____E> increase MAXRES or gap pen'
            if (recover(.true., 1)) return
          end if
          ialn1(naln) = i
          ialn2(naln) = 0
          i = i - 1
        end do
        do  j1 = 1, nb-jopt
          naln = naln + 1
          if (naln.ge.maxres) then
            write(*,'(a)') 'pntdp____E> increase MAXRES or gap pen'
            if (recover(.true., 1)) return
          end if
          ialn1(naln) = 0
          ialn2(naln) = j
          j = j - 1
        end do

10      if (i.eq.0 .or. j.eq.0 .or. ipoint(i,j).eq.nundf) go to 100

          if (ipoint(i,j).eq.0) then
            naln = naln + 1
            if (naln.ge.maxres) then
              write(*,'(a)') 'pntdp____E> increase MAXRES or gap pen'
              if (recover(.true., 1)) return
            end if
            ialn1(naln) = i
            ialn2(naln) = j
            i = i - 1
            j = j - 1
          else
           if (ipoint(i,j) .gt. 0) then
            do  i1 = 1, ipoint(i,j)
              naln = naln + 1
              if (naln.ge.maxres) then
                write(*,'(a)') 'pntdp____E> increase MAXRES or gap pen'
                if (recover(.true., 1)) return
              end if
              ialn1(naln) = i
              ialn2(naln) = 0
              i = i - 1
            end do
           else
            do  j1 = 1, -ipoint(i,j)
              naln = naln + 1
              if (naln.ge.maxres) then
                write(*,'(a)') 'pntdp____E> increase MAXRES or gap pen'
                if (recover(.true., 1)) return
              end if
              ialn1(naln) = 0
              ialn2(naln) = j
              j = j - 1
            end do
           end if
          end if

          go to 10
100     continue

        i0 = i
        do  i1 = 1, i0
          naln = naln + 1
          if (naln.ge.maxres) then
            write(*,'(a)') 'pntdp____E> increase MAXRES or gap pen'
            if (recover(.true., 1)) return
          end if
          ialn1(naln) = i
          ialn2(naln) = 0
          i = i - 1
        end do
        j0 = j
        do  j1 = 1, j0
          naln = naln + 1
          if (naln.ge.maxres) then
            write(*,'(a)') 'pntdp____E> increase MAXRES or gap pen'
            if (recover(.true., 1)) return
          end if
          ialn1(naln) = 0
          ialn2(naln) = j
          j = j - 1
        end do

c ----- reverse the order:
        do i = 1, naln/2
          call iswap(ialn1(i), ialn1(naln-i+1))
          call iswap(ialn2(i), ialn2(naln-i+1))
        end do


        return
      end
