cf ----------------------------------------------------------------------------
cf
cf    RDINI() reads the mdt1.ini file which specifies the unchangeable data
cf    about each feature recognized by the MDT system; for example, property,
cf    relationship, one protein, two proteins, which data files required
cf    for its calculation, ...
cf
cf    subroutine rdini
cf
cf ----------------------------------------------------------------------------

      subroutine rdini
      implicit none
      integer i, j
#include "io.cst"
#include "mdt_all.cmn"
      integer ierr
      character card*80
      logical cmpr

      call openf4(ioinp,inifile,'OLD','SEQUENTIAL','FORMATTED',3,
     &            .true.,ierr,cmpr,iolog)

1     read(ioinp, '(a)') card
      if (card(1:10).ne.'----------') go to 1

c --- Read in for each feature:
c     1.   Number of data file types (atm,psa, ...).
c     2.   Pre-calculation type.
c     3.   protein 1, protein 2, protein 3, proteins 1 & 2
c     4.   Level of comparison (0 for whole proteins, 1 for residues, 2 
c          for intra-molecular residue pairs).
c     5.   0 for properties and symmetric rels, 1 for asymmetric rels

c --- After that, any types of data files and any ranges are read in, 
c     each in its own line.

c --- Note: the ndimen(i)-th bin of the feature i, i.e. the last one, is always
c     used for an undefined value: number of ranges in rang1/2 lines is one 
c     less.

      do  i = 1, maxfeats
c ----- blank line:
        read(ioinp, '(a)') card
c ----- data:
        read(ioinp, *) ndatfil(i), idatfeat(i), iknown(i), 
     &     iresfeat(i), isymm(i)
        if (ndatfil(i).gt.0) read(ioinp, *) 
     &     (idatfil(j,i),j=1,ndatfil(i))
      end do
      close(ioinp)

      return
      end
