cf ----------------------------------------------------------------------------
cf
cf    UPDTSTAT() routine scans all alignment positions or all alignment 
cf    position pairs in the current alignment. If whole protein features
cf    only occur in the current MDT, then no positions are scanned.
cf
cf    subroutine updtstat
cf
cf ----------------------------------------------------------------------------

      subroutine updtstat
        implicit none
#include "mdt_all.cmn"

        go to (101, 102, 103) nprotcmp
101     naprots = naprots + nseqacc
        go to 104
102     if (iseq2beg .eq. 1) then
          naprots = naprots + nseqacc*(nseqacc-1)
        else
          naprots = naprots + nseqacc*(nseqacc-1)/2
        end if
        go to 104
103     if (iseq3beg .eq. 1) then
          naprots = naprots + nseqacc*(nseqacc-1)*(nseqacc-2)
        else
          naprots = naprots + nseqacc*(nseqacc-1)*(nseqacc-2)/6
        end if
104     continue
 
c ----- the lowest level feature: protein, residue, intramolecular residue pair
        go to (1,2,3) nresfeat

c ------- whole proteins (ir1,ir2,ir1p,ir2p not referred to):
1         call genpair
          go to 100

c ------- single residues
2         do  ip1 = 1, naln
c --------- ip2 is not really used, but it is sometimes referred to,
c           so lets define it
            ip2 = ip1
            call genpair
          end do
          go to 100

c ------- intra-molecular residue pairs
3         do  ip1 = 1, naln-1

c c --------- always generate all NxN residue pairs
c             do  ip2 = 1, naln
c               if (ip1.ne.ip2) call genpair
c             end do

c --------- only if any of the residue relationships is asymmetric, go NxN 
c           (mainchain H-bonds are an example)
            if (symmetric) then
              do  ip2 = ip1+iresrng(3), min(naln,ip1+iresrng(4))
                call genpair
              end do
            else
              do  ip2 = max(1,ip1-iresrng(4)), min(naln,ip1+iresrng(4))
                if (abs(ip1-ip2).ge.iresrng(2)) call genpair
              end do
            end if

          end do
          go to 100

100     continue
        return
      end




cf ----------------------------------------------------------------------------
cf
cf    INDGAP() returns the bin index of the `nearest distance from the 
cf    gap' feature.
cf
cf    integer function indgap(rng1,rng2,ndim)
cf
cf ----------------------------------------------------------------------------

      integer function indgap(rng1,rng2,ndim)
        implicit none
#include "mdt_all.cmn"
        integer ndim, igap, iclsbin
        real g, rng1(ndim), rng2(ndim)

        if ((ir1.gt.0).or.(ir2.gt.0)) then
          g = igap(ip1,is1,is2)
          indgap = iclsbin(g,rng1,rng2,ndim)
        else
          indgap = ndim + 1
        end if

        return
      end 


cf ----------------------------------------------------------------------------
cf
cf    IGAP() finds the distance of the closest gap upstream or downstream 
cf    from position IP in the pairwise alignment between sequences ISA 
cf    and ISB.
cf
cf    integer function igap(ip,isa,isb)
cf
cf ----------------------------------------------------------------------------

      integer function igap(ip,isa,isb)
        implicit none
#include "mdt_all.cmn"
        integer ia, ig1, ip, isa, isb, jr1, jr2, ig2

c ----- speed up this code by making two parts dependent:

        ia = ip
        ig1 = 0
10      if (ia.gt.naln) go to 100
c ------- upstream position a gap?
          jr1 = ialn(ia,isa)
          jr2 = ialn(ia,isb)
          if ((jr1.gt.0) .and. (jr2.gt.0)) then
            ig1 = ig1 + 1
          else
            if ((jr1.gt.0) .or. (jr2.gt.0)) go to 100
          end if
          ia = ia + 1 
          go to 10
100     continue

        ia = ip
        ig2 = 0
20      if (ia.lt.1) go to 200
c ------- downstream position a gap?
          jr1 = ialn(ia,isa)
          jr2 = ialn(ia,isb)
          if ((jr1.gt.0) .and. (jr2.gt.0)) then
            ig2 = ig2 + 1
          else
            if ((jr1.gt.0) .or. (jr2.gt.0)) go to 200
          end if
          ia = ia - 1 
          go to 20
200     continue

        igap = min(ig1,ig2)
        
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    IFLOCSIM() returns the bin index for the local similarity feature.
cf
cf    integer function iflocsim(ires1,iseq1,iseq2,rng1,rng2,ndmen)
cf
cf ----------------------------------------------------------------------------

      integer function iflocsim(ires1,iseq1,iseq2,rng1,rng2,ndmen)
        implicit none
#include "mdt_all.cmn"
        integer ires1,iseq1,iseq2,ndmen,iclsbin
        real rng1(ndmen), rng2(ndmen), score, simloc
        if (ires1 .gt. 0) then
          score =simloc(ialn,invaln,neigh(ires1,iseq1),
     &                  ineigh(1,ires1,iseq1),maxres,maxseq,
     &                  rrwght,mrestyp,irestypn,iseq1,iseq2,igaptyp)
          iflocsim = iclsbin(score,rng1,rng2,ndmen)
        else
          iflocsim = ndmen+1
        end if
        return
      end 


cf ----------------------------------------------------------------------------
cf
cf    IFLOCSIM2() returns the bin index for the average residue 
cf    neighbourhood similarity: both residues in the first protein 
cf    have to exist. None of the residues have to exist in the 
cf    second protein;
cf
cf    integer function iflocsim2(ires1,ires2,iseq1,iseq2,rng1,
cf   -                           rng2,ndmen)
cf
cf ----------------------------------------------------------------------------

      integer function iflocsim2(ires1,ires2,iseq1,iseq2,rng1,
     &                           rng2,ndmen)
        implicit none
#include "mdt_all.cmn"
        integer ires1,iseq1,iseq2,ndmen,ires2,iclsbin
        real rng1(ndmen), rng2(ndmen), score1, score2, simloc
        real score
        if ((ires1 .gt. 0) .and. (ires2 .gt. 0)) then
          score1 =simloc(ialn,invaln,neigh(ires1,iseq1),
     &                  ineigh(1,ires1,iseq1),maxres,maxseq,
     &                  rrwght,mrestyp,irestypn,iseq1,iseq2,igaptyp)
          score2 =simloc(ialn,invaln,neigh(ires2,iseq1),
     &                  ineigh(1,ires2,iseq1),maxres,maxseq,
     &                  rrwght,mrestyp,irestypn,iseq1,iseq2,igaptyp)
          score = 0.5 * (score1+score2)
          iflocsim2 = iclsbin(score,rng1,rng2,ndmen)
        else
          iflocsim2 = ndmen+1
        end if
        return
      end 


cf ----------------------------------------------------------------------------
cf
cf    SIMLOC() returns the local residue similarity for two equivalent 
cf    residues in two aligned proteins.
cf
cf    real function simloc(ialn,invaln,neigh,ineigh,maxres,maxseq,
cf   -                     rrwght,mrestyp,irestypn,is1,is2,igaptyp)
cf
cf ----------------------------------------------------------------------------


      real function simloc(ialn,invaln,neigh,ineigh,maxres,maxseq,
     &                     rrwght,mrestyp,irestypn,is1,is2,igaptyp)
        implicit none
        integer maxseq, ires1, igaptyp
        integer is1, is2,i,maxres, ipos, ires2
        integer irtyp1, irtyp2, mrestyp
        integer neigh, ineigh(neigh), ialn(maxres,maxseq)
        integer invaln(maxres,maxseq), irestypn(maxres,maxseq)
        real rrwght(mrestyp,mrestyp), score
        logical notiaa

        score = 0.0
        if (neigh .gt. 0) then
          do  i = 1, neigh
            ires1 = ineigh(i)
            ipos  = invaln(ires1,is1)
            ires2 = ialn(ipos,is2) 
            irtyp1= irestypn(ires1,is1)
            if (ires2 .eq. 0) then
              irtyp2 = igaptyp
            else
              irtyp2= irestypn(ires2,is2)
            end if
c --------- if not a building block, pretend it is a gap:
            if (notiaa(irtyp2)) irtyp2 = igaptyp
            score = score + rrwght(irtyp1,irtyp2)
          end do
          score = score / neigh
        end if
        simloc = score

        return
      end



cf ----------------------------------------------------------------------------
cf
cf    IACC2() returns the bin index for the average residue accessibility
cf    of two residues in the same protein.
cf
cf    integer function iacc2(ir,irp,is,rng1,rng2,ndim)
cf
cf ----------------------------------------------------------------------------

      integer function iacc2(ir,irp,is,rng1,rng2,ndim)
        implicit none
#include "mdt_all.cmn"
        integer ir,irp,is,ndim,iclsbin
        real rng1(ndim), rng2(ndim),d
        if ((ir.gt.0).and.(irp.gt.0)) then
          d = 0.5*(acc(ir,is) + acc(irp,is))
          iacc2 = iclsbin(d,rng1,rng2,ndim)
        else
          iacc2 = ndim+1
        end if
        return
      end



cf ----------------------------------------------------------------------------
cf
cf    IDIFF() returns the bin index for the angle difference.
cf
cf    integer function idiffc(phi1,phi2,ir1,ir2,nres1,nres2,
cf   -                        rng1,rng2,ndim)
cf
cf ----------------------------------------------------------------------------

      integer function idiffc(phi1,phi2,ir1,ir2,nres1,nres2,
     &                        rng1,rng2,ndim)
        implicit none
#include "numbers.cst"
        integer ndim,iclsbin,nres1,nres2,ir1,ir2
        real rng1(ndim), rng2(ndim),diff,phi1(nres1),phi2(nres2) 
        real diffdeg

        if ((ir1.gt.0).and.(ir2.gt.0)) then
          diff = diffdeg(phi2(ir2), phi1(ir1))
          idiffc = iclsbin(diff, rng1, rng2, ndim)
        else 
          idiffc = ndim + 1
        end if

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    ITABLE() returns ITAB(IR) if IR>0 and  1 <= ITAB(IR) <= NDIM;
cf    otherwise it returns NDIM.
cf
cf    integer function itable(itab,nr,ir,ndim)
cf
cf ----------------------------------------------------------------------------

      integer function itable(itab,nr,ir,ndim)
        implicit none
        integer ndim,nr,ir,itab(nr)
        if ((ir .ge. 1) .and. (ir .le. nr)) then
          if ((itab(ir).ge.1) .and. (itab(ir).le.ndim)) then
            itable = itab(ir)
          else
            itable = ndim
          end if
        else
          itable = ndim
        end if
        return
      end


cf ----------------------------------------------------------------------------
cf
cf    DIST() returns the Euclidean distance.
cf
cf    real function dist(x1,y1,z1,x2,y2,z2)
cf
cf ----------------------------------------------------------------------------

      real function dist(x1,y1,z1,x2,y2,z2)
      implicit none
      real x1,y1,z1,x2,y2,z2,dx,dy,dz
      dx = x1-x2
      dy = y1-y2
      dz = z1-z2
      dist = sqrt(dx*dx+dy*dy+dz*dz)
      return
      end


cf ----------------------------------------------------------------------------
cf
cf    INDICES() assigns the bin indices INDF(I) for all the features in the
cf    current MDT pdf for the current position in the alignment.
cf
cf    subroutine indices(outrange)
cf
cf ----------------------------------------------------------------------------

      subroutine indices(outrange)
        implicit none
#include "mdt_all.cmn"
        integer i, iflocsim, itable, idist, iddist, iclsbin
        integer indgpa, indgap, idiffc, iacc2, idres
        integer iflocsim2, irestab, indresgrp
        real fp
        logical outrange

c ----- index for feature ifeat(i) is in indf(i): it had to be between 1 and
c       ndimen(ifeat(i)) but now it has to be between i1mdt(i) and i2mdt(i);

c ----- for each feature required to be analyzed, produce an index:
        do  i = 1, nfeat1

c --- FEATURE SLOT
          go to (1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
     &           21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
     &           38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,
     &           55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,
     &           72,73,74,75,76,77,78)
     &           ifeat(i)
1         indf(i) =irestab(ialn(1,is1),naln,irestypn(1,is1),nresn(is1),
     &                     ip1,0,pdelta,ndimen(1))
          go to 100
2         indf(i) =irestab(ialn(1,is2),naln,irestypn(1,is2),nresn(is2),
     &                     ip1,0,pdelta,ndimen(2))
          go to 100
3         indf(i) =itable(idih(1,ichi1typ,is1),nresn(is1),ir1,ndimen(3))
          go to 100
4         indf(i) =itable(idih(1,ichi1typ,is2),nresn(is2),ir2,ndimen(4))
          go to 100
5         indf(i) =itable(idih(1,ichi2typ,is1),nresn(is1),ir1,ndimen(5))
          go to 100
6         indf(i) =itable(idih(1,ichi2typ,is2),nresn(is2),ir2,ndimen(6))
          go to 100
7         indf(i) =itable(idih(1,iphityp,is1),nresn(is1),ir1,ndimen(7))
          go to 100
8         indf(i) =itable(idih(1,iphityp,is2),nresn(is2),ir2,ndimen(8))
          go to 100
9         indf(i) =itable(idih(1,ipsityp,is1),nresn(is1),ir1,ndimen(9))
          go to 100
10        indf(i) =itable(idih(1,ipsityp,is2),nresn(is2),ir2,ndimen(10))
          go to 100
11        indf(i) =itable(imnch(1,is1),nresn(is1),ir1,ndimen(11))
          go to 100
12        indf(i) =itable(imnch(1,is2),nresn(is2),ir2,ndimen(12))
          go to 100
13        indf(i) =itable(iacc(1,is1),nresn(is1),ir1,ndimen(13))
          go to 100
14        indf(i) =iflocsim(ir1,is1,is2,rang1(1,14),rang2(1,14),
     &                      ndimen(14)-1)
          go to 100
15        indf(i) =iglbsim(is1,is2)
          go to 100
16        indf(i) =idist(idstyp1,ir1,ir1p,is1,idsta1(1,is1),
     &                   idsta2(1,is1),nresn(is1),rang1(1,16),
     &                   rang2(1,16),ndimen(16)-1)
          go to 100
17        indf(i) =idist(idstyp1,ir2,ir2p,is2,idsta1(1,is2),
     &                   idsta2(1,is2),nresn(is2),rang1(1,17),
     &                   rang2(1,17),ndimen(17)-1)
          go to 100
18        indf(i)=itable(idihc(1,ichi1typ,is1),nresn(is1),ir1,
     &            ndimen(18))
          go to 100
19        indf(i)=itable(idihc(1,ichi1typ,is2),nresn(is2),ir2,
     &            ndimen(19))
          go to 100
20        indf(i)=itable(idihc(1,ichi2typ,is1),nresn(is1),ir1,
     &            ndimen(20))
          go to 100
21        indf(i)=itable(idihc(1,ichi2typ,is2),nresn(is2),ir2,
     &            ndimen(21))
          go to 100
22        indf(i)=itable(idihc(1,ichi3typ,is1),nresn(is1),ir1,
     &            ndimen(22))
          go to 100
23        indf(i)=itable(idihc(1,ichi3typ,is2),nresn(is2),ir2,
     &            ndimen(23))
          go to 100
24        indf(i)=iflocsim2(ir1,ir1p,is1,is2,rang1(1,24),rang2(1,24),
     &                      ndimen(24)-1)
          go to 100
25        indf(i)=iflocsim2(ir1,ir1p,is1,is3,rang1(1,25),rang2(1,25),
     &                      ndimen(25)-1)
          go to 100
26        indf(i)=itable(idihc(1,ichi4typ,is1),nresn(is1),ir1,
     &            ndimen(26))
          go to 100
27        indf(i)=itable(idihc(1,ichi4typ,is2),nresn(is2),ir2,
     &            ndimen(27))
          go to 100
28        indf(i)=itable(idih(1,iomgtyp,is1),nresn(is1),ir1,ndimen(28))
          go to 100
29        indf(i)=itable(idih(1,iomgtyp,is2),nresn(is2),ir2,ndimen(29))
          go to 100
30        indf(i) = iacont(is1)
          go to 100
31        indf(i) = iflocsim(ir1,is1,is3,rang1(1,31),rang2(1,31),
     &                    ndimen(31)-1)
          go to 100
32        indf(i) = itable(iacc(1,is2),nresn(is2),ir2,ndimen(32))
          go to 100
33        indf(i) = itable(ibiso(1,is1),nresn(is1),ir1,ndimen(33))
          go to 100
34        indf(i) = itable(ibiso(1,is2),nresn(is2),ir2,ndimen(34))
          go to 100
35        indf(i) = itable(iresol,nseq,is1,ndimen(35))
          go to 100
36        indf(i) = itable(incnts(1,is1),nresn(is1),ir1,ndimen(36))
          go to 100
37        indf(i) = itable(incnts(1,is2),nresn(is2),ir2,ndimen(37))
          go to 100
38        indf(i) = itable(iresol,nseq,is2,ndimen(38))
          go to 100
39        indf(i) = iacc2(ir1,ir1p,is1,rang1(1,39),rang2(1,39),
     &                    ndimen(39)-1)
          go to 100
40        indf(i) = iddist(ir1,ir1p,is1,ir2,ir2p,is2,rang1(1,40),
     &                     rang2(1,40),ndimen(40)-1)
          go to 100
41        indf(i) = idiffc(dih(1,iphityp,is1),dih(1,iphityp,is2),
     &              ir1,ir2,nresn(is1),
     &              nresn(is2),rang1(1,41),rang2(1,41),ndimen(41)-1)
          go to 100
42        indf(i) = idiffc(dih(1,ipsityp,is1),dih(1,ipsityp,is2),
     &              ir1,ir2,nresn(is1),
     &              nresn(is2),rang1(1,42),rang2(1,42),ndimen(42)-1)
          go to 100
43        indf(i) = itable(imnchw(1,is1),nresn(is1),ir1,ndimen(43))
          go to 100
44        indf(i) = itable(imnchw(1,is2),nresn(is2),ir2,ndimen(44))
          go to 100
45        indf(i) = itable(ichi12(1,is1),nresn(is1),ir1,ndimen(45))
          go to 100
46        indf(i) = itable(ichi12(1,is2),nresn(is2),ir2,ndimen(46))
          go to 100
47        indf(i) = indgap(rang1(1,47),rang2(1,47),ndimen(47)-1)
          go to 100
48        indf(i) = indgpa(rang1(1,48),rang2(1,48),ndimen(48)-1)
          go to 100
49        indf(i) =idist(idstyp1,ir3,ir3p,is3,idsta1(1,is3),
     &                   idsta2(1,is3),nresn(is3),rang1(1,49),
     &                   rang2(1,49),ndimen(49)-1)
          go to 100
50        indf(i) = iglbsim(is1,is3)
          go to 100
51        indf(i) = idres(ir1,ir1p,rang1(1,51),rang2(1,51),
     &                    ndimen(51)-1)
          go to 100
52        indf(i) = idres(ir2,ir2p,rang1(1,52),rang2(1,52),
     &                    ndimen(52)-1)
          go to 100
53        indf(i)=itable(idih(1,ichi3typ,is1),nresn(is1),ir1,ndimen(53))
          go to 100
54        indf(i)=itable(idih(1,ichi3typ,is2),nresn(is2),ir2,ndimen(54))
          go to 100
55        indf(i)=itable(idih(1,ichi4typ,is1),nresn(is1),ir1,ndimen(55))
          go to 100
56        indf(i)=itable(idih(1,ichi4typ,is2),nresn(is2),ir2,ndimen(56))
          go to 100
57        indf(i)=idiffc(dih(1,iomgtyp,is1),dih(1,iomgtyp,is2),
     &                   ir1,ir2,nresn(is1),nresn(is2),rang1(1,41),
     &                   rang2(1,41),ndimen(57)-1)
          go to 100
58        indf(i)=itable(idihc(1,iphityp,is1),nresn(is1),ir1,
     &            ndimen(58))
          go to 100
59        indf(i)=itable(idihc(1,iphityp,is2),nresn(is2),ir2,
     &            ndimen(59))
          go to 100
60        indf(i)=itable(idihc(1,ipsityp,is1),nresn(is1),ir1,
     &            ndimen(60))
          go to 100
61        indf(i)=itable(idihc(1,ipsityp,is2),nresn(is2),ir2,
     &            ndimen(61))
          go to 100
62        indf(i)=itable(idihc(1,iomgtyp,is1),nresn(is1),ir1,
     &            ndimen(62))
          go to 100
63        indf(i)=itable(idihc(1,iomgtyp,is2),nresn(is2),ir2,
     &            ndimen(63))
          go to 100
64        indf(i)=itable(idihc(1,ichi5typ,is1),nresn(is1),ir1,
     &            ndimen(64))
          go to 100
65        indf(i)=itable(idihc(1,ichi5typ,is2),nresn(is2),ir2,
     &            ndimen(65))
          go to 100
66        indf(i) =irestab(ialn(1,is1),naln,irestypn(1,is1),nresn(is1),
     &                     ip1,idelta,pdelta,ndimen(66))
          go to 100
67        indf(i) =irestab(ialn(1,is2),naln,irestypn(1,is2),nresn(is2),
     &                     ip1,idelta,pdelta,ndimen(67))
          go to 100
68        indf(i) =irestab(ialn(1,is1),naln,irestypn(1,is1),nresn(is1),
     &                     ip2,0,pdelta,ndimen(68))
          go to 100
69        indf(i) =irestab(ialn(1,is2),naln,irestypn(1,is2),nresn(is2),
     &                     ip2,0,pdelta,ndimen(69))
          go to 100
70        fp = nresn(is1)
          indf(i) =iclsbin(fp,rang1(1,70),rang2(1,70),ndimen(70)-1)
          go to 100
71        indf(i) =indresgrp(caln(ip1,is1),ndimen(71))
          go to 100
72        indf(i) =indresgrp(caln(ip2,is2),ndimen(72))
          go to 100
73        indf(i) =idist(idstyp2,ir1,ir1p,is1,idst2a1(1,is1),
     &                   idst2a2(1,is1),nresn(is1),
     &                   rang1(1,73),rang2(1,73),ndimen(73)-1)
          go to 100
74        indf(i) =idist(idstyp2,ir2,ir2p,is2,idst2a1(1,is2),
     &                   idst2a2(1,is2),nresn(is2),
     &                   rang1(1,74),rang2(1,74),ndimen(74)-1)
          go to 100
75        indf(i)=itable(idihc(1,iomgtyp,is1),nresn(is1),ir1-1,
     &            ndimen(75))
          go to 100
76        indf(i)=itable(idihc(1,iomgtyp,is2),nresn(is2),ir2-1,
     &            ndimen(76))
          go to 100
77        indf(i) =irestab(ialn(1,is1),naln,irestypn(1,is1),nresn(is1),
     &                     ip1,idelta2,pdelta2,ndimen(77))
          go to 100
78        indf(i) =irestab(ialn(1,is2),naln,irestypn(1,is2),nresn(is2),
     &                     ip1,idelta2,pdelta2,ndimen(78))
          go to 100

c --- FEATURE SLOT

100     continue

        if ((indf(i).lt.i1mdt(i)).or.(indf(i).gt.i2mdt(i))) then
          outrange = .true.
          return
        end if

        end do

        outrange = .false.

        return
      end




cf ----------------------------------------------------------------------------
cf
cf    IRESGRP() function returns the residue class of the residue RESTYP.
cf    It uses the common block RESGRP.CMN and the currently selected
cf    residue class grouping.
cf
cf    integer function indresgrp(restyp, ndimen)
cf
cf ----------------------------------------------------------------------------

      integer function indresgrp(restyp, ndimen)
        implicit none
#include "resgrp.cst"
#include "resgrp.cmn"
        integer ndimen, icls
        character restyp*(*)

        do  icls = 1, ndimen-1
          if (index(resgrp(icls,iselgrp), restyp) .gt. 0) then
            indresgrp = icls
            go to 100
          end if
        end do
        indresgrp = ndimen

100     continue

        return
      end




cf ----------------------------------------------------------------------------
cf
cf    Scan all proteins, protein pairs or protein triples in the alignment.
cf
cf    subroutine genpair
cf
cf ----------------------------------------------------------------------------

      subroutine genpair
        implicit none
#include "mdt_all.cmn"
        integer isbeg

        nsrc = 0

c ----- generate all indices for the protein A:
        do  is1 = 1, nseq
         if (accepts(is1)) then

c --------residue index for a residue of the protein A in the 1st position:
c         avoid reference to ialn if ip1 is not defined
          if (nresfeat .ne. 1) ir1 = ialn(ip1, is1)
c ------- residue index for a residue of the protein A in the 2nd position:
c         (not used if residue relationships are not compared)
          if (nresfeat .eq. 3) ir1p = ialn(ip2, is1)

c ------- do you have to generate a singlet, a pair or a triplet of proteins 
          if (nprotcmp .eq. 1) then
c --------- SINGLE PROTEIN:
c --------- in case the feature of the B or C was selected: use the pointers
c           for the protein A
            is2 = is1
            ir2 = ir1
            ir2p = ir1p
            is3 = is1
            ir3 = ir1
            ir3p = ir1p

c --------- while comparison including gaps is sensible when you are
c           dealing with a pair of proteins, it is not when considering 
c           a single protein: therefore, ignore this sample point if it does
c           not contain defined residue(s) 
            go to (1,2,3) nresfeat
c ----------- no residue, whole proteins compared
1             call update
              go to 4
c ----------- properties compared
2             if (ir1.gt.0) call update     
              go to 4 
c ----------- rels compared
3             if ((ir1.gt.0) .and. (ir1p.gt.0))call update
4           continue

          else

c --------- generate all indices for the protein B:
            do is2 = isbeg(is1,nseq,iseq2beg), nseq
             if (accepts(is2)) then
c ----------- residue indices in the first and second position for protein 2
              if (nresfeat .ne. 1) ir2 = ialn(ip1, is2)
              if (nresfeat .eq. 3) ir2p = ialn(ip2, is2)
              is3 = is2
              ir3 = ir2
              ir3p = ir2p

c ----------- do you have to generate a pair or a triplet of proteins 
              if (nprotcmp .eq. 2) then
c ------------- PAIR OF PROTEINS:
c ------------- ignore self-comparisons:
c               (the second condition only applies in the GETCSR mode to
c               allow the prediction from the sequence of the unknown alone
c               even if the MDT table was read in that requires the known)
                if ((is1 .ne. is2) .or. (nseq.eq.1)) call update
              else
c ------------- TRIPLET OF PROTEINS:
c ------------- generate all indices for the protein C:
                do is3 = isbeg(is2,nseq,iseq3beg), nseq
                 if (accepts(is3)) then
                  if (nresfeat .ne. 1) ir3 = ialn(ip1, is3)
                  if (nresfeat .eq. 3) ir3p = ialn(ip2, is3)
                  if (((is1.ne.is2).and.(is1.ne.is3).and.(is2.ne.is3)) 
     &                 .or. (nseq.eq.1)) call update
                 end if
                end do
              end if
             end if
            end do
          end if
         end if
        end do

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    IDRES() returns the bin for the residue index difference between
cf    two residues in the same protein.
cf
cf    integer function idres(ir, irp, rng1,rng2,ndim)
cf
cf ----------------------------------------------------------------------------

      integer function idres(ir, irp, rng1,rng2,ndim)
        implicit none
#include "mdt_all.cmn"
        integer ndim, iclsbin, ir, irp
        real rng1(ndim), rng2(ndim), fp

        if ((ir1.gt.0) .or.(ir2.gt.0)) then
          fp = irp - ir
          idres = iclsbin(fp, rng1, rng2, ndim)
        else
          idres = ndim + 1
        end if

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    INDGPA() returns the bin index for the average distance from the gap
cf    feature.
cf
cf    integer function indgpa(rng1,rng2,ndim)
cf
cf ----------------------------------------------------------------------------

      integer function indgpa(rng1,rng2,ndim)
        implicit none
#include "mdt_all.cmn"
        integer ndim, iclsbin, igap
        real rng1(ndim), rng2(ndim), g1, g2, ga

        if (((ir1.gt.0) .or.(ir2.gt.0)) .and. 
     &      ((ir1p.gt.0).or.(ir2p.gt.0))) then
          g1 = igap(ip1,is1,is2)
          g2 = igap(ip2,is1,is2)
          ga = 0.5*(g1+g2)
          indgpa = iclsbin(ga,rng1,rng2,ndim)
        else
          indgpa = ndim + 1
        end if

        return
      end



cf ----------------------------------------------------------------------------
cf
cf    IDDIST() returns the bin index for the difference between two
cf    equivalent distance.
cf
cf    integer function iddist(ie1,ie1p,io1,ie2,ie2p,io2,rng1,rng2,ndim)
cf
cf ----------------------------------------------------------------------------

      integer function iddist(ie1,ie1p,io1,ie2,ie2p,io2,rng1,rng2,ndim)
        implicit none
#include "mdt_all.cmn"
        integer ie1, ie1p, io1, ie2, ie2p, io2, ndim, iclsbin
        integer ie1a, ie1pa, ie2a, ie2pa
        real d1, d2, d, dist
        real rng1(ndim), rng2(ndim)

        if ((ie1.gt.0).and.(ie1p.gt.0).and.(ie2.gt.0).and.(ie2p.gt.0))
     &  then
          ie1a = idsta1(ie1,io1)
          ie1pa = idsta2(ie1p,io1)
          ie2a = idsta1(ie2,io2)
          ie2pa = idsta2(ie2p,io2)
          if ((ie1a.gt.0).and.(ie1pa.gt.0).and.
     &        (ie2a.gt.0).and.(ie2pa.gt.0)) then
           d1=dist(xn(ie1a,io1), yn(ie1a,io1), zn(ie1a,io1),
     &             xn(ie1pa,io1),yn(ie1pa,io1),zn(ie1pa,io1))
           d2=dist(xn(ie2a,io2), yn(ie2a,io2), zn(ie2a,io2),
     &             xn(ie2pa,io2),yn(ie2pa,io2),zn(ie2pa,io2))
           d = d2 - d1
           iddist = iclsbin(d,rng1,rng2,ndim)
          else
           iddist = ndim+1
          end if
        else
          iddist = ndim+1
        end if

        return
      end



cf ----------------------------------------------------------------------------
cf
cf    IDIST() returns the bin index for a distance of a specified type
cf    between two residue positions in the same protein.
cf
cf    integer function idist(idstyp,ir,irp,is,idst1,idst2,nr,rng1,
cf   &                       rng2,ndim)
cf
cf ----------------------------------------------------------------------------

      integer function idist(idstyp,ir,irp,is,idst1,idst2,nr,rng1,
     &                       rng2,ndim)
        implicit none
        integer ir,irp,is,ndim,idstyp,nr,idst1(nr),idst2(nr)
        integer idist1,idist2,idist3,idist4
        real rng1(ndim), rng2(ndim)

        go to (1,2,3,4) idstyp
1       idist = idist1(ir,irp,is,idst1,idst2,nr,rng1,rng2,ndim)
        go to 100
2       idist = idist2(ir,irp,is,rng1,rng2,ndim)
        go to 100
3       idist = idist3(ir,irp,is,rng1,rng2,ndim)
        go to 100
4       idist = idist4(ir,irp,is,rng1,rng2,ndim)

100     continue
        return
      end



cf ----------------------------------------------------------------------------
cf
cf    IDIST1() returns the bin index for the distance between two specified
cf    atoms in the same protein.
cf
cf    integer function idist1(ir,irp,is,idst1,idst2,nr,rng1,rng2,ndim)
cf
cf ----------------------------------------------------------------------------

      integer function idist1(ir,irp,is,idst1,idst2,nr,rng1,rng2,ndim)
        implicit none
#include "mdt_all.cmn"
        integer ir,irp,is,ndim,iclsbin,ira,irpa,nr,idst1(nr),idst2(nr)
        real rng1(ndim), rng2(ndim), d, dist

        if ((ir.gt.0).and.(irp.gt.0)) then
          ira  = idst1(ir)
          irpa = idst2(irp)
          if ((ira.gt.0).and.(irpa.gt.0)) then
            d = dist(xn(ira,is), yn(ira,is), zn(ira,is),
     &               xn(irpa,is),yn(irpa,is),zn(irpa,is))
            idist1 = iclsbin(d,rng1,rng2,ndim)
          else
            idist1 = ndim+1
          end if
        else
          idist1 = ndim+1
        end if

        return
      end

cf ----------------------------------------------------------------------------
cf
cf    IDIST2() returns the bin index for the shortest distance between 
cf    two sidechain atoms from specified residues in the same protein.
cf    Sidechains for all residues but glycine include positions from 
cf    Cbeta (including) onwards; Gly sidechain also includes CA position.
cf
cf    integer function idist2(ir,irp,is,rng1,rng2,ndim)
cf
cf ----------------------------------------------------------------------------

      integer function idist2(ir,irp,is,rng1,rng2,ndim)
        implicit none
#include "mdt_all.cmn"
        integer ir,irp,is,ndim,iclsbin,ir1a1,ir1a2,ir2a1,ir2a2
        integer iatmr2,ia1,ia2
        real rng1(ndim), rng2(ndim), d, dist, dmin
        character mnch1*17, mnch2*17

c        integer i1m, i2m

        if ((ir.gt.0).and.(irp.gt.0)) then
          ir1a1 = iatmr1n(ir,is)
          ir1a2 = iatmr2(iatmr1n(1,is), nresn(is), natmn(is), ir)
          ir2a1 = iatmr1n(irp,is)
          ir2a2 = iatmr2(iatmr1n(1,is), nresn(is), natmn(is), irp)
          if (irestypn(ir,is).eq.iglytyp) then
            mnch1 = ' N   C   O       '
          else
            mnch1 = ' N   C   O   CA  '
          end if
          if (irestypn(irp,is).eq.iglytyp) then
            mnch2 = ' N   C   O       '
          else
            mnch2 = ' N   C   O   CA  '
          end if
          dmin = ten10
          do ia1 = ir1a1, ir1a2
            if (index(mnch1,atmnamn(ia1,is)).le.0) then
              do ia2 = ir2a1, ir2a2
                if(index(mnch2,atmnamn(ia2,is)).le.0)then
                  d = dist(xn(ia1,is), yn(ia1,is), zn(ia1,is),
     &                     xn(ia2,is), yn(ia2,is), zn(ia2,is))
                  if (d .lt. dmin) dmin = d
c                    i1m = ia1
c                    i2m = ia2
c                  end if
                end if
              end do
            end if
          end do
          idist2 = iclsbin(dmin,rng1,rng2,ndim)
c          if (idist2 .eq. 1)
c     &      write(*,'(a,3(a,1x,i5,1x),f8.3,2i5)')
c     &      'CNT: ','PROT',is,'RES1',
c     &      ir,'RES2',irp,dmin,i1m,i2m
        else
          idist2 = ndim+1
        end if

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    IDIST3() returns the bin index for the shortest distance between 
cf    two mainchain atoms (N, CA, C, O) from specified residues in the 
cf    same protein.
cf
cf    integer function idist3(ir,irp,is,rng1,rng2,ndim)
cf
cf ----------------------------------------------------------------------------

      integer function idist3(ir,irp,is,rng1,rng2,ndim)
        implicit none
#include "mdt_all.cmn"
        integer ir,irp,is,ndim,iclsbin,ir1a1,ir1a2,ir2a1,ir2a2
        integer iatmr2,ia1,ia2
        real rng1(ndim), rng2(ndim), d, dist, dmin

        if ((ir.gt.0).and.(irp.gt.0)) then
          ir1a1 = iatmr1n(ir,is)
          ir1a2 = iatmr2(iatmr1n(1,is), nresn(is), natmn(is), ir)
          ir2a1 = iatmr1n(irp,is)
          ir2a2 = iatmr2(iatmr1n(1,is), nresn(is), natmn(is), irp)
          dmin = ten10
          do ia1 = ir1a1, ir1a2
            if (index(' N   CA   C   O   ',atmnamn(ia1,is)).gt.0) then
              do ia2 = ir2a1, ir2a2
               if(index(' N   CA   C   O   ',atmnamn(ia2,is)).gt.0)then
                 d = dist(xn(ia1,is), yn(ia1,is), zn(ia1,is),
     &                    xn(ia2,is), yn(ia2,is), zn(ia2,is))
                 if (d .lt. dmin) dmin = d
               end if
              end do
            end if
          end do
          idist3 = iclsbin(dmin,rng1,rng2,ndim)
        else
          idist3 = ndim+1
        end if

        return
      end


cf ----------------------------------------------------------------------------
cf
cf    IDIST4() returns the bin index for the shortest distance between 
cf    two atoms from specified residues in the same protein.
cf
cf    integer function idist4(ir,irp,is,rng1,rng2,ndim)
cf
cf ----------------------------------------------------------------------------

      integer function idist4(ir,irp,is,rng1,rng2,ndim)
        implicit none
#include "mdt_all.cmn"
        integer ir,irp,is,ndim,iclsbin,ir1a1,ir1a2,ir2a1,ir2a2
        integer iatmr2,ia1,ia2
        real rng1(ndim), rng2(ndim), d, dist, dmin

        if ((ir.gt.0).and.(irp.gt.0)) then
          ir1a1 = iatmr1n(ir,is)
          ir1a2 = iatmr2(iatmr1n(1,is), nresn(is), natmn(is), ir)
          ir2a1 = iatmr1n(irp,is)
          ir2a2 = iatmr2(iatmr1n(1,is), nresn(is), natmn(is), irp)
          dmin = ten10
          do ia1 = ir1a1, ir1a2
            do ia2 = ir2a1, ir2a2
              d = dist(xn(ia1,is), yn(ia1,is), zn(ia1,is),
     &                 xn(ia2,is), yn(ia2,is), zn(ia2,is))
              if (d .lt. dmin) dmin = d
            end do
          end do
          idist4 = iclsbin(dmin,rng1,rng2,ndim)
        else
          idist4 = ndim+1
        end if

        return
      end


cf ---------------------------------------------------------------------------
cf
cf    IRESTAB() function returns the MDT residue type index for the
cf    alignment position IPOS+IDELTA (PDELTA=.T.) or for residue 
cf    IRES+IDELTA (PDELTA=.F.).
cf
cf    integer function irestab(ialn,naln,irestypn,nres,ipos,idelta,
cf                             pdelta,ndimen)
cf
cf ---------------------------------------------------------------------------

      integer function irestab(ialn,naln,irestypn,nres,ip,idelta,
     &                         pdelta,ndimen)
        implicit none
#include "reslib.cst"
#include "reslib.cmn"
        integer ires1,ires2,ndimen,ipos,nres,irestypn(nres),naln
        integer ialn(naln),idelta,ip
        logical pdelta

        if (pdelta) then

          ipos = ip + idelta 
          if ((ipos .lt. 1) .or. (ipos .gt. naln)) then
            irestab = igaptyp
          else
            ires1 = ialn(ipos)
            if ((ires1 .lt. 1) .or. (ires1 .gt. nres)) then
              irestab = igaptyp
            else
              if((irestypn(ires1).ge.21).or.(irestypn(ires1).le.0))then
                write(*,'(a,2i5)') 'irestab_W> irestp: ',
     &          ires1,irestypn(ires1)
                irestab = ndimen
c                stop
              else
                irestab = irestypn(ires1)
              end if
            end if
          end if

        else

          ires2 = ialn(ip)
          if ((ires2 .lt. 1) .or. (ires2 .gt. nres)) then
            irestab = igaptyp
          else
            ires2 = ires2 + idelta
            if ((ires2 .lt. 1) .or. (ires2 .gt. nres)) then
              irestab = igaptyp
            else
              if((irestypn(ires2).ge.21).or.(irestypn(ires2).le.0))then
                write(*,'(a,2i5)') 'irestab_W> irestp: ',
     &          ires2,irestypn(ires2)
                irestab = ndimen
c                stop
              else
                irestab = irestypn(ires2)
              end if
            end if
          end if

        end if

        return
      end



      integer function isbeg(is,nseq,iseqbeg)
        implicit none
        integer is, nseq, iseqbeg
     
        go to (1,2,3) iseqbeg 
1         isbeg = 1 
          go to 999
2         isbeg = is + 1
          go to 999
3         isbeg = nseq 
        
999     continue
 
        return
      end
